/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc;

import cats.data.NonEmptyList;
import geotrellis.proj4.CRS;
import geotrellis.raster.GridExtent;
import geotrellis.raster.RasterMetadata;
import geotrellis.raster.RasterSource;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.server.ogc.GeoTrellisOgcSource$;
import geotrellis.server.ogc.OgcSource;
import geotrellis.server.ogc.OgcTime;
import geotrellis.server.ogc.OgcTime$;
import geotrellis.server.ogc.OgcTime$OgcTimeOps$;
import geotrellis.server.ogc.OgcTimeDefault;
import geotrellis.server.ogc.OgcTimeDefault$Newest$;
import geotrellis.server.ogc.OgcTimeDefault$Oldest$;
import geotrellis.server.ogc.OgcTimeEmpty$;
import geotrellis.server.ogc.OgcTimeFormat;
import geotrellis.server.ogc.OgcTimeInterval;
import geotrellis.server.ogc.OgcTimePositions;
import geotrellis.server.ogc.OgcTimePositions$;
import geotrellis.server.ogc.RasterOgcSource;
import geotrellis.server.ogc.SimpleOgcLayer;
import geotrellis.server.ogc.SimpleSource$;
import geotrellis.server.ogc.style.OgcStyle;
import geotrellis.store.AttributeStore;
import geotrellis.store.AttributeStore$;
import geotrellis.store.GeoTrellisPath;
import geotrellis.store.GeoTrellisPath$;
import geotrellis.store.GeoTrellisRasterSource;
import geotrellis.store.GeoTrellisRasterSource$;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import java.time.ZonedDateTime;
import jp.ne.opt.chronoscala.Imports$;
import jp.ne.opt.chronoscala.RichZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple10;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMf\u0001B\u001c9\u0001~B\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t;\u0002\u0011\t\u0012)A\u0005%\"Aa\f\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005`\u0001\tE\t\u0015!\u0003S\u0011!\u0001\u0007A!f\u0001\n\u0003\t\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u0011\t\u0004!Q3A\u0005\u0002\rD\u0001b\u001a\u0001\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\tQ\u0002\u0011)\u001a!C\u0001S\"A\u0011\u0010\u0001B\tB\u0003%!\u000e\u0003\u0005{\u0001\tU\r\u0011\"\u0001|\u0011%\t\t\u0002\u0001B\tB\u0003%A\u0010\u0003\u0006\u0002\u0014\u0001\u0011)\u001a!C\u0001\u0003+A!\"a\n\u0001\u0005#\u0005\u000b\u0011BA\f\u0011%\tI\u0003\u0001BK\u0002\u0013\u00051\rC\u0005\u0002,\u0001\u0011\t\u0012)A\u0005I\"Q\u0011Q\u0006\u0001\u0003\u0016\u0004%\t!a\f\t\u0015\u0005]\u0002A!E!\u0002\u0013\t\t\u0004\u0003\u0006\u0002:\u0001\u0011)\u001a!C\u0001\u0003wA!\"a\u0011\u0001\u0005#\u0005\u000b\u0011BA\u001f\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!a\u0018\u0001\t\u0003\t\t\u0007C\u0005\u0002\n\u0002\u0011\r\u0011\"\u0003\u0002\f\"A\u0011\u0011\u0014\u0001!\u0002\u0013\ti\t\u0003\u0006\u0002\u001c\u0002A)\u0019!C\u0001\u0003;C!\"!*\u0001\u0011\u000b\u0007I\u0011AAT\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!!+\u0001\t\u0003\t\t\fC\u0005\u0002D\u0002\t\t\u0011\"\u0001\u0002F\"I\u00111\u001c\u0001\u0012\u0002\u0013\u0005\u0011Q\u001c\u0005\n\u0003g\u0004\u0011\u0013!C\u0001\u0003;D\u0011\"!>\u0001#\u0003%\t!!8\t\u0013\u0005]\b!%A\u0005\u0002\u0005e\b\"CA\u007f\u0001E\u0005I\u0011AA\u0000\u0011%\u0011\u0019\u0001AI\u0001\n\u0003\u0011)\u0001C\u0005\u0003\n\u0001\t\n\u0011\"\u0001\u0003\f!I!q\u0002\u0001\u0012\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0005#\u0001\u0011\u0013!C\u0001\u0005'A\u0011Ba\u0006\u0001#\u0003%\tA!\u0007\t\u0013\tu\u0001!!A\u0005B\t}\u0001\"\u0003B\u0016\u0001\u0005\u0005I\u0011\u0001B\u0017\u0011%\u0011)\u0004AA\u0001\n\u0003\u00119\u0004C\u0005\u0003D\u0001\t\t\u0011\"\u0011\u0003F!I!1\u000b\u0001\u0002\u0002\u0013\u0005!Q\u000b\u0005\n\u0005?\u0002\u0011\u0011!C!\u0005CB\u0011Ba\u0019\u0001\u0003\u0003%\tE!\u001a\t\u0013\t\u001d\u0004!!A\u0005B\t%t!\u0003B7q\u0005\u0005\t\u0012\u0001B8\r!9\u0004(!A\t\u0002\tE\u0004bBA#c\u0011\u0005!q\u0010\u0005\n\u0005G\n\u0014\u0011!C#\u0005KB\u0011B!!2\u0003\u0003%\tIa!\t\u0013\te\u0015'!A\u0005\u0002\nm\u0005\"\u0003BUc\u0005\u0005I\u0011\u0002BV\u0005M9Um\u001c+sK2d\u0017n](hGN{WO]2f\u0015\tI$(A\u0002pO\u000eT!a\u000f\u001f\u0002\rM,'O^3s\u0015\u0005i\u0014AC4f_R\u0014X\r\u001c7jg\u000e\u00011#\u0002\u0001A\r*k\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%AB!osJ+g\r\u0005\u0002H\u00116\t\u0001(\u0003\u0002Jq\ty!+Y:uKJ|umY*pkJ\u001cW\r\u0005\u0002B\u0017&\u0011AJ\u0011\u0002\b!J|G-^2u!\t\te*\u0003\u0002P\u0005\na1+\u001a:jC2L'0\u00192mK\u0006!a.Y7f+\u0005\u0011\u0006CA*[\u001d\t!\u0006\f\u0005\u0002V\u00056\taK\u0003\u0002X}\u00051AH]8pizJ!!\u0017\"\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033\n\u000bQA\\1nK\u0002\nQ\u0001^5uY\u0016\fa\u0001^5uY\u0016\u0004\u0013!C:pkJ\u001cW-\u0016:j\u0003)\u0019x.\u001e:dKV\u0013\u0018\u000eI\u0001\rI\u00164\u0017-\u001e7u'RLH.Z\u000b\u0002IB\u0019\u0011)\u001a*\n\u0005\u0019\u0014%AB(qi&|g.A\u0007eK\u001a\fW\u000f\u001c;TifdW\rI\u0001\u0007gRLH.Z:\u0016\u0003)\u00042a\u001b9t\u001d\tagN\u0004\u0002V[&\t1)\u0003\u0002p\u0005\u00069\u0001/Y2lC\u001e,\u0017BA9s\u0005\u0011a\u0015n\u001d;\u000b\u0005=\u0014\u0005C\u0001;x\u001b\u0005)(B\u0001<9\u0003\u0015\u0019H/\u001f7f\u0013\tAXO\u0001\u0005PO\u000e\u001cF/\u001f7f\u0003\u001d\u0019H/\u001f7fg\u0002\naB]3tC6\u0004H.Z'fi\"|G-F\u0001}!\ri\u00181\u0002\b\u0004}\u0006\u001dabA@\u0002\u00049\u0019Q+!\u0001\n\u0003uJ1!!\u0002=\u0003\u0019\u0011\u0018m\u001d;fe&\u0019q.!\u0003\u000b\u0007\u0005\u0015A(\u0003\u0003\u0002\u000e\u0005=!A\u0004*fg\u0006l\u0007\u000f\\3NKRDw\u000e\u001a\u0006\u0004_\u0006%\u0011a\u0004:fg\u0006l\u0007\u000f\\3NKRDw\u000e\u001a\u0011\u0002!=4XM\u001d<jK^\u001cFO]1uK\u001eLXCAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tqaZ3pi&4gM\u0003\u0003\u0002\"\u0005%\u0011AA5p\u0013\u0011\t)#a\u0007\u0003!=3XM\u001d<jK^\u001cFO]1uK\u001eL\u0018!E8wKJ4\u0018.Z<TiJ\fG/Z4zA\u0005yA/[7f\u001b\u0016$\u0018\rZ1uC.+\u00170\u0001\tuS6,W*\u001a;bI\u0006$\u0018mS3zA\u0005QA/[7f\r>\u0014X.\u0019;\u0016\u0005\u0005E\u0002cA$\u00024%\u0019\u0011Q\u0007\u001d\u0003\u001b=;7\rV5nK\u001a{'/\\1u\u0003-!\u0018.\\3G_Jl\u0017\r\u001e\u0011\u0002\u0017QLW.\u001a#fM\u0006,H\u000e^\u000b\u0003\u0003{\u00012aRA \u0013\r\t\t\u0005\u000f\u0002\u000f\u001f\u001e\u001cG+[7f\t\u00164\u0017-\u001e7u\u00031!\u0018.\\3EK\u001a\fW\u000f\u001c;!\u0003\u0019a\u0014N\\5u}Q1\u0012\u0011JA&\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0013qKA-\u00037\ni\u0006\u0005\u0002H\u0001!)\u0001+\u0006a\u0001%\")a,\u0006a\u0001%\")\u0001-\u0006a\u0001%\")!-\u0006a\u0001I\")\u0001.\u0006a\u0001U\")!0\u0006a\u0001y\"9\u00111C\u000bA\u0002\u0005]\u0001BBA\u0015+\u0001\u0007A\rC\u0004\u0002.U\u0001\r!!\r\t\u000f\u0005eR\u00031\u0001\u0002>\u00059Ao\u001c'bs\u0016\u0014H\u0003CA2\u0003S\nI(! \u0011\u0007\u001d\u000b)'C\u0002\u0002ha\u0012abU5na2,wjZ2MCf,'\u000fC\u0004\u0002lY\u0001\r!!\u001c\u0002\u0007\r\u00148\u000f\u0005\u0003\u0002p\u0005UTBAA9\u0015\r\t\u0019\bP\u0001\u0006aJ|'\u000eN\u0005\u0005\u0003o\n\tHA\u0002D%NCaA\u001e\fA\u0002\u0005m\u0004cA!fg\"9\u0011q\u0010\fA\u0002\u0005\u0005\u0015\u0001\u0005;f[B|'/\u00197TKF,XM\\2f!\u0011Y\u0007/a!\u0011\u0007\u001d\u000b))C\u0002\u0002\bb\u0012qaT4d)&lW-\u0001\u0005eCR\f\u0007+\u0019;i+\t\ti\t\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\r\t\u0019\nP\u0001\u0006gR|'/Z\u0005\u0005\u0003/\u000b\tJ\u0001\bHK>$&/\u001a7mSN\u0004\u0016\r\u001e5\u0002\u0013\u0011\fG/\u0019)bi\"\u0004\u0013AB:pkJ\u001cW-\u0006\u0002\u0002 B!\u0011qRAQ\u0013\u0011\t\u0019+!%\u0003-\u001d+w\u000e\u0016:fY2L7OU1ti\u0016\u00148k\\;sG\u0016\fA\u0001^5nKV\u0011\u00111Q\u0001\u000eg>,(oY3G_J$\u0016.\\3\u0015\t\u0005}\u0015Q\u0016\u0005\b\u0003_[\u0002\u0019AAB\u0003!Ig\u000e^3sm\u0006dG\u0003BAP\u0003gCq!!*\u001d\u0001\u0004\t)\f\u0005\u0003\u00028\u0006}VBAA]\u0015\u0011\t)+a/\u000b\u0005\u0005u\u0016\u0001\u00026bm\u0006LA!!1\u0002:\ni!l\u001c8fI\u0012\u000bG/\u001a+j[\u0016\fAaY8qsR1\u0012\u0011JAd\u0003\u0013\fY-!4\u0002P\u0006E\u00171[Ak\u0003/\fI\u000eC\u0004Q;A\u0005\t\u0019\u0001*\t\u000fyk\u0002\u0013!a\u0001%\"9\u0001-\bI\u0001\u0002\u0004\u0011\u0006b\u00022\u001e!\u0003\u0005\r\u0001\u001a\u0005\bQv\u0001\n\u00111\u0001k\u0011\u001dQX\u0004%AA\u0002qD\u0011\"a\u0005\u001e!\u0003\u0005\r!a\u0006\t\u0011\u0005%R\u0004%AA\u0002\u0011D\u0011\"!\f\u001e!\u0003\u0005\r!!\r\t\u0013\u0005eR\u0004%AA\u0002\u0005u\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003?T3AUAqW\t\t\u0019\u000f\u0005\u0003\u0002f\u0006=XBAAt\u0015\u0011\tI/a;\u0002\u0013Ut7\r[3dW\u0016$'bAAw\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0018q\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a?+\u0007\u0011\f\t/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\u0005!f\u00016\u0002b\u0006q1m\u001c9zI\u0011,g-Y;mi\u00122TC\u0001B\u0004U\ra\u0018\u0011]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011iA\u000b\u0003\u0002\u0018\u0005\u0005\u0018AD2paf$C-\u001a4bk2$H\u0005O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0011)B\u000b\u0003\u00022\u0005\u0005\u0018aD2paf$C-\u001a4bk2$H%\r\u0019\u0016\u0005\tm!\u0006BA\u001f\u0003C\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0011!\u0011\u0011\u0019C!\u000b\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0003w\u000bA\u0001\\1oO&\u00191L!\n\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t=\u0002cA!\u00032%\u0019!1\u0007\"\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\te\"q\b\t\u0004\u0003\nm\u0012b\u0001B\u001f\u0005\n\u0019\u0011I\\=\t\u0013\t\u0005#&!AA\u0002\t=\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003HA1!\u0011\nB(\u0005si!Aa\u0013\u000b\u0007\t5#)\u0001\u0006d_2dWm\u0019;j_:LAA!\u0015\u0003L\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u00119F!\u0018\u0011\u0007\u0005\u0013I&C\u0002\u0003\\\t\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003B1\n\t\u00111\u0001\u0003:\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00030\u0005AAo\\*ue&tw\r\u0006\u0002\u0003\"\u00051Q-];bYN$BAa\u0016\u0003l!I!\u0011I\u0018\u0002\u0002\u0003\u0007!\u0011H\u0001\u0014\u000f\u0016|GK]3mY&\u001cxjZ2T_V\u00148-\u001a\t\u0003\u000fF\u001aB!\rB:\u001bB\u0019\"Q\u000fB>%J\u0013FM\u001b?\u0002\u0018\u0011\f\t$!\u0010\u0002J5\u0011!q\u000f\u0006\u0004\u0005s\u0012\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005{\u00129H\u0001\nBEN$(/Y2u\rVt7\r^5p]F\u0002DC\u0001B8\u0003\u0015\t\u0007\u000f\u001d7z)Y\tIE!\"\u0003\b\n%%1\u0012BG\u0005\u001f\u0013\tJa%\u0003\u0016\n]\u0005\"\u0002)5\u0001\u0004\u0011\u0006\"\u000205\u0001\u0004\u0011\u0006\"\u000215\u0001\u0004\u0011\u0006\"\u000225\u0001\u0004!\u0007\"\u000255\u0001\u0004Q\u0007\"\u0002>5\u0001\u0004a\bbBA\ni\u0001\u0007\u0011q\u0003\u0005\u0007\u0003S!\u0004\u0019\u00013\t\u000f\u00055B\u00071\u0001\u00022!9\u0011\u0011\b\u001bA\u0002\u0005u\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0005;\u0013)\u000b\u0005\u0003BK\n}\u0005\u0003E!\u0003\"J\u0013&\u000b\u001a6}\u0003/!\u0017\u0011GA\u001f\u0013\r\u0011\u0019K\u0011\u0002\b)V\u0004H.Z\u00191\u0011%\u00119+NA\u0001\u0002\u0004\tI%A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u0016\t\u0005\u0005G\u0011y+\u0003\u0003\u00032\n\u0015\"AB(cU\u0016\u001cG\u000f")
public class GeoTrellisOgcSource
implements RasterOgcSource,
Product,
scala.Serializable {
    private GeoTrellisRasterSource source;
    private OgcTime time;
    private final String name;
    private final String title;
    private final String sourceUri;
    private final Option<String> defaultStyle;
    private final List<OgcStyle> styles;
    private final ResampleMethod resampleMethod;
    private final OverviewStrategy overviewStrategy;
    private final Option<String> timeMetadataKey;
    private final OgcTimeFormat timeFormat;
    private final OgcTimeDefault timeDefault;
    private final GeoTrellisPath dataPath;
    private GridExtent<Object> nativeRE;
    private Set<CRS> nativeCrs;
    private Extent nativeExtent;
    private RasterMetadata metadata;
    private Map<String, String> attributes;
    private volatile byte bitmap$0;

    public static Option<Tuple10<String, String, String, Option<String>, List<OgcStyle>, ResampleMethod, OverviewStrategy, Option<String>, OgcTimeFormat, OgcTimeDefault>> unapply(GeoTrellisOgcSource geoTrellisOgcSource) {
        return GeoTrellisOgcSource$.MODULE$.unapply(geoTrellisOgcSource);
    }

    public static GeoTrellisOgcSource apply(String string, String string2, String string3, Option<String> option, List<OgcStyle> list, ResampleMethod resampleMethod, OverviewStrategy overviewStrategy, Option<String> option2, OgcTimeFormat ogcTimeFormat, OgcTimeDefault ogcTimeDefault) {
        return GeoTrellisOgcSource$.MODULE$.apply(string, string2, string3, option, list, resampleMethod, overviewStrategy, option2, ogcTimeFormat, ogcTimeDefault);
    }

    public static Function1<Tuple10<String, String, String, Option<String>, List<OgcStyle>, ResampleMethod, OverviewStrategy, Option<String>, OgcTimeFormat, OgcTimeDefault>, GeoTrellisOgcSource> tupled() {
        return GeoTrellisOgcSource$.MODULE$.tupled();
    }

    public static Function1<String, Function1<String, Function1<String, Function1<Option<String>, Function1<List<OgcStyle>, Function1<ResampleMethod, Function1<OverviewStrategy, Function1<Option<String>, Function1<OgcTimeFormat, Function1<OgcTimeDefault, GeoTrellisOgcSource>>>>>>>>>> curried() {
        return GeoTrellisOgcSource$.MODULE$.curried();
    }

    @Override
    public Extent extentIn(CRS crs) {
        return RasterOgcSource.extentIn$(this, crs);
    }

    @Override
    public boolean isTemporal() {
        return OgcSource.isTemporal$(this);
    }

    @Override
    public ProjectedExtent nativeProjectedExtent() {
        return OgcSource.nativeProjectedExtent$(this);
    }

    @Override
    public ProjectedExtent projectedExtent() {
        return OgcSource.projectedExtent$(this);
    }

    private GridExtent<Object> nativeRE$lzycompute() {
        GeoTrellisOgcSource geoTrellisOgcSource = this;
        synchronized (geoTrellisOgcSource) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.nativeRE = RasterOgcSource.nativeRE$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.nativeRE;
    }

    @Override
    public GridExtent<Object> nativeRE() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.nativeRE$lzycompute() : this.nativeRE;
    }

    private Set<CRS> nativeCrs$lzycompute() {
        GeoTrellisOgcSource geoTrellisOgcSource = this;
        synchronized (geoTrellisOgcSource) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.nativeCrs = RasterOgcSource.nativeCrs$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.nativeCrs;
    }

    @Override
    public Set<CRS> nativeCrs() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.nativeCrs$lzycompute() : this.nativeCrs;
    }

    private Extent nativeExtent$lzycompute() {
        GeoTrellisOgcSource geoTrellisOgcSource = this;
        synchronized (geoTrellisOgcSource) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.nativeExtent = RasterOgcSource.nativeExtent$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.nativeExtent;
    }

    @Override
    public Extent nativeExtent() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.nativeExtent$lzycompute() : this.nativeExtent;
    }

    private RasterMetadata metadata$lzycompute() {
        GeoTrellisOgcSource geoTrellisOgcSource = this;
        synchronized (geoTrellisOgcSource) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.metadata = RasterOgcSource.metadata$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.metadata;
    }

    @Override
    public RasterMetadata metadata() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.metadata$lzycompute() : this.metadata;
    }

    private Map<String, String> attributes$lzycompute() {
        GeoTrellisOgcSource geoTrellisOgcSource = this;
        synchronized (geoTrellisOgcSource) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.attributes = RasterOgcSource.attributes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.attributes;
    }

    @Override
    public Map<String, String> attributes() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.attributes$lzycompute() : this.attributes;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String title() {
        return this.title;
    }

    public String sourceUri() {
        return this.sourceUri;
    }

    @Override
    public Option<String> defaultStyle() {
        return this.defaultStyle;
    }

    @Override
    public List<OgcStyle> styles() {
        return this.styles;
    }

    @Override
    public ResampleMethod resampleMethod() {
        return this.resampleMethod;
    }

    @Override
    public OverviewStrategy overviewStrategy() {
        return this.overviewStrategy;
    }

    @Override
    public Option<String> timeMetadataKey() {
        return this.timeMetadataKey;
    }

    public OgcTimeFormat timeFormat() {
        return this.timeFormat;
    }

    @Override
    public OgcTimeDefault timeDefault() {
        return this.timeDefault;
    }

    @Override
    public SimpleOgcLayer toLayer(CRS crs, Option<OgcStyle> style, List<OgcTime> temporalSequence) {
        GeoTrellisRasterSource geoTrellisRasterSource;
        Some some;
        OgcTime t;
        Option option = temporalSequence.headOption();
        if (option instanceof Some && (t = (OgcTime)(some = (Some)option).value()).nonEmpty()) {
            geoTrellisRasterSource = this.sourceForTime(t);
        } else if (temporalSequence.isEmpty() && this.source().isTemporal()) {
            ZonedDateTime zonedDateTime;
            LazyRef sorted$lzy = new LazyRef();
            OgcTimeDefault ogcTimeDefault = this.timeDefault();
            if (OgcTimeDefault$Oldest$.MODULE$.equals(ogcTimeDefault)) {
                zonedDateTime = (ZonedDateTime)this.sorted$1(sorted$lzy).head();
            } else if (OgcTimeDefault$Newest$.MODULE$.equals(ogcTimeDefault)) {
                zonedDateTime = (ZonedDateTime)this.sorted$1(sorted$lzy).last();
            } else if (ogcTimeDefault instanceof OgcTimeDefault.Time) {
                ZonedDateTime dt;
                OgcTimeDefault.Time time = (OgcTimeDefault.Time)ogcTimeDefault;
                zonedDateTime = dt = time.time();
            } else {
                throw new MatchError((Object)ogcTimeDefault);
            }
            ZonedDateTime time = zonedDateTime;
            geoTrellisRasterSource = this.sourceForTime(time);
        } else {
            geoTrellisRasterSource = this.source();
        }
        GeoTrellisRasterSource src = geoTrellisRasterSource;
        return new SimpleOgcLayer(this.name(), this.title(), crs, (RasterSource)src, style, this.resampleMethod(), this.overviewStrategy());
    }

    private GeoTrellisPath dataPath() {
        return this.dataPath;
    }

    private GeoTrellisRasterSource source$lzycompute() {
        GeoTrellisOgcSource geoTrellisOgcSource = this;
        synchronized (geoTrellisOgcSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                AttributeStore attributeStore = AttributeStore$.MODULE$.apply(this.dataPath().value());
                this.source = new GeoTrellisRasterSource(attributeStore, this.dataPath(), GeoTrellisRasterSource$.MODULE$.getSourceLayersByName(attributeStore, this.dataPath().layerName(), BoxesRunTime.unboxToInt((Object)this.dataPath().bandCount().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1))), (Option)None$.MODULE$, (Option)None$.MODULE$, (String)this.timeMetadataKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> SimpleSource$.MODULE$.TimeFieldDefault()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.source;
    }

    public GeoTrellisRasterSource source() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.source$lzycompute() : this.source;
    }

    private OgcTime time$lzycompute() {
        GeoTrellisOgcSource geoTrellisOgcSource = this;
        synchronized (geoTrellisOgcSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.time = !this.source().isTemporal() ? OgcTimeEmpty$.MODULE$ : OgcTime$OgcTimeOps$.MODULE$.sorted$extension(OgcTime$.MODULE$.OgcTimeOps(OgcTime$OgcTimeOps$.MODULE$.format$extension(OgcTime$.MODULE$.OgcTimeOps(OgcTimePositions$.MODULE$.apply((List<ZonedDateTime>)this.source().times())), this.timeFormat())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.time;
    }

    @Override
    public OgcTime time() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.time$lzycompute() : this.time;
    }

    public GeoTrellisRasterSource sourceForTime(OgcTime interval) {
        GeoTrellisRasterSource geoTrellisRasterSource;
        if (this.source().isTemporal()) {
            OgcTime ogcTime = this.time();
            Object object = OgcTimeEmpty$.MODULE$.equals(ogcTime) ? None$.MODULE$ : this.source().times().find((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)GeoTrellisOgcSource.$anonfun$sourceForTime$1(interval, t))).map((Function1 & Serializable & scala.Serializable)time -> this.sourceForTime((ZonedDateTime)time));
            geoTrellisRasterSource = (GeoTrellisRasterSource)object.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.source());
        } else {
            geoTrellisRasterSource = this.source();
        }
        return geoTrellisRasterSource;
    }

    public GeoTrellisRasterSource sourceForTime(ZonedDateTime time) {
        return this.source().isTemporal() ? GeoTrellisRasterSource$.MODULE$.apply(this.dataPath(), (Option)new Some((Object)time)) : this.source();
    }

    public GeoTrellisOgcSource copy(String name, String title, String sourceUri, Option<String> defaultStyle, List<OgcStyle> styles, ResampleMethod resampleMethod, OverviewStrategy overviewStrategy, Option<String> timeMetadataKey, OgcTimeFormat timeFormat, OgcTimeDefault timeDefault) {
        return new GeoTrellisOgcSource(name, title, sourceUri, defaultStyle, styles, resampleMethod, overviewStrategy, timeMetadataKey, timeFormat, timeDefault);
    }

    public String copy$default$1() {
        return this.name();
    }

    public OgcTimeDefault copy$default$10() {
        return this.timeDefault();
    }

    public String copy$default$2() {
        return this.title();
    }

    public String copy$default$3() {
        return this.sourceUri();
    }

    public Option<String> copy$default$4() {
        return this.defaultStyle();
    }

    public List<OgcStyle> copy$default$5() {
        return this.styles();
    }

    public ResampleMethod copy$default$6() {
        return this.resampleMethod();
    }

    public OverviewStrategy copy$default$7() {
        return this.overviewStrategy();
    }

    public Option<String> copy$default$8() {
        return this.timeMetadataKey();
    }

    public OgcTimeFormat copy$default$9() {
        return this.timeFormat();
    }

    public String productPrefix() {
        return "GeoTrellisOgcSource";
    }

    public int productArity() {
        return 10;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.name();
                break;
            }
            case 1: {
                object = this.title();
                break;
            }
            case 2: {
                object = this.sourceUri();
                break;
            }
            case 3: {
                object = this.defaultStyle();
                break;
            }
            case 4: {
                object = this.styles();
                break;
            }
            case 5: {
                object = this.resampleMethod();
                break;
            }
            case 6: {
                object = this.overviewStrategy();
                break;
            }
            case 7: {
                object = this.timeMetadataKey();
                break;
            }
            case 8: {
                object = this.timeFormat();
                break;
            }
            case 9: {
                object = this.timeDefault();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GeoTrellisOgcSource;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GeoTrellisOgcSource)) return false;
        boolean bl = true;
        if (!bl) return false;
        GeoTrellisOgcSource geoTrellisOgcSource = (GeoTrellisOgcSource)x$1;
        String string = this.name();
        String string2 = geoTrellisOgcSource.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.title();
        String string4 = geoTrellisOgcSource.title();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.sourceUri();
        String string6 = geoTrellisOgcSource.sourceUri();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        Option<String> option = this.defaultStyle();
        Option<String> option2 = geoTrellisOgcSource.defaultStyle();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        List<OgcStyle> list = this.styles();
        List<OgcStyle> list2 = geoTrellisOgcSource.styles();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        ResampleMethod resampleMethod = this.resampleMethod();
        ResampleMethod resampleMethod2 = geoTrellisOgcSource.resampleMethod();
        if (resampleMethod == null) {
            if (resampleMethod2 != null) {
                return false;
            }
        } else if (!resampleMethod.equals(resampleMethod2)) return false;
        OverviewStrategy overviewStrategy = this.overviewStrategy();
        OverviewStrategy overviewStrategy2 = geoTrellisOgcSource.overviewStrategy();
        if (overviewStrategy == null) {
            if (overviewStrategy2 != null) {
                return false;
            }
        } else if (!overviewStrategy.equals(overviewStrategy2)) return false;
        Option<String> option3 = this.timeMetadataKey();
        Option<String> option4 = geoTrellisOgcSource.timeMetadataKey();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        OgcTimeFormat ogcTimeFormat = this.timeFormat();
        OgcTimeFormat ogcTimeFormat2 = geoTrellisOgcSource.timeFormat();
        if (ogcTimeFormat == null) {
            if (ogcTimeFormat2 != null) {
                return false;
            }
        } else if (!ogcTimeFormat.equals(ogcTimeFormat2)) return false;
        OgcTimeDefault ogcTimeDefault = this.timeDefault();
        OgcTimeDefault ogcTimeDefault2 = geoTrellisOgcSource.timeDefault();
        if (ogcTimeDefault == null) {
            if (ogcTimeDefault2 != null) {
                return false;
            }
        } else if (!ogcTimeDefault.equals(ogcTimeDefault2)) return false;
        if (!geoTrellisOgcSource.canEqual(this)) return false;
        return true;
    }

    private final /* synthetic */ List sorted$lzycompute$1(LazyRef sorted$lzy$1) {
        List list;
        LazyRef lazyRef = sorted$lzy$1;
        synchronized (lazyRef) {
            list = sorted$lzy$1.initialized() ? (List)sorted$lzy$1.value() : (List)sorted$lzy$1.initialize(this.source().times().sorted(Imports$.MODULE$.zonedDateTimeOrdering()));
        }
        return list;
    }

    private final List sorted$1(LazyRef sorted$lzy$1) {
        return sorted$lzy$1.initialized() ? (List)sorted$lzy$1.value() : this.sorted$lzycompute$1(sorted$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$sourceForTime$2(ZonedDateTime t$1, ZonedDateTime x$1) {
        ZonedDateTime zonedDateTime = x$1;
        ZonedDateTime zonedDateTime2 = t$1;
        return !(zonedDateTime != null ? !((Object)zonedDateTime).equals(zonedDateTime2) : zonedDateTime2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sourceForTime$1(OgcTime interval$1, ZonedDateTime t) {
        boolean bl;
        OgcTime ogcTime = interval$1;
        if (ogcTime instanceof OgcTimeInterval) {
            OgcTimeInterval ogcTimeInterval = (OgcTimeInterval)ogcTime;
            ZonedDateTime start = ogcTimeInterval.start();
            ZonedDateTime end = ogcTimeInterval.end();
            bl = new RichZonedDateTime(Imports$.MODULE$.richZonedDateTime(start)).$less$eq((Object)t) && new RichZonedDateTime(Imports$.MODULE$.richZonedDateTime(t)).$less$eq((Object)end);
        } else if (ogcTime instanceof OgcTimePositions) {
            OgcTimePositions ogcTimePositions = (OgcTimePositions)ogcTime;
            NonEmptyList<ZonedDateTime> list = ogcTimePositions.list();
            bl = list.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoTrellisOgcSource.$anonfun$sourceForTime$2(t, x$1)));
        } else if (OgcTimeEmpty$.MODULE$.equals(ogcTime)) {
            bl = false;
        } else {
            throw new MatchError((Object)ogcTime);
        }
        return bl;
    }

    public GeoTrellisOgcSource(String name, String title, String sourceUri, Option<String> defaultStyle, List<OgcStyle> styles, ResampleMethod resampleMethod, OverviewStrategy overviewStrategy, Option<String> timeMetadataKey, OgcTimeFormat timeFormat, OgcTimeDefault timeDefault) {
        this.name = name;
        this.title = title;
        this.sourceUri = sourceUri;
        this.defaultStyle = defaultStyle;
        this.styles = styles;
        this.resampleMethod = resampleMethod;
        this.overviewStrategy = overviewStrategy;
        this.timeMetadataKey = timeMetadataKey;
        this.timeFormat = timeFormat;
        this.timeDefault = timeDefault;
        OgcSource.$init$(this);
        RasterOgcSource.$init$(this);
        Product.$init$((Product)this);
        this.dataPath = GeoTrellisPath$.MODULE$.parse(sourceUri);
    }
}

