/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.syntax.package;
import com.azavea.maml.ast.Expression;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.GridExtent;
import geotrellis.raster.RasterMetadata;
import geotrellis.raster.RasterSource;
import geotrellis.raster.SourceName;
import geotrellis.raster.StringName;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.server.extent.SampleUtils$;
import geotrellis.server.ogc.MapAlgebraSource$;
import geotrellis.server.ogc.MapAlgebraSourceMetadata;
import geotrellis.server.ogc.OgcSource;
import geotrellis.server.ogc.OgcTime;
import geotrellis.server.ogc.OgcTime$;
import geotrellis.server.ogc.OgcTime$OgcTimeOps$;
import geotrellis.server.ogc.OgcTimeDefault;
import geotrellis.server.ogc.OgcTimeEmpty$;
import geotrellis.server.ogc.OgcTimeFormat;
import geotrellis.server.ogc.RasterOgcSource;
import geotrellis.server.ogc.style.OgcStyle;
import geotrellis.server.ogc.wms.CapabilitiesView$;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import opengis.wms.BoundingBox;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple11;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import spire.math.Integral;
import spire.math.Integral$;

@ScalaSignature(bytes="\u0006\u0001\ruc\u0001B#G\u00016C\u0001B\u0018\u0001\u0003\u0016\u0004%\ta\u0018\u0005\tW\u0002\u0011\t\u0012)A\u0005A\"AA\u000e\u0001BK\u0002\u0013\u0005q\f\u0003\u0005n\u0001\tE\t\u0015!\u0003a\u0011!q\u0007A!f\u0001\n\u0003y\u0007\u0002\u0003<\u0001\u0005#\u0005\u000b\u0011\u00029\t\u0011]\u0004!Q3A\u0005\u0002aD\u0011\"a\u0003\u0001\u0005#\u0005\u000b\u0011B=\t\u0015\u00055\u0001A!f\u0001\n\u0003\ty\u0001\u0003\u0006\u0002\u0018\u0001\u0011\t\u0012)A\u0005\u0003#A!\"!\u0007\u0001\u0005+\u0007I\u0011AA\u000e\u0011)\tY\u0004\u0001B\tB\u0003%\u0011Q\u0004\u0005\u000b\u0003{\u0001!Q3A\u0005\u0002\u0005}\u0002BCA-\u0001\tE\t\u0015!\u0003\u0002B!Q\u00111\f\u0001\u0003\u0016\u0004%\t!!\u0018\t\u0015\u0005=\u0004A!E!\u0002\u0013\ty\u0006\u0003\u0006\u0002r\u0001\u0011)\u001a!C\u0001\u0003gB!\"a\u001f\u0001\u0005#\u0005\u000b\u0011BA;\u0011)\ti\b\u0001BK\u0002\u0013\u0005\u0011q\u0010\u0005\u000b\u0003\u000f\u0003!\u0011#Q\u0001\n\u0005\u0005\u0005BCAE\u0001\tU\r\u0011\"\u0001\u0002\f\"Q\u0011Q\u0013\u0001\u0003\u0012\u0003\u0006I!!$\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"I\u00111\u0017\u0001C\u0002\u0013\u0005\u0011q\u0002\u0005\t\u0003k\u0003\u0001\u0015!\u0003\u0002\u0012!Q\u0011q\u0017\u0001\t\u0006\u0004%\t!!/\t\u0015\u0005\u0015\u0007\u0001#b\u0001\n\u0003\t9\r\u0003\u0006\u0002L\u0002A)\u0019!C\u0001\u0003\u001bDq!!5\u0001\t\u0003\t\u0019\u000eC\u0004\u0002r\u0002!\t!a=\t\u0015\t\u001d\u0001\u0001#b\u0001\n\u0003\u0011I\u0001\u0003\u0006\u0003\u0012\u0001A)\u0019!C\u0001\u0005'A!B!\u0006\u0001\u0011\u000b\u0007I\u0011\u0001B\f\u0011%\u0011)\u0003\u0001b\u0001\n\u0003\u00119\u0003\u0003\u0005\u00030\u0001\u0001\u000b\u0011\u0002B\u0015\u0011%\u0011\t\u0004\u0001b\u0001\n\u0003\u0011\u0019\u0004\u0003\u0005\u00038\u0001\u0001\u000b\u0011\u0002B\u001b\u0011)\u0011I\u0004\u0001EC\u0002\u0013\u0005!1\b\u0005\u000b\u0005\u0007\u0002\u0001R1A\u0005\u0002\t\u0015\u0003B\u0003B'\u0001!\u0015\r\u0011\"\u0001\u0003P!Q!1\u000b\u0001\t\u0006\u0004%\tA!\u0016\t\u0013\t}\u0003!!A\u0005\u0002\t\u0005\u0004\"\u0003B=\u0001E\u0005I\u0011\u0001B>\u0011%\u0011\t\nAI\u0001\n\u0003\u0011Y\bC\u0005\u0003\u0014\u0002\t\n\u0011\"\u0001\u0003\u0016\"I!\u0011\u0014\u0001\u0012\u0002\u0013\u0005!1\u0014\u0005\n\u0005?\u0003\u0011\u0013!C\u0001\u0005CC\u0011B!*\u0001#\u0003%\tAa*\t\u0013\t-\u0006!%A\u0005\u0002\t5\u0006\"\u0003BY\u0001E\u0005I\u0011\u0001BZ\u0011%\u00119\fAI\u0001\n\u0003\u0011I\fC\u0005\u0003>\u0002\t\n\u0011\"\u0001\u0003@\"I!1\u0019\u0001\u0012\u0002\u0013\u0005!Q\u0019\u0005\n\u0005\u0013\u0004\u0011\u0011!C!\u0005\u0017D\u0011Ba7\u0001\u0003\u0003%\tA!\u0012\t\u0013\tu\u0007!!A\u0005\u0002\t}\u0007\"\u0003Bv\u0001\u0005\u0005I\u0011\tBw\u0011%\u0011Y\u0010AA\u0001\n\u0003\u0011i\u0010C\u0005\u0004\b\u0001\t\t\u0011\"\u0011\u0004\n!I11\u0002\u0001\u0002\u0002\u0013\u00053Q\u0002\u0005\n\u0007\u001f\u0001\u0011\u0011!C!\u0007#9\u0011b!\u0006G\u0003\u0003E\taa\u0006\u0007\u0011\u00153\u0015\u0011!E\u0001\u00073Aq!a&@\t\u0003\u00199\u0003C\u0005\u0004\f}\n\t\u0011\"\u0012\u0004\u000e!I1\u0011F \u0002\u0002\u0013\u000551\u0006\u0005\n\u0007\u0007z\u0014\u0011!CA\u0007\u000bB\u0011ba\u0015@\u0003\u0003%Ia!\u0016\u0003!5\u000b\u0007/\u00117hK\n\u0014\u0018mU8ve\u000e,'BA$I\u0003\rywm\u0019\u0006\u0003\u0013*\u000baa]3sm\u0016\u0014(\"A&\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u000b\u0001qE\u000bW.\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\r\u0005s\u0017PU3g!\t)f+D\u0001G\u0013\t9fIA\u0005PO\u000e\u001cv.\u001e:dKB\u0011q*W\u0005\u00035B\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002P9&\u0011Q\f\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005]\u0006lW-F\u0001a!\t\t\u0007N\u0004\u0002cMB\u00111\rU\u0007\u0002I*\u0011Q\rT\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\u0004\u0016A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!a\u001a)\u0002\u000b9\fW.\u001a\u0011\u0002\u000bQLG\u000f\\3\u0002\rQLG\u000f\\3!\u0003)ywmY*pkJ\u001cWm]\u000b\u0002aB!\u0011-\u001d1t\u0013\t\u0011(NA\u0002NCB\u0004\"!\u0016;\n\u0005U4%a\u0004*bgR,'oT4d'>,(oY3\u0002\u0017=<7mU8ve\u000e,7\u000fI\u0001\bC2<WM\u0019:b+\u0005I\bc\u0001>\u0002\b5\t1P\u0003\u0002}{\u0006\u0019\u0011m\u001d;\u000b\u0005y|\u0018\u0001B7b[2TA!!\u0001\u0002\u0004\u00051\u0011M_1wK\u0006T!!!\u0002\u0002\u0007\r|W.C\u0002\u0002\nm\u0014!\"\u0012=qe\u0016\u001c8/[8o\u0003!\tGnZ3ce\u0006\u0004\u0013\u0001\u00043fM\u0006,H\u000e^*us2,WCAA\t!\u0011y\u00151\u00031\n\u0007\u0005U\u0001K\u0001\u0004PaRLwN\\\u0001\u000eI\u00164\u0017-\u001e7u'RLH.\u001a\u0011\u0002\rM$\u0018\u0010\\3t+\t\ti\u0002\u0005\u0004\u0002 \u0005%\u0012q\u0006\b\u0005\u0003C\t)CD\u0002d\u0003GI\u0011!U\u0005\u0004\u0003O\u0001\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003W\tiC\u0001\u0003MSN$(bAA\u0014!B!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026\u0019\u000bQa\u001d;zY\u0016LA!!\u000f\u00024\tAqjZ2TifdW-A\u0004tifdWm\u001d\u0011\u0002\u001dI,7/Y7qY\u0016lU\r\u001e5pIV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\n\u0019F\u0004\u0003\u0002F\u0005=c\u0002BA$\u0003\u0017r1aYA%\u0013\u0005Y\u0015bAA'\u0015\u00061!/Y:uKJLA!a\n\u0002R)\u0019\u0011Q\n&\n\t\u0005U\u0013q\u000b\u0002\u000f%\u0016\u001c\u0018-\u001c9mK6+G\u000f[8e\u0015\u0011\t9#!\u0015\u0002\u001fI,7/Y7qY\u0016lU\r\u001e5pI\u0002\n\u0001c\u001c<feZLWm^*ue\u0006$XmZ=\u0016\u0005\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\bO\u0016|G/\u001b4g\u0015\u0011\tI'!\u0015\u0002\u0005%|\u0017\u0002BA7\u0003G\u0012\u0001c\u0014<feZLWm^*ue\u0006$XmZ=\u0002#=4XM\u001d<jK^\u001cFO]1uK\u001eL\b%\u0001\u0006uS6,gi\u001c:nCR,\"!!\u001e\u0011\u0007U\u000b9(C\u0002\u0002z\u0019\u0013QbT4d)&lWMR8s[\u0006$\u0018a\u0003;j[\u00164uN]7bi\u0002\n1\u0002^5nK\u0012+g-Y;miV\u0011\u0011\u0011\u0011\t\u0004+\u0006\r\u0015bAAC\r\nqqjZ2US6,G)\u001a4bk2$\u0018\u0001\u0004;j[\u0016$UMZ1vYR\u0004\u0013A\u0004;be\u001e,GoQ3mYRK\b/Z\u000b\u0003\u0003\u001b\u0003RaTA\n\u0003\u001f\u0003B!a\u0011\u0002\u0012&!\u00111SA,\u0005!\u0019U\r\u001c7UsB,\u0017a\u0004;be\u001e,GoQ3mYRK\b/\u001a\u0011\u0002\rqJg.\u001b;?)a\tY*!(\u0002 \u0006\u0005\u00161UAS\u0003O\u000bI+a+\u0002.\u0006=\u0016\u0011\u0017\t\u0003+\u0002AQAX\fA\u0002\u0001DQ\u0001\\\fA\u0002\u0001DQA\\\fA\u0002ADQa^\fA\u0002eDq!!\u0004\u0018\u0001\u0004\t\t\u0002C\u0004\u0002\u001a]\u0001\r!!\b\t\u000f\u0005ur\u00031\u0001\u0002B!9\u00111L\fA\u0002\u0005}\u0003bBA9/\u0001\u0007\u0011Q\u000f\u0005\b\u0003{:\u0002\u0019AAA\u0011\u001d\tIi\u0006a\u0001\u0003\u001b\u000bq\u0002^5nK6+G/\u00193bi\u0006\\U-_\u0001\u0011i&lW-T3uC\u0012\fG/Y&fs\u0002\nqa]8ve\u000e,7/\u0006\u0002\u0002<B)\u0011-\u001d1\u0002>B!\u0011qXAa\u001b\t\t\t&\u0003\u0003\u0002D\u0006E#\u0001\u0004*bgR,'oU8ve\u000e,\u0017aC:pkJ\u001cWm\u001d'jgR,\"!!3\u0011\r\u0005}\u0011\u0011FA_\u00039ywmY*pkJ\u001cWm\u001d'jgR,\"!a4\u0011\u000b\u0005}\u0011\u0011F:\u0002\u0011\u0015DH/\u001a8u\u0013:$B!!6\u0002bB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\*\u000baA^3di>\u0014\u0018\u0002BAp\u00033\u0014a!\u0012=uK:$\bbBAr;\u0001\u0007\u0011Q]\u0001\u0004GJ\u001c\b\u0003BAt\u0003[l!!!;\u000b\u0007\u0005-(*A\u0003qe>TG'\u0003\u0003\u0002p\u0006%(aA\"S'\u00061!MY8y\u0013:$B!!>\u0003\u0006A!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018aA<ng*\u0011\u0011q`\u0001\b_B,gnZ5t\u0013\u0011\u0011\u0019!!?\u0003\u0017\t{WO\u001c3j]\u001e\u0014u\u000e\u001f\u0005\b\u0003Gt\u0002\u0019AAs\u0003!iW\r^1eCR\fWC\u0001B\u0006!\r)&QB\u0005\u0004\u0005\u001f1%\u0001G'ba\u0006cw-\u001a2sCN{WO]2f\u001b\u0016$\u0018\rZ1uC\u0006aa.\u0019;jm\u0016,\u0005\u0010^3oiV\u0011\u0011Q[\u0001\t]\u0006$\u0018N^3S\u000bV\u0011!\u0011\u0004\t\u0007\u0003\u007f\u0013YBa\b\n\t\tu\u0011\u0011\u000b\u0002\u000b\u000fJLG-\u0012=uK:$\bcA(\u0003\"%\u0019!1\u0005)\u0003\t1{gnZ\u0001\u0005i&lW-\u0006\u0002\u0003*A\u0019QKa\u000b\n\u0007\t5bIA\u0004PO\u000e$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0015\u0005$HO]5ckR,7/\u0006\u0002\u00036A!\u0011-\u001d1a\u0003-\tG\u000f\u001e:jEV$Xm\u001d\u0011\u0002\u00139\fG/\u001b<f\u0007J\u001cXC\u0001B\u001f!\u0015\t'qHAs\u0013\r\u0011\tE\u001b\u0002\u0004'\u0016$\u0018\u0001D7j]\n\u000bg\u000eZ\"pk:$XC\u0001B$!\ry%\u0011J\u0005\u0004\u0005\u0017\u0002&aA%oi\u0006I1-\u001a7m)f\u0004Xm]\u000b\u0003\u0005#\u0002R!\u0019B \u0003\u001f\u000b1B]3t_2,H/[8ogV\u0011!q\u000b\t\u0007\u0003?\tIC!\u0017\u0011\t\u0005}&1L\u0005\u0005\u0005;\n\tF\u0001\u0005DK2d7+\u001b>f\u0003\u0011\u0019w\u000e]=\u00151\u0005m%1\rB3\u0005O\u0012IGa\u001b\u0003n\t=$\u0011\u000fB:\u0005k\u00129\bC\u0004_UA\u0005\t\u0019\u00011\t\u000f1T\u0003\u0013!a\u0001A\"9aN\u000bI\u0001\u0002\u0004\u0001\bbB<+!\u0003\u0005\r!\u001f\u0005\n\u0003\u001bQ\u0003\u0013!a\u0001\u0003#A\u0011\"!\u0007+!\u0003\u0005\r!!\b\t\u0013\u0005u\"\u0006%AA\u0002\u0005\u0005\u0003\"CA.UA\u0005\t\u0019AA0\u0011%\t\tH\u000bI\u0001\u0002\u0004\t)\bC\u0005\u0002~)\u0002\n\u00111\u0001\u0002\u0002\"I\u0011\u0011\u0012\u0016\u0011\u0002\u0003\u0007\u0011QR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iHK\u0002a\u0005\u007fZ#A!!\u0011\t\t\r%QR\u0007\u0003\u0005\u000bSAAa\"\u0003\n\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0017\u0003\u0016AC1o]>$\u0018\r^5p]&!!q\u0012BC\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa&+\u0007A\u0014y(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tu%fA=\u0003\u0000\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001BRU\u0011\t\tBa \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!\u0011\u0016\u0016\u0005\u0003;\u0011y(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t=&\u0006BA!\u0005\u007f\nabY8qs\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u00036*\"\u0011q\fB@\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIe*\"Aa/+\t\u0005U$qP\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132aU\u0011!\u0011\u0019\u0016\u0005\u0003\u0003\u0013y(A\bd_BLH\u0005Z3gCVdG\u000fJ\u00192+\t\u00119M\u000b\u0003\u0002\u000e\n}\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003NB!!q\u001aBm\u001b\t\u0011\tN\u0003\u0003\u0003T\nU\u0017\u0001\u00027b]\u001eT!Aa6\u0002\t)\fg/Y\u0005\u0004S\nE\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005C\u00149\u000fE\u0002P\u0005GL1A!:Q\u0005\r\te.\u001f\u0005\n\u0005SD\u0014\u0011!a\u0001\u0005\u000f\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001Bx!\u0019\u0011\tPa>\u0003b6\u0011!1\u001f\u0006\u0004\u0005k\u0004\u0016AC2pY2,7\r^5p]&!!\u0011 Bz\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t}8Q\u0001\t\u0004\u001f\u000e\u0005\u0011bAB\u0002!\n9!i\\8mK\u0006t\u0007\"\u0003Buu\u0005\u0005\t\u0019\u0001Bq\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B$\u0003!!xn\u0015;sS:<GC\u0001Bg\u0003\u0019)\u0017/^1mgR!!q`B\n\u0011%\u0011I/PA\u0001\u0002\u0004\u0011\t/\u0001\tNCB\fEnZ3ce\u0006\u001cv.\u001e:dKB\u0011QkP\n\u0005\u007f\rm1\f\u0005\r\u0004\u001e\r\r\u0002\r\u00199z\u0003#\ti\"!\u0011\u0002`\u0005U\u0014\u0011QAG\u00037k!aa\b\u000b\u0007\r\u0005\u0002+A\u0004sk:$\u0018.\\3\n\t\r\u00152q\u0004\u0002\u0013\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0014\u0007\u0006\u0002\u0004\u0018\u0005)\u0011\r\u001d9msRA\u00121TB\u0017\u0007_\u0019\tda\r\u00046\r]2\u0011HB\u001e\u0007{\u0019yd!\u0011\t\u000by\u0013\u0005\u0019\u00011\t\u000b1\u0014\u0005\u0019\u00011\t\u000b9\u0014\u0005\u0019\u00019\t\u000b]\u0014\u0005\u0019A=\t\u000f\u00055!\t1\u0001\u0002\u0012!9\u0011\u0011\u0004\"A\u0002\u0005u\u0001bBA\u001f\u0005\u0002\u0007\u0011\u0011\t\u0005\b\u00037\u0012\u0005\u0019AA0\u0011\u001d\t\tH\u0011a\u0001\u0003kBq!! C\u0001\u0004\t\t\tC\u0004\u0002\n\n\u0003\r!!$\u0002\u000fUt\u0017\r\u001d9msR!1qIB(!\u0015y\u00151CB%!Uy51\n1aaf\f\t\"!\b\u0002B\u0005}\u0013QOAA\u0003\u001bK1a!\u0014Q\u0005\u001d!V\u000f\u001d7fcEB\u0011b!\u0015D\u0003\u0003\u0005\r!a'\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAB,!\u0011\u0011ym!\u0017\n\t\rm#\u0011\u001b\u0002\u0007\u001f\nTWm\u0019;")
public class MapAlgebraSource
implements OgcSource,
Product,
scala.Serializable {
    private Map<String, RasterSource> sources;
    private List<RasterSource> sourcesList;
    private List<RasterOgcSource> ogcSourcesList;
    private MapAlgebraSourceMetadata metadata;
    private Extent nativeExtent;
    private GridExtent<Object> nativeRE;
    private Set<CRS> nativeCrs;
    private int minBandCount;
    private Set<DataType> cellTypes;
    private List<CellSize> resolutions;
    private final String name;
    private final String title;
    private final Map<String, RasterOgcSource> ogcSources;
    private final Expression algebra;
    private final Option<String> defaultStyle;
    private final List<OgcStyle> styles;
    private final ResampleMethod resampleMethod;
    private final OverviewStrategy overviewStrategy;
    private final OgcTimeFormat timeFormat;
    private final OgcTimeDefault timeDefault;
    private final Option<DataType> targetCellType;
    private final Option<String> timeMetadataKey;
    private final OgcTime time;
    private final Map<String, String> attributes;
    private volatile int bitmap$0;

    public static Option<Tuple11<String, String, Map<String, RasterOgcSource>, Expression, Option<String>, List<OgcStyle>, ResampleMethod, OverviewStrategy, OgcTimeFormat, OgcTimeDefault, Option<DataType>>> unapply(MapAlgebraSource mapAlgebraSource) {
        return MapAlgebraSource$.MODULE$.unapply(mapAlgebraSource);
    }

    public static MapAlgebraSource apply(String string, String string2, Map<String, RasterOgcSource> map, Expression expression, Option<String> option, List<OgcStyle> list, ResampleMethod resampleMethod, OverviewStrategy overviewStrategy, OgcTimeFormat ogcTimeFormat, OgcTimeDefault ogcTimeDefault, Option<DataType> option2) {
        return MapAlgebraSource$.MODULE$.apply(string, string2, map, expression, option, list, resampleMethod, overviewStrategy, ogcTimeFormat, ogcTimeDefault, option2);
    }

    public static Function1<Tuple11<String, String, Map<String, RasterOgcSource>, Expression, Option<String>, List<OgcStyle>, ResampleMethod, OverviewStrategy, OgcTimeFormat, OgcTimeDefault, Option<DataType>>, MapAlgebraSource> tupled() {
        return MapAlgebraSource$.MODULE$.tupled();
    }

    public static Function1<String, Function1<String, Function1<Map<String, RasterOgcSource>, Function1<Expression, Function1<Option<String>, Function1<List<OgcStyle>, Function1<ResampleMethod, Function1<OverviewStrategy, Function1<OgcTimeFormat, Function1<OgcTimeDefault, Function1<Option<DataType>, MapAlgebraSource>>>>>>>>>>> curried() {
        return MapAlgebraSource$.MODULE$.curried();
    }

    @Override
    public boolean isTemporal() {
        return OgcSource.isTemporal$(this);
    }

    @Override
    public ProjectedExtent nativeProjectedExtent() {
        return OgcSource.nativeProjectedExtent$(this);
    }

    @Override
    public ProjectedExtent projectedExtent() {
        return OgcSource.projectedExtent$(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String title() {
        return this.title;
    }

    public Map<String, RasterOgcSource> ogcSources() {
        return this.ogcSources;
    }

    public Expression algebra() {
        return this.algebra;
    }

    @Override
    public Option<String> defaultStyle() {
        return this.defaultStyle;
    }

    @Override
    public List<OgcStyle> styles() {
        return this.styles;
    }

    @Override
    public ResampleMethod resampleMethod() {
        return this.resampleMethod;
    }

    @Override
    public OverviewStrategy overviewStrategy() {
        return this.overviewStrategy;
    }

    public OgcTimeFormat timeFormat() {
        return this.timeFormat;
    }

    @Override
    public OgcTimeDefault timeDefault() {
        return this.timeDefault;
    }

    public Option<DataType> targetCellType() {
        return this.targetCellType;
    }

    @Override
    public Option<String> timeMetadataKey() {
        return this.timeMetadataKey;
    }

    private Map<String, RasterSource> sources$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sources = this.ogcSources().mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.source());
                this.bitmap$0 |= 1;
            }
        }
        return this.sources;
    }

    public Map<String, RasterSource> sources() {
        return (this.bitmap$0 & 1) == 0 ? this.sources$lzycompute() : this.sources;
    }

    private List<RasterSource> sourcesList$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 2) == 0) {
                this.sourcesList = this.sources().values().toList();
                this.bitmap$0 |= 2;
            }
        }
        return this.sourcesList;
    }

    public List<RasterSource> sourcesList() {
        return (this.bitmap$0 & 2) == 0 ? this.sourcesList$lzycompute() : this.sourcesList;
    }

    private List<RasterOgcSource> ogcSourcesList$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 4) == 0) {
                this.ogcSourcesList = this.ogcSources().values().toList();
                this.bitmap$0 |= 4;
            }
        }
        return this.ogcSourcesList;
    }

    public List<RasterOgcSource> ogcSourcesList() {
        return (this.bitmap$0 & 4) == 0 ? this.ogcSourcesList$lzycompute() : this.ogcSourcesList;
    }

    @Override
    public Extent extentIn(CRS crs) {
        return (Extent)SampleUtils$.MODULE$.intersectExtents((List)this.sourcesList().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.reproject(crs, x$3.reproject$default$2(), x$3.reproject$default$3(), x$3.reproject$default$4()).extent(), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("no intersection found among map map algebra sources");
        });
    }

    public BoundingBox bboxIn(CRS crs) {
        NonEmptyList reprojectedSources = NonEmptyList$.MODULE$.fromListUnsafe((List)this.sourcesList().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.reproject(crs, x$4.reproject$default$2(), x$4.reproject$default$3(), x$4.reproject$default$4()), List$.MODULE$.canBuildFrom()));
        NonEmptyList extents = reprojectedSources.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.extent());
        Option extentIntersection = SampleUtils$.MODULE$.intersectExtents(extents);
        CellSize cellSize = SampleUtils$.MODULE$.chooseLargestCellSize(reprojectedSources.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.cellSize()));
        Option option = extentIntersection;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception("no intersection found among map map algebra sources");
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Extent extent = (Extent)some.value();
        BoundingBox boundingBox = CapabilitiesView$.MODULE$.boundingBox(crs, extent, cellSize);
        return boundingBox;
    }

    private MapAlgebraSourceMetadata metadata$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 8) == 0) {
                this.metadata = new MapAlgebraSourceMetadata((SourceName)new StringName(this.name()), (CRS)this.nativeCrs().head(), this.minBandCount(), (DataType)this.cellTypes().head(), this.nativeRE(), this.resolutions(), (Map<String, RasterMetadata>)this.sources().mapValues((Function1 & Serializable & scala.Serializable)x$7 -> x$7.metadata()));
                this.bitmap$0 |= 8;
            }
        }
        return this.metadata;
    }

    @Override
    public MapAlgebraSourceMetadata metadata() {
        return (this.bitmap$0 & 8) == 0 ? this.metadata$lzycompute() : this.metadata;
    }

    private Extent nativeExtent$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 0x10) == 0) {
                Extent extent;
                Option option = SampleUtils$.MODULE$.intersectExtents((List)this.sourcesList().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.reproject((CRS)this.nativeCrs().head(), x$8.reproject$default$2(), x$8.reproject$default$3(), x$8.reproject$default$4()).extent(), List$.MODULE$.canBuildFrom()));
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new Exception("no intersection found among map algebra sources");
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                Extent extent2 = extent = (Extent)some.value();
                this.nativeExtent = extent2;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.nativeExtent;
    }

    @Override
    public Extent nativeExtent() {
        return (this.bitmap$0 & 0x10) == 0 ? this.nativeExtent$lzycompute() : this.nativeExtent;
    }

    private GridExtent<Object> nativeRE$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 0x20) == 0) {
                NonEmptyList reprojectedSources = NonEmptyList$.MODULE$.fromListUnsafe((List)this.sourcesList().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.reproject((CRS)this.nativeCrs().head(), x$9.reproject$default$2(), x$9.reproject$default$3(), x$9.reproject$default$4()), List$.MODULE$.canBuildFrom()));
                CellSize cellSize = SampleUtils$.MODULE$.chooseSmallestCellSize(reprojectedSources.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.cellSize()));
                this.nativeRE = new GridExtent.mcJ.sp(this.nativeExtent(), cellSize, (Integral)Integral$.MODULE$.LongIsIntegral());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.nativeRE;
    }

    @Override
    public GridExtent<Object> nativeRE() {
        return (this.bitmap$0 & 0x20) == 0 ? this.nativeRE$lzycompute() : this.nativeRE;
    }

    @Override
    public OgcTime time() {
        return this.time;
    }

    @Override
    public Map<String, String> attributes() {
        return this.attributes;
    }

    private Set<CRS> nativeCrs$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.nativeCrs = ((TraversableOnce)this.ogcSourcesList().flatMap((Function1 & Serializable & scala.Serializable)x$14 -> x$14.nativeCrs(), List$.MODULE$.canBuildFrom())).toSet();
                this.bitmap$0 |= 0x40;
            }
        }
        return this.nativeCrs;
    }

    @Override
    public Set<CRS> nativeCrs() {
        return (this.bitmap$0 & 0x40) == 0 ? this.nativeCrs$lzycompute() : this.nativeCrs;
    }

    private int minBandCount$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.minBandCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.sourcesList().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.bandCount()), List$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Int$.MODULE$));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.minBandCount;
    }

    public int minBandCount() {
        return (this.bitmap$0 & 0x80) == 0 ? this.minBandCount$lzycompute() : this.minBandCount;
    }

    private Set<DataType> cellTypes$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.cellTypes = ((TraversableOnce)this.sourcesList().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.cellType(), List$.MODULE$.canBuildFrom())).toSet();
                this.bitmap$0 |= 0x100;
            }
        }
        return this.cellTypes;
    }

    public Set<DataType> cellTypes() {
        return (this.bitmap$0 & 0x100) == 0 ? this.cellTypes$lzycompute() : this.cellTypes;
    }

    private List<CellSize> resolutions$lzycompute() {
        MapAlgebraSource mapAlgebraSource = this;
        synchronized (mapAlgebraSource) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.resolutions = (List)((SeqLike)this.sourcesList().flatMap((Function1 & Serializable & scala.Serializable)x$17 -> x$17.resolutions(), List$.MODULE$.canBuildFrom())).distinct();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.resolutions;
    }

    public List<CellSize> resolutions() {
        return (this.bitmap$0 & 0x200) == 0 ? this.resolutions$lzycompute() : this.resolutions;
    }

    public MapAlgebraSource copy(String name, String title, Map<String, RasterOgcSource> ogcSources, Expression algebra, Option<String> defaultStyle, List<OgcStyle> styles, ResampleMethod resampleMethod, OverviewStrategy overviewStrategy, OgcTimeFormat timeFormat, OgcTimeDefault timeDefault, Option<DataType> targetCellType) {
        return new MapAlgebraSource(name, title, ogcSources, algebra, defaultStyle, styles, resampleMethod, overviewStrategy, timeFormat, timeDefault, targetCellType);
    }

    public String copy$default$1() {
        return this.name();
    }

    public OgcTimeDefault copy$default$10() {
        return this.timeDefault();
    }

    public Option<DataType> copy$default$11() {
        return this.targetCellType();
    }

    public String copy$default$2() {
        return this.title();
    }

    public Map<String, RasterOgcSource> copy$default$3() {
        return this.ogcSources();
    }

    public Expression copy$default$4() {
        return this.algebra();
    }

    public Option<String> copy$default$5() {
        return this.defaultStyle();
    }

    public List<OgcStyle> copy$default$6() {
        return this.styles();
    }

    public ResampleMethod copy$default$7() {
        return this.resampleMethod();
    }

    public OverviewStrategy copy$default$8() {
        return this.overviewStrategy();
    }

    public OgcTimeFormat copy$default$9() {
        return this.timeFormat();
    }

    public String productPrefix() {
        return "MapAlgebraSource";
    }

    public int productArity() {
        return 11;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.name();
                break;
            }
            case 1: {
                object = this.title();
                break;
            }
            case 2: {
                object = this.ogcSources();
                break;
            }
            case 3: {
                object = this.algebra();
                break;
            }
            case 4: {
                object = this.defaultStyle();
                break;
            }
            case 5: {
                object = this.styles();
                break;
            }
            case 6: {
                object = this.resampleMethod();
                break;
            }
            case 7: {
                object = this.overviewStrategy();
                break;
            }
            case 8: {
                object = this.timeFormat();
                break;
            }
            case 9: {
                object = this.timeDefault();
                break;
            }
            case 10: {
                object = this.targetCellType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapAlgebraSource;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapAlgebraSource)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapAlgebraSource mapAlgebraSource = (MapAlgebraSource)x$1;
        String string = this.name();
        String string2 = mapAlgebraSource.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.title();
        String string4 = mapAlgebraSource.title();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Map<String, RasterOgcSource> map = this.ogcSources();
        Map<String, RasterOgcSource> map2 = mapAlgebraSource.ogcSources();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.algebra();
        Expression expression2 = mapAlgebraSource.algebra();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.defaultStyle();
        Option<String> option2 = mapAlgebraSource.defaultStyle();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        List<OgcStyle> list = this.styles();
        List<OgcStyle> list2 = mapAlgebraSource.styles();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        ResampleMethod resampleMethod = this.resampleMethod();
        ResampleMethod resampleMethod2 = mapAlgebraSource.resampleMethod();
        if (resampleMethod == null) {
            if (resampleMethod2 != null) {
                return false;
            }
        } else if (!resampleMethod.equals(resampleMethod2)) return false;
        OverviewStrategy overviewStrategy = this.overviewStrategy();
        OverviewStrategy overviewStrategy2 = mapAlgebraSource.overviewStrategy();
        if (overviewStrategy == null) {
            if (overviewStrategy2 != null) {
                return false;
            }
        } else if (!overviewStrategy.equals(overviewStrategy2)) return false;
        OgcTimeFormat ogcTimeFormat = this.timeFormat();
        OgcTimeFormat ogcTimeFormat2 = mapAlgebraSource.timeFormat();
        if (ogcTimeFormat == null) {
            if (ogcTimeFormat2 != null) {
                return false;
            }
        } else if (!ogcTimeFormat.equals(ogcTimeFormat2)) return false;
        OgcTimeDefault ogcTimeDefault = this.timeDefault();
        OgcTimeDefault ogcTimeDefault2 = mapAlgebraSource.timeDefault();
        if (ogcTimeDefault == null) {
            if (ogcTimeDefault2 != null) {
                return false;
            }
        } else if (!ogcTimeDefault.equals(ogcTimeDefault2)) return false;
        Option<DataType> option3 = this.targetCellType();
        Option<DataType> option4 = mapAlgebraSource.targetCellType();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!mapAlgebraSource.canEqual(this)) return false;
        return true;
    }

    public MapAlgebraSource(String name, String title, Map<String, RasterOgcSource> ogcSources, Expression algebra, Option<String> defaultStyle, List<OgcStyle> styles, ResampleMethod resampleMethod, OverviewStrategy overviewStrategy, OgcTimeFormat timeFormat, OgcTimeDefault timeDefault, Option<DataType> targetCellType) {
        this.name = name;
        this.title = title;
        this.ogcSources = ogcSources;
        this.algebra = algebra;
        this.defaultStyle = defaultStyle;
        this.styles = styles;
        this.resampleMethod = resampleMethod;
        this.overviewStrategy = overviewStrategy;
        this.timeFormat = timeFormat;
        this.timeDefault = timeDefault;
        this.targetCellType = targetCellType;
        OgcSource.$init$(this);
        Product.$init$((Product)this);
        this.timeMetadataKey = None$.MODULE$;
        this.time = OgcTime$OgcTimeOps$.MODULE$.sorted$extension(OgcTime$.MODULE$.OgcTimeOps(OgcTime$OgcTimeOps$.MODULE$.format$extension(OgcTime$.MODULE$.OgcTimeOps((OgcTime)((LinearSeqOptimized)ogcSources.values().toList().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.time(), List$.MODULE$.canBuildFrom())).foldLeft((Object)OgcTimeEmpty$.MODULE$, (Function2 & Serializable & scala.Serializable)(x$12, x$13) -> (OgcTime)package.semigroup$.MODULE$.catsSyntaxSemigroup(x$12, OgcTime$.MODULE$.ogcTimeMonoid()).$bar$plus$bar(x$13))), timeFormat)));
        this.attributes = Predef$.MODULE$.Map().empty();
    }
}

