/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc;

import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import geotrellis.proj4.CRS;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Raster;
import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.io.geotiff.GeoTiff$;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffOptions$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.TiffType;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.tags.codes.ColorSpace$;
import geotrellis.raster.package$;
import geotrellis.raster.render.png.PngColorEncoding;
import geotrellis.raster.render.png.RgbPngEncoding$;
import geotrellis.raster.render.png.RgbPngEncodingConvertable;
import geotrellis.raster.render.png.RgbaPngEncoding$;
import geotrellis.server.ogc.OutputFormat;
import geotrellis.server.ogc.OutputFormat$GeoTiff$;
import geotrellis.server.ogc.OutputFormat$Jpg$;
import geotrellis.server.ogc.style.OgcStyle;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;

public final class Render$ {
    public static Render$ MODULE$;

    static {
        new Render$();
    }

    public byte[] rgb(Raster<MultibandTile> raster, CRS crs, Option<OgcStyle> maybeStyle, OutputFormat format, List<Histogram<Object>> hists) {
        byte[] byArray;
        Option<OgcStyle> option = maybeStyle;
        if (option instanceof Some) {
            Some some = (Some)option;
            OgcStyle style = (OgcStyle)some.value();
            byArray = style.renderRaster(raster, crs, format, hists);
        } else if (None$.MODULE$.equals(option)) {
            byte[] byArray2;
            OutputFormat outputFormat = format;
            if (outputFormat instanceof OutputFormat.Png) {
                byArray2 = new OutputFormat.Png((Option<PngColorEncoding>)new Some((Object)RgbPngEncoding$.MODULE$.toRgbPngEncoding((RgbPngEncodingConvertable)RgbPngEncoding$.MODULE$))).render(package$.MODULE$.withMultibandRenderMethods((MultibandTile)raster.tile()).color());
            } else if (OutputFormat$Jpg$.MODULE$.equals(outputFormat)) {
                byArray2 = package$.MODULE$.withSinglebandRenderMethods(package$.MODULE$.withMultibandRenderMethods((MultibandTile)raster.tile()).color()).renderJpg().bytes();
            } else if (OutputFormat$GeoTiff$.MODULE$.equals(outputFormat)) {
                int x$1 = ColorSpace$.MODULE$.RGB();
                StorageMethod x$2 = GeoTiffOptions$.MODULE$.apply$default$1();
                Compression x$3 = GeoTiffOptions$.MODULE$.apply$default$2();
                Option x$4 = GeoTiffOptions$.MODULE$.apply$default$4();
                InterleaveMethod x$5 = GeoTiffOptions$.MODULE$.apply$default$5();
                Option x$6 = GeoTiffOptions$.MODULE$.apply$default$6();
                TiffType x$7 = GeoTiffOptions$.MODULE$.apply$default$7();
                byArray2 = MultibandGeoTiff$.MODULE$.apply(raster, crs, new GeoTiffOptions(x$2, x$3, x$1, x$4, x$5, x$6, x$7)).toCloudOptimizedByteArray();
            } else {
                throw new MatchError((Object)outputFormat);
            }
            byArray = byArray2;
        } else {
            throw new MatchError(option);
        }
        return byArray;
    }

    public byte[] rgba(Raster<MultibandTile> raster, CRS crs, Option<OgcStyle> maybeStyle, OutputFormat format, List<Histogram<Object>> hists) {
        byte[] byArray;
        Option<OgcStyle> option = maybeStyle;
        if (option instanceof Some) {
            Some some = (Some)option;
            OgcStyle style = (OgcStyle)some.value();
            byArray = style.renderRaster(raster, crs, format, hists);
        } else if (None$.MODULE$.equals(option)) {
            byte[] byArray2;
            OutputFormat outputFormat = format;
            if (outputFormat instanceof OutputFormat.Png) {
                byArray2 = new OutputFormat.Png((Option<PngColorEncoding>)new Some((Object)RgbaPngEncoding$.MODULE$)).render(package$.MODULE$.withMultibandRenderMethods(((MultibandTile)raster.tile()).withNoData(OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)BoxesRunTime.boxToDouble((double)0.0))))).color());
            } else if (OutputFormat$Jpg$.MODULE$.equals(outputFormat)) {
                byArray2 = package$.MODULE$.withSinglebandRenderMethods(package$.MODULE$.withMultibandRenderMethods((MultibandTile)raster.tile()).color()).renderJpg().bytes();
            } else if (OutputFormat$GeoTiff$.MODULE$.equals(outputFormat)) {
                int x$1 = ColorSpace$.MODULE$.RGB();
                StorageMethod x$2 = GeoTiffOptions$.MODULE$.apply$default$1();
                Compression x$3 = GeoTiffOptions$.MODULE$.apply$default$2();
                Option x$4 = GeoTiffOptions$.MODULE$.apply$default$4();
                InterleaveMethod x$5 = GeoTiffOptions$.MODULE$.apply$default$5();
                Option x$6 = GeoTiffOptions$.MODULE$.apply$default$6();
                TiffType x$7 = GeoTiffOptions$.MODULE$.apply$default$7();
                byArray2 = MultibandGeoTiff$.MODULE$.apply(raster, crs, new GeoTiffOptions(x$2, x$3, x$1, x$4, x$5, x$6, x$7)).toCloudOptimizedByteArray();
            } else {
                throw new MatchError((Object)outputFormat);
            }
            byArray = byArray2;
        } else {
            throw new MatchError(option);
        }
        return byArray;
    }

    public byte[] singleband(Raster<MultibandTile> raster, CRS crs, Option<OgcStyle> maybeStyle, OutputFormat format, List<Histogram<Object>> hists) {
        byte[] byArray;
        Option<OgcStyle> option = maybeStyle;
        if (option instanceof Some) {
            Some some = (Some)option;
            OgcStyle style = (OgcStyle)some.value();
            byArray = style.renderRaster(raster, crs, format, hists);
        } else if (None$.MODULE$.equals(option)) {
            byte[] byArray2;
            OutputFormat outputFormat = format;
            if (outputFormat instanceof OutputFormat.Png) {
                OutputFormat.Png png = (OutputFormat.Png)outputFormat;
                byArray2 = png.render(((MultibandTile)raster.tile()).band(0));
            } else if (OutputFormat$Jpg$.MODULE$.equals(outputFormat)) {
                byArray2 = package$.MODULE$.withSinglebandRenderMethods(((MultibandTile)raster.tile()).band(0)).renderJpg().bytes();
            } else if (OutputFormat$GeoTiff$.MODULE$.equals(outputFormat)) {
                byArray2 = GeoTiff$.MODULE$.apply(raster.mapTile((Function1 & Serializable & scala.Serializable)x$1 -> x$1.band(0)), crs).toCloudOptimizedByteArray();
            } else {
                throw new MatchError((Object)outputFormat);
            }
            byArray = byArray2;
        } else {
            throw new MatchError(option);
        }
        return byArray;
    }

    public byte[] multiband(Raster<MultibandTile> raster, CRS crs, Option<OgcStyle> maybeStyle, OutputFormat format, List<Histogram<Object>> hists) {
        return this.rgba(raster, crs, maybeStyle, format, hists);
    }

    private Render$() {
        MODULE$ = this;
    }
}

