/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc;

import cats.Apply;
import cats.Functor;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.syntax.package;
import geotrellis.proj4.CRS;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.GridExtent;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.RasterSource;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.ReprojectRasterExtent$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.server.ExtentReification;
import geotrellis.server.HasRasterExtents;
import geotrellis.server.ogc.SimpleOgcLayer;
import geotrellis.server.ogc.style.OgcStyle;
import geotrellis.vector.package$;
import io.chrisdavenport.log4cats.Logger;
import io.chrisdavenport.log4cats.Logger$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import spire.math.Integral;
import spire.math.Integral$;

public final class SimpleOgcLayer$
implements scala.Serializable {
    public static SimpleOgcLayer$ MODULE$;

    static {
        new SimpleOgcLayer$();
    }

    public <F> ExtentReification<F, SimpleOgcLayer> simpleOgcReification(Sync<F> evidence$1, Logger<F> evidence$2) {
        return self -> (Function2 & Serializable & scala.Serializable)(extent, cellSize) -> package.functor$.MODULE$.toFunctorOps(package.apply$.MODULE$.catsSyntaxApply(package.apply$.MODULE$.catsSyntaxApply(package.apply$.MODULE$.catsSyntaxApply(Logger$.MODULE$.apply(evidence$2).trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("attempting to retrieve layer ").append(self).append(" at extent ").append(extent).append(" with ").append(cellSize).toString()), (Apply)evidence$1).$times$greater(Logger$.MODULE$.apply(evidence$2).trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Requested extent geojson: ").append(package$.MODULE$.ExtentsToGeoJson(extent).toGeoJson()).toString())), (Apply)evidence$1).$times$greater(Sync$.MODULE$.apply(evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> (Raster)((RasterSource)cellSize.fold((Function0 & Serializable & scala.Serializable)() -> self.source().reproject(self.crs(), self.source().reproject$default$2(), self.source().reproject$default$3(), self.source().reproject$default$4()), (Function1 & Serializable & scala.Serializable)cs -> self.source().reprojectToRegion(self.crs(), new GridExtent.mcJ.sp(extent, cs, (Integral)Integral$.MODULE$.LongIsIntegral()).toRasterExtent(), self.resampleMethod(), self.overviewStrategy()))).read(extent).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Logger$.MODULE$.apply(evidence$2).trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Unable to retrieve layer ").append(self).append(" at extent ").append(extent).append(" ").append(cellSize).toString());
            return new Raster((CellGrid)MultibandTile$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{ArrayTile$.MODULE$.empty(self.source().cellType(), 10, 10)})), extent);
        }))), (Apply)evidence$1).$less$times(Logger$.MODULE$.apply(evidence$2).trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Successfully retrieved layer ").append(self).append(" at extent ").append(extent).append(" with f ").append(cellSize).toString())), (Functor)evidence$1).map((Function1 & Serializable & scala.Serializable)raster -> new ProjectedRaster(raster, self.crs()));
    }

    public <F> HasRasterExtents<F, SimpleOgcLayer> simpleOgcHasRasterExtents(Sync<F> evidence$3) {
        return self -> Sync$.MODULE$.apply(evidence$3).delay((Function0 & Serializable & scala.Serializable)() -> {
            List rasterExtents = (List)self.source().resolutions().map((Function1 & Serializable & scala.Serializable)cs -> {
                RasterExtent re = RasterExtent$.MODULE$.apply(self.source().extent(), cs);
                Reproject.Options qual$1 = Reproject.Options$.MODULE$.DEFAULT();
                ResampleMethod x$1 = self.resampleMethod();
                double x$2 = qual$1.copy$default$2();
                Option x$3 = qual$1.copy$default$3();
                Option x$4 = qual$1.copy$default$4();
                Option x$5 = qual$1.copy$default$5();
                return ReprojectRasterExtent$.MODULE$.apply(re, self.source().crs(), self.crs(), qual$1.copy(x$1, x$2, x$3, x$4, x$5));
            }, List$.MODULE$.canBuildFrom());
            return (NonEmptyList)NonEmptyList$.MODULE$.fromList(rasterExtents).get();
        });
    }

    public SimpleOgcLayer apply(String name, String title, CRS crs, RasterSource source, Option<OgcStyle> style, ResampleMethod resampleMethod, OverviewStrategy overviewStrategy) {
        return new SimpleOgcLayer(name, title, crs, source, style, resampleMethod, overviewStrategy);
    }

    public Option<Tuple7<String, String, CRS, RasterSource, Option<OgcStyle>, ResampleMethod, OverviewStrategy>> unapply(SimpleOgcLayer x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.name(), (Object)x$0.title(), (Object)x$0.crs(), (Object)x$0.source(), x$0.style(), (Object)x$0.resampleMethod(), (Object)x$0.overviewStrategy()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SimpleOgcLayer$() {
        MODULE$ = this;
    }
}

