/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.style;

import geotrellis.proj4.CRS;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Raster;
import geotrellis.raster.histogram.Histogram;
import geotrellis.raster.io.geotiff.GeoTiff$;
import geotrellis.raster.render.ColorMap;
import geotrellis.raster.render.ColorRamp;
import geotrellis.raster.render.ColorRamp$;
import geotrellis.server.ogc.OutputFormat;
import geotrellis.server.ogc.OutputFormat$GeoTiff$;
import geotrellis.server.ogc.OutputFormat$Jpg$;
import geotrellis.server.ogc.style.ColorRampStyle$;
import geotrellis.server.ogc.style.LegendModel;
import geotrellis.server.ogc.style.OgcStyle;
import geotrellis.util.np.package$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u00193\u0001nB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t3\u0002\u0011\t\u0012)A\u0005\u001d\"A!\f\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005\\\u0001\tE\t\u0015!\u0003O\u0011!a\u0006A!f\u0001\n\u0003i\u0006\u0002\u00034\u0001\u0005#\u0005\u000b\u0011\u00020\t\u0011\u001d\u0004!Q3A\u0005\u0002!D\u0001b\u001c\u0001\u0003\u0012\u0003\u0006I!\u001b\u0005\ta\u0002\u0011)\u001a!C\u0001c\"Aa\u000f\u0001B\tB\u0003%!\u000f\u0003\u0005x\u0001\tU\r\u0011\"\u0001r\u0011!A\bA!E!\u0002\u0013\u0011\b\u0002C=\u0001\u0005+\u0007I\u0011\u0001>\t\u0011y\u0004!\u0011#Q\u0001\nmD\u0011b \u0001\u0003\u0016\u0004%\t!!\u0001\t\u0015\u0005m\u0001A!E!\u0002\u0013\t\u0019\u0001C\u0004\u0002\u001e\u0001!\t!a\b\t\u0015\u0005M\u0002\u0001#b\u0001\n\u0003\t)\u0004C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j!I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003k\u0003\u0011\u0013!C\u0001\u0003oC\u0011\"!4\u0001#\u0003%\t!a.\t\u0013\u0005=\u0007!%A\u0005\u0002\u0005E\u0007\"CAk\u0001E\u0005I\u0011AAl\u0011%\tY\u000eAI\u0001\n\u0003\ti\u000eC\u0005\u0002b\u0002\t\n\u0011\"\u0001\u0002^\"I\u00111\u001d\u0001\u0012\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003S\u0004\u0011\u0013!C\u0001\u0003WD\u0011\"a<\u0001\u0003\u0003%\t%!=\t\u0013\t\u0005\u0001!!A\u0005\u0002\t\r\u0001\"\u0003B\u0003\u0001\u0005\u0005I\u0011\u0001B\u0004\u0011%\u0011\u0019\u0002AA\u0001\n\u0003\u0012)\u0002C\u0005\u0003$\u0001\t\t\u0011\"\u0001\u0003&!I!\u0011\u0006\u0001\u0002\u0002\u0013\u0005#1\u0006\u0005\n\u0005[\u0001\u0011\u0011!C!\u0005_A\u0011B!\r\u0001\u0003\u0003%\tEa\r\b\u0013\t]\"'!A\t\u0002\teb\u0001C\u00193\u0003\u0003E\tAa\u000f\t\u000f\u0005uq\u0005\"\u0001\u0003J!I!QF\u0014\u0002\u0002\u0013\u0015#q\u0006\u0005\n\u0005\u0017:\u0013\u0011!CA\u0005\u001bB\u0011Ba\u0018(#\u0003%\t!!:\t\u0013\t\u0005t%%A\u0005\u0002\u0005-\b\"\u0003B2O\u0005\u0005I\u0011\u0011B3\u0011%\u0011\u0019hJI\u0001\n\u0003\t)\u000fC\u0005\u0003v\u001d\n\n\u0011\"\u0001\u0002l\"I!qO\u0014\u0002\u0002\u0013%!\u0011\u0010\u0002\u000f\u0007>dwN\u001d*b[B\u001cF/\u001f7f\u0015\t\u0019D'A\u0003tifdWM\u0003\u00026m\u0005\u0019qnZ2\u000b\u0005]B\u0014AB:feZ,'OC\u0001:\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\u0015\u0001AH\u0011$J!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0019\te.\u001f*fMB\u00111\tR\u0007\u0002e%\u0011QI\r\u0002\t\u001f\u001e\u001c7\u000b^=mKB\u0011QhR\u0005\u0003\u0011z\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002>\u0015&\u00111J\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005]\u0006lW-F\u0001O!\tyeK\u0004\u0002Q)B\u0011\u0011KP\u0007\u0002%*\u00111KO\u0001\u0007yI|w\u000e\u001e \n\u0005Us\u0014A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!\u0016 \u0002\u000b9\fW.\u001a\u0011\u0002\u000bQLG\u000f\\3\u0002\rQLG\u000f\\3!\u0003%\u0019w\u000e\\8s%\u0006l\u0007/F\u0001_!\tyF-D\u0001a\u0015\t\t'-\u0001\u0004sK:$WM\u001d\u0006\u0003Gb\naA]1ti\u0016\u0014\u0018BA3a\u0005%\u0019u\u000e\\8s%\u0006l\u0007/\u0001\u0006d_2|'OU1na\u0002\nQa\u001d;paN,\u0012!\u001b\t\u0004{)d\u0017BA6?\u0005\u0019y\u0005\u000f^5p]B\u0011Q(\\\u0005\u0003]z\u00121!\u00138u\u0003\u0019\u0019Ho\u001c9tA\u0005IQ.\u001b8SK:$WM]\u000b\u0002eB\u0019QH[:\u0011\u0005u\"\u0018BA;?\u0005\u0019!u.\u001e2mK\u0006QQ.\u001b8SK:$WM\u001d\u0011\u0002\u00135\f\u0007PU3oI\u0016\u0014\u0018AC7bqJ+g\u000eZ3sA\u0005q1\r\\1na^KG\u000f[\"pY>\u0014X#A>\u0011\u0005ub\u0018BA??\u0005\u001d\u0011un\u001c7fC:\fqb\u00197b[B<\u0016\u000e\u001e5D_2|'\u000fI\u0001\bY\u0016<WM\u001c3t+\t\t\u0019\u0001\u0005\u0004\u0002\u0006\u0005=\u0011Q\u0003\b\u0005\u0003\u000f\tYAD\u0002R\u0003\u0013I\u0011aP\u0005\u0004\u0003\u001bq\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003#\t\u0019B\u0001\u0003MSN$(bAA\u0007}A\u00191)a\u0006\n\u0007\u0005e!GA\u0006MK\u001e,g\u000eZ'pI\u0016d\u0017\u0001\u00037fO\u0016tGm\u001d\u0011\u0002\rqJg.\u001b;?)I\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty#!\r\u0011\u0005\r\u0003\u0001\"\u0002'\u0012\u0001\u0004q\u0005\"\u0002.\u0012\u0001\u0004q\u0005\"\u0002/\u0012\u0001\u0004q\u0006\"B4\u0012\u0001\u0004I\u0007\"\u00029\u0012\u0001\u0004\u0011\b\"B<\u0012\u0001\u0004\u0011\bbB=\u0012!\u0003\u0005\ra\u001f\u0005\t\u007fF\u0001\n\u00111\u0001\u0002\u0004\u00051An\\4hKJ,\"!a\u000e\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005)An\\45g*\u0011\u0011\u0011I\u0001\u0004_J<\u0017\u0002BA#\u0003w\u0011a\u0001T8hO\u0016\u0014\u0018A\u00022sK\u0006\\7\u000f\u0006\u0004\u0002L\u0005E\u00131\r\t\u0005{\u000553/C\u0002\u0002Py\u0012Q!\u0011:sCfDq!a\u0015\u0014\u0001\u0004\t)&A\u0003iSN$8\u000f\u0005\u0004\u0002\u0006\u0005=\u0011q\u000b\t\u0006\u00033\nyf]\u0007\u0003\u00037R1!!\u0018c\u0003%A\u0017n\u001d;pOJ\fW.\u0003\u0003\u0002b\u0005m#!\u0003%jgR|wM]1n\u0011\u0019\t)g\u0005a\u0001Y\u0006Ia.^7Ce\u0016\f7n]\u0001\re\u0016tG-\u001a:SCN$XM\u001d\u000b\u000b\u0003W\n\u0019(a!\u0002\u0014\u0006}\u0005#B\u001f\u0002N\u00055\u0004cA\u001f\u0002p%\u0019\u0011\u0011\u000f \u0003\t\tKH/\u001a\u0005\u0007GR\u0001\r!!\u001e\u0011\r\u0005]\u0014\u0011PA?\u001b\u0005\u0011\u0017bAA>E\n1!+Y:uKJ\u0004B!a\u001e\u0002\u0000%\u0019\u0011\u0011\u00112\u0003\u001b5+H\u000e^5cC:$G+\u001b7f\u0011\u001d\t)\t\u0006a\u0001\u0003\u000f\u000b1a\u0019:t!\u0011\tI)a$\u000e\u0005\u0005-%bAAGq\u0005)\u0001O]8ki%!\u0011\u0011SAF\u0005\r\u0019%k\u0015\u0005\b\u0003+#\u0002\u0019AAL\u0003\u00191wN]7biB!\u0011\u0011TAN\u001b\u0005!\u0014bAAOi\taq*\u001e;qkR4uN]7bi\"9\u00111\u000b\u000bA\u0002\u0005U\u0013\u0001B2paf$\"#!\t\u0002&\u0006\u001d\u0016\u0011VAV\u0003[\u000by+!-\u00024\"9A*\u0006I\u0001\u0002\u0004q\u0005b\u0002.\u0016!\u0003\u0005\rA\u0014\u0005\b9V\u0001\n\u00111\u0001_\u0011\u001d9W\u0003%AA\u0002%Dq\u0001]\u000b\u0011\u0002\u0003\u0007!\u000fC\u0004x+A\u0005\t\u0019\u0001:\t\u000fe,\u0002\u0013!a\u0001w\"Aq0\u0006I\u0001\u0002\u0004\t\u0019!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e&f\u0001(\u0002<.\u0012\u0011Q\u0018\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003%)hn\u00195fG.,GMC\u0002\u0002Hz\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY-!1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u001b\u0016\u0004=\u0006m\u0016AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u00033T3![A^\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!a8+\u0007I\fY,\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%oU\u0011\u0011q\u001d\u0016\u0004w\u0006m\u0016AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003[TC!a\u0001\u0002<\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a=\u0011\t\u0005U\u0018q`\u0007\u0003\u0003oTA!!?\u0002|\u0006!A.\u00198h\u0015\t\ti0\u0001\u0003kCZ\f\u0017bA,\u0002x\u0006a\u0001O]8ek\u000e$\u0018I]5usV\tA.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t%!q\u0002\t\u0004{\t-\u0011b\u0001B\u0007}\t\u0019\u0011I\\=\t\u0011\tE\u0001%!AA\u00021\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\f!\u0019\u0011IBa\b\u0003\n5\u0011!1\u0004\u0006\u0004\u0005;q\u0014AC2pY2,7\r^5p]&!!\u0011\u0005B\u000e\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007m\u00149\u0003C\u0005\u0003\u0012\t\n\t\u00111\u0001\u0003\n\u0005A\u0001.Y:i\u0007>$W\rF\u0001m\u0003!!xn\u0015;sS:<GCAAz\u0003\u0019)\u0017/^1mgR\u00191P!\u000e\t\u0013\tEQ%!AA\u0002\t%\u0011AD\"pY>\u0014(+Y7q'RLH.\u001a\t\u0003\u0007\u001e\u001aBa\nB\u001f\u0013By!q\bB#\u001d:s\u0016N\u001d:|\u0003\u0007\t\t#\u0004\u0002\u0003B)\u0019!1\t \u0002\u000fI,h\u000e^5nK&!!q\tB!\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000f\u000b\u0003\u0005s\tQ!\u00199qYf$\"#!\t\u0003P\tE#1\u000bB+\u0005/\u0012IFa\u0017\u0003^!)AJ\u000ba\u0001\u001d\")!L\u000ba\u0001\u001d\")AL\u000ba\u0001=\")qM\u000ba\u0001S\")\u0001O\u000ba\u0001e\")qO\u000ba\u0001e\"9\u0011P\u000bI\u0001\u0002\u0004Y\b\u0002C@+!\u0003\u0005\r!a\u0001\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uI]\nq\"\u00199qYf$C-\u001a4bk2$H\u0005O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Ga\u001c\u0011\tuR'\u0011\u000e\t\r{\t-dJ\u00140jeJ\\\u00181A\u0005\u0004\u0005[r$A\u0002+va2,\u0007\bC\u0005\u0003r5\n\t\u00111\u0001\u0002\"\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\b\u0005\u0003\u0002v\nu\u0014\u0002\u0002B@\u0003o\u0014aa\u00142kK\u000e$\b")
public class ColorRampStyle
implements OgcStyle,
Product,
scala.Serializable {
    private Logger logger;
    private final String name;
    private final String title;
    private final ColorRamp colorRamp;
    private final Option<Object> stops;
    private final Option<Object> minRender;
    private final Option<Object> maxRender;
    private final boolean clampWithColor;
    private final List<LegendModel> legends;
    private volatile boolean bitmap$0;

    public static List<LegendModel> $lessinit$greater$default$8() {
        return ColorRampStyle$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$7() {
        return ColorRampStyle$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple8<String, String, ColorRamp, Option<Object>, Option<Object>, Option<Object>, Object, List<LegendModel>>> unapply(ColorRampStyle colorRampStyle) {
        return ColorRampStyle$.MODULE$.unapply(colorRampStyle);
    }

    public static List<LegendModel> apply$default$8() {
        return ColorRampStyle$.MODULE$.apply$default$8();
    }

    public static boolean apply$default$7() {
        return ColorRampStyle$.MODULE$.apply$default$7();
    }

    public static ColorRampStyle apply(String string, String string2, ColorRamp colorRamp, Option<Object> option, Option<Object> option2, Option<Object> option3, boolean bl, List<LegendModel> list) {
        return ColorRampStyle$.MODULE$.apply(string, string2, colorRamp, option, option2, option3, bl, list);
    }

    public static Function1<Tuple8<String, String, ColorRamp, Option<Object>, Option<Object>, Option<Object>, Object, List<LegendModel>>, ColorRampStyle> tupled() {
        return ColorRampStyle$.MODULE$.tupled();
    }

    public static Function1<String, Function1<String, Function1<ColorRamp, Function1<Option<Object>, Function1<Option<Object>, Function1<Option<Object>, Function1<Object, Function1<List<LegendModel>, ColorRampStyle>>>>>>>> curried() {
        return ColorRampStyle$.MODULE$.curried();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String title() {
        return this.title;
    }

    public ColorRamp colorRamp() {
        return this.colorRamp;
    }

    public Option<Object> stops() {
        return this.stops;
    }

    public Option<Object> minRender() {
        return this.minRender;
    }

    public Option<Object> maxRender() {
        return this.maxRender;
    }

    public boolean clampWithColor() {
        return this.clampWithColor;
    }

    @Override
    public List<LegendModel> legends() {
        return this.legends;
    }

    private Logger logger$lzycompute() {
        ColorRampStyle colorRampStyle = this;
        synchronized (colorRampStyle) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger(ColorRampStyle.class);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public double[] breaks(List<Histogram<Object>> hists, int numBreaks) {
        double minBreak = BoxesRunTime.unboxToDouble((Object)this.minRender().orElse((Function0 & Serializable & scala.Serializable)() -> ((Histogram)hists.head()).minValue()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!this.logger().isWarnEnabled()) break block0;
                this.logger().warn(new StringBuilder(37).append("No minimum render value found, using ").append(Double$.MODULE$.MinValue()).toString());
            }
            return Double$.MODULE$.MinValue();
        }));
        double maxBreak = BoxesRunTime.unboxToDouble((Object)this.maxRender().orElse((Function0 & Serializable & scala.Serializable)() -> ((Histogram)hists.head()).maxValue()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!this.logger().isWarnEnabled()) break block0;
                this.logger().warn(new StringBuilder(37).append("No maximum render value found, using ").append((double)Double.MAX_VALUE).toString());
            }
            return Double.MAX_VALUE;
        }));
        return package$.MODULE$.linspace(minBreak, maxBreak, numBreaks);
    }

    @Override
    public byte[] renderRaster(Raster<MultibandTile> raster, CRS crs, OutputFormat format, List<Histogram<Object>> hists) {
        byte[] byArray;
        int numStops = BoxesRunTime.unboxToInt((Object)this.stops().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.colorRamp().colors().length()));
        int minColor = this.clampWithColor() ? BoxesRunTime.unboxToInt((Object)this.colorRamp().colors().head()) : 0;
        int maxColor = this.clampWithColor() ? BoxesRunTime.unboxToInt((Object)this.colorRamp().colors().last()) : 0;
        int n = minColor;
        Vector interpolatedColors = (Vector)((Vector)ColorRamp$.MODULE$.colorRampToIntVector(this.colorRamp().stops(numStops)).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Vector$.MODULE$.canBuildFrom())).$colon$plus((Object)BoxesRunTime.boxToInteger((int)maxColor), Vector$.MODULE$.canBuildFrom());
        double[] interpolatedBreaks = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.breaks(hists, interpolatedColors.length()))).$colon$plus((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), ClassTag$.MODULE$.Double());
        ColorMap cmap = ColorRamp$.MODULE$.apply((Traversable)interpolatedColors).toColorMap(interpolatedBreaks, Predef.DummyImplicit$.MODULE$.dummyImplicit());
        OutputFormat outputFormat = format;
        if (outputFormat instanceof OutputFormat.Png) {
            OutputFormat.Png png = (OutputFormat.Png)outputFormat;
            byArray = png.render(((MultibandTile)raster.tile()).band(0), cmap);
        } else if (OutputFormat$Jpg$.MODULE$.equals(outputFormat)) {
            byArray = geotrellis.raster.package$.MODULE$.withSinglebandRenderMethods(((MultibandTile)raster.tile()).band(0)).renderJpg(cmap).bytes();
        } else if (OutputFormat$GeoTiff$.MODULE$.equals(outputFormat)) {
            byArray = GeoTiff$.MODULE$.apply(raster.mapTile((Function1 & Serializable & scala.Serializable)x$2 -> geotrellis.raster.package$.MODULE$.withSinglebandRenderMethods(x$2.band(0)).color(cmap)), crs).toCloudOptimizedByteArray();
        } else {
            throw new MatchError((Object)outputFormat);
        }
        return byArray;
    }

    public ColorRampStyle copy(String name, String title, ColorRamp colorRamp, Option<Object> stops, Option<Object> minRender, Option<Object> maxRender, boolean clampWithColor, List<LegendModel> legends) {
        return new ColorRampStyle(name, title, colorRamp, stops, minRender, maxRender, clampWithColor, legends);
    }

    public String copy$default$1() {
        return this.name();
    }

    public String copy$default$2() {
        return this.title();
    }

    public ColorRamp copy$default$3() {
        return this.colorRamp();
    }

    public Option<Object> copy$default$4() {
        return this.stops();
    }

    public Option<Object> copy$default$5() {
        return this.minRender();
    }

    public Option<Object> copy$default$6() {
        return this.maxRender();
    }

    public boolean copy$default$7() {
        return this.clampWithColor();
    }

    public List<LegendModel> copy$default$8() {
        return this.legends();
    }

    public String productPrefix() {
        return "ColorRampStyle";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.name();
                break;
            }
            case 1: {
                object = this.title();
                break;
            }
            case 2: {
                object = this.colorRamp();
                break;
            }
            case 3: {
                object = this.stops();
                break;
            }
            case 4: {
                object = this.minRender();
                break;
            }
            case 5: {
                object = this.maxRender();
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this.clampWithColor());
                break;
            }
            case 7: {
                object = this.legends();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ColorRampStyle;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.title()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.colorRamp()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.stops()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.minRender()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.maxRender()));
        n = Statics.mix((int)n, (int)(this.clampWithColor() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.legends()));
        return Statics.finalizeHash((int)n, (int)8);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ColorRampStyle)) return false;
        boolean bl = true;
        if (!bl) return false;
        ColorRampStyle colorRampStyle = (ColorRampStyle)x$1;
        String string = this.name();
        String string2 = colorRampStyle.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.title();
        String string4 = colorRampStyle.title();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        ColorRamp colorRamp = this.colorRamp();
        ColorRamp colorRamp2 = colorRampStyle.colorRamp();
        if (colorRamp == null) {
            if (colorRamp2 != null) {
                return false;
            }
        } else if (!colorRamp.equals(colorRamp2)) return false;
        Option<Object> option = this.stops();
        Option<Object> option2 = colorRampStyle.stops();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.minRender();
        Option<Object> option4 = colorRampStyle.minRender();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.maxRender();
        Option<Object> option6 = colorRampStyle.maxRender();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (this.clampWithColor() != colorRampStyle.clampWithColor()) return false;
        List<LegendModel> list = this.legends();
        List<LegendModel> list2 = colorRampStyle.legends();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!colorRampStyle.canEqual(this)) return false;
        return true;
    }

    public ColorRampStyle(String name, String title, ColorRamp colorRamp, Option<Object> stops, Option<Object> minRender, Option<Object> maxRender, boolean clampWithColor, List<LegendModel> legends) {
        this.name = name;
        this.title = title;
        this.colorRamp = colorRamp;
        this.stops = stops;
        this.minRender = minRender;
        this.maxRender = maxRender;
        this.clampWithColor = clampWithColor;
        this.legends = legends;
        Product.$init$((Product)this);
    }
}

