/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.style;

import geotrellis.raster.render.RGBA$;
import geotrellis.server.ogc.style.ClipBoth$;
import geotrellis.server.ogc.style.ClipDefinition;
import geotrellis.server.ogc.style.ClipLeft$;
import geotrellis.server.ogc.style.ClipNone$;
import geotrellis.server.ogc.style.ClipRight$;
import geotrellis.server.ogc.style.InterpolatedColorMap;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class InterpolatedColorMap$
implements scala.Serializable {
    public static InterpolatedColorMap$ MODULE$;

    static {
        new InterpolatedColorMap$();
    }

    private int RgbLerp(int color1, int color2, double proportion) {
        int r = (int)((double)RGBA$.MODULE$.red$extension(color1) + (double)(RGBA$.MODULE$.red$extension(color2) - RGBA$.MODULE$.red$extension(color1)) * proportion);
        int g = (int)((double)RGBA$.MODULE$.green$extension(color1) + (double)(RGBA$.MODULE$.green$extension(color2) - RGBA$.MODULE$.green$extension(color1)) * proportion);
        int b = (int)((double)RGBA$.MODULE$.blue$extension(color1) + (double)(RGBA$.MODULE$.blue$extension(color2) - RGBA$.MODULE$.blue$extension(color1)) * proportion);
        double a = ((double)RGBA$.MODULE$.alpha$extension(color1) + (double)(RGBA$.MODULE$.alpha$extension(color2) - RGBA$.MODULE$.alpha$extension(color1)) * proportion) / 2.55;
        return RGBA$.MODULE$.fromRGBAPct(r, g, b, a);
    }

    public Function1<Object, Object> interpolation(Map<Object, Object> poles, ClipDefinition clipDefinition) {
        return (JFunction1.mcID.sp & Serializable & scala.Serializable)dbl -> {
            int n;
            Tuple2 decomposed = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])poles.toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int());
            double[] breaks = (double[])decomposed._1();
            int[] colors = (int[])decomposed._2();
            int insertionPoint = Arrays.binarySearch(breaks, dbl);
            if (insertionPoint == -1) {
                int n2;
                ClipDefinition clipDefinition = clipDefinition;
                boolean bl = ClipNone$.MODULE$.equals(clipDefinition) ? true : ClipRight$.MODULE$.equals(clipDefinition);
                if (bl) {
                    n2 = colors[0];
                } else {
                    boolean bl2 = ClipLeft$.MODULE$.equals(clipDefinition) ? true : ClipBoth$.MODULE$.equals(clipDefinition);
                    if (bl2) {
                        n2 = 0;
                    } else {
                        throw new MatchError((Object)clipDefinition);
                    }
                }
                n = n2;
            } else if (package$.MODULE$.abs(insertionPoint) - 1 == breaks.length) {
                int n3;
                ClipDefinition clipDefinition = clipDefinition;
                boolean bl = ClipNone$.MODULE$.equals(clipDefinition) ? true : ClipLeft$.MODULE$.equals(clipDefinition);
                if (bl) {
                    n3 = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colors)).last());
                } else {
                    boolean bl3 = ClipRight$.MODULE$.equals(clipDefinition) ? true : ClipBoth$.MODULE$.equals(clipDefinition);
                    if (bl3) {
                        n3 = 0;
                    } else {
                        throw new MatchError((Object)clipDefinition);
                    }
                }
                n = n3;
            } else if (insertionPoint < 0) {
                int lowerIdx = package$.MODULE$.abs(insertionPoint) - 2;
                int higherIdx = package$.MODULE$.abs(insertionPoint) - 1;
                double lower = breaks[lowerIdx];
                double higher = breaks[higherIdx];
                double proportion = (dbl - lower) / (higher - lower);
                n = MODULE$.RgbLerp(RGBA$.MODULE$.apply(colors[lowerIdx]), RGBA$.MODULE$.apply(colors[higherIdx]), proportion);
            } else {
                n = colors[insertionPoint];
            }
            return n;
        };
    }

    public InterpolatedColorMap apply(Map<Object, Object> poles, ClipDefinition clipDefinition) {
        return new InterpolatedColorMap(poles, clipDefinition);
    }

    public Option<Tuple2<Map<Object, Object>, ClipDefinition>> unapply(InterpolatedColorMap x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.poles(), (Object)x$0.clipDefinition()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private InterpolatedColorMap$() {
        MODULE$ = this;
    }
}

