/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.wcs;

import cats.Functor;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import geotrellis.proj4.CRS;
import geotrellis.proj4.LatLng$;
import geotrellis.raster.CellSize;
import geotrellis.raster.Dimensions;
import geotrellis.raster.GridExtent;
import geotrellis.raster.RasterSource;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.ReprojectRasterExtent$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.server.ogc.MapAlgebraSource;
import geotrellis.server.ogc.OgcSource;
import geotrellis.server.ogc.OgcTime;
import geotrellis.server.ogc.OgcTimeEmpty$;
import geotrellis.server.ogc.OgcTimeInterval;
import geotrellis.server.ogc.OgcTimePositions;
import geotrellis.server.ogc.OutputFormat$;
import geotrellis.server.ogc.RasterOgcSource;
import geotrellis.server.ogc.URN$;
import geotrellis.server.ogc.gml.GmlDataRecord$;
import geotrellis.server.ogc.ows.OwsDataRecord$;
import geotrellis.server.ogc.wcs.CoverageView;
import geotrellis.server.ogc.wcs.DescribeCoverageWcsParams;
import geotrellis.server.ogc.wcs.WcsModel;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.time.ZonedDateTime;
import opengis.gml.TimePositionType;
import opengis.gml.TimePositionType$;
import opengis.ows.AnyValue;
import opengis.ows.BoundingBoxType;
import opengis.ows.LanguageStringType;
import opengis.ows.LanguageStringType$;
import opengis.ows.UnNamedDomainTypable;
import opengis.ows.UnNamedDomainType;
import opengis.ows.UnNamedDomainType$;
import opengis.ows.WGS84BoundingBoxType;
import opengis.wcs.CoverageDescriptionType;
import opengis.wcs.CoverageDomainType;
import opengis.wcs.FieldType;
import opengis.wcs.FieldType$;
import opengis.wcs.GridCrsType;
import opengis.wcs.GridCrsType$;
import opengis.wcs.InterpolationMethodType;
import opengis.wcs.InterpolationMethodType$;
import opengis.wcs.InterpolationMethods;
import opengis.wcs.RangeType;
import opengis.wcs.SpatialDomainType;
import opengis.wcs.SpatialDomainType$;
import opengis.wcs.TimePeriodType;
import opengis.wcs.TimePeriodType$;
import opengis.wcs.TimeSequenceType;
import org.threeten.extra.PeriodDuration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scalaxb.CanWriteXML;
import scalaxb.DataRecord;
import scalaxb.DataRecord$;
import spire.math.Integral;
import spire.math.Integral$;

public final class CoverageView$ {
    public static CoverageView$ MODULE$;

    static {
        new CoverageView$();
    }

    private GridExtent<Object> extractGridExtent(OgcSource source, CRS targetCRS) {
        GridExtent gridExtent;
        OgcSource ogcSource = source;
        if (ogcSource instanceof MapAlgebraSource) {
            MapAlgebraSource mapAlgebraSource = (MapAlgebraSource)ogcSource;
            gridExtent = (GridExtent)((TraversableOnce)mapAlgebraSource.sourcesList().map((Function1 & Serializable & scala.Serializable)rs -> {
                Reproject.Options qual$1 = Reproject.Options$.MODULE$.DEFAULT();
                ResampleMethod x$1 = mapAlgebraSource.resampleMethod();
                double x$2 = qual$1.copy$default$2();
                Option x$3 = qual$1.copy$default$3();
                Option x$4 = qual$1.copy$default$4();
                Option x$5 = qual$1.copy$default$5();
                return ReprojectRasterExtent$.MODULE$.apply(rs.gridExtent(), rs.crs(), targetCRS, qual$1.copy(x$1, x$2, x$3, x$4, x$5), (Integral)Integral$.MODULE$.LongIsIntegral());
            }, List$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(re1, re2) -> {
                Extent e = re1.extent().combine(re2.extent());
                CellSize cs = re1.cellSize().resolution() < re2.cellSize().resolution() ? re1.cellSize() : re2.cellSize();
                return new GridExtent.mcJ.sp(e, cs, (Integral)Integral$.MODULE$.LongIsIntegral());
            });
        } else if (ogcSource instanceof RasterOgcSource) {
            RasterOgcSource rasterOgcSource = (RasterOgcSource)ogcSource;
            RasterSource rs2 = rasterOgcSource.source();
            Reproject.Options qual$2 = Reproject.Options$.MODULE$.DEFAULT();
            ResampleMethod x$6 = rasterOgcSource.resampleMethod();
            double x$7 = qual$2.copy$default$2();
            Option x$8 = qual$2.copy$default$3();
            Option x$9 = qual$2.copy$default$4();
            Option x$10 = qual$2.copy$default$5();
            gridExtent = ReprojectRasterExtent$.MODULE$.apply(rs2.gridExtent(), rs2.crs(), targetCRS, qual$2.copy(x$6, x$7, x$8, x$9, x$10), (Integral)Integral$.MODULE$.LongIsIntegral());
        } else {
            throw new MatchError((Object)ogcSource);
        }
        return gridExtent;
    }

    public CoverageDescriptionType sourceDescription(List<CRS> supportedProjections, List<OgcSource> sources) {
        List list;
        OgcSource source = (OgcSource)sources.head();
        CRS nativeCrs = (CRS)source.nativeCrs().head();
        GridExtent<Object> re = source.nativeRE();
        Extent ex = re.extent();
        Dimensions dimensions = re.dimensions();
        if (dimensions == null) {
            throw new MatchError((Object)dimensions);
        }
        long w = dimensions.cols$mcJ$sp();
        long h = dimensions.rows$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(w, h);
        Tuple2.mcJJ.sp sp3 = sp2;
        long w2 = sp3._1$mcJ$sp();
        long h2 = sp3._2$mcJ$sp();
        OgcTime ogcTime = source.time();
        if (ogcTime instanceof OgcTimePositions) {
            OgcTimePositions ogcTimePositions = (OgcTimePositions)ogcTime;
            list = (List)ogcTimePositions.toList().map((Function1 & Serializable & scala.Serializable)p -> GmlDataRecord$.MODULE$.apply(new TimePositionType(p, TimePositionType$.MODULE$.apply$default$2()), opengis.package$.MODULE$.Opengisgml_TimePositionTypeFormat(), ClassTag$.MODULE$.apply(TimePositionType.class)), List$.MODULE$.canBuildFrom());
        } else if (ogcTime instanceof OgcTimeInterval) {
            OgcTimeInterval ogcTimeInterval = (OgcTimeInterval)ogcTime;
            ZonedDateTime start = ogcTimeInterval.start();
            ZonedDateTime end = ogcTimeInterval.end();
            Option<PeriodDuration> period = ogcTimeInterval.interval();
            DataRecord<TimePeriodType> dataRecord = GmlDataRecord$.MODULE$.apply(new TimePeriodType(new TimePositionType(start.toInstant().toString(), TimePositionType$.MODULE$.apply$default$2()), new TimePositionType(end.toInstant().toString(), TimePositionType$.MODULE$.apply$default$2()), period.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString()), TimePeriodType$.MODULE$.apply$default$4()), opengis.package$.MODULE$.Opengiswcs_TimePeriodTypeFormat(), ClassTag$.MODULE$.apply(TimePeriodType.class));
            list = Nil$.MODULE$.$colon$colon(dataRecord);
        } else if (OgcTimeEmpty$.MODULE$.equals(ogcTime)) {
            list = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)ogcTime);
        }
        List records = list;
        None$ temporalDomain = records.nonEmpty() ? OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)new TimeSequenceType((Seq)records))) : None$.MODULE$;
        CRS cRS = nativeCrs;
        LatLng$ latLng$ = LatLng$.MODULE$;
        List uniqueCrs = (List)supportedProjections.$colon$colon((Object)latLng$).$colon$colon((Object)cRS).distinct();
        LanguageStringType languageStringType = new LanguageStringType(source.title(), LanguageStringType$.MODULE$.apply$default$2());
        double d = 0.0;
        double d2 = 0.0;
        double d3 = w2;
        double d4 = h2;
        DataRecord<BoundingBoxType> dataRecord = OwsDataRecord$.MODULE$.apply(new BoundingBoxType((Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d2)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d)), (Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d4)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d3)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@crs"), (Object)DataRecord$.MODULE$.apply((Object)new URI("urn:ogc:def:crs:OGC::imageCRS"), (CanWriteXML)opengis.package$.MODULE$.__URIXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@dimensions"), (Object)DataRecord$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(2), (CanWriteXML)opengis.package$.MODULE$.__BigIntXMLFormat()))}))), opengis.package$.MODULE$.Opengisows_BoundingBoxTypeFormat(), ClassTag$.MODULE$.apply(BoundingBoxType.class));
        URI x$1 = new URI(URN$.MODULE$.unsafeFromCrs(nativeCrs));
        Option x$2 = OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)new URI("urn:ogc:def:method:WCS:1.1:2dSimpleGrid")));
        Option x$3 = OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{ex.xmin(), ex.ymax()}))));
        double d5 = re.cellheight();
        double d6 = -re.cellwidth();
        List x$4 = Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d6)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d5));
        Option x$5 = OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)new URI("urn:ogc:def:cs:OGC:0.0:Grid2dSquareCS")));
        Option x$62 = GridCrsType$.MODULE$.apply$default$1();
        Map x$7 = GridCrsType$.MODULE$.apply$default$7();
        String x$8 = "contents";
        UnNamedDomainType x$9 = new UnNamedDomainType(OwsDataRecord$.MODULE$.apply(new AnyValue(), opengis.package$.MODULE$.Opengisows_AnyValueFormat(), ClassTag$.MODULE$.apply(AnyValue.class)), UnNamedDomainType$.MODULE$.apply$default$2(), UnNamedDomainType$.MODULE$.apply$default$3(), UnNamedDomainType$.MODULE$.apply$default$4(), UnNamedDomainType$.MODULE$.apply$default$5(), UnNamedDomainType$.MODULE$.apply$default$6());
        InterpolationMethodType interpolationMethodType = new InterpolationMethodType("nearest-neighbor", InterpolationMethodType$.MODULE$.apply$default$2());
        InterpolationMethodType interpolationMethodType2 = new InterpolationMethodType("bilinear", InterpolationMethodType$.MODULE$.apply$default$2());
        InterpolationMethodType interpolationMethodType3 = new InterpolationMethodType("cubic-convolution", InterpolationMethodType$.MODULE$.apply$default$2());
        InterpolationMethodType interpolationMethodType4 = new InterpolationMethodType("cubic-spline", InterpolationMethodType$.MODULE$.apply$default$2());
        InterpolationMethodType interpolationMethodType5 = new InterpolationMethodType("lanczos", InterpolationMethodType$.MODULE$.apply$default$2());
        InterpolationMethods x$10 = new InterpolationMethods((Seq)Nil$.MODULE$.$colon$colon((Object)interpolationMethodType5).$colon$colon((Object)interpolationMethodType4).$colon$colon((Object)interpolationMethodType3).$colon$colon((Object)interpolationMethodType2).$colon$colon((Object)interpolationMethodType), OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)"nearest-neighbor")));
        Seq x$11 = FieldType$.MODULE$.apply$default$1();
        Seq x$12 = FieldType$.MODULE$.apply$default$2();
        Seq x$13 = FieldType$.MODULE$.apply$default$3();
        Seq x$14 = FieldType$.MODULE$.apply$default$6();
        Seq x$15 = FieldType$.MODULE$.apply$default$8();
        FieldType fieldType = new FieldType(x$11, x$12, x$13, x$8, (UnNamedDomainTypable)x$9, x$14, x$10, x$15);
        URI uRI = new URI("urn:ogc:def:crs:OGC::imageCRS");
        return new CoverageDescriptionType((Seq)Nil$.MODULE$.$colon$colon((Object)languageStringType), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, source.name(), (Seq)Nil$.MODULE$, new CoverageDomainType(new SpatialDomainType((Seq)((List)uniqueCrs.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list;
            CRS cRS;
            CRS cRS2 = cRS = x0$1;
            LatLng$ latLng$ = LatLng$.MODULE$;
            if (!(cRS2 != null ? !cRS2.equals(latLng$) : latLng$ != null)) {
                Extent lex = MODULE$.extractGridExtent(source, cRS).extent();
                double d = lex.ymin();
                double d2 = lex.xmin();
                double d3 = lex.ymax();
                double d4 = lex.xmax();
                DataRecord<BoundingBoxType> dataRecord = OwsDataRecord$.MODULE$.apply(new BoundingBoxType((Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d2)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d)), (Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d4)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d3)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@crs"), (Object)DataRecord$.MODULE$.apply((Object)new URI(URN$.MODULE$.unsafeFromCrs(cRS)), (CanWriteXML)opengis.package$.MODULE$.__URIXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@dimensions"), (Object)DataRecord$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(2), (CanWriteXML)opengis.package$.MODULE$.__BigIntXMLFormat()))}))), opengis.package$.MODULE$.Opengisows_BoundingBoxTypeFormat(), ClassTag$.MODULE$.apply(BoundingBoxType.class));
                double d5 = lex.ymin();
                double d6 = lex.xmin();
                double d7 = lex.ymax();
                double d8 = lex.xmax();
                DataRecord<WGS84BoundingBoxType> dataRecord2 = OwsDataRecord$.MODULE$.apply(new WGS84BoundingBoxType((Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d6)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d5)), (Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d8)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d7)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@dimensions"), (Object)DataRecord$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(2), (CanWriteXML)opengis.package$.MODULE$.__BigIntXMLFormat()))}))), opengis.package$.MODULE$.Opengisows_WGS84BoundingBoxTypeFormat(), ClassTag$.MODULE$.apply(WGS84BoundingBoxType.class));
                list = Nil$.MODULE$.$colon$colon(dataRecord2).$colon$colon(dataRecord);
            } else if (cRS.isGeographic()) {
                Extent lex = MODULE$.extractGridExtent(source, cRS).extent();
                double d = lex.ymin();
                double d9 = lex.xmin();
                double d10 = lex.ymax();
                double d11 = lex.xmax();
                DataRecord<BoundingBoxType> dataRecord = OwsDataRecord$.MODULE$.apply(new BoundingBoxType((Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d9)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d)), (Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d11)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d10)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@crs"), (Object)DataRecord$.MODULE$.apply((Object)new URI(URN$.MODULE$.unsafeFromCrs(cRS)), (CanWriteXML)opengis.package$.MODULE$.__URIXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@dimensions"), (Object)DataRecord$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(2), (CanWriteXML)opengis.package$.MODULE$.__BigIntXMLFormat()))}))), opengis.package$.MODULE$.Opengisows_BoundingBoxTypeFormat(), ClassTag$.MODULE$.apply(BoundingBoxType.class));
                list = Nil$.MODULE$.$colon$colon(dataRecord);
            } else {
                Extent lex = MODULE$.extractGridExtent(source, cRS).extent();
                double d = lex.xmin();
                double d12 = lex.ymin();
                double d13 = lex.xmax();
                double d14 = lex.ymax();
                DataRecord<BoundingBoxType> dataRecord = OwsDataRecord$.MODULE$.apply(new BoundingBoxType((Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d12)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d)), (Seq)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d14)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d13)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@crs"), (Object)DataRecord$.MODULE$.apply((Object)new URI(URN$.MODULE$.unsafeFromCrs(cRS)), (CanWriteXML)opengis.package$.MODULE$.__URIXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@dimensions"), (Object)DataRecord$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(2), (CanWriteXML)opengis.package$.MODULE$.__BigIntXMLFormat()))}))), opengis.package$.MODULE$.Opengisows_BoundingBoxTypeFormat(), ClassTag$.MODULE$.apply(BoundingBoxType.class));
                list = Nil$.MODULE$.$colon$colon(dataRecord);
            }
            return list;
        }, List$.MODULE$.canBuildFrom())).$colon$colon(dataRecord), (Option)new Some((Object)new GridCrsType(x$62, x$1, x$2, x$3, (Seq)x$4, x$5, x$7)), SpatialDomainType$.MODULE$.apply$default$3(), SpatialDomainType$.MODULE$.apply$default$4(), SpatialDomainType$.MODULE$.apply$default$5()), (Option)temporalDomain), new RangeType((Seq)Nil$.MODULE$.$colon$colon((Object)fieldType)), (Seq)((List)uniqueCrs.flatMap((Function1 & Serializable & scala.Serializable)proj -> Option$.MODULE$.option2Iterable(URN$.MODULE$.fromCrs((CRS)proj).map((Function1 & Serializable & scala.Serializable)x$44 -> new URI((String)x$44))), List$.MODULE$.canBuildFrom())).$colon$colon((Object)uRI), (Seq)OutputFormat$.MODULE$.all().reverse());
    }

    public <F> CoverageView<F> apply(WcsModel<F> wcsModel, URL serviceUrl, Functor<F> evidence$2) {
        return new CoverageView<F>(wcsModel, serviceUrl, (Seq<String>)Nil$.MODULE$, evidence$2);
    }

    public <F> CoverageView<F> apply(WcsModel<F> wcsModel, URL serviceUrl, DescribeCoverageWcsParams params, Functor<F> evidence$3) {
        return new CoverageView<F>(wcsModel, serviceUrl, params.identifiers(), evidence$3);
    }

    private CoverageView$() {
        MODULE$ = this;
    }
}

