/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.wcs;

import cats.Parallel;
import cats.data.NonEmptyList;
import cats.data.Validated;
import cats.effect.Concurrent;
import cats.effect.Sync$;
import cats.instances.package;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import com.azavea.maml.error.MamlException;
import com.azavea.maml.eval.ConcurrentInterpreter$;
import com.azavea.maml.eval.Interpreter;
import com.github.blemale.scaffeine.Cache;
import com.github.blemale.scaffeine.Scaffeine$;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.Tile;
import geotrellis.raster.histogram.Histogram;
import geotrellis.server.LayerExtent$;
import geotrellis.server.ogc.MapAlgebraOgcLayer;
import geotrellis.server.ogc.OgcLayer;
import geotrellis.server.ogc.SimpleOgcLayer;
import geotrellis.server.ogc.SimpleOgcLayer$;
import geotrellis.server.ogc.package$;
import geotrellis.server.ogc.package$RasterOps$;
import geotrellis.server.ogc.style.OgcStyle;
import geotrellis.server.ogc.wcs.GetCoverageWcsParams;
import geotrellis.server.ogc.wcs.WcsModel;
import geotrellis.vector.Extent;
import io.chrisdavenport.log4cats.Logger;
import io.chrisdavenport.log4cats.Logger$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0003\u0006\u0001'!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005/\u0001\t\r\t\u0015a\u00030\u0011!9\u0004AaA!\u0002\u0017A\u0004\u0002\u0003\u001f\u0001\u0005\u0007\u0005\u000b1B\u001f\t\u000b\u001d\u0003A\u0011\u0001%\t\u000b=\u0003A\u0011\u0001)\t\u0011\u0001\u0004\u0001R1A\u0005\u0002\u0005DQA\u001c\u0001\u0005\u0002=\u00141bR3u\u0007>4XM]1hK*\u00111\u0002D\u0001\u0004o\u000e\u001c(BA\u0007\u000f\u0003\rywm\u0019\u0006\u0003\u001fA\taa]3sm\u0016\u0014(\"A\t\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0016\u0005Q\u00113C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u0006AqoY:N_\u0012,G\u000eE\u0002\u001e=\u0001j\u0011AC\u0005\u0003?)\u0011\u0001bV2t\u001b>$W\r\u001c\t\u0003C\tb\u0001\u0001B\u0003$\u0001\t\u0007AEA\u0001G+\t)C&\u0005\u0002'SA\u0011acJ\u0005\u0003Q]\u0011qAT8uQ&tw\r\u0005\u0002\u0017U%\u00111f\u0006\u0002\u0004\u0003:LH!B\u0017#\u0005\u0004)#!A0\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u00021k\u0001j\u0011!\r\u0006\u0003eM\na!\u001a4gK\u000e$(\"\u0001\u001b\u0002\t\r\fGo]\u0005\u0003mE\u0012!bQ8oGV\u0014(/\u001a8u\u0003))g/\u001b3f]\u000e,GE\r\t\u0004si\u0002S\"A\u001a\n\u0005m\u001a$\u0001\u0003)be\u0006dG.\u001a7\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002?\u000b\u0002j\u0011a\u0010\u0006\u0003\u0001\u0006\u000b\u0001\u0002\\8hi\r\fGo\u001d\u0006\u0003\u0005\u000e\u000bab\u00195sSN$\u0017M^3oa>\u0014HOC\u0001E\u0003\tIw.\u0003\u0002G\u007f\t1Aj\\4hKJ\fa\u0001P5oSRtDCA%O)\u0011Q5\nT'\u0011\u0007u\u0001\u0001\u0005C\u0003/\u000b\u0001\u000fq\u0006C\u00038\u000b\u0001\u000f\u0001\bC\u0003=\u000b\u0001\u000fQ\bC\u0003\u001c\u000b\u0001\u0007A$\u0001\u0007sK:$WM\u001d'bs\u0016\u00148\u000f\u0006\u0002R7B\u0019\u0011E\t*\u0011\u0007Y\u0019V+\u0003\u0002U/\t1q\n\u001d;j_:\u00042A\u0006,Y\u0013\t9vCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u00173&\u0011!l\u0006\u0002\u0005\u0005f$X\rC\u0003]\r\u0001\u0007Q,\u0001\u0004qCJ\fWn\u001d\t\u0003;yK!a\u0018\u0006\u0003)\u001d+GoQ8wKJ\fw-Z,dgB\u000b'/Y7t\u00031\u0011X-];fgR\u001c\u0015m\u00195f+\u0005\u0011\u0007\u0003B2m;Vk\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0011b]2bM\u001a,\u0017N\\3\u000b\u0005\u001dD\u0017a\u00022mK6\fG.\u001a\u0006\u0003S*\faaZ5uQV\u0014'\"A6\u0002\u0007\r|W.\u0003\u0002nI\n)1)Y2iK\u0006)!-^5mIR\u0011\u0001/\u001d\t\u0004C\t*\u0006\"\u0002/\t\u0001\u0004i\u0006")
public class GetCoverage<F> {
    private Cache<GetCoverageWcsParams, byte[]> requestCache;
    private final WcsModel<F> wcsModel;
    private final Concurrent<F> evidence$1;
    private final Parallel<F> evidence$2;
    private final Logger<F> evidence$3;
    private volatile boolean bitmap$0;

    public F renderLayers(GetCoverageWcsParams params) {
        Extent e = params.extent();
        Option<CellSize> cs = params.cellSize();
        return (F)package.flatMap$.MODULE$.toFlatMapOps(this.wcsModel.getLayers(params), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> package.traverse$.MODULE$.toTraverseOps((Object)x$1.headOption().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Function2 function2;
            OgcLayer ogcLayer = x0$1;
            if (ogcLayer instanceof SimpleOgcLayer) {
                SimpleOgcLayer simpleOgcLayer = (SimpleOgcLayer)ogcLayer;
                function2 = LayerExtent$.MODULE$.withCellType((Object)simpleOgcLayer, simpleOgcLayer.source().cellType(), $this.evidence$3, $this.evidence$2, $this.evidence$1, $this.evidence$1, SimpleOgcLayer$.MODULE$.simpleOgcReification($this.evidence$1, $this.evidence$3));
            } else if (ogcLayer instanceof MapAlgebraOgcLayer) {
                MapAlgebraOgcLayer mapAlgebraOgcLayer = (MapAlgebraOgcLayer)ogcLayer;
                function2 = LayerExtent$.MODULE$.apply(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)mapAlgebraOgcLayer.algebra()), $this.evidence$1), ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId(mapAlgebraOgcLayer.parameters()), $this.evidence$1), (Interpreter)ConcurrentInterpreter$.MODULE$.DEFAULT($this.evidence$1), mapAlgebraOgcLayer.targetCellType(), $this.evidence$3, $this.evidence$2, $this.evidence$1, SimpleOgcLayer$.MODULE$.simpleOgcReification($this.evidence$1, $this.evidence$3));
            } else {
                throw new MatchError((Object)ogcLayer);
            }
            return function2;
        }), package.option$.MODULE$.catsStdInstancesForOption()).traverse((Function1 & Serializable & scala.Serializable)eval -> package.functor$.MODULE$.toFunctorOps(eval.apply((Object)e, (Object)cs), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Validated validated = x0$2;
            if (!(validated instanceof Validated.Valid)) {
                if (validated instanceof Validated.Invalid) {
                    Validated.Invalid invalid = (Validated.Invalid)validated;
                    NonEmptyList errs = (NonEmptyList)invalid.e();
                    throw new MamlException(errs);
                }
                throw new MatchError((Object)validated);
            }
            Validated.Valid valid = (Validated.Valid)validated;
            MultibandTile mbtile = (MultibandTile)valid.a();
            byte[] bytes = package$RasterOps$.MODULE$.render$extension(package$.MODULE$.RasterOps((Raster<MultibandTile>)new Raster((CellGrid)mbtile, e)), params.crs(), (Option<OgcStyle>)None$.MODULE$, params.format(), (List<Histogram<Object>>)Nil$.MODULE$);
            this.requestCache().put((Object)params, (Object)bytes);
            byte[] byArray = bytes;
            return byArray;
        }), $this.evidence$1));
    }

    private Cache<GetCoverageWcsParams, byte[]> requestCache$lzycompute() {
        GetCoverage getCoverage = this;
        synchronized (getCoverage) {
            if (!this.bitmap$0) {
                this.requestCache = Scaffeine$.MODULE$.apply().recordStats().expireAfterWrite(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour()).maximumSize(32L).build();
                this.bitmap$0 = true;
            }
        }
        return this.requestCache;
    }

    public Cache<GetCoverageWcsParams, byte[]> requestCache() {
        return !this.bitmap$0 ? this.requestCache$lzycompute() : this.requestCache;
    }

    public F build(GetCoverageWcsParams params) {
        return (F)FlatMapOps$.MODULE$.$greater$greater$eq$extension(package.flatMap$.MODULE$.catsSyntaxFlatMapOps(Sync$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> this.requestCache().getIfPresent((Object)params)), this.evidence$1), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                byte[] bytes = (byte[])some.value();
                object = package.apply$.MODULE$.catsSyntaxApply(Logger$.MODULE$.apply($this.evidence$3).trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("GetCoverage cache HIT: ").append(params).toString()), $this.evidence$1).$times$greater(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)bytes), $this.evidence$1));
            } else {
                object = FlatMapOps$.MODULE$.$greater$greater$eq$extension(package.flatMap$.MODULE$.catsSyntaxFlatMapOps(Logger$.MODULE$.apply($this.evidence$3).trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("GetCoverage cache MISS: ").append(params).toString()), $this.evidence$1), (Function1 & Serializable & scala.Serializable)x$2 -> package.flatMap$.MODULE$.toFlatMapOps(this.renderLayers(params), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Object object;
                    Option option = x0$2;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        byte[] bytes = (byte[])some.value();
                        object = ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)bytes), $this.evidence$1);
                    } else if (None$.MODULE$.equals(option)) {
                        object = package.flatMap$.MODULE$.toFlatMapOps($this.wcsModel.sources().find(geotrellis.store.query.package$.MODULE$.withName(params.identifier())), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                            Object object;
                            Option option = x$3.headOption();
                            if (option instanceof Some) {
                                MutableArrayTile tile = ArrayTile$.MODULE$.empty((DataType)new IntUserDefinedNoDataCellType(0), 1, 1);
                                object = ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)package$RasterOps$.MODULE$.render$extension(package$.MODULE$.RasterOps((Raster<MultibandTile>)new Raster((CellGrid)MultibandTile$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{tile, tile, tile})), params.extent())), params.crs(), (Option<OgcStyle>)None$.MODULE$, params.format(), (List<Histogram<Object>>)Nil$.MODULE$)), $this.evidence$1);
                            } else {
                                object = package.apply$.MODULE$.catsSyntaxApply(Logger$.MODULE$.apply($this.evidence$3).error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("No tile found for the ").append(params).append(" request.").toString()), $this.evidence$1).$times$greater(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte())), $this.evidence$1));
                            }
                            return object;
                        });
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return object;
                }), $this.evidence$1);
            }
            return object;
        }, this.evidence$1);
    }

    public GetCoverage(WcsModel<F> wcsModel, Concurrent<F> evidence$1, Parallel<F> evidence$2, Logger<F> evidence$3) {
        this.wcsModel = wcsModel;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
    }
}

