/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.wcs;

import cats.Applicative;
import cats.Functor;
import cats.Semigroupal;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import geotrellis.proj4.CRS;
import geotrellis.server.ogc.OgcTime;
import geotrellis.server.ogc.OutputFormat;
import geotrellis.server.ogc.OutputFormat$;
import geotrellis.server.ogc.params.CRSUtils$;
import geotrellis.server.ogc.params.ParamError;
import geotrellis.server.ogc.params.ParamMap;
import geotrellis.server.ogc.wcs.GetCoverageWcsParams;
import geotrellis.server.ogc.wcs.WcsParams;
import geotrellis.server.ogc.wcs.WcsParams$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.net.URI;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function8;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class GetCoverageWcsParams$
implements scala.Serializable {
    public static GetCoverageWcsParams$ MODULE$;

    static {
        new GetCoverageWcsParams$();
    }

    private Validated<NonEmptyList<ParamError>, Tuple2<Vector<Object>, Option<String>>> getBboxAndCrsOption(ParamMap params, String field) {
        return params.validatedParam(field, (Function1 & Serializable & scala.Serializable)bboxStr -> {
            None$ none$;
            block4: {
                try {
                    Vector v = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bboxStr.split(","))).toVector();
                    if (v.length() == 4) {
                        none$ = OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)new Tuple2(v.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)GetCoverageWcsParams$.$anonfun$getBboxAndCrsOption$2(x$8)), Vector$.MODULE$.canBuildFrom()), (Object)None$.MODULE$)));
                        break block4;
                    }
                    if (v.length() == 5) {
                        none$ = OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)new Tuple2(v.take(4).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)GetCoverageWcsParams$.$anonfun$getBboxAndCrsOption$3(x$9)), Vector$.MODULE$.canBuildFrom()), (Object)OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId(v.last())))));
                        break block4;
                    }
                    none$ = None$.MODULE$;
                }
                catch (Throwable throwable) {
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        });
    }

    public Validated<NonEmptyList<ParamError>, WcsParams> build(ParamMap params) {
        Validated<NonEmptyList<ParamError>, String> versionParam = params.validatedVersion(WcsParams$.MODULE$.wcsVersion(), WcsParams$.MODULE$.wcsVersions());
        return versionParam.andThen((Function1 & Serializable & scala.Serializable)version -> {
            Validated<NonEmptyList<ParamError>, String> identifier = params.validatedParam("identifier");
            Validated<NonEmptyList<ParamError>, Tuple2<Vector<Object>, Option<String>>> bboxAndCrsOption = MODULE$.getBboxAndCrsOption(params, "boundingbox");
            Validated idAndBboxAndCrsOption = (Validated)package.apply$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(identifier, bboxAndCrsOption)).mapN((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                String id;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        id = (String)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Vector bbox = (Vector)tuple2._1();
                Option crsOption = (Option)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)id, (Object)bbox, (Object)crsOption);
                return tuple3;
            }, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()));
            Validated gridBaseCRS = params.validatedOptionalParam("gridbasecrs").andThen((Function1 & Serializable & scala.Serializable)x$10 -> (Validated)package.traverse$.MODULE$.toTraverseOps(x$10, UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse((Function1 & Serializable & scala.Serializable)crsDesc -> CRSUtils$.MODULE$.ogcToCRS((String)crsDesc), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList())));
            Validated idAndBboxAndCrs = idAndBboxAndCrsOption.andThen((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Validated validated;
                Tuple3 tuple3 = x0$2;
                if (tuple3 == null) throw new MatchError((Object)tuple3);
                String id = (String)tuple3._1();
                Vector bbox = (Vector)tuple3._2();
                Option crsOption = (Option)tuple3._3();
                Option option = crsOption;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String crsDesc = (String)some.value();
                    validated = CRSUtils$.MODULE$.ogcToCRS(crsDesc).map((Function1 & Serializable & scala.Serializable)crs -> new Tuple3((Object)id, (Object)bbox, crs));
                    return validated;
                } else {
                    Validated validated2;
                    Validated.Valid valid;
                    Option option2;
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    Validated validated3 = gridBaseCRS;
                    if (validated3 instanceof Validated.Valid && (option2 = (Option)(valid = (Validated.Valid)validated3).a()) instanceof Some) {
                        Some some = (Some)option2;
                        CRS crs2 = (CRS)some.value();
                        validated2 = gridBaseCRS.map((Function1 & Serializable & scala.Serializable)x$11 -> new Tuple3((Object)id, (Object)bbox, (Object)crs2));
                    } else {
                        validated2 = new Validated.Invalid((Object)new ParamError.MissingParam("BoundingBox CRS")).toValidatedNel();
                    }
                    validated = validated2;
                }
                return validated;
            });
            Validated<NonEmptyList<ParamError>, List<OgcTime>> temporalSequenceOption = params.validatedOgcTimeSequence("timesequence");
            Validated format = params.validatedParam("format").andThen((Function1 & Serializable & scala.Serializable)f -> {
                Validated validated;
                Option<OutputFormat> option = OutputFormat$.MODULE$.fromString((String)f);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    OutputFormat format = (OutputFormat)some.value();
                    validated = new Validated.Valid((Object)format).toValidatedNel();
                } else if (None$.MODULE$.equals(option)) {
                    validated = new Validated.Invalid((Object)new ParamError.UnsupportedFormatError((String)f)).toValidatedNel();
                } else {
                    throw new MatchError(option);
                }
                return validated;
            });
            Validated gridCS = params.validatedOptionalParam("gridcs", (Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URI((String)s)).toOption()).map((Function1 & Serializable & scala.Serializable)x$12 -> (URI)x$12.getOrElse((Function0 & Serializable & scala.Serializable)() -> new URI("urn:ogc:def:cs:OGC:0.0:Grid2dSquareCS")));
            Validated gridType = params.validatedOptionalParam("gridtype", (Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URI((String)s)).toOption()).map((Function1 & Serializable & scala.Serializable)x$13 -> (URI)x$13.getOrElse((Function0 & Serializable & scala.Serializable)() -> new URI("urn:ogc:def:method:WCS:1.1:2dSimpleGrid")));
            Validated gridOrigin = params.validatedOptionalParam("gridorigin", (Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                List list = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(","))).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)GetCoverageWcsParams$.$anonfun$build$24(x$14)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toList();
                Some some = List$.MODULE$.unapplySeq((Seq)list);
                if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)list);
                }
                double fst = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(0));
                double snd = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(1));
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(fst, snd);
                Tuple2.mcDD.sp sp3 = sp2;
                double fst2 = sp3._1$mcD$sp();
                double snd2 = sp3._2$mcD$sp();
                return new Tuple2.mcDD.sp(fst2, snd2);
            }).toOption());
            Validated gridOffsets = params.validatedOptionalParam("gridoffsets", (Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                List list = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(","))).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToDouble((double)GetCoverageWcsParams$.$anonfun$build$27(x$16)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toList();
                return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)list.head()), BoxesRunTime.unboxToDouble((Object)list.last()));
            }).toOption());
            return (Validated)package.apply$.MODULE$.catsSyntaxTuple8Semigroupal(new Tuple8((Object)idAndBboxAndCrs, (Object)format, (Object)gridBaseCRS, (Object)gridCS, (Object)gridType, gridOrigin, gridOffsets, temporalSequenceOption)).mapN((Function8 & Serializable & scala.Serializable)(x0$3, x1$2, x2$1, x3$1, x4$1, x5$1, x6$1, x7$1) -> {
                List temporalSeqOpt;
                Option gridOffsets;
                Option gridOrigin;
                URI gridType;
                URI gridCS;
                Option gridBaseCRS;
                OutputFormat format;
                Tuple3 tuple3;
                block3: {
                    Tuple8 tuple8;
                    block2: {
                        tuple8 = new Tuple8(x0$3, x1$2, x2$1, x3$1, x4$1, x5$1, x6$1, x7$1);
                        if (tuple8 == null) break block2;
                        tuple3 = (Tuple3)tuple8._1();
                        format = (OutputFormat)tuple8._2();
                        gridBaseCRS = (Option)tuple8._3();
                        gridCS = (URI)tuple8._4();
                        gridType = (URI)tuple8._5();
                        gridOrigin = (Option)tuple8._6();
                        gridOffsets = (Option)tuple8._7();
                        temporalSeqOpt = (List)tuple8._8();
                        if (tuple3 != null) break block3;
                    }
                    throw new MatchError((Object)tuple8);
                }
                String id = (String)tuple3._1();
                Vector bbox = (Vector)tuple3._2();
                CRS crs = (CRS)tuple3._3();
                Extent extent = new Extent(BoxesRunTime.unboxToDouble((Object)bbox.apply(0)), BoxesRunTime.unboxToDouble((Object)bbox.apply(1)), BoxesRunTime.unboxToDouble((Object)bbox.apply(2)), BoxesRunTime.unboxToDouble((Object)bbox.apply(3)));
                GetCoverageWcsParams getCoverageWcsParams = new GetCoverageWcsParams((String)version, id, extent, (List<OgcTime>)temporalSeqOpt, format, (Option<CRS>)gridBaseCRS, gridCS, gridType, (Option<Tuple2<Object, Object>>)gridOrigin, (Option<Tuple2<Object, Object>>)gridOffsets, crs, params);
                return getCoverageWcsParams;
            }, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()));
        });
    }

    public GetCoverageWcsParams apply(String version, String identifier, Extent boundingBox, List<OgcTime> temporalSequence, OutputFormat format, Option<CRS> gridBaseCRS, URI gridCS, URI gridType, Option<Tuple2<Object, Object>> gridOrigin, Option<Tuple2<Object, Object>> gridOffsets, CRS crs, ParamMap params) {
        return new GetCoverageWcsParams(version, identifier, boundingBox, temporalSequence, format, gridBaseCRS, gridCS, gridType, gridOrigin, gridOffsets, crs, params);
    }

    public Option<Tuple12<String, String, Extent, List<OgcTime>, OutputFormat, Option<CRS>, URI, URI, Option<Tuple2<Object, Object>>, Option<Tuple2<Object, Object>>, CRS, ParamMap>> unapply(GetCoverageWcsParams x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.version(), (Object)x$0.identifier(), (Object)x$0.boundingBox(), x$0.temporalSequence(), (Object)x$0.format(), x$0.gridBaseCRS(), (Object)x$0.gridCS(), (Object)x$0.gridType(), x$0.gridOrigin(), x$0.gridOffsets(), (Object)x$0.crs(), (Object)x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ double $anonfun$getBboxAndCrsOption$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toDouble();
    }

    public static final /* synthetic */ double $anonfun$getBboxAndCrsOption$3(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toDouble();
    }

    public static final /* synthetic */ double $anonfun$build$24(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toDouble();
    }

    public static final /* synthetic */ double $anonfun$build$27(String x$16) {
        return new StringOps(Predef$.MODULE$.augmentString(x$16)).toDouble();
    }

    private GetCoverageWcsParams$() {
        MODULE$ = this;
    }
}

