/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.wcs;

import cats.data.NonEmptyList;
import cats.data.Validated;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellSize;
import geotrellis.raster.GridExtent;
import geotrellis.raster.GridExtent$;
import geotrellis.server.ogc.OgcTime;
import geotrellis.server.ogc.OgcTimeInterval;
import geotrellis.server.ogc.OgcTimePositions;
import geotrellis.server.ogc.OutputFormat;
import geotrellis.server.ogc.package$;
import geotrellis.server.ogc.package$ExtentOps$;
import geotrellis.server.ogc.params.ParamError;
import geotrellis.server.ogc.params.ParamMap;
import geotrellis.server.ogc.wcs.GetCoverageWcsParams$;
import geotrellis.server.ogc.wcs.WcsParams;
import geotrellis.store.query.package;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import java.net.URI;
import java.time.ZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple12;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import spire.math.Integral;
import spire.math.Integral$;

@ScalaSignature(bytes="\u0006\u0001\rMa\u0001B\u001f?\u0001\u001eC\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\tE\u0002\u0011\t\u0012)A\u0005/\"A1\r\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005e\u0001\tE\t\u0015!\u0003X\u0011!)\u0007A!f\u0001\n\u00031\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011B4\t\u00119\u0004!Q3A\u0005\u0002=D\u0001\" \u0001\u0003\u0012\u0003\u0006I\u0001\u001d\u0005\t}\u0002\u0011)\u001a!C\u0001\u007f\"Q\u0011q\u0001\u0001\u0003\u0012\u0003\u0006I!!\u0001\t\u0015\u0005%\u0001A!f\u0001\n\u0003\tY\u0001\u0003\u0006\u0002 \u0001\u0011\t\u0012)A\u0005\u0003\u001bA!\"!\t\u0001\u0005+\u0007I\u0011AA\u0012\u0011)\t)\u0004\u0001B\tB\u0003%\u0011Q\u0005\u0005\u000b\u0003o\u0001!Q3A\u0005\u0002\u0005\r\u0002BCA\u001d\u0001\tE\t\u0015!\u0003\u0002&!Q\u00111\b\u0001\u0003\u0016\u0004%\t!!\u0010\t\u0015\u00055\u0003A!E!\u0002\u0013\ty\u0004\u0003\u0006\u0002P\u0001\u0011)\u001a!C\u0001\u0003{A!\"!\u0015\u0001\u0005#\u0005\u000b\u0011BA \u0011)\t\u0019\u0006\u0001BK\u0002\u0013\u0005\u0011Q\u000b\u0005\u000b\u0003/\u0002!\u0011#Q\u0001\n\u0005M\u0001BCA-\u0001\tU\r\u0011\"\u0001\u0002\\!Q\u0011q\r\u0001\u0003\u0012\u0003\u0006I!!\u0018\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005\"CAV\u0001\t\u0007I\u0011AAW\u0011!\t)\f\u0001Q\u0001\n\u0005=\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\u0007\u0003\u0013\u0004A\u0011\u00014\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"I\u0011Q\u001c\u0001\u0002\u0002\u0013\u0005\u0011q\u001c\u0005\n\u0003s\u0004\u0011\u0013!C\u0001\u0003wD\u0011B!\u0005\u0001#\u0003%\t!a?\t\u0013\tM\u0001!%A\u0005\u0002\tU\u0001\"\u0003B\r\u0001E\u0005I\u0011\u0001B\u000e\u0011%\u0011y\u0002AI\u0001\n\u0003\u0011\t\u0003C\u0005\u0003&\u0001\t\n\u0011\"\u0001\u0003(!I!1\u0006\u0001\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005c\u0001\u0011\u0013!C\u0001\u0005[A\u0011Ba\r\u0001#\u0003%\tA!\u000e\t\u0013\te\u0002!%A\u0005\u0002\tU\u0002\"\u0003B\u001e\u0001E\u0005I\u0011\u0001B\u001f\u0011%\u0011\t\u0005AI\u0001\n\u0003\u0011\u0019\u0005C\u0005\u0003H\u0001\t\t\u0011\"\u0011\u0003J!I!Q\u000b\u0001\u0002\u0002\u0013\u0005!q\u000b\u0005\n\u0005?\u0002\u0011\u0011!C\u0001\u0005CB\u0011B!\u001c\u0001\u0003\u0003%\tEa\u001c\t\u0013\tu\u0004!!A\u0005\u0002\t}\u0004\"\u0003BB\u0001\u0005\u0005I\u0011\tBC\u0011%\u00119\tAA\u0001\n\u0003\u0012I\tC\u0005\u0003\f\u0002\t\t\u0011\"\u0011\u0003\u000e\u001e9!\u0011\u0013 \t\u0002\tMeAB\u001f?\u0011\u0003\u0011)\nC\u0004\u0002jY\"\tA!(\t\u000f\t}e\u0007\"\u0003\u0003\"\"9!Q\u001b\u001c\u0005\u0002\t]\u0007\"\u0003Bom\u0005\u0005I\u0011\u0011Bp\u0011%\u0011IPNA\u0001\n\u0003\u0013Y\u0010C\u0005\u0004\nY\n\t\u0011\"\u0003\u0004\f\t!r)\u001a;D_Z,'/Y4f/\u000e\u001c\b+\u0019:b[NT!a\u0010!\u0002\u0007]\u001c7O\u0003\u0002B\u0005\u0006\u0019qnZ2\u000b\u0005\r#\u0015AB:feZ,'OC\u0001F\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\u0011\u0001\u0001\n\u0014*\u0011\u0005%SU\"\u0001 \n\u0005-s$!C,dgB\u000b'/Y7t!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u001d\u0001&o\u001c3vGR\u0004\"!T*\n\u0005Qs%\u0001D*fe&\fG.\u001b>bE2,\u0017a\u0002<feNLwN\\\u000b\u0002/B\u0011\u0001l\u0018\b\u00033v\u0003\"A\u0017(\u000e\u0003mS!\u0001\u0018$\u0002\rq\u0012xn\u001c;?\u0013\tqf*\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u0014aa\u0015;sS:<'B\u00010O\u0003!1XM]:j_:\u0004\u0013AC5eK:$\u0018NZ5fe\u0006Y\u0011\u000eZ3oi&4\u0017.\u001a:!\u0003-\u0011w.\u001e8eS:<'i\u001c=\u0016\u0003\u001d\u0004\"\u0001[6\u000e\u0003%T!A\u001b#\u0002\rY,7\r^8s\u0013\ta\u0017N\u0001\u0004FqR,g\u000e^\u0001\rE>,h\u000eZ5oO\n{\u0007\u0010I\u0001\u0011i\u0016l\u0007o\u001c:bYN+\u0017/^3oG\u0016,\u0012\u0001\u001d\t\u0004cZLhB\u0001:u\u001d\tQ6/C\u0001P\u0013\t)h*A\u0004qC\u000e\\\u0017mZ3\n\u0005]D(\u0001\u0002'jgRT!!\u001e(\u0011\u0005i\\X\"\u0001!\n\u0005q\u0004%aB(hGRKW.Z\u0001\u0012i\u0016l\u0007o\u001c:bYN+\u0017/^3oG\u0016\u0004\u0013A\u00024pe6\fG/\u0006\u0002\u0002\u0002A\u0019!0a\u0001\n\u0007\u0005\u0015\u0001I\u0001\u0007PkR\u0004X\u000f\u001e$pe6\fG/A\u0004g_Jl\u0017\r\u001e\u0011\u0002\u0017\u001d\u0014\u0018\u000e\u001a\"bg\u0016\u001c%kU\u000b\u0003\u0003\u001b\u0001R!TA\b\u0003'I1!!\u0005O\u0005\u0019y\u0005\u000f^5p]B!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0011\u000bQ\u0001\u001d:pURJA!!\b\u0002\u0018\t\u00191IU*\u0002\u0019\u001d\u0014\u0018\u000e\u001a\"bg\u0016\u001c%k\u0015\u0011\u0002\r\u001d\u0014\u0018\u000eZ\"T+\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u00079,GO\u0003\u0002\u00020\u0005!!.\u0019<b\u0013\u0011\t\u0019$!\u000b\u0003\u0007U\u0013\u0016*A\u0004he&$7i\u0015\u0011\u0002\u0011\u001d\u0014\u0018\u000e\u001a+za\u0016\f\u0011b\u001a:jIRK\b/\u001a\u0011\u0002\u0015\u001d\u0014\u0018\u000eZ(sS\u001eLg.\u0006\u0002\u0002@A)Q*a\u0004\u0002BA9Q*a\u0011\u0002H\u0005\u001d\u0013bAA#\u001d\n1A+\u001e9mKJ\u00022!TA%\u0013\r\tYE\u0014\u0002\u0007\t>,(\r\\3\u0002\u0017\u001d\u0014\u0018\u000eZ(sS\u001eLg\u000eI\u0001\fOJLGm\u00144gg\u0016$8/\u0001\u0007he&$wJ\u001a4tKR\u001c\b%A\u0002deN,\"!a\u0005\u0002\t\r\u00148\u000fI\u0001\u0007a\u0006\u0014\u0018-\\:\u0016\u0005\u0005u\u0003\u0003BA0\u0003Gj!!!\u0019\u000b\u0007\u0005e\u0003)\u0003\u0003\u0002f\u0005\u0005$\u0001\u0003)be\u0006lW*\u00199\u0002\u000fA\f'/Y7tA\u00051A(\u001b8jiz\"\"$!\u001c\u0002p\u0005E\u00141OA;\u0003o\nI(a\u001f\u0002~\u0005}\u0014\u0011QAB\u0003\u000b\u0003\"!\u0013\u0001\t\u000bUK\u0002\u0019A,\t\u000b\rL\u0002\u0019A,\t\u000b\u0015L\u0002\u0019A4\t\u000b9L\u0002\u0019\u00019\t\ryL\u0002\u0019AA\u0001\u0011\u001d\tI!\u0007a\u0001\u0003\u001bAq!!\t\u001a\u0001\u0004\t)\u0003C\u0004\u00028e\u0001\r!!\n\t\u000f\u0005m\u0012\u00041\u0001\u0002@!9\u0011qJ\rA\u0002\u0005}\u0002bBA*3\u0001\u0007\u00111\u0003\u0005\b\u00033J\u0002\u0019AA/\u0003\u001d!x.U;fef,\"!a#\u0011\t\u00055\u0015Q\u0015\b\u0005\u0003\u001f\u000b\tK\u0004\u0003\u0002\u0012\u0006me\u0002BAJ\u0003/s1AWAK\u0013\u0005)\u0015bAAM\t\u0006)1\u000f^8sK&!\u0011QTAP\u0003\u0015\tX/\u001a:z\u0015\r\tI\nR\u0005\u0004k\u0006\r&\u0002BAO\u0003?KA!a*\u0002*\n)\u0011+^3ss*\u0019Q/a)\u0002\u0011\rD\u0017M\\4f1f+\"!a,\u0011\u00075\u000b\t,C\u0002\u00024:\u0013qAQ8pY\u0016\fg.A\u0005dQ\u0006tw-\u001a-ZA\u0005A1-\u001a7m'&TX-\u0006\u0002\u0002<B)Q*a\u0004\u0002>B!\u0011qXAc\u001b\t\t\tMC\u0002\u0002D\u0012\u000baA]1ti\u0016\u0014\u0018\u0002BAd\u0003\u0003\u0014\u0001bQ3mYNK'0Z\u0001\u0007Kb$XM\u001c;\u0002\u0015\u001d\u0014\u0018\u000eZ#yi\u0016tG/\u0006\u0002\u0002PB)Q*a\u0004\u0002RB1\u0011qXAj\u0003/LA!!6\u0002B\nQqI]5e\u000bb$XM\u001c;\u0011\u00075\u000bI.C\u0002\u0002\\:\u0013A\u0001T8oO\u0006!1m\u001c9z)i\ti'!9\u0002d\u0006\u0015\u0018q]Au\u0003W\fi/a<\u0002r\u0006M\u0018Q_A|\u0011\u001d)\u0006\u0005%AA\u0002]Cqa\u0019\u0011\u0011\u0002\u0003\u0007q\u000bC\u0004fAA\u0005\t\u0019A4\t\u000f9\u0004\u0003\u0013!a\u0001a\"Aa\u0010\tI\u0001\u0002\u0004\t\t\u0001C\u0005\u0002\n\u0001\u0002\n\u00111\u0001\u0002\u000e!I\u0011\u0011\u0005\u0011\u0011\u0002\u0003\u0007\u0011Q\u0005\u0005\n\u0003o\u0001\u0003\u0013!a\u0001\u0003KA\u0011\"a\u000f!!\u0003\u0005\r!a\u0010\t\u0013\u0005=\u0003\u0005%AA\u0002\u0005}\u0002\"CA*AA\u0005\t\u0019AA\n\u0011%\tI\u0006\tI\u0001\u0002\u0004\ti&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u(fA,\u0002\u0000.\u0012!\u0011\u0001\t\u0005\u0005\u0007\u0011i!\u0004\u0002\u0003\u0006)!!q\u0001B\u0005\u0003%)hn\u00195fG.,GMC\u0002\u0003\f9\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yA!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0003\u0016\u0004O\u0006}\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005;Q3\u0001]A\u0000\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"Aa\t+\t\u0005\u0005\u0011q`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011IC\u000b\u0003\u0002\u000e\u0005}\u0018AD2paf$C-\u001a4bk2$HeN\u000b\u0003\u0005_QC!!\n\u0002\u0000\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012B\u0014AD2paf$C-\u001a4bk2$H%O\u000b\u0003\u0005oQC!a\u0010\u0002\u0000\u0006y1m\u001c9zI\u0011,g-Y;mi\u0012\n\u0004'A\bd_BLH\u0005Z3gCVdG\u000fJ\u00192+\t\u0011yD\u000b\u0003\u0002\u0014\u0005}\u0018aD2paf$C-\u001a4bk2$H%\r\u001a\u0016\u0005\t\u0015#\u0006BA/\u0003\u007f\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B&!\u0011\u0011iEa\u0015\u000e\u0005\t=#\u0002\u0002B)\u0003[\tA\u0001\\1oO&\u0019\u0001Ma\u0014\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\te\u0003cA'\u0003\\%\u0019!Q\f(\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\r$\u0011\u000e\t\u0004\u001b\n\u0015\u0014b\u0001B4\u001d\n\u0019\u0011I\\=\t\u0013\t-t&!AA\u0002\te\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003rA1!1\u000fB=\u0005Gj!A!\u001e\u000b\u0007\t]d*\u0001\u0006d_2dWm\u0019;j_:LAAa\u001f\u0003v\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tyK!!\t\u0013\t-\u0014'!AA\u0002\t\r\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\te\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t-\u0013AB3rk\u0006d7\u000f\u0006\u0003\u00020\n=\u0005\"\u0003B6i\u0005\u0005\t\u0019\u0001B2\u0003Q9U\r^\"pm\u0016\u0014\u0018mZ3XGN\u0004\u0016M]1ngB\u0011\u0011JN\n\u0005m\t]%\u000bE\u0002N\u00053K1Aa'O\u0005\u0019\te.\u001f*fMR\u0011!1S\u0001\u0014O\u0016$(IY8y\u0003:$7I]:PaRLwN\u001c\u000b\u0007\u0005G\u0013yM!5\u0011\u0011\t\u0015&\u0011\u0018B`\u0005\u000btAAa*\u00036:!!\u0011\u0016BX\u001d\rQ&1V\u0005\u0003\u0005[\u000bAaY1ug&!!\u0011\u0017BZ\u0003\u0011!\u0017\r^1\u000b\u0005\t5\u0016bA;\u00038*!!\u0011\u0017BZ\u0013\u0011\u0011YL!0\u0003\u0019Y\u000bG.\u001b3bi\u0016$g*\u001a7\u000b\u0007U\u00149\f\u0005\u0003\u0002`\t\u0005\u0017\u0002\u0002Bb\u0003C\u0012!\u0002U1sC6,%O]8s!\u001di\u00151\tBd\u0005\u001b\u0004R!\u001dBe\u0003\u000fJ1Aa3y\u0005\u00191Vm\u0019;peB!Q*a\u0004X\u0011\u001d\tI\u0006\u000fa\u0001\u0003;BaAa59\u0001\u00049\u0016!\u00024jK2$\u0017!\u00022vS2$G\u0003\u0002Bm\u00057\u0004rA!*\u0003:\n}\u0006\nC\u0004\u0002Ze\u0002\r!!\u0018\u0002\u000b\u0005\u0004\b\u000f\\=\u00155\u00055$\u0011\u001dBr\u0005K\u00149O!;\u0003l\n5(q\u001eBy\u0005g\u0014)Pa>\t\u000bUS\u0004\u0019A,\t\u000b\rT\u0004\u0019A,\t\u000b\u0015T\u0004\u0019A4\t\u000b9T\u0004\u0019\u00019\t\ryT\u0004\u0019AA\u0001\u0011\u001d\tIA\u000fa\u0001\u0003\u001bAq!!\t;\u0001\u0004\t)\u0003C\u0004\u00028i\u0002\r!!\n\t\u000f\u0005m\"\b1\u0001\u0002@!9\u0011q\n\u001eA\u0002\u0005}\u0002bBA*u\u0001\u0007\u00111\u0003\u0005\b\u00033R\u0004\u0019AA/\u0003\u001d)h.\u00199qYf$BA!@\u0004\u0006A)Q*a\u0004\u0003\u0000B9Rj!\u0001X/\u001e\u0004\u0018\u0011AA\u0007\u0003K\t)#a\u0010\u0002@\u0005M\u0011QL\u0005\u0004\u0007\u0007q%a\u0002+va2,\u0017G\r\u0005\n\u0007\u000fY\u0014\u0011!a\u0001\u0003[\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r5\u0001\u0003\u0002B'\u0007\u001fIAa!\u0005\u0003P\t1qJ\u00196fGR\u0004")
public class GetCoverageWcsParams
extends WcsParams
implements Product,
scala.Serializable {
    private final String version;
    private final String identifier;
    private final Extent boundingBox;
    private final List<OgcTime> temporalSequence;
    private final OutputFormat format;
    private final Option<CRS> gridBaseCRS;
    private final URI gridCS;
    private final URI gridType;
    private final Option<Tuple2<Object, Object>> gridOrigin;
    private final Option<Tuple2<Object, Object>> gridOffsets;
    private final CRS crs;
    private final ParamMap params;
    private final boolean changeXY;

    public static Option<Tuple12<String, String, Extent, List<OgcTime>, OutputFormat, Option<CRS>, URI, URI, Option<Tuple2<Object, Object>>, Option<Tuple2<Object, Object>>, CRS, ParamMap>> unapply(GetCoverageWcsParams getCoverageWcsParams) {
        return GetCoverageWcsParams$.MODULE$.unapply(getCoverageWcsParams);
    }

    public static GetCoverageWcsParams apply(String string, String string2, Extent extent, List<OgcTime> list, OutputFormat outputFormat, Option<CRS> option, URI uRI, URI uRI2, Option<Tuple2<Object, Object>> option2, Option<Tuple2<Object, Object>> option3, CRS cRS, ParamMap paramMap) {
        return GetCoverageWcsParams$.MODULE$.apply(string, string2, extent, list, outputFormat, option, uRI, uRI2, option2, option3, cRS, paramMap);
    }

    public static Validated<NonEmptyList<ParamError>, WcsParams> build(ParamMap paramMap) {
        return GetCoverageWcsParams$.MODULE$.build(paramMap);
    }

    @Override
    public String version() {
        return this.version;
    }

    public String identifier() {
        return this.identifier;
    }

    public Extent boundingBox() {
        return this.boundingBox;
    }

    public List<OgcTime> temporalSequence() {
        return this.temporalSequence;
    }

    public OutputFormat format() {
        return this.format;
    }

    public Option<CRS> gridBaseCRS() {
        return this.gridBaseCRS;
    }

    public URI gridCS() {
        return this.gridCS;
    }

    public URI gridType() {
        return this.gridType;
    }

    public Option<Tuple2<Object, Object>> gridOrigin() {
        return this.gridOrigin;
    }

    public Option<Tuple2<Object, Object>> gridOffsets() {
        return this.gridOffsets;
    }

    public CRS crs() {
        return this.crs;
    }

    public ParamMap params() {
        return this.params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object toQuery() {
        Object query = package.QueryOps$.MODULE$.and$extension(geotrellis.store.query.package$.MODULE$.QueryOps(geotrellis.store.query.package$.MODULE$.withName(this.identifier())), geotrellis.store.query.package$.MODULE$.intersects(new ProjectedExtent(this.extent(), this.crs())));
        boolean bl = false;
        Some some = null;
        Option option = this.temporalSequence().headOption();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            OgcTime timeInterval = (OgcTime)some.value();
            if (timeInterval instanceof OgcTimeInterval) {
                OgcTimeInterval ogcTimeInterval = (OgcTimeInterval)timeInterval;
                return package.QueryOps$.MODULE$.and$extension(geotrellis.store.query.package$.MODULE$.QueryOps(query), geotrellis.store.query.package$.MODULE$.between(ogcTimeInterval.start(), ogcTimeInterval.end(), geotrellis.store.query.package$.MODULE$.between$default$3()));
            }
        }
        if (!bl) return query;
        OgcTime ogcTime = (OgcTime)some.value();
        if (!(ogcTime instanceof OgcTimePositions)) return query;
        OgcTimePositions ogcTimePositions = (OgcTimePositions)ogcTime;
        NonEmptyList<ZonedDateTime> list = ogcTimePositions.list();
        return package.QueryOps$.MODULE$.and$extension(geotrellis.store.query.package$.MODULE$.QueryOps(query), ((TraversableOnce)list.toList().map((Function1 & Serializable & scala.Serializable)x$1 -> geotrellis.store.query.package$.MODULE$.at(x$1, geotrellis.store.query.package$.MODULE$.at$default$2()), List$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> package.QueryOps$.MODULE$.or$extension(geotrellis.store.query.package$.MODULE$.QueryOps(x$2), x$3)));
    }

    public boolean changeXY() {
        return this.changeXY;
    }

    public Option<CellSize> cellSize() {
        return this.changeXY() ? this.gridOffsets().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double f = tuple2._1$mcD$sp();
            double s = tuple2._2$mcD$sp();
            CellSize cellSize = new CellSize(-f, s);
            return cellSize;
        }) : this.gridOffsets().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double f = tuple2._1$mcD$sp();
            double s = tuple2._2$mcD$sp();
            CellSize cellSize = new CellSize(f, -s);
            return cellSize;
        });
    }

    public Extent extent() {
        Extent extent;
        if (this.changeXY()) {
            Tuple2 tuple2 = (Tuple2)this.gridOrigin().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)this.boundingBox().xmax())), (Object)BoxesRunTime.boxToDouble((double)this.boundingBox().ymin())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double xmax = tuple2._1$mcD$sp();
            double ymin = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(xmax, ymin);
            Tuple2.mcDD.sp sp3 = sp2;
            double xmax2 = sp3._1$mcD$sp();
            double ymin2 = sp3._2$mcD$sp();
            extent = package$ExtentOps$.MODULE$.swapXY$extension(package$.MODULE$.ExtentOps(package$ExtentOps$.MODULE$.buffer$extension1(package$.MODULE$.ExtentOps(new Extent(this.boundingBox().xmin(), ymin2, xmax2, this.boundingBox().ymax())), this.cellSize())));
        } else {
            Tuple2 tuple2 = (Tuple2)this.gridOrigin().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)this.boundingBox().xmin())), (Object)BoxesRunTime.boxToDouble((double)this.boundingBox().ymax())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double xmin = tuple2._1$mcD$sp();
            double ymax = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(xmin, ymax);
            Tuple2.mcDD.sp sp5 = sp4;
            double xmin2 = sp5._1$mcD$sp();
            double ymax2 = sp5._2$mcD$sp();
            extent = package$ExtentOps$.MODULE$.buffer$extension1(package$.MODULE$.ExtentOps(new Extent(xmin2, this.boundingBox().ymin(), this.boundingBox().xmax(), ymax2)), this.cellSize());
        }
        return extent;
    }

    public Option<GridExtent<Object>> gridExtent() {
        return this.cellSize().map((Function1 & Serializable & scala.Serializable)x$6 -> GridExtent$.MODULE$.apply(this.extent(), x$6, (Integral)Integral$.MODULE$.LongIsIntegral()));
    }

    public GetCoverageWcsParams copy(String version, String identifier, Extent boundingBox, List<OgcTime> temporalSequence, OutputFormat format, Option<CRS> gridBaseCRS, URI gridCS, URI gridType, Option<Tuple2<Object, Object>> gridOrigin, Option<Tuple2<Object, Object>> gridOffsets, CRS crs, ParamMap params) {
        return new GetCoverageWcsParams(version, identifier, boundingBox, temporalSequence, format, gridBaseCRS, gridCS, gridType, gridOrigin, gridOffsets, crs, params);
    }

    public String copy$default$1() {
        return this.version();
    }

    public Option<Tuple2<Object, Object>> copy$default$10() {
        return this.gridOffsets();
    }

    public CRS copy$default$11() {
        return this.crs();
    }

    public ParamMap copy$default$12() {
        return this.params();
    }

    public String copy$default$2() {
        return this.identifier();
    }

    public Extent copy$default$3() {
        return this.boundingBox();
    }

    public List<OgcTime> copy$default$4() {
        return this.temporalSequence();
    }

    public OutputFormat copy$default$5() {
        return this.format();
    }

    public Option<CRS> copy$default$6() {
        return this.gridBaseCRS();
    }

    public URI copy$default$7() {
        return this.gridCS();
    }

    public URI copy$default$8() {
        return this.gridType();
    }

    public Option<Tuple2<Object, Object>> copy$default$9() {
        return this.gridOrigin();
    }

    public String productPrefix() {
        return "GetCoverageWcsParams";
    }

    public int productArity() {
        return 12;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.version();
                break;
            }
            case 1: {
                object = this.identifier();
                break;
            }
            case 2: {
                object = this.boundingBox();
                break;
            }
            case 3: {
                object = this.temporalSequence();
                break;
            }
            case 4: {
                object = this.format();
                break;
            }
            case 5: {
                object = this.gridBaseCRS();
                break;
            }
            case 6: {
                object = this.gridCS();
                break;
            }
            case 7: {
                object = this.gridType();
                break;
            }
            case 8: {
                object = this.gridOrigin();
                break;
            }
            case 9: {
                object = this.gridOffsets();
                break;
            }
            case 10: {
                object = this.crs();
                break;
            }
            case 11: {
                object = this.params();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetCoverageWcsParams;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetCoverageWcsParams)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetCoverageWcsParams getCoverageWcsParams = (GetCoverageWcsParams)x$1;
        String string = this.version();
        String string2 = getCoverageWcsParams.version();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.identifier();
        String string4 = getCoverageWcsParams.identifier();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Extent extent = this.boundingBox();
        Extent extent2 = getCoverageWcsParams.boundingBox();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!extent.equals(extent2)) return false;
        List<OgcTime> list = this.temporalSequence();
        List<OgcTime> list2 = getCoverageWcsParams.temporalSequence();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        OutputFormat outputFormat = this.format();
        OutputFormat outputFormat2 = getCoverageWcsParams.format();
        if (outputFormat == null) {
            if (outputFormat2 != null) {
                return false;
            }
        } else if (!outputFormat.equals(outputFormat2)) return false;
        Option<CRS> option = this.gridBaseCRS();
        Option<CRS> option2 = getCoverageWcsParams.gridBaseCRS();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        URI uRI = this.gridCS();
        URI uRI2 = getCoverageWcsParams.gridCS();
        if (uRI == null) {
            if (uRI2 != null) {
                return false;
            }
        } else if (!((Object)uRI).equals(uRI2)) return false;
        URI uRI3 = this.gridType();
        URI uRI4 = getCoverageWcsParams.gridType();
        if (uRI3 == null) {
            if (uRI4 != null) {
                return false;
            }
        } else if (!((Object)uRI3).equals(uRI4)) return false;
        Option<Tuple2<Object, Object>> option3 = this.gridOrigin();
        Option<Tuple2<Object, Object>> option4 = getCoverageWcsParams.gridOrigin();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Tuple2<Object, Object>> option5 = this.gridOffsets();
        Option<Tuple2<Object, Object>> option6 = getCoverageWcsParams.gridOffsets();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        CRS cRS = this.crs();
        CRS cRS2 = getCoverageWcsParams.crs();
        if (cRS == null) {
            if (cRS2 != null) {
                return false;
            }
        } else if (!cRS.equals(cRS2)) return false;
        ParamMap paramMap = this.params();
        ParamMap paramMap2 = getCoverageWcsParams.params();
        if (paramMap == null) {
            if (paramMap2 != null) {
                return false;
            }
        } else if (!((Object)paramMap).equals(paramMap2)) return false;
        if (!getCoverageWcsParams.canEqual(this)) return false;
        return true;
    }

    public GetCoverageWcsParams(String version, String identifier, Extent boundingBox, List<OgcTime> temporalSequence, OutputFormat format, Option<CRS> gridBaseCRS, URI gridCS, URI gridType, Option<Tuple2<Object, Object>> gridOrigin, Option<Tuple2<Object, Object>> gridOffsets, CRS crs, ParamMap params) {
        this.version = version;
        this.identifier = identifier;
        this.boundingBox = boundingBox;
        this.temporalSequence = temporalSequence;
        this.format = format;
        this.gridBaseCRS = gridBaseCRS;
        this.gridCS = gridCS;
        this.gridType = gridType;
        this.gridOrigin = gridOrigin;
        this.gridOffsets = gridOffsets;
        this.crs = crs;
        this.params = params;
        Product.$init$((Product)this);
        this.changeXY = crs.isGeographic();
    }
}

