/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.wfs;

import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellSize;
import geotrellis.server.ogc.URN$;
import geotrellis.server.ogc.gml.GmlDataRecord$;
import geotrellis.server.ogc.wfs.package$;
import geotrellis.server.ogc.wfs.package$DataRecordOps$;
import geotrellis.server.ogc.wfs.package$ElemOps$;
import geotrellis.vector.Feature;
import geotrellis.vector.Polygon$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.JsonObject;
import io.circe.syntax.package;
import java.io.Serializable;
import java.net.URI;
import opengis.gml.CoordinatesType;
import opengis.gml.FeaturePropertyType;
import opengis.gml.FeaturePropertyType$;
import opengis.gml.FeaturePropertyTypeSequence1;
import opengis.gml.GeometryPropertyType;
import opengis.gml.GeometryPropertyType$;
import opengis.gml.GeometryPropertyTypeSequence1;
import opengis.gml.LinearRingType;
import opengis.gml.LinearRingType$;
import opengis.gml.MultiPolygonType;
import opengis.gml.PolygonPropertyType;
import opengis.gml.PolygonPropertyType$;
import opengis.gml.PolygonPropertyTypeSequence1;
import opengis.gml.PolygonType;
import opengis.gml.PolygonType$;
import opengis.gml.StandardObjectPropertiesSequence;
import opengis.gml.StandardObjectPropertiesSequence$;
import opengis.wfs.FeatureCollectionType;
import opengis.wfs.FeatureCollectionType$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.XML$;
import scalaxb.CanWriteXML;
import scalaxb.DataRecord;
import scalaxb.DataRecord$;

public final class WfsFeatureCollection$ {
    public static WfsFeatureCollection$ MODULE$;

    static {
        new WfsFeatureCollection$();
    }

    public <G extends Geometry> Elem toXML(Seq<Feature<G, Json>> features, CRS crs, CellSize cellSize) {
        return (Elem)scalaxb.package$.MODULE$.toXML((Object)this.apply(features, crs, cellSize), (Option)None$.MODULE$, OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)"FeatureCollection")), package$.MODULE$.wfsScope(), false, (CanWriteXML)opengis.package$.MODULE$.Opengiswfs_FeatureCollectionTypeFormat());
    }

    private NodeSeq jsonXML(Json j) {
        Elem elem;
        Option option = j.asObject();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonObject obj = (JsonObject)some.value();
            elem = (NodeSeq)((TraversableOnce)obj.toMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                NodeSeq nodeSeq;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Json v = (Json)tuple2._2();
                    Option option = v.asObject();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        JsonObject obj = (JsonObject)some.value();
                        nodeSeq = MODULE$.jsonXML(package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)obj), (Encoder)Encoder$.MODULE$.encodeJsonObject()));
                    } else {
                        nodeSeq = XML$.MODULE$.loadString(new StringBuilder(5).append("<").append(k).append(">").append(v.noSpaces()).append("</").append(k).append(">").toString());
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                NodeSeq nodeSeq2 = nodeSeq;
                return nodeSeq2;
            }, Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)NodeSeq$.MODULE$.Empty(), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> (NodeSeq)x$1.$plus$plus((GenTraversableOnce)x$2, NodeSeq$.MODULE$.canBuildFrom()));
        } else {
            elem = package$DataRecordOps$.MODULE$.nested$extension(package$.MODULE$.DataRecordOps((DataRecord<Object>)DataRecord$.MODULE$.apply((Object)j.noSpaces(), (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat())));
        }
        return elem;
    }

    private <G extends Geometry> NodeSeq propertiesXML(Feature<G, Json> f) {
        return this.jsonXML((Json)f.data());
    }

    public <G extends Geometry> FeatureCollectionType apply(Seq<Feature<G, Json>> features, CRS crs, CellSize cellSize) {
        StandardObjectPropertiesSequence x$1 = new StandardObjectPropertiesSequence(StandardObjectPropertiesSequence$.MODULE$.apply$default$1(), StandardObjectPropertiesSequence$.MODULE$.apply$default$2(), StandardObjectPropertiesSequence$.MODULE$.apply$default$3());
        Seq x$2 = (Seq)features.map((Function1 & Serializable & scala.Serializable)feature -> {
            List list;
            Geometry geometry = feature.geom();
            if (geometry instanceof Polygon) {
                Polygon polygon2;
                Polygon polygon3 = polygon2 = (Polygon)geometry;
                list = Nil$.MODULE$.$colon$colon((Object)polygon3);
            } else if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geotrellis.vector.package$.MODULE$.withExtraMultiPolygonMethods(multiPolygon).polygons())).toList();
            } else if (geometry instanceof Point) {
                Point point = (Point)geometry;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)point.getX())), (Object)BoxesRunTime.boxToDouble((double)point.getY()));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double x = tuple2._1$mcD$sp();
                double y = tuple2._2$mcD$sp();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
                Tuple2.mcDD.sp sp3 = sp2;
                double x2 = sp3._1$mcD$sp();
                double y2 = sp3._2$mcD$sp();
                CellSize cellSize = cellSize;
                if (cellSize == null) {
                    throw new MatchError((Object)cellSize);
                }
                double w = cellSize.width();
                double h = cellSize.height();
                Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(w, h);
                Tuple2.mcDD.sp sp5 = sp4;
                double w2 = sp5._1$mcD$sp();
                double h2 = sp5._2$mcD$sp();
                Polygon polygon4 = Polygon$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(x2 - w2, y2 - h2), new Tuple2.mcDD.sp(x2 + w2, y2 - h2), new Tuple2.mcDD.sp(x2 + w2, y2 + h2), new Tuple2.mcDD.sp(x2 - w2, y2 + h2), new Tuple2.mcDD.sp(x2 - w2, y2 - h2)}), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
                list = Nil$.MODULE$.$colon$colon((Object)polygon4);
            } else {
                list = Nil$.MODULE$;
            }
            List polygons = list;
            return new FeaturePropertyType((Option)new Some((Object)new FeaturePropertyTypeSequence1(DataRecord$.MODULE$.apply((Option)None$.MODULE$, OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)"PixelPerBandFeature")), package$DataRecordOps$.MODULE$.nested$extension(package$.MODULE$.DataRecordOps((DataRecord<Object>)DataRecord$.MODULE$.apply((Option)None$.MODULE$, OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)"Geometry")), (Object)new GeometryPropertyType(OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)new GeometryPropertyTypeSequence1(GmlDataRecord$.MODULE$.apply(new MultiPolygonType(new StandardObjectPropertiesSequence(StandardObjectPropertiesSequence$.MODULE$.apply$default$1(), StandardObjectPropertiesSequence$.MODULE$.apply$default$2(), StandardObjectPropertiesSequence$.MODULE$.apply$default$3()), (Seq)polygons.map((Function1 & Serializable & scala.Serializable)polygon -> {
                DataRecord<CoordinatesType> dataRecord = GmlDataRecord$.MODULE$.apply(new CoordinatesType(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])polygon.getExteriorRing().getCoordinates())).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(1).append(c.getX()).append(",").append(c.getY()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList().mkString(" "), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@decimal"), (Object)DataRecord$.MODULE$.apply((Object)".", (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@cs"), (Object)DataRecord$.MODULE$.apply((Object)",", (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@ts"), (Object)DataRecord$.MODULE$.apply((Object)" ", (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat()))}))), opengis.package$.MODULE$.Opengisgml_CoordinatesTypeFormat(), ClassTag$.MODULE$.apply(CoordinatesType.class));
                return new PolygonPropertyType(OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)new PolygonPropertyTypeSequence1(new PolygonType(new StandardObjectPropertiesSequence(StandardObjectPropertiesSequence$.MODULE$.apply$default$1(), StandardObjectPropertiesSequence$.MODULE$.apply$default$2(), StandardObjectPropertiesSequence$.MODULE$.apply$default$3()), OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)DataRecord$.MODULE$.apply(OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)"gml")), OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)"gml:exterior")), (Object)package$ElemOps$.MODULE$.nestedXML$extension(package$.MODULE$.ElemOps(package$DataRecordOps$.MODULE$.nested$extension(package$.MODULE$.DataRecordOps(GmlDataRecord$.MODULE$.apply(new LinearRingType(new StandardObjectPropertiesSequence(StandardObjectPropertiesSequence$.MODULE$.apply$default$1(), StandardObjectPropertiesSequence$.MODULE$.apply$default$2(), StandardObjectPropertiesSequence$.MODULE$.apply$default$3()), (Seq)Nil$.MODULE$.$colon$colon(dataRecord), LinearRingType$.MODULE$.apply$default$3()), opengis.package$.MODULE$.Opengisgml_LinearRingTypeFormat(), ClassTag$.MODULE$.apply(LinearRingType.class))))), "gml:exterior"), (CanWriteXML)opengis.package$.MODULE$.__ElemXMLFormat()))), PolygonType$.MODULE$.apply$default$3(), PolygonType$.MODULE$.apply$default$4())))), PolygonPropertyType$.MODULE$.apply$default$2());
            }, List$.MODULE$.canBuildFrom()), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@srsName"), (Object)DataRecord$.MODULE$.apply(URN$.MODULE$.fromCrs(crs).map((Function1 & Serializable & scala.Serializable)x$8 -> new URI((String)x$8)).get(), (CanWriteXML)opengis.package$.MODULE$.__URIXMLFormat()))}))), opengis.package$.MODULE$.Opengisgml_MultiPolygonTypeFormat(), ClassTag$.MODULE$.apply(MultiPolygonType.class))))), GeometryPropertyType$.MODULE$.apply$default$2()), (CanWriteXML)opengis.package$.MODULE$.Opengisgml_GeometryPropertyTypeFormat()))).$plus$plus((GenTraversableOnce)MODULE$.propertiesXML((Feature)feature), NodeSeq$.MODULE$.canBuildFrom()), (CanWriteXML)opengis.package$.MODULE$.__NodeSeqXMLFormat()))), FeaturePropertyType$.MODULE$.apply$default$2());
        }, Seq$.MODULE$.canBuildFrom());
        Option x$3 = FeatureCollectionType$.MODULE$.apply$default$2();
        Option x$4 = FeatureCollectionType$.MODULE$.apply$default$3();
        Option x$5 = FeatureCollectionType$.MODULE$.apply$default$5();
        Map x$6 = FeatureCollectionType$.MODULE$.apply$default$6();
        return new FeatureCollectionType(x$1, x$3, x$4, x$2, x$5, x$6);
    }

    private WfsFeatureCollection$() {
        MODULE$ = this;
    }
}

