/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.wms;

import cats.Apply;
import cats.Functor;
import cats.Monad;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import geotrellis.proj4.CRS;
import geotrellis.proj4.LatLng$;
import geotrellis.raster.CellSize;
import geotrellis.raster.GridExtent;
import geotrellis.raster.RasterSource;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.ReprojectRasterExtent$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.server.ogc.MapAlgebraSource;
import geotrellis.server.ogc.OgcSource;
import geotrellis.server.ogc.OgcTime;
import geotrellis.server.ogc.OgcTimeEmpty$;
import geotrellis.server.ogc.OgcTimeInterval;
import geotrellis.server.ogc.OgcTimePositions;
import geotrellis.server.ogc.RasterOgcSource;
import geotrellis.server.ogc.style.OgcStyle;
import geotrellis.server.ogc.wms.CapabilitiesView;
import geotrellis.server.ogc.wms.WmsModel;
import geotrellis.server.ogc.wms.WmsParentLayerMeta;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.net.URL;
import opengis.package$;
import opengis.wms.BoundingBox;
import opengis.wms.Dimension;
import opengis.wms.EX_GeographicBoundingBox;
import opengis.wms.Layer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scalaxb.CanWriteXML;
import scalaxb.DataRecord;
import scalaxb.DataRecord$;
import spire.math.Integral;
import spire.math.Integral$;

public final class CapabilitiesView$
implements scala.Serializable {
    public static CapabilitiesView$ MODULE$;

    static {
        new CapabilitiesView$();
    }

    public <F> List<DataRecord<Elem>> $lessinit$greater$default$3() {
        return Nil$.MODULE$;
    }

    public <T> DataRecord<T> toRecord(T t, CanWriteXML<T> evidence$4) {
        return DataRecord$.MODULE$.apply(t, evidence$4);
    }

    public BoundingBox boundingBox(CRS crs, Extent extent, CellSize cellSize) {
        return crs.isGeographic() ? new BoundingBox((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@CRS"), this.toRecord((Object)new StringBuilder(5).append("EPSG:").append(crs.epsgCode().get()).toString(), (CanWriteXML)package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@minx"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)extent.ymin()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@miny"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)extent.xmin()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@maxx"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)extent.ymax()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@maxy"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)extent.xmax()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@resx"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)cellSize.width()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@resy"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)cellSize.height()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat()))}))) : new BoundingBox((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@CRS"), this.toRecord((Object)new StringBuilder(5).append("EPSG:").append(crs.epsgCode().get()).toString(), (CanWriteXML)package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@minx"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)extent.xmin()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@miny"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)extent.ymin()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@maxx"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)extent.xmax()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@maxy"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)extent.ymax()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@resx"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)cellSize.width()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@resy"), this.toRecord((Object)BoxesRunTime.boxToDouble((double)cellSize.height()), (CanWriteXML)package$.MODULE$.__DoubleXMLFormat()))})));
    }

    public CapabilitiesView.StyleMethods StyleMethods(OgcStyle style) {
        return new CapabilitiesView.StyleMethods(style);
    }

    public CapabilitiesView.RasterSourceMethods RasterSourceMethods(OgcSource source) {
        return new CapabilitiesView.RasterSourceMethods(source);
    }

    public <F> F modelAsLayer(WmsParentLayerMeta parentLayerMeta, WmsModel<F> model, Monad<F> evidence$5) {
        Object bboxAndLayers = package.functor$.MODULE$.toFunctorOps(model.sources().store(), evidence$5).map((Function1 & Serializable & scala.Serializable)sources -> {
            List bboxes = (List)sources.map((Function1 & Serializable & scala.Serializable)source -> {
                GridExtent gridExtent;
                OgcSource ogcSource = source;
                if (ogcSource instanceof MapAlgebraSource) {
                    MapAlgebraSource mapAlgebraSource = (MapAlgebraSource)ogcSource;
                    gridExtent = (GridExtent)((TraversableOnce)mapAlgebraSource.sourcesList().map((Function1 & Serializable & scala.Serializable)rs -> {
                        Reproject.Options qual$1 = Reproject.Options$.MODULE$.DEFAULT();
                        ResampleMethod x$1 = mapAlgebraSource.resampleMethod();
                        double x$2 = qual$1.copy$default$2();
                        Option x$3 = qual$1.copy$default$3();
                        Option x$4 = qual$1.copy$default$4();
                        Option x$5 = qual$1.copy$default$5();
                        return ReprojectRasterExtent$.MODULE$.apply(rs.gridExtent(), rs.crs(), (CRS)LatLng$.MODULE$, qual$1.copy(x$1, x$2, x$3, x$4, x$5), (Integral)Integral$.MODULE$.LongIsIntegral());
                    }, List$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(re1, re2) -> {
                        Extent e = re1.extent().combine(re2.extent());
                        CellSize cs = re1.cellSize().resolution() < re2.cellSize().resolution() ? re1.cellSize() : re2.cellSize();
                        return new GridExtent.mcJ.sp(e, cs, (Integral)Integral$.MODULE$.LongIsIntegral());
                    });
                } else if (ogcSource instanceof RasterOgcSource) {
                    RasterOgcSource rasterOgcSource = (RasterOgcSource)ogcSource;
                    RasterSource rs2 = rasterOgcSource.source();
                    Reproject.Options qual$2 = Reproject.Options$.MODULE$.DEFAULT();
                    ResampleMethod x$6 = rasterOgcSource.resampleMethod();
                    double x$7 = qual$2.copy$default$2();
                    Option x$8 = qual$2.copy$default$3();
                    Option x$9 = qual$2.copy$default$4();
                    Option x$10 = qual$2.copy$default$5();
                    gridExtent = ReprojectRasterExtent$.MODULE$.apply(rs2.gridExtent(), rs2.crs(), (CRS)LatLng$.MODULE$, qual$2.copy(x$6, x$7, x$8, x$9, x$10), (Integral)Integral$.MODULE$.LongIsIntegral());
                } else {
                    throw new MatchError((Object)ogcSource);
                }
                GridExtent llre = gridExtent;
                return llre.extent();
            }, List$.MODULE$.canBuildFrom());
            Extent bbox = (Extent)((TraversableOnce)bboxes.tail()).fold(bboxes.head(), (Function2 & Serializable & scala.Serializable)(x$14, x$15) -> x$14.combine(x$15));
            Option ogcBbox = OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)new EX_GeographicBoundingBox(bbox.xmin(), bbox.xmax(), bbox.ymin(), bbox.ymax())));
            return new Tuple2((Object)ogcBbox, sources.map((Function1 & Serializable & scala.Serializable)x$16 -> MODULE$.RasterSourceMethods((OgcSource)x$16).toLayer(parentLayerMeta.supportedProjections()), List$.MODULE$.canBuildFrom()));
        });
        return (F)package.apply$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(bboxAndLayers, model.time())).mapN((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Nil$ nil$;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            OgcTime time = (OgcTime)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            Option bbox = (Option)tuple22._1();
            List layers = (List)tuple22._2();
            Option<String> option = parentLayerMeta.name();
            String string = parentLayerMeta.title();
            Option<String> option2 = parentLayerMeta.description();
            Seq seq = (Seq)((List)parentLayerMeta.supportedProjections().distinct()).map((Function1 & Serializable & scala.Serializable)crs -> (String)crs.epsgCode().map((Function1 & Serializable & scala.Serializable)code -> CapabilitiesView$.$anonfun$modelAsLayer$9(BoxesRunTime.unboxToInt((Object)code))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception(new StringBuilder(35).append("Unable to construct EPSG code from ").append(crs).toString());
            }), List$.MODULE$.canBuildFrom());
            OgcTime ogcTime = time;
            if (ogcTime instanceof OgcTimePositions) {
                OgcTimePositions ogcTimePositions = (OgcTimePositions)ogcTime;
                Dimension dimension = new Dimension(ogcTimePositions.toString(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@name"), (Object)DataRecord$.MODULE$.apply((Object)"time", (CanWriteXML)package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@units"), (Object)DataRecord$.MODULE$.apply((Object)"ISO8601", (CanWriteXML)package$.MODULE$.__StringXMLFormat()))})));
                nil$ = Nil$.MODULE$.$colon$colon((Object)dimension);
                return new Layer(option, string, option2, (Option)None$.MODULE$, seq, bbox, (Seq)Nil$.MODULE$, (Seq)nil$, (Option)None$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)layers, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@queryable"), (Object)DataRecord$.MODULE$.apply((Object)"1", (CanWriteXML)package$.MODULE$.__StringXMLFormat()))})));
            } else if (ogcTime instanceof OgcTimeInterval) {
                OgcTimeInterval ogcTimeInterval = (OgcTimeInterval)ogcTime;
                Dimension dimension = new Dimension(ogcTimeInterval.toString(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@name"), (Object)DataRecord$.MODULE$.apply((Object)"time", (CanWriteXML)package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@units"), (Object)DataRecord$.MODULE$.apply((Object)"ISO8601", (CanWriteXML)package$.MODULE$.__StringXMLFormat()))})));
                nil$ = Nil$.MODULE$.$colon$colon((Object)dimension);
                return new Layer(option, string, option2, (Option)None$.MODULE$, seq, bbox, (Seq)Nil$.MODULE$, (Seq)nil$, (Option)None$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)layers, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@queryable"), (Object)DataRecord$.MODULE$.apply((Object)"1", (CanWriteXML)package$.MODULE$.__StringXMLFormat()))})));
            } else {
                if (!OgcTimeEmpty$.MODULE$.equals(ogcTime)) throw new MatchError((Object)ogcTime);
                nil$ = Nil$.MODULE$;
            }
            return new Layer(option, string, option2, (Option)None$.MODULE$, seq, bbox, (Seq)Nil$.MODULE$, (Seq)nil$, (Option)None$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)layers, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@queryable"), (Object)DataRecord$.MODULE$.apply((Object)"1", (CanWriteXML)package$.MODULE$.__StringXMLFormat()))})));
        }, evidence$5, evidence$5);
    }

    public <F> CapabilitiesView<F> apply(WmsModel<F> model, URL serviceUrl, List<DataRecord<Elem>> extendedCapabilities, Functor<F> evidence$1, Apply<F> evidence$2, Monad<F> evidence$3) {
        return new CapabilitiesView<F>(model, serviceUrl, extendedCapabilities, evidence$1, evidence$2, evidence$3);
    }

    public <F> List<DataRecord<Elem>> apply$default$3() {
        return Nil$.MODULE$;
    }

    public <F> Option<Tuple3<WmsModel<F>, URL, List<DataRecord<Elem>>>> unapply(CapabilitiesView<F> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3(x$0.model(), (Object)x$0.serviceUrl(), x$0.extendedCapabilities()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ String $anonfun$modelAsLayer$9(int code) {
        return new StringBuilder(5).append("EPSG:").append(code).toString();
    }

    private CapabilitiesView$() {
        MODULE$ = this;
    }
}

