/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.wms;

import cats.Apply;
import cats.Functor;
import cats.Monad;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import geotrellis.proj4.CRS;
import geotrellis.proj4.LatLng$;
import geotrellis.raster.CellSize;
import geotrellis.raster.GridExtent;
import geotrellis.raster.RasterSource;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.ReprojectRasterExtent$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.server.ogc.InfoFormat$;
import geotrellis.server.ogc.InfoFormat$XML$;
import geotrellis.server.ogc.MapAlgebraSource;
import geotrellis.server.ogc.OgcSource;
import geotrellis.server.ogc.OgcTime;
import geotrellis.server.ogc.OgcTimeDefault$;
import geotrellis.server.ogc.OgcTimeDefault$OgcTimeDefaultOps$;
import geotrellis.server.ogc.OgcTimeEmpty$;
import geotrellis.server.ogc.OgcTimeInterval;
import geotrellis.server.ogc.OgcTimePositions;
import geotrellis.server.ogc.OutputFormat$;
import geotrellis.server.ogc.RasterOgcSource;
import geotrellis.server.ogc.style.LegendModel;
import geotrellis.server.ogc.style.OgcStyle;
import geotrellis.server.ogc.wms.CapabilitiesView$;
import geotrellis.server.ogc.wms.WmsModel;
import geotrellis.server.ogc.wms.WmsParentLayerMeta;
import geotrellis.server.ogc.wms.package$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.net.URL;
import java.time.ZonedDateTime;
import opengis.wms.BoundingBox;
import opengis.wms.Capability;
import opengis.wms.DCPType;
import opengis.wms.Dimension;
import opengis.wms.EX_GeographicBoundingBox;
import opengis.wms.Exception;
import opengis.wms.Get;
import opengis.wms.HTTP;
import opengis.wms.HTTP$;
import opengis.wms.Layer;
import opengis.wms.OnlineResource;
import opengis.wms.OperationType;
import opengis.wms.Request;
import opengis.wms.Request$;
import opengis.wms.Style;
import opengis.wms.Style$;
import opengis.wms.WMS_Capabilities;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scalaxb.CanWriteXML;
import scalaxb.DataRecord;
import scalaxb.DataRecord$;
import spire.math.Integral;
import spire.math.Integral$;
import xlink.Simple$;

@ScalaSignature(bytes="\u0006\u0001\reb\u0001B\u00181\u0001fB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t7\u0002\u0011\t\u0012)A\u0005\u0013\"AA\f\u0001BK\u0002\u0013\u0005Q\f\u0003\u0005g\u0001\tE\t\u0015!\u0003_\u0011!9\u0007A!f\u0001\n\u0003A\u0007\"CA\u0002\u0001\tE\t\u0015!\u0003j\u0011)\t)\u0001\u0001B\u0002B\u0003-\u0011q\u0001\u0005\u000b\u0003'\u0001!1!Q\u0001\f\u0005U\u0001BCA\u000e\u0001\t\r\t\u0015a\u0003\u0002\u001e!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\n\u0003{\u0001\u0011\u0011!C\u0001\u0003\u007fA\u0011\"a\u0019\u0001#\u0003%\t!!\u001a\t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005\u0015\u0005\"CAI\u0001E\u0005I\u0011AAJ\u0011%\ty\nAA\u0001\n\u0003\n\t\u000bC\u0005\u00020\u0002\t\t\u0011\"\u0001\u00022\"I\u0011\u0011\u0018\u0001\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u0003\u0004\u0011\u0011!C!\u0003\u0007D\u0011\"!5\u0001\u0003\u0003%\t!a5\t\u0013\u0005u\u0007!!A\u0005B\u0005}\u0007\"CAq\u0001\u0005\u0005I\u0011IAr\u0011%\t)\u000fAA\u0001\n\u0003\n9oB\u0004\u0002lBB\t!!<\u0007\r=\u0002\u0004\u0012AAx\u0011\u001d\t\u0019#\u0007C\u0001\u0003cDq!a=\u001a\t\u0007\t)\u0010C\u0004\u0003\u0012e!\tAa\u0005\u0007\r\tM\u0013$\u0001B+\u0011)\u00119&\bBC\u0002\u0013\u0005!\u0011\f\u0005\u000b\u0005Kj\"\u0011!Q\u0001\n\tm\u0003bBA\u0012;\u0011\u0005!q\r\u0005\b\u0005_jB\u0011\u0001B9\u0011%\u0011I(GA\u0001\n\u0007\u0011YH\u0002\u0004\u0003\u0000e\t!\u0011\u0011\u0005\u000b\u0005\u0007\u001b#Q1A\u0005\u0002\t\u0015\u0005B\u0003BHG\t\u0005\t\u0015!\u0003\u0003\b\"9\u00111E\u0012\u0005\u0002\tE\u0005b\u0002BLG\u0011\u0005!\u0011\u0014\u0005\n\u0005OK\u0012\u0011!C\u0002\u0005SCqA!,\u001a\t\u0003\u0011y\u000bC\u0005\u0003Tf\t\t\u0011\"!\u0003V\"I!\u0011`\r\u0012\u0002\u0013\u0005!1 \u0005\n\u0007\u0007I\u0012\u0011!CA\u0007\u000bA\u0011b!\n\u001a#\u0003%\taa\n\t\u0013\r=\u0012$!A\u0005\n\rE\"\u0001E\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001ch+[3x\u0015\t\t$'A\u0002x[NT!a\r\u001b\u0002\u0007=<7M\u0003\u00026m\u000511/\u001a:wKJT\u0011aN\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\u000b\u0003u=\u001bB\u0001A\u001eB\tB\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1\u0011I\\=SK\u001a\u0004\"\u0001\u0010\"\n\u0005\rk$a\u0002)s_\u0012,8\r\u001e\t\u0003y\u0015K!AR\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b5|G-\u001a7\u0016\u0003%\u00032AS&N\u001b\u0005\u0001\u0014B\u0001'1\u0005!9Vn]'pI\u0016d\u0007C\u0001(P\u0019\u0001!Q\u0001\u0015\u0001C\u0002E\u0013\u0011AR\u000b\u0003%f\u000b\"a\u0015,\u0011\u0005q\"\u0016BA+>\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001P,\n\u0005ak$aA!os\u0012)!l\u0014b\u0001%\n\tq,\u0001\u0004n_\u0012,G\u000eI\u0001\u000bg\u0016\u0014h/[2f+JdW#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017a\u00018fi*\t1-\u0001\u0003kCZ\f\u0017BA3a\u0005\r)&\u000bT\u0001\fg\u0016\u0014h/[2f+Jd\u0007%\u0001\u000bfqR,g\u000eZ3e\u0007\u0006\u0004\u0018MY5mSRLWm]\u000b\u0002SB\u0019!N];\u000f\u0005-\u0004hB\u00017p\u001b\u0005i'B\u000189\u0003\u0019a$o\\8u}%\ta(\u0003\u0002r{\u00059\u0001/Y2lC\u001e,\u0017BA:u\u0005\u0011a\u0015n\u001d;\u000b\u0005El\u0004c\u0001<zw6\tqOC\u0001y\u0003\u001d\u00198-\u00197bq\nL!A_<\u0003\u0015\u0011\u000bG/\u0019*fG>\u0014H\r\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f{\u0005\u0019\u00010\u001c7\n\u0007\u0005\u0005QP\u0001\u0003FY\u0016l\u0017!F3yi\u0016tG-\u001a3DCB\f'-\u001b7ji&,7\u000fI\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004#BA\u0005\u0003\u001fiUBAA\u0006\u0015\t\ti!\u0001\u0003dCR\u001c\u0018\u0002BA\t\u0003\u0017\u0011qAR;oGR|'/\u0001\u0006fm&$WM\\2fII\u0002R!!\u0003\u0002\u00185KA!!\u0007\u0002\f\t)\u0011\t\u001d9ms\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u000b\u0005%\u0011qD'\n\t\u0005\u0005\u00121\u0002\u0002\u0006\u001b>t\u0017\rZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0005\u001d\u0012\u0011GA\u001a\u0003k!\u0002\"!\u000b\u0002,\u00055\u0012q\u0006\t\u0004\u0015\u0002i\u0005bBA\u0003\u0015\u0001\u000f\u0011q\u0001\u0005\b\u0003'Q\u00019AA\u000b\u0011\u001d\tYB\u0003a\u0002\u0003;AQa\u0012\u0006A\u0002%CQ\u0001\u0018\u0006A\u0002yCqa\u001a\u0006\u0011\u0002\u0003\u0007\u0011.A\u0003u_bkE*\u0006\u0002\u0002<A\u0019ajT>\u0002\t\r|\u0007/_\u000b\u0005\u0003\u0003\nI\u0005\u0006\u0005\u0002D\u0005m\u0013qLA1)!\t)%a\u0014\u0002T\u0005]\u0003\u0003\u0002&\u0001\u0003\u000f\u00022ATA%\t\u0019\u0001FB1\u0001\u0002LU\u0019!+!\u0014\u0005\ri\u000bIE1\u0001S\u0011\u001d\t)\u0001\u0004a\u0002\u0003#\u0002b!!\u0003\u0002\u0010\u0005\u001d\u0003bBA\n\u0019\u0001\u000f\u0011Q\u000b\t\u0007\u0003\u0013\t9\"a\u0012\t\u000f\u0005mA\u0002q\u0001\u0002ZA1\u0011\u0011BA\u0010\u0003\u000fB\u0001b\u0012\u0007\u0011\u0002\u0003\u0007\u0011Q\f\t\u0005\u0015.\u000b9\u0005C\u0004]\u0019A\u0005\t\u0019\u00010\t\u000f\u001dd\u0001\u0013!a\u0001S\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT\u0003BA4\u0003{*\"!!\u001b+\u0007%\u000bYg\u000b\u0002\u0002nA!\u0011qNA=\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014!C;oG\",7m[3e\u0015\r\t9(P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA>\u0003c\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019\u0001VB1\u0001\u0002\u0000U\u0019!+!!\u0005\ri\u000biH1\u0001S\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*B!a\"\u0002\fV\u0011\u0011\u0011\u0012\u0016\u0004=\u0006-DA\u0002)\u000f\u0005\u0004\ti)F\u0002S\u0003\u001f#aAWAF\u0005\u0004\u0011\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0005\u0003+\u000bI*\u0006\u0002\u0002\u0018*\u001a\u0011.a\u001b\u0005\rA{!\u0019AAN+\r\u0011\u0016Q\u0014\u0003\u00075\u0006e%\u0019\u0001*\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u000b\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\tIKY\u0001\u0005Y\u0006tw-\u0003\u0003\u0002.\u0006\u001d&AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00024B\u0019A(!.\n\u0007\u0005]VHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002W\u0003{C\u0011\"a0\u0013\u0003\u0003\u0005\r!a-\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\rE\u0003\u0002H\u00065g+\u0004\u0002\u0002J*\u0019\u00111Z\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002P\u0006%'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!6\u0002\\B\u0019A(a6\n\u0007\u0005eWHA\u0004C_>dW-\u00198\t\u0011\u0005}F#!AA\u0002Y\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003g\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003G\u000ba!Z9vC2\u001cH\u0003BAk\u0003SD\u0001\"a0\u0018\u0003\u0003\u0005\rAV\u0001\u0011\u0007\u0006\u0004\u0018MY5mSRLWm\u001d,jK^\u0004\"AS\r\u0014\u0007eYD\t\u0006\u0002\u0002n\u0006AAo\u001c*fG>\u0014H-\u0006\u0003\u0002x\u0006}H\u0003BA}\u0005\u001b!B!a?\u0003\u0004A!a/_A\u007f!\rq\u0015q \u0003\u0007\u0005\u0003Y\"\u0019\u0001*\u0003\u0003QC\u0011B!\u0002\u001c\u0003\u0003\u0005\u001dAa\u0002\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0003w\u0005\u0013\ti0C\u0002\u0003\f]\u00141bQ1o/JLG/\u001a-N\u0019\"9!qB\u000eA\u0002\u0005u\u0018!\u0001;\u0002\u0017\t|WO\u001c3j]\u001e\u0014u\u000e\u001f\u000b\t\u0005+\u0011\u0019Ca\r\u0003DA!!q\u0003B\u0010\u001b\t\u0011IBC\u00022\u00057Q!A!\b\u0002\u000f=\u0004XM\\4jg&!!\u0011\u0005B\r\u0005-\u0011u.\u001e8eS:<'i\u001c=\t\u000f\t\u0015B\u00041\u0001\u0003(\u0005\u00191M]:\u0011\t\t%\"qF\u0007\u0003\u0005WQ1A!\f7\u0003\u0015\u0001(o\u001c65\u0013\u0011\u0011\tDa\u000b\u0003\u0007\r\u00136\u000bC\u0004\u00036q\u0001\rAa\u000e\u0002\r\u0015DH/\u001a8u!\u0011\u0011IDa\u0010\u000e\u0005\tm\"b\u0001B\u001fm\u00051a/Z2u_JLAA!\u0011\u0003<\t1Q\t\u001f;f]RDqA!\u0012\u001d\u0001\u0004\u00119%\u0001\u0005dK2d7+\u001b>f!\u0011\u0011IEa\u0014\u000e\u0005\t-#b\u0001B'm\u00051!/Y:uKJLAA!\u0015\u0003L\tA1)\u001a7m'&TXM\u0001\u0007TifdW-T3uQ>$7o\u0005\u0002\u001ew\u0005)1\u000f^=mKV\u0011!1\f\t\u0005\u0005;\u0012\t'\u0004\u0002\u0003`)\u0019!q\u000b\u001a\n\t\t\r$q\f\u0002\t\u001f\u001e\u001c7\u000b^=mK\u000611\u000f^=mK\u0002\"BA!\u001b\u0003nA\u0019!1N\u000f\u000e\u0003eAqAa\u0016!\u0001\u0004\u0011Y&\u0001\u0004sK:$WM]\u000b\u0003\u0005g\u0002BAa\u0006\u0003v%!!q\u000fB\r\u0005\u0015\u0019F/\u001f7f\u00031\u0019F/\u001f7f\u001b\u0016$\bn\u001c3t)\u0011\u0011IG! \t\u000f\t]#\u00051\u0001\u0003\\\t\u0019\"+Y:uKJ\u001cv.\u001e:dK6+G\u000f[8egN\u00111eO\u0001\u0007g>,(oY3\u0016\u0005\t\u001d\u0005\u0003\u0002BE\u0005\u0017k\u0011AM\u0005\u0004\u0005\u001b\u0013$!C(hGN{WO]2f\u0003\u001d\u0019x.\u001e:dK\u0002\"BAa%\u0003\u0016B\u0019!1N\u0012\t\u000f\t\re\u00051\u0001\u0003\b\u00069Ao\u001c'bs\u0016\u0014H\u0003\u0002BN\u0005C\u0003BAa\u0006\u0003\u001e&!!q\u0014B\r\u0005\u0015a\u0015-_3s\u0011\u001d\u0011\u0019k\na\u0001\u0005K\u000b\u0011\u0003]1sK:$\bK]8kK\u000e$\u0018n\u001c8t!\u0011Q'Oa\n\u0002'I\u000b7\u000f^3s'>,(oY3NKRDw\u000eZ:\u0015\t\tM%1\u0016\u0005\b\u0005\u0007C\u0003\u0019\u0001BD\u00031iw\u000eZ3m\u0003Nd\u0015-_3s+\u0011\u0011\tLa.\u0015\r\tM&Q\u0019Bh)\u0011\u0011)L!0\u0011\u000b9\u00139La'\u0005\rAK#\u0019\u0001B]+\r\u0011&1\u0018\u0003\u00075\n]&\u0019\u0001*\t\u0013\t}\u0016&!AA\u0004\t\u0005\u0017AC3wS\u0012,gnY3%kA1\u0011\u0011BA\u0010\u0005\u0007\u00042A\u0014B\\\u0011\u001d\u00119-\u000ba\u0001\u0005\u0013\fq\u0002]1sK:$H*Y=fe6+G/\u0019\t\u0004\u0015\n-\u0017b\u0001Bga\t\u0011r+\\:QCJ,g\u000e\u001e'bs\u0016\u0014X*\u001a;b\u0011\u00199\u0015\u00061\u0001\u0003RB!!j\u0013Bb\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\u00119Na8\u0015\u0011\te'\u0011\u001fB{\u0005o$\u0002Ba7\u0003f\n%(Q\u001e\t\u0005\u0015\u0002\u0011i\u000eE\u0002O\u0005?$a\u0001\u0015\u0016C\u0002\t\u0005Xc\u0001*\u0003d\u00121!La8C\u0002ICq!!\u0002+\u0001\b\u00119\u000f\u0005\u0004\u0002\n\u0005=!Q\u001c\u0005\b\u0003'Q\u00039\u0001Bv!\u0019\tI!a\u0006\u0003^\"9\u00111\u0004\u0016A\u0004\t=\bCBA\u0005\u0003?\u0011i\u000e\u0003\u0004HU\u0001\u0007!1\u001f\t\u0005\u0015.\u0013i\u000eC\u0003]U\u0001\u0007a\fC\u0004hUA\u0005\t\u0019A5\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*B!!&\u0003~\u00121\u0001k\u000bb\u0001\u0005\u007f,2AUB\u0001\t\u0019Q&Q b\u0001%\u00069QO\\1qa2LX\u0003BB\u0004\u00073!Ba!\u0003\u0004 A)Aha\u0003\u0004\u0010%\u00191QB\u001f\u0003\r=\u0003H/[8o!\u001da4\u0011CB\u000b=&L1aa\u0005>\u0005\u0019!V\u000f\u001d7fgA!!jSB\f!\rq5\u0011\u0004\u0003\u0007!2\u0012\raa\u0007\u0016\u0007I\u001bi\u0002\u0002\u0004[\u00073\u0011\rA\u0015\u0005\n\u0007Ca\u0013\u0011!a\u0001\u0007G\t1\u0001\u001f\u00131!\u0011Q\u0005aa\u0006\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\t)j!\u000b\u0005\rAk#\u0019AB\u0016+\r\u00116Q\u0006\u0003\u00075\u000e%\"\u0019\u0001*\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007g\u0001B!!*\u00046%!1qGAT\u0005\u0019y%M[3di\u0002")
public class CapabilitiesView<F>
implements Product,
scala.Serializable {
    private final WmsModel<F> model;
    private final URL serviceUrl;
    private final List<DataRecord<Elem>> extendedCapabilities;
    private final Monad<F> evidence$3;

    public static <F> List<DataRecord<Elem>> $lessinit$greater$default$3() {
        return CapabilitiesView$.MODULE$.$lessinit$greater$default$3();
    }

    public static <F> Option<Tuple3<WmsModel<F>, URL, List<DataRecord<Elem>>>> unapply(CapabilitiesView<F> capabilitiesView) {
        return CapabilitiesView$.MODULE$.unapply(capabilitiesView);
    }

    public static <F> List<DataRecord<Elem>> apply$default$3() {
        return CapabilitiesView$.MODULE$.apply$default$3();
    }

    public static <F> CapabilitiesView<F> apply(WmsModel<F> wmsModel, URL uRL, List<DataRecord<Elem>> list, Functor<F> functor, Apply<F> apply, Monad<F> monad) {
        return CapabilitiesView$.MODULE$.apply(wmsModel, uRL, list, functor, apply, monad);
    }

    public static <F> F modelAsLayer(WmsParentLayerMeta wmsParentLayerMeta, WmsModel<F> wmsModel, Monad<F> monad) {
        return CapabilitiesView$.MODULE$.modelAsLayer(wmsParentLayerMeta, wmsModel, monad);
    }

    public static RasterSourceMethods RasterSourceMethods(OgcSource ogcSource) {
        return CapabilitiesView$.MODULE$.RasterSourceMethods(ogcSource);
    }

    public static StyleMethods StyleMethods(OgcStyle ogcStyle) {
        return CapabilitiesView$.MODULE$.StyleMethods(ogcStyle);
    }

    public static BoundingBox boundingBox(CRS cRS, Extent extent, CellSize cellSize) {
        return CapabilitiesView$.MODULE$.boundingBox(cRS, extent, cellSize);
    }

    public static <T> DataRecord<T> toRecord(T t, CanWriteXML<T> canWriteXML) {
        return CapabilitiesView$.MODULE$.toRecord(t, canWriteXML);
    }

    public WmsModel<F> model() {
        return this.model;
    }

    public URL serviceUrl() {
        return this.serviceUrl;
    }

    public List<DataRecord<Elem>> extendedCapabilities() {
        return this.extendedCapabilities;
    }

    public F toXML() {
        String string = InfoFormat$XML$.MODULE$.name();
        DCPType dCPType = new DCPType(new HTTP(new Get(new OnlineResource((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@{http://www.w3.org/1999/xlink}href"), (Object)DataRecord$.MODULE$.apply((Object)this.serviceUrl().toURI(), (CanWriteXML)opengis.package$.MODULE$.__URIXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@{http://www.w3.org/1999/xlink}type"), (Object)DataRecord$.MODULE$.apply((Object)Simple$.MODULE$, (CanWriteXML)opengis.package$.MODULE$.Xlink_TypeTypeFormat()))})))), HTTP$.MODULE$.apply$default$2()));
        OperationType getCapabilities = new OperationType((Seq)Nil$.MODULE$.$colon$colon((Object)string), (Seq)Nil$.MODULE$.$colon$colon((Object)dCPType));
        DCPType dCPType2 = new DCPType(new HTTP(new Get(new OnlineResource((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@{http://www.w3.org/1999/xlink}href"), (Object)DataRecord$.MODULE$.apply((Object)this.serviceUrl().toURI(), (CanWriteXML)opengis.package$.MODULE$.__URIXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@{http://www.w3.org/1999/xlink}type"), (Object)DataRecord$.MODULE$.apply((Object)Simple$.MODULE$, (CanWriteXML)opengis.package$.MODULE$.Xlink_TypeTypeFormat()))})))), HTTP$.MODULE$.apply$default$2()));
        OperationType getMap = new OperationType(OutputFormat$.MODULE$.all(), (Seq)Nil$.MODULE$.$colon$colon((Object)dCPType2));
        DCPType dCPType3 = new DCPType(new HTTP(new Get(new OnlineResource((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@{http://www.w3.org/1999/xlink}href"), (Object)DataRecord$.MODULE$.apply((Object)this.serviceUrl().toURI(), (CanWriteXML)opengis.package$.MODULE$.__URIXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@{http://www.w3.org/1999/xlink}type"), (Object)DataRecord$.MODULE$.apply((Object)Simple$.MODULE$, (CanWriteXML)opengis.package$.MODULE$.Xlink_TypeTypeFormat()))})))), HTTP$.MODULE$.apply$default$2()));
        OperationType getFeatureInfo = new OperationType(InfoFormat$.MODULE$.all(), (Seq)Nil$.MODULE$.$colon$colon((Object)dCPType3));
        return (F)package.functor$.MODULE$.toFunctorOps(CapabilitiesView$.MODULE$.modelAsLayer(this.model().parentLayerMeta(), this.model(), this.evidence$3), this.evidence$3).map((Function1 & Serializable & scala.Serializable)layer -> {
            Request x$1 = new Request(getCapabilities, getMap, OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)getFeatureInfo)), Request$.MODULE$.apply$default$4());
            String string = "XML";
            String string2 = "INIMAGE";
            String string3 = "BLANK";
            String string4 = "JSON";
            Exception x$2 = new Exception((Seq)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
            Option x$3 = OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId(layer));
            List<DataRecord<Elem>> x$4 = this.extendedCapabilities();
            Capability capability = new Capability(x$1, x$2, x$4, x$3);
            return (Elem)scalaxb.package$.MODULE$.toXML((Object)new WMS_Capabilities(this.model().serviceMeta(), capability, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@version"), (Object)DataRecord$.MODULE$.apply((Object)"1.3.0", (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat()))}))), (Option)None$.MODULE$, OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)"WMS_Capabilities")), package$.MODULE$.wmsScope(), false, (CanWriteXML)opengis.package$.MODULE$.Opengiswms_WMS_CapabilitiesFormat());
        });
    }

    public <F> CapabilitiesView<F> copy(WmsModel<F> model, URL serviceUrl, List<DataRecord<Elem>> extendedCapabilities, Functor<F> evidence$1, Apply<F> evidence$2, Monad<F> evidence$3) {
        return new CapabilitiesView<F>(model, serviceUrl, extendedCapabilities, evidence$1, evidence$2, evidence$3);
    }

    public <F> WmsModel<F> copy$default$1() {
        return this.model();
    }

    public <F> URL copy$default$2() {
        return this.serviceUrl();
    }

    public <F> List<DataRecord<Elem>> copy$default$3() {
        return this.extendedCapabilities();
    }

    public String productPrefix() {
        return "CapabilitiesView";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        List<DataRecord<Elem>> list;
        int n = x$1;
        switch (n) {
            case 0: {
                list = this.model();
                break;
            }
            case 1: {
                list = this.serviceUrl();
                break;
            }
            case 2: {
                list = this.extendedCapabilities();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return list;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CapabilitiesView;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CapabilitiesView)) return false;
        boolean bl = true;
        if (!bl) return false;
        CapabilitiesView capabilitiesView = (CapabilitiesView)x$1;
        WmsModel<F> wmsModel = this.model();
        WmsModel<F> wmsModel2 = capabilitiesView.model();
        if (wmsModel == null) {
            if (wmsModel2 != null) {
                return false;
            }
        } else if (!((Object)wmsModel).equals(wmsModel2)) return false;
        URL uRL = this.serviceUrl();
        URL uRL2 = capabilitiesView.serviceUrl();
        if (uRL == null) {
            if (uRL2 != null) {
                return false;
            }
        } else if (!((Object)uRL).equals(uRL2)) return false;
        List<DataRecord<Elem>> list = this.extendedCapabilities();
        List<DataRecord<Elem>> list2 = capabilitiesView.extendedCapabilities();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!capabilitiesView.canEqual(this)) return false;
        return true;
    }

    public CapabilitiesView(WmsModel<F> model, URL serviceUrl, List<DataRecord<Elem>> extendedCapabilities, Functor<F> evidence$1, Apply<F> evidence$2, Monad<F> evidence$3) {
        this.model = model;
        this.serviceUrl = serviceUrl;
        this.extendedCapabilities = extendedCapabilities;
        this.evidence$3 = evidence$3;
        Product.$init$((Product)this);
    }

    public static class RasterSourceMethods {
        private final OgcSource source;

        public OgcSource source() {
            return this.source;
        }

        public Layer toLayer(List<CRS> parentProjections) {
            Nil$ nil$;
            GridExtent gridExtent;
            Option option = OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)this.source().name()));
            String string = this.source().title();
            Seq seq = (Seq)((List)((SeqLike)parentProjections.$plus$plus(this.source().nativeCrs(), List$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)crs -> (String)crs.epsgCode().map((Function1 & Serializable & scala.Serializable)code -> RasterSourceMethods.$anonfun$toLayer$2(BoxesRunTime.unboxToInt((Object)code))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new java.lang.Exception(new StringBuilder(35).append("Unable to construct EPSG code from ").append(crs).toString());
            }), List$.MODULE$.canBuildFrom());
            OgcSource ogcSource = this.source();
            if (ogcSource instanceof MapAlgebraSource) {
                MapAlgebraSource mapAlgebraSource = (MapAlgebraSource)ogcSource;
                gridExtent = (GridExtent)((TraversableOnce)mapAlgebraSource.sourcesList().map((Function1 & Serializable & scala.Serializable)rs -> {
                    Reproject.Options qual$1 = Reproject.Options$.MODULE$.DEFAULT();
                    ResampleMethod x$1 = mapAlgebraSource.resampleMethod();
                    double x$2 = qual$1.copy$default$2();
                    Option x$3 = qual$1.copy$default$3();
                    Option x$4 = qual$1.copy$default$4();
                    Option x$5 = qual$1.copy$default$5();
                    return ReprojectRasterExtent$.MODULE$.apply(rs.gridExtent(), rs.crs(), (CRS)LatLng$.MODULE$, qual$1.copy(x$1, x$2, x$3, x$4, x$5), (Integral)Integral$.MODULE$.LongIsIntegral());
                }, List$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(re1, re2) -> {
                    Extent e = re1.extent().combine(re2.extent());
                    CellSize cs = re1.cellSize().resolution() < re2.cellSize().resolution() ? re1.cellSize() : re2.cellSize();
                    return new GridExtent.mcJ.sp(e, cs, (Integral)Integral$.MODULE$.LongIsIntegral());
                });
            } else if (ogcSource instanceof RasterOgcSource) {
                RasterOgcSource rasterOgcSource = (RasterOgcSource)ogcSource;
                RasterSource rs2 = rasterOgcSource.source();
                Reproject.Options qual$2 = Reproject.Options$.MODULE$.DEFAULT();
                ResampleMethod x$6 = rasterOgcSource.resampleMethod();
                double x$7 = qual$2.copy$default$2();
                Option x$8 = qual$2.copy$default$3();
                Option x$9 = qual$2.copy$default$4();
                Option x$10 = qual$2.copy$default$5();
                gridExtent = ReprojectRasterExtent$.MODULE$.apply(rs2.gridExtent(), rs2.crs(), (CRS)LatLng$.MODULE$, qual$2.copy(x$6, x$7, x$8, x$9, x$10), (Integral)Integral$.MODULE$.LongIsIntegral());
            } else {
                throw new MatchError((Object)ogcSource);
            }
            GridExtent llre = gridExtent;
            Extent extent = llre.extent();
            if (extent == null) {
                throw new MatchError((Object)extent);
            }
            double xmin = extent.xmin();
            double ymin = extent.ymin();
            double xmax = extent.xmax();
            double ymax = extent.ymax();
            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax));
            Tuple4 tuple42 = tuple4;
            double xmin2 = BoxesRunTime.unboxToDouble((Object)tuple42._1());
            double ymin2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
            double xmax2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
            double ymax2 = BoxesRunTime.unboxToDouble((Object)tuple42._4());
            Option option2 = OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)new EX_GeographicBoundingBox(xmin2, xmax2, ymin2, ymax2)));
            OgcTime ogcTime = this.source().time();
            if (ogcTime instanceof OgcTimePositions) {
                OgcTimePositions ogcTimePositions = (OgcTimePositions)ogcTime;
                NonEmptyList<ZonedDateTime> nel = ogcTimePositions.list();
                Dimension dimension = new Dimension(ogcTimePositions.toString(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@name"), (Object)DataRecord$.MODULE$.apply((Object)"time", (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@units"), (Object)DataRecord$.MODULE$.apply((Object)"ISO8601", (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@default"), (Object)DataRecord$.MODULE$.apply((Object)OgcTimeDefault$OgcTimeDefaultOps$.MODULE$.selectTime$extension(OgcTimeDefault$.MODULE$.OgcTimeDefaultOps(this.source().timeDefault()), nel).toInstant().toString(), (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat()))})));
                nil$ = Nil$.MODULE$.$colon$colon((Object)dimension);
            } else if (ogcTime instanceof OgcTimeInterval) {
                OgcTimeInterval ogcTimeInterval = (OgcTimeInterval)ogcTime;
                ZonedDateTime start = ogcTimeInterval.start();
                ZonedDateTime end = ogcTimeInterval.end();
                Dimension dimension = new Dimension(ogcTimeInterval.toString(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@name"), (Object)DataRecord$.MODULE$.apply((Object)"time", (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@units"), (Object)DataRecord$.MODULE$.apply((Object)"ISO8601", (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@default"), (Object)DataRecord$.MODULE$.apply((Object)OgcTimeDefault$OgcTimeDefaultOps$.MODULE$.selectTime$extension(OgcTimeDefault$.MODULE$.OgcTimeDefaultOps(this.source().timeDefault()), (NonEmptyList<ZonedDateTime>)NonEmptyList$.MODULE$.of((Object)start, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ZonedDateTime[]{end}))).toInstant().toString(), (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat()))})));
                nil$ = Nil$.MODULE$.$colon$colon((Object)dimension);
            } else if (OgcTimeEmpty$.MODULE$.equals(ogcTime)) {
                nil$ = Nil$.MODULE$;
            } else {
                throw new MatchError((Object)ogcTime);
            }
            return new Layer(option, string, (Option)None$.MODULE$, (Option)None$.MODULE$, seq, option2, (Seq)Nil$.MODULE$, (Seq)nil$, (Option)None$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)this.source().styles().map((Function1 & Serializable & scala.Serializable)x$13 -> CapabilitiesView$.MODULE$.StyleMethods((OgcStyle)x$13).render(), List$.MODULE$.canBuildFrom()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)Nil$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"@queryable"), (Object)DataRecord$.MODULE$.apply((Object)"1", (CanWriteXML)opengis.package$.MODULE$.__StringXMLFormat()))})));
        }

        public static final /* synthetic */ String $anonfun$toLayer$2(int code) {
            return new StringBuilder(5).append("EPSG:").append(code).toString();
        }

        public RasterSourceMethods(OgcSource source) {
            this.source = source;
        }
    }

    public static class StyleMethods {
        private final OgcStyle style;

        public OgcStyle style() {
            return this.style;
        }

        public Style render() {
            String x$1 = this.style().name();
            String x$2 = this.style().title();
            Seq x$3 = (Seq)this.style().legends().map((Function1 & Serializable & scala.Serializable)x$9 -> package$.MODULE$.withLegendModelMethods((LegendModel)x$9).toLegendURL(), List$.MODULE$.canBuildFrom());
            Option x$4 = Style$.MODULE$.apply$default$3();
            Option x$5 = Style$.MODULE$.apply$default$5();
            Option x$6 = Style$.MODULE$.apply$default$6();
            return new Style(x$1, x$2, x$4, x$3, x$5, x$6);
        }

        public StyleMethods(OgcStyle style) {
            this.style = style;
        }
    }
}

