/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.wms;

import cats.ApplicativeError;
import cats.Parallel;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.Validated;
import cats.effect.Concurrent;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.azavea.maml.eval.ConcurrentInterpreter$;
import com.azavea.maml.eval.Interpreter;
import com.github.blemale.scaffeine.Cache;
import geotrellis.raster.CellGrid;
import geotrellis.raster.Dimensions;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.server.LayerExtent$;
import geotrellis.server.ogc.MapAlgebraOgcLayer;
import geotrellis.server.ogc.OgcLayer;
import geotrellis.server.ogc.SimpleOgcLayer;
import geotrellis.server.ogc.SimpleOgcLayer$;
import geotrellis.server.ogc.wms.GetFeatureInfo$;
import geotrellis.server.ogc.wms.GetFeatureInfoException;
import geotrellis.server.ogc.wms.InvalidPointException;
import geotrellis.server.ogc.wms.LayerNotDefinedException;
import geotrellis.server.ogc.wms.WmsModel;
import geotrellis.server.ogc.wms.WmsParams;
import geotrellis.vector.Feature;
import geotrellis.vector.Point$;
import io.chrisdavenport.log4cats.Logger;
import io.chrisdavenport.log4cats.Logger$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.KeyEncoder$;
import io.circe.syntax.package;
import java.io.Serializable;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tue\u0001\u0002\u0010 \u0001\"B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005q!A1\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005u\u0001\tE\t\u0015!\u0003N\u0011!)\bAaA!\u0002\u00171\bBCA\u0001\u0001\t\r\t\u0015a\u0003\u0002\u0004!Q\u0011q\u0002\u0001\u0003\u0004\u0003\u0006Y!!\u0005\t\u0015\u0005u\u0001AaA!\u0002\u0017\ty\u0002C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005\"CAN\u0001\u0005\u0005I\u0011AAO\u0011%\t\u0019\rAI\u0001\n\u0003\t)\rC\u0005\u0002d\u0002\t\n\u0011\"\u0001\u0002f\"I\u0011\u0011\u001f\u0001\u0002\u0002\u0013\u0005\u00131\u001f\u0005\n\u0005\u000b\u0001\u0011\u0011!C\u0001\u0005\u000fA\u0011Ba\u0004\u0001\u0003\u0003%\tA!\u0005\t\u0013\t]\u0001!!A\u0005B\te\u0001\"\u0003B\u0014\u0001\u0005\u0005I\u0011\u0001B\u0015\u0011%\u0011\u0019\u0004AA\u0001\n\u0003\u0012)\u0004C\u0005\u00038\u0001\t\t\u0011\"\u0011\u0003:!I!1\b\u0001\u0002\u0002\u0013\u0005#QH\u0004\n\u0005\u0003z\u0012\u0011!E\u0001\u0005\u00072\u0001BH\u0010\u0002\u0002#\u0005!Q\t\u0005\b\u0003cAB\u0011\u0001B$\u0011%\u00119\u0004GA\u0001\n\u000b\u0012I\u0004C\u0005\u0003Ja\t\t\u0011\"!\u0003L!I!\u0011\u000f\r\u0002\u0002\u0013\u0005%1\u000f\u0005\n\u0005'C\u0012\u0011!C\u0005\u0005+\u0013abR3u\r\u0016\fG/\u001e:f\u0013:4wN\u0003\u0002!C\u0005\u0019q/\\:\u000b\u0005\t\u001a\u0013aA8hG*\u0011A%J\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0019\n!bZ3piJ,G\u000e\\5t\u0007\u0001)\"!\u000b \u0014\t\u0001Q\u0003g\r\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-\n\u0014B\u0001\u001a-\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u000b\u001b\n\u0005Ub#\u0001D*fe&\fG.\u001b>bE2,\u0017!B7pI\u0016dW#\u0001\u001d\u0011\u0007eRD(D\u0001 \u0013\tYtD\u0001\u0005X[Nlu\u000eZ3m!\tid\b\u0004\u0001\u0005\u000b}\u0002!\u0019\u0001!\u0003\u0003\u0019+\"!\u0011%\u0012\u0005\t+\u0005CA\u0016D\u0013\t!EFA\u0004O_RD\u0017N\\4\u0011\u0005-2\u0015BA$-\u0005\r\te.\u001f\u0003\u0006\u0013z\u0012\r!\u0011\u0002\u0002?\u00061Qn\u001c3fY\u0002\n1B]1ti\u0016\u00148)Y2iKV\tQ\n\u0005\u0003O/f[W\"A(\u000b\u0005A\u000b\u0016!C:dC\u001a4W-\u001b8f\u0015\t\u00116+A\u0004cY\u0016l\u0017\r\\3\u000b\u0005Q+\u0016AB4ji\",(MC\u0001W\u0003\r\u0019w.\\\u0005\u00031>\u0013QaQ1dQ\u0016\u0004\"A\u00175\u000f\u0005m3gB\u0001/f\u001d\tiFM\u0004\u0002_G:\u0011qLY\u0007\u0002A*\u0011\u0011mJ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019J!\u0001J\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\t9w$A\u0005X[N\u0004\u0016M]1ng&\u0011\u0011N\u001b\u0002\r\u000f\u0016$X*\u00199QCJ\fWn\u001d\u0006\u0003O~\u00012\u0001\\8r\u001b\u0005i'B\u00018&\u0003\u0019\u0011\u0018m\u001d;fe&\u0011\u0001/\u001c\u0002\u0007%\u0006\u001cH/\u001a:\u0011\u00051\u0014\u0018BA:n\u00055iU\u000f\u001c;jE\u0006tG\rV5mK\u0006a!/Y:uKJ\u001c\u0015m\u00195fA\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007]tH(D\u0001y\u0015\tI(0\u0001\u0005m_\u001e$4-\u0019;t\u0015\tYH0\u0001\bdQJL7\u000fZ1wK:\u0004xN\u001d;\u000b\u0003u\f!![8\n\u0005}D(A\u0002'pO\u001e,'/\u0001\u0006fm&$WM\\2fII\u0002R!!\u0002\u0002\fqj!!a\u0002\u000b\u0005\u0005%\u0011\u0001B2biNLA!!\u0004\u0002\b\tA\u0001+\u0019:bY2,G.\u0001\u0006fm&$WM\\2fIM\u0002R!a\u0005\u0002\u001aqj!!!\u0006\u000b\t\u0005]\u0011qA\u0001\u0007K\u001a4Wm\u0019;\n\t\u0005m\u0011Q\u0003\u0002\u000b\u0007>t7-\u001e:sK:$\u0018AC3wS\u0012,gnY3%iA)\u0011\u0011EA\u0016y9!\u00111EA\u0014\u001d\ry\u0016QE\u0005\u0003\u0003\u0013IA!!\u000b\u0002\b\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0017\u0003_\u0011\u0001#\u00119qY&\u001c\u0017\r^5wKRC'o\\<\u000b\t\u0005%\u0012qA\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0005U\u0012\u0011IA\"))\t9$!\u000f\u0002<\u0005u\u0012q\b\t\u0004s\u0001a\u0004\"B;\n\u0001\b1\bbBA\u0001\u0013\u0001\u000f\u00111\u0001\u0005\b\u0003\u001fI\u00019AA\t\u0011\u001d\ti\"\u0003a\u0002\u0003?AQAN\u0005A\u0002aBQaS\u0005A\u00025\u000bQAY;jY\u0012$B!!\u0013\u0002\nB!QHPA&!!\ti%!\u0016\u0002\\\u0005\u0005d\u0002BA(\u0003'r1aXA)\u0013\u0005i\u0013bAA\u0015Y%!\u0011qKA-\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011\u0011\u0006\u0017\u0011\u0007e\ni&C\u0002\u0002`}\u0011qcR3u\r\u0016\fG/\u001e:f\u0013:4w.\u0012=dKB$\u0018n\u001c8\u0011\u0011\u0005\r\u0014\u0011NA7\u0003{j!!!\u001a\u000b\u0007\u0005\u001dT%\u0001\u0004wK\u000e$xN]\u0005\u0005\u0003W\n)GA\u0004GK\u0006$XO]3\u0011\t\u0005=\u0014q\u000f\b\u0005\u0003c\n)HD\u0002_\u0003gJ1!a\u001a&\u0013\u0011\tI#!\u001a\n\t\u0005e\u00141\u0010\u0002\t\u000f\u0016|W.\u001a;ss*!\u0011\u0011FA3!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAABy\u0006)1-\u001b:dK&!\u0011qQAA\u0005\u0011Q5o\u001c8\t\u000f\u0005-%\u00021\u0001\u0002\u000e\u00061\u0001/\u0019:b[N\u00042AWAH\u0013\r\t\tJ\u001b\u0002\u0015\u000f\u0016$h)Z1ukJ,\u0017J\u001c4p!\u0006\u0014\u0018-\\:\u0002#\u0019,\u0017\r^;sK\u001a\u0013x.\u001c*bgR,'\u000f\u0006\u0004\u0002L\u0005]\u0015\u0011\u0014\u0005\u0006].\u0001\ra\u001b\u0005\b\u0003\u0017[\u0001\u0019AAG\u0003\u0011\u0019w\u000e]=\u0016\t\u0005}\u0015q\u0015\u000b\u0007\u0003C\u000bi,!1\u0015\u0015\u0005\r\u0016QVAY\u0003k\u000bI\f\u0005\u0003:\u0001\u0005\u0015\u0006cA\u001f\u0002(\u00121q\b\u0004b\u0001\u0003S+2!QAV\t\u0019I\u0015q\u0015b\u0001\u0003\"1Q\u000f\u0004a\u0002\u0003_\u0003Ba\u001e@\u0002&\"9\u0011\u0011\u0001\u0007A\u0004\u0005M\u0006CBA\u0003\u0003\u0017\t)\u000bC\u0004\u0002\u00101\u0001\u001d!a.\u0011\r\u0005M\u0011\u0011DAS\u0011\u001d\ti\u0002\u0004a\u0002\u0003w\u0003b!!\t\u0002,\u0005\u0015\u0006\u0002\u0003\u001c\r!\u0003\u0005\r!a0\u0011\teR\u0014Q\u0015\u0005\b\u00172\u0001\n\u00111\u0001N\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*B!a2\u0002^V\u0011\u0011\u0011\u001a\u0016\u0004q\u0005-7FAAg!\u0011\ty-!7\u000e\u0005\u0005E'\u0002BAj\u0003+\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]G&\u0001\u0006b]:|G/\u0019;j_:LA!a7\u0002R\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\r}j!\u0019AAp+\r\t\u0015\u0011\u001d\u0003\u0007\u0013\u0006u'\u0019A!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011q]Av+\t\tIOK\u0002N\u0003\u0017$aa\u0010\bC\u0002\u00055XcA!\u0002p\u00121\u0011*a;C\u0002\u0005\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA{!\u0011\t9P!\u0001\u000e\u0005\u0005e(\u0002BA~\u0003{\fA\u0001\\1oO*\u0011\u0011q`\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0004\u0005e(AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003\nA\u00191Fa\u0003\n\u0007\t5AFA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002F\u0005'A\u0011B!\u0006\u0012\u0003\u0003\u0005\rA!\u0003\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\u0002E\u0003\u0003\u001e\t\rR)\u0004\u0002\u0003 )\u0019!\u0011\u0005\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003&\t}!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u000b\u00032A\u00191F!\f\n\u0007\t=BFA\u0004C_>dW-\u00198\t\u0011\tU1#!AA\u0002\u0015\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005\u0013\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003k\fa!Z9vC2\u001cH\u0003\u0002B\u0016\u0005\u007fA\u0001B!\u0006\u0017\u0003\u0003\u0005\r!R\u0001\u000f\u000f\u0016$h)Z1ukJ,\u0017J\u001c4p!\tI\u0004dE\u0002\u0019UM\"\"Aa\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\t5#Q\u000b\u000b\u0007\u0005\u001f\u0012YGa\u001c\u0015\u0015\tE#1\fB0\u0005G\u00129\u0007\u0005\u0003:\u0001\tM\u0003cA\u001f\u0003V\u00111qh\u0007b\u0001\u0005/*2!\u0011B-\t\u0019I%Q\u000bb\u0001\u0003\"1Qo\u0007a\u0002\u0005;\u0002Ba\u001e@\u0003T!9\u0011\u0011A\u000eA\u0004\t\u0005\u0004CBA\u0003\u0003\u0017\u0011\u0019\u0006C\u0004\u0002\u0010m\u0001\u001dA!\u001a\u0011\r\u0005M\u0011\u0011\u0004B*\u0011\u001d\tib\u0007a\u0002\u0005S\u0002b!!\t\u0002,\tM\u0003B\u0002\u001c\u001c\u0001\u0004\u0011i\u0007\u0005\u0003:u\tM\u0003\"B&\u001c\u0001\u0004i\u0015aB;oCB\u0004H._\u000b\u0005\u0005k\u00129\t\u0006\u0003\u0003x\t5\u0005#B\u0016\u0003z\tu\u0014b\u0001B>Y\t1q\n\u001d;j_:\u0004ba\u000bB@\u0005\u0007k\u0015b\u0001BAY\t1A+\u001e9mKJ\u0002B!\u000f\u001e\u0003\u0006B\u0019QHa\"\u0005\r}b\"\u0019\u0001BE+\r\t%1\u0012\u0003\u0007\u0013\n\u001d%\u0019A!\t\u0013\t=E$!AA\u0002\tE\u0015a\u0001=%aA!\u0011\b\u0001BC\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t]\u0005\u0003BA|\u00053KAAa'\u0002z\n1qJ\u00196fGR\u0004")
public class GetFeatureInfo<F>
implements Product,
scala.Serializable {
    private final WmsModel<F> model;
    private final Cache<WmsParams.GetMapParams, Raster<MultibandTile>> rasterCache;
    private final Logger<F> evidence$1;
    private final Parallel<F> evidence$2;
    private final Concurrent<F> evidence$3;

    public static <F> Option<Tuple2<WmsModel<F>, Cache<WmsParams.GetMapParams, Raster<MultibandTile>>>> unapply(GetFeatureInfo<F> getFeatureInfo) {
        return GetFeatureInfo$.MODULE$.unapply(getFeatureInfo);
    }

    public static <F> GetFeatureInfo<F> apply(WmsModel<F> wmsModel, Cache<WmsParams.GetMapParams, Raster<MultibandTile>> cache, Logger<F> logger, Parallel<F> parallel, Concurrent<F> concurrent, ApplicativeError<F, Throwable> applicativeError) {
        return GetFeatureInfo$.MODULE$.apply(wmsModel, cache, logger, parallel, concurrent, applicativeError);
    }

    public WmsModel<F> model() {
        return this.model;
    }

    public Cache<WmsParams.GetMapParams, Raster<MultibandTile>> rasterCache() {
        return this.rasterCache;
    }

    public F build(WmsParams.GetFeatureInfoParams params) {
        Object object;
        RasterExtent re = params.rasterExtent();
        Object res = package.flatMap$.MODULE$.toFlatMapOps(this.model().getLayer(params.toGetMapParamsQuery()), this.evidence$3).flatMap((Function1 & Serializable & scala.Serializable)layers -> package.traverse$.MODULE$.toTraverseOps((Object)((TraversableLike)layers.map((Function1 & Serializable & scala.Serializable)layer -> {
            Function2 function2;
            OgcLayer ogcLayer = layer;
            if (ogcLayer instanceof SimpleOgcLayer) {
                SimpleOgcLayer simpleOgcLayer = (SimpleOgcLayer)ogcLayer;
                function2 = LayerExtent$.MODULE$.withCellType((Object)simpleOgcLayer, simpleOgcLayer.source().cellType(), $this.evidence$1, $this.evidence$2, $this.evidence$3, $this.evidence$3, SimpleOgcLayer$.MODULE$.simpleOgcReification($this.evidence$3, $this.evidence$1));
            } else if (ogcLayer instanceof MapAlgebraOgcLayer) {
                MapAlgebraOgcLayer mapAlgebraOgcLayer = (MapAlgebraOgcLayer)ogcLayer;
                function2 = LayerExtent$.MODULE$.apply(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)mapAlgebraOgcLayer.algebra()), $this.evidence$3), ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId(mapAlgebraOgcLayer.parameters()), $this.evidence$3), (Interpreter)ConcurrentInterpreter$.MODULE$.DEFAULT($this.evidence$3), mapAlgebraOgcLayer.targetCellType(), $this.evidence$1, $this.evidence$2, $this.evidence$3, SimpleOgcLayer$.MODULE$.simpleOgcReification($this.evidence$3, $this.evidence$1));
            } else {
                throw new MatchError((Object)ogcLayer);
            }
            Function2 evalExtent = function2;
            return package.flatMap$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.applicativeError$.MODULE$.catsSyntaxApplicativeError(package.functor$.MODULE$.toFunctorOps(evalExtent.apply((Object)re.extent(), (Object)OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)re.cellSize()))), $this.evidence$3).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Validated.Valid valid;
                Validated validated = x0$1;
                if (validated instanceof Validated.Valid) {
                    Validated.Valid valid2 = (Validated.Valid)validated;
                    MultibandTile mbtile = (MultibandTile)valid2.a();
                    valid = new Validated.Valid((Object)mbtile);
                } else if (validated instanceof Validated.Invalid) {
                    Validated.Invalid invalid = (Validated.Invalid)validated;
                    NonEmptyList errs = (NonEmptyList)invalid.e();
                    valid = new Validated.Invalid((Object)errs);
                } else {
                    throw new MatchError((Object)validated);
                }
                return valid;
            }), $this.evidence$3), $this.evidence$3), $this.evidence$3).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Validated validated;
                boolean bl = false;
                Right right = null;
                Either either = x0$2;
                if (either instanceof Right) {
                    bl = true;
                    right = (Right)either;
                    Validated validated2 = (Validated)right.value();
                    if (validated2 instanceof Validated.Valid) {
                        Validated.Valid valid = (Validated.Valid)validated2;
                        MultibandTile mbtile = (MultibandTile)valid.a();
                        Raster raster = new Raster((CellGrid)mbtile, re.extent());
                        this.rasterCache().put((Object)params.toGetMapParams(), (Object)raster);
                        return package.functor$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId(this.featureFromRaster((Raster<MultibandTile>)raster, params)), $this.evidence$3), $this.evidence$3).widen();
                    }
                }
                if (bl && (validated = (Validated)right.value()) instanceof Validated.Invalid) {
                    Validated.Invalid invalid = (Validated.Invalid)validated;
                    NonEmptyList errs = (NonEmptyList)invalid.e();
                    return package.functor$.MODULE$.toFunctorOps(package.functor$.MODULE$.toFunctorOps(Logger$.MODULE$.apply($this.evidence$1).debug((Function0 & Serializable & scala.Serializable)() -> errs.toList().toString()), $this.evidence$3).as((Object)package$.MODULE$.Left().apply((Object)new LayerNotDefinedException(errs.toList().toString(), params.version()))), $this.evidence$3).widen();
                }
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Left left = (Left)either;
                Throwable err = (Throwable)left.value();
                return package.functor$.MODULE$.toFunctorOps(package.functor$.MODULE$.toFunctorOps(Logger$.MODULE$.apply($this.evidence$1).error((Function0 & Serializable & scala.Serializable)() -> geotrellis.server.utils.package$.MODULE$.throwableExtensions(err).stackTraceString()), $this.evidence$3).as((Object)package$.MODULE$.Left().apply((Object)new LayerNotDefinedException(geotrellis.server.utils.package$.MODULE$.throwableExtensions(err).stackTraceString(), params.version()))), $this.evidence$3).widen();
            });
        }, List$.MODULE$.canBuildFrom())).headOption(), UnorderedFoldable$.MODULE$.catsTraverseForOption()).sequence(Predef$.MODULE$.$conforms(), $this.evidence$3));
        Option option = this.rasterCache().getIfPresent((Object)params.toGetMapParams());
        if (option instanceof Some) {
            Some some = (Some)option;
            Raster raster = (Raster)some.value();
            object = ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId(this.featureFromRaster((Raster<MultibandTile>)raster, params)), this.evidence$3);
        } else {
            object = package.functor$.MODULE$.toFunctorOps(res, this.evidence$3).map((Function1 & Serializable & scala.Serializable)x$1 -> (Either)x$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new LayerNotDefinedException(new StringBuilder(17).append("Layers ").append(params.queryLayers()).append(" not found").toString(), params.version()))));
        }
        return (F)object;
    }

    public Either<GetFeatureInfoException, Feature<Geometry, Json>> featureFromRaster(Raster<MultibandTile> raster, WmsParams.GetFeatureInfoParams params) {
        Dimensions dimensions = raster.dimensions();
        if (dimensions == null) {
            throw new MatchError((Object)dimensions);
        }
        int cols = dimensions.cols$mcI$sp();
        int rows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        return params.i() < 0 && params.i() >= cols2 || params.j() < 0 && params.j() >= rows2 ? package$.MODULE$.Left().apply((Object)new InvalidPointException(new StringBuilder(33).append(params.i()).append(", ").append(params.j()).append(" not in dimensions of image: ").append(cols2).append(", ").append(rows2).toString(), params.version())) : package$.MODULE$.Right().apply((Object)new Feature((Geometry)Point$.MODULE$.apply(raster.rasterExtent().gridToMap$mcI$sp(params.i(), params.j())), (Object)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)((TraversableOnce)((TraversableLike)((MultibandTile)raster.tile()).bands().zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tile b = (Tile)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(17).append("band-").append(i).append("-pixel-value").toString()), (Object)BoxesRunTime.boxToDouble((double)b.getDouble(params.i(), params.j())));
            return tuple22;
        }, Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())), (Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeDouble()))));
    }

    public <F> GetFeatureInfo<F> copy(WmsModel<F> model, Cache<WmsParams.GetMapParams, Raster<MultibandTile>> rasterCache, Logger<F> evidence$1, Parallel<F> evidence$2, Concurrent<F> evidence$3, ApplicativeError<F, Throwable> evidence$4) {
        return new GetFeatureInfo<F>(model, rasterCache, evidence$1, evidence$2, evidence$3, evidence$4);
    }

    public <F> WmsModel<F> copy$default$1() {
        return this.model();
    }

    public <F> Cache<WmsParams.GetMapParams, Raster<MultibandTile>> copy$default$2() {
        return this.rasterCache();
    }

    public String productPrefix() {
        return "GetFeatureInfo";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        WmsModel<F> wmsModel;
        int n = x$1;
        switch (n) {
            case 0: {
                wmsModel = this.model();
                break;
            }
            case 1: {
                wmsModel = this.rasterCache();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return wmsModel;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetFeatureInfo;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetFeatureInfo)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetFeatureInfo getFeatureInfo = (GetFeatureInfo)x$1;
        WmsModel<F> wmsModel = this.model();
        WmsModel<F> wmsModel2 = getFeatureInfo.model();
        if (wmsModel == null) {
            if (wmsModel2 != null) {
                return false;
            }
        } else if (!((Object)wmsModel).equals(wmsModel2)) return false;
        Cache<WmsParams.GetMapParams, Raster<MultibandTile>> cache = this.rasterCache();
        Cache<WmsParams.GetMapParams, Raster<MultibandTile>> cache2 = getFeatureInfo.rasterCache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        if (!getFeatureInfo.canEqual(this)) return false;
        return true;
    }

    public GetFeatureInfo(WmsModel<F> model, Cache<WmsParams.GetMapParams, Raster<MultibandTile>> rasterCache, Logger<F> evidence$1, Parallel<F> evidence$2, Concurrent<F> evidence$3, ApplicativeError<F, Throwable> evidence$4) {
        this.model = model;
        this.rasterCache = rasterCache;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
        Product.$init$((Product)this);
    }
}

