/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.server.ogc.wms;

import cats.ApplicativeError;
import cats.Parallel;
import cats.data.NonEmptyList;
import cats.data.Validated;
import cats.effect.Concurrent;
import cats.effect.Sync$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.azavea.maml.error.MamlError;
import com.azavea.maml.error.MamlError$;
import com.azavea.maml.eval.ConcurrentInterpreter$;
import com.azavea.maml.eval.Interpreter;
import com.github.blemale.scaffeine.Cache;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.histogram.Histogram;
import geotrellis.server.LayerExtent$;
import geotrellis.server.LayerHistogram$;
import geotrellis.server.ogc.MapAlgebraOgcLayer;
import geotrellis.server.ogc.OgcLayer;
import geotrellis.server.ogc.SimpleOgcLayer;
import geotrellis.server.ogc.SimpleOgcLayer$;
import geotrellis.server.ogc.package$;
import geotrellis.server.ogc.package$RasterOps$;
import geotrellis.server.ogc.style.OgcStyle;
import geotrellis.server.ogc.wms.GetMap$;
import geotrellis.server.ogc.wms.GetMapBadRequest;
import geotrellis.server.ogc.wms.GetMapInternalServerError;
import geotrellis.server.ogc.wms.WmsModel;
import geotrellis.server.ogc.wms.WmsParams;
import io.chrisdavenport.log4cats.Logger;
import io.chrisdavenport.log4cats.Logger$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001\u0002\u0011\"\u0001*B\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!\u000f\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005u!AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005t\u0001\tE\t\u0015!\u0003P\u0011!!\bA!f\u0001\n\u0003)\b\"CA&\u0001\tE\t\u0015!\u0003w\u0011)\ti\u0005\u0001B\u0002B\u0003-\u0011q\n\u0005\u000b\u0003G\u0002!1!Q\u0001\f\u0005\u0015\u0004BCA9\u0001\t\r\t\u0015a\u0003\u0002t!Q\u0011q\u0010\u0001\u0003\u0004\u0003\u0006Y!!!\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006\"CA_\u0001\u0005\u0005I\u0011AA`\u0011%\t9\u000fAI\u0001\n\u0003\tI\u000fC\u0005\u0003\b\u0001\t\n\u0011\"\u0001\u0003\n!I!Q\u0003\u0001\u0012\u0002\u0013\u0005!q\u0003\u0005\n\u0005G\u0001\u0011\u0011!C!\u0005KA\u0011Ba\u000e\u0001\u0003\u0003%\tA!\u000f\t\u0013\t\u0005\u0003!!A\u0005\u0002\t\r\u0003\"\u0003B%\u0001\u0005\u0005I\u0011\tB&\u0011%\u0011I\u0006AA\u0001\n\u0003\u0011Y\u0006C\u0005\u0003f\u0001\t\t\u0011\"\u0011\u0003h!I!\u0011\u000e\u0001\u0002\u0002\u0013\u0005#1\u000e\u0005\n\u0005[\u0002\u0011\u0011!C!\u0005_:\u0011Ba\u001d\"\u0003\u0003E\tA!\u001e\u0007\u0011\u0001\n\u0013\u0011!E\u0001\u0005oBq!!%\u001b\t\u0003\u0011I\bC\u0005\u0003ji\t\t\u0011\"\u0012\u0003l!I!1\u0010\u000e\u0002\u0002\u0013\u0005%Q\u0010\u0005\n\u0005KS\u0012\u0011!CA\u0005OC\u0011Ba2\u001b\u0003\u0003%IA!3\u0003\r\u001d+G/T1q\u0015\t\u00113%A\u0002x[NT!\u0001J\u0013\u0002\u0007=<7M\u0003\u0002'O\u000511/\u001a:wKJT\u0011\u0001K\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\u000b\u0003W\u0001\u001bB\u0001\u0001\u00173kA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\u0004\"!L\u001a\n\u0005Qr#a\u0002)s_\u0012,8\r\u001e\t\u0003[YJ!a\u000e\u0018\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b5|G-\u001a7\u0016\u0003i\u00022a\u000f\u001f?\u001b\u0005\t\u0013BA\u001f\"\u0005!9Vn]'pI\u0016d\u0007CA A\u0019\u0001!Q!\u0011\u0001C\u0002\t\u0013\u0011AR\u000b\u0003\u0007*\u000b\"\u0001R$\u0011\u00055*\u0015B\u0001$/\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\f%\n\u0005%s#aA!os\u0012)1\n\u0011b\u0001\u0007\n\tq,\u0001\u0004n_\u0012,G\u000eI\u0001\ni&dWmQ1dQ\u0016,\u0012a\u0014\t\u0005!f[V.D\u0001R\u0015\t\u00116+A\u0005tG\u00064g-Z5oK*\u0011A+V\u0001\bE2,W.\u00197f\u0015\t1v+\u0001\u0004hSRDWO\u0019\u0006\u00021\u0006\u00191m\\7\n\u0005i\u000b&!B\"bG\",\u0007C\u0001/k\u001d\ti\u0006N\u0004\u0002_O:\u0011qL\u001a\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!aY\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0013B\u0001\u0014(\u0013\t!S%\u0003\u0002#G%\u0011\u0011.I\u0001\n/6\u001c\b+\u0019:b[NL!a\u001b7\u0003\u0019\u001d+G/T1q!\u0006\u0014\u0018-\\:\u000b\u0005%\f\u0003cA\u0017oa&\u0011qN\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003[EL!A\u001d\u0018\u0003\t\tKH/Z\u0001\u000bi&dWmQ1dQ\u0016\u0004\u0013A\u00035jgR|7)Y2iKV\ta\u000f\u0005\u0003Q3^\\\bC\u0001=z\u001b\u0005\u0019\u0013B\u0001>$\u0005!yum\u0019'bs\u0016\u0014\b#\u0002?\u0002\u001c\u0005\u0005bbA?\u0002\u00169\u0019a0a\u0004\u000f\u0007}\fIA\u0004\u0003\u0002\u0002\u0005\u0015abA1\u0002\u0004%\t\u0001,C\u0002\u0002\b]\u000ba!\u0019>bm\u0016\f\u0017\u0002BA\u0006\u0003\u001b\tA!\\1nY*\u0019\u0011qA,\n\t\u0005E\u00111C\u0001\u0006KJ\u0014xN\u001d\u0006\u0005\u0003\u0017\ti!\u0003\u0003\u0002\u0018\u0005e\u0011a\u00029bG.\fw-\u001a\u0006\u0005\u0003#\t\u0019\"\u0003\u0003\u0002\u001e\u0005}!aC%oi\u0016\u0014\bO]3uK\u0012TA!a\u0006\u0002\u001aA1\u00111EA\u0016\u0003cqA!!\n\u0002*9\u0019\u0011-a\n\n\u0003=J1!a\u0006/\u0013\u0011\ti#a\f\u0003\t1K7\u000f\u001e\u0006\u0004\u0003/q\u0003CBA\u001a\u0003\u007f\t)E\u0004\u0003\u00026\u0005mbb\u00011\u00028%\u0019\u0011\u0011H\u0014\u0002\rI\f7\u000f^3s\u0013\u0011\t9\"!\u0010\u000b\u0007\u0005er%\u0003\u0003\u0002B\u0005\r#!\u0003%jgR|wM]1n\u0015\u0011\t9\"!\u0010\u0011\u00075\n9%C\u0002\u0002J9\u0012a\u0001R8vE2,\u0017a\u00035jgR|7)Y2iK\u0002\n!\"\u001a<jI\u0016t7-\u001a\u00132!\u0015\t\t&a\u0018?\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013\u0001\u00037pOR\u001a\u0017\r^:\u000b\t\u0005e\u00131L\u0001\u000fG\"\u0014\u0018n\u001d3bm\u0016t\u0007o\u001c:u\u0015\t\ti&\u0001\u0002j_&!\u0011\u0011MA*\u0005\u0019aunZ4fe\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\u000b\u0005\u001d\u0014Q\u000e \u000e\u0005\u0005%$BAA6\u0003\u0011\u0019\u0017\r^:\n\t\u0005=\u0014\u0011\u000e\u0002\t!\u0006\u0014\u0018\r\u001c7fY\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u000b\u0005U\u00141\u0010 \u000e\u0005\u0005]$\u0002BA=\u0003S\na!\u001a4gK\u000e$\u0018\u0002BA?\u0003o\u0012!bQ8oGV\u0014(/\u001a8u\u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0006\u0003\u0007\u000bYI\u0010\b\u0005\u0003\u000b\u000bIID\u0002b\u0003\u000fK!!a\u001b\n\t\u0005]\u0011\u0011N\u0005\u0005\u0003\u001b\u000byI\u0001\tBaBd\u0017nY1uSZ,G\u000b\u001b:po*!\u0011qCA5\u0003\u0019a\u0014N\\5u}QA\u0011QSAQ\u0003G\u000b)\u000b\u0006\u0006\u0002\u0018\u0006e\u00151TAO\u0003?\u00032a\u000f\u0001?\u0011\u001d\tie\u0003a\u0002\u0003\u001fBq!a\u0019\f\u0001\b\t)\u0007C\u0004\u0002r-\u0001\u001d!a\u001d\t\u000f\u0005}4\u0002q\u0001\u0002\u0002\")\u0001h\u0003a\u0001u!)Qj\u0003a\u0001\u001f\")Ao\u0003a\u0001m\u0006)!-^5mIR!\u00111VA]!\u0011y\u0004)!,\u0011\u000f\u0005\r\u0012qVAZ[&!\u0011\u0011WA\u0018\u0005\u0019)\u0015\u000e\u001e5feB\u00191(!.\n\u0007\u0005]\u0016EA\bHKRl\u0015\r]#yG\u0016\u0004H/[8o\u0011\u0019\tY\f\u0004a\u00017\u00061\u0001/\u0019:b[N\fAaY8qsV!\u0011\u0011YAe)!\t\u0019-a8\u0002d\u0006\u0015HCCAc\u0003\u001f\f\u0019.a6\u0002\\B!1\bAAd!\ry\u0014\u0011\u001a\u0003\u0007\u00036\u0011\r!a3\u0016\u0007\r\u000bi\r\u0002\u0004L\u0003\u0013\u0014\ra\u0011\u0005\b\u0003\u001bj\u00019AAi!\u0019\t\t&a\u0018\u0002H\"9\u00111M\u0007A\u0004\u0005U\u0007CBA4\u0003[\n9\rC\u0004\u0002r5\u0001\u001d!!7\u0011\r\u0005U\u00141PAd\u0011\u001d\ty(\u0004a\u0002\u0003;\u0004b!a!\u0002\f\u0006\u001d\u0007\u0002\u0003\u001d\u000e!\u0003\u0005\r!!9\u0011\tmb\u0014q\u0019\u0005\b\u001b6\u0001\n\u00111\u0001P\u0011\u001d!X\u0002%AA\u0002Y\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0002l\n\u0005QCAAwU\rQ\u0014q^\u0016\u0003\u0003c\u0004B!a=\u0002~6\u0011\u0011Q\u001f\u0006\u0005\u0003o\fI0A\u0005v]\u000eDWmY6fI*\u0019\u00111 \u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0000\u0006U(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121\u0011I\u0004b\u0001\u0005\u0007)2a\u0011B\u0003\t\u0019Y%\u0011\u0001b\u0001\u0007\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B\u0006\u0005\u001f)\"A!\u0004+\u0007=\u000by\u000f\u0002\u0004B\u001f\t\u0007!\u0011C\u000b\u0004\u0007\nMAAB&\u0003\u0010\t\u00071)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\te!QD\u000b\u0003\u00057Q3A^Ax\t\u0019\t\u0005C1\u0001\u0003 U\u00191I!\t\u0005\r-\u0013iB1\u0001D\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\u0005\t\u0005\u0005S\u0011\u0019$\u0004\u0002\u0003,)!!Q\u0006B\u0018\u0003\u0011a\u0017M\\4\u000b\u0005\tE\u0012\u0001\u00026bm\u0006LAA!\u000e\u0003,\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u000f\u0011\u00075\u0012i$C\u0002\u0003@9\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a\u0012B#\u0011%\u00119eEA\u0001\u0002\u0004\u0011Y$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001b\u0002RAa\u0014\u0003V\u001dk!A!\u0015\u000b\u0007\tMc&\u0001\u0006d_2dWm\u0019;j_:LAAa\u0016\u0003R\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011iFa\u0019\u0011\u00075\u0012y&C\u0002\u0003b9\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0003HU\t\t\u00111\u0001H\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u001e\u0003!!xn\u0015;sS:<GC\u0001B\u0014\u0003\u0019)\u0017/^1mgR!!Q\fB9\u0011!\u00119\u0005GA\u0001\u0002\u00049\u0015AB$fi6\u000b\u0007\u000f\u0005\u0002<5M\u0019!\u0004L\u001b\u0015\u0005\tU\u0014!B1qa2LX\u0003\u0002B@\u0005\u000f#\u0002B!!\u0003\u001e\n\u0005&1\u0015\u000b\u000b\u0005\u0007\u0013iI!%\u0003\u0016\ne\u0005\u0003B\u001e\u0001\u0005\u000b\u00032a\u0010BD\t\u0019\tUD1\u0001\u0003\nV\u00191Ia#\u0005\r-\u00139I1\u0001D\u0011\u001d\ti%\ba\u0002\u0005\u001f\u0003b!!\u0015\u0002`\t\u0015\u0005bBA2;\u0001\u000f!1\u0013\t\u0007\u0003O\niG!\"\t\u000f\u0005ET\u0004q\u0001\u0003\u0018B1\u0011QOA>\u0005\u000bCq!a \u001e\u0001\b\u0011Y\n\u0005\u0004\u0002\u0004\u0006-%Q\u0011\u0005\u0007qu\u0001\rAa(\u0011\tmb$Q\u0011\u0005\u0006\u001bv\u0001\ra\u0014\u0005\u0006iv\u0001\rA^\u0001\bk:\f\u0007\u000f\u001d7z+\u0011\u0011IKa/\u0015\t\t-&\u0011\u0019\t\u0006[\t5&\u0011W\u0005\u0004\u0005_s#AB(qi&|g\u000eE\u0004.\u0005g\u00139l\u0014<\n\u0007\tUfF\u0001\u0004UkBdWm\r\t\u0005wq\u0012I\fE\u0002@\u0005w#a!\u0011\u0010C\u0002\tuVcA\"\u0003@\u001211Ja/C\u0002\rC\u0011Ba1\u001f\u0003\u0003\u0005\rA!2\u0002\u0007a$\u0003\u0007\u0005\u0003<\u0001\te\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa3\u0011\t\t%\"QZ\u0005\u0005\u0005\u001f\u0014YC\u0001\u0004PE*,7\r\u001e")
public class GetMap<F>
implements Product,
scala.Serializable {
    private final WmsModel<F> model;
    private final Cache<WmsParams.GetMapParams, byte[]> tileCache;
    private final Cache<OgcLayer, Validated<NonEmptyList<MamlError>, List<Histogram<Object>>>> histoCache;
    private final Logger<F> evidence$1;
    private final Parallel<F> evidence$2;
    private final Concurrent<F> evidence$3;

    public static <F> Option<Tuple3<WmsModel<F>, Cache<WmsParams.GetMapParams, byte[]>, Cache<OgcLayer, Validated<NonEmptyList<MamlError>, List<Histogram<Object>>>>>> unapply(GetMap<F> getMap) {
        return GetMap$.MODULE$.unapply(getMap);
    }

    public static <F> GetMap<F> apply(WmsModel<F> wmsModel, Cache<WmsParams.GetMapParams, byte[]> cache, Cache<OgcLayer, Validated<NonEmptyList<MamlError>, List<Histogram<Object>>>> cache2, Logger<F> logger, Parallel<F> parallel, Concurrent<F> concurrent, ApplicativeError<F, Throwable> applicativeError) {
        return GetMap$.MODULE$.apply(wmsModel, cache, cache2, logger, parallel, concurrent, applicativeError);
    }

    public WmsModel<F> model() {
        return this.model;
    }

    public Cache<WmsParams.GetMapParams, byte[]> tileCache() {
        return this.tileCache;
    }

    public Cache<OgcLayer, Validated<NonEmptyList<MamlError>, List<Histogram<Object>>>> histoCache() {
        return this.histoCache;
    }

    public F build(WmsParams.GetMapParams params) {
        Object object;
        RasterExtent re = RasterExtent$.MODULE$.apply(params.boundingBox(), params.width(), params.height());
        Object res = package.flatMap$.MODULE$.toFlatMapOps(this.model().getLayer(params), this.evidence$3).flatMap((Function1 & Serializable & scala.Serializable)layers -> ((TraversableLike)layers.map((Function1 & Serializable & scala.Serializable)layer -> {
            Object object;
            Function2 function2;
            OgcLayer ogcLayer = layer;
            if (ogcLayer instanceof SimpleOgcLayer) {
                SimpleOgcLayer simpleOgcLayer = (SimpleOgcLayer)ogcLayer;
                function2 = LayerExtent$.MODULE$.withCellType((Object)simpleOgcLayer, simpleOgcLayer.source().cellType(), $this.evidence$1, $this.evidence$2, $this.evidence$3, $this.evidence$3, SimpleOgcLayer$.MODULE$.simpleOgcReification($this.evidence$3, $this.evidence$1));
            } else if (ogcLayer instanceof MapAlgebraOgcLayer) {
                MapAlgebraOgcLayer mapAlgebraOgcLayer = (MapAlgebraOgcLayer)ogcLayer;
                function2 = LayerExtent$.MODULE$.apply(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)mapAlgebraOgcLayer.algebra()), $this.evidence$3), ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId(mapAlgebraOgcLayer.parameters()), $this.evidence$3), (Interpreter)ConcurrentInterpreter$.MODULE$.DEFAULT($this.evidence$3), mapAlgebraOgcLayer.targetCellType(), $this.evidence$1, $this.evidence$2, $this.evidence$3, SimpleOgcLayer$.MODULE$.simpleOgcReification($this.evidence$3, $this.evidence$1));
            } else {
                throw new MatchError((Object)ogcLayer);
            }
            Function2 evalExtent = function2;
            OgcLayer ogcLayer2 = layer;
            if (ogcLayer2 instanceof SimpleOgcLayer) {
                SimpleOgcLayer simpleOgcLayer = (SimpleOgcLayer)ogcLayer2;
                object = LayerHistogram$.MODULE$.concurrent((Object)simpleOgcLayer, 512, $this.evidence$1, $this.evidence$2, $this.evidence$3, $this.evidence$3, SimpleOgcLayer$.MODULE$.simpleOgcReification($this.evidence$3, $this.evidence$1), SimpleOgcLayer$.MODULE$.simpleOgcHasRasterExtents($this.evidence$3));
            } else if (ogcLayer2 instanceof MapAlgebraOgcLayer) {
                MapAlgebraOgcLayer mapAlgebraOgcLayer = (MapAlgebraOgcLayer)ogcLayer2;
                object = LayerHistogram$.MODULE$.apply(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)mapAlgebraOgcLayer.algebra()), $this.evidence$3), ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId(mapAlgebraOgcLayer.parameters()), $this.evidence$3), (Interpreter)ConcurrentInterpreter$.MODULE$.DEFAULT($this.evidence$3), 512, $this.evidence$1, $this.evidence$2, $this.evidence$3, SimpleOgcLayer$.MODULE$.simpleOgcReification($this.evidence$3, $this.evidence$1), SimpleOgcLayer$.MODULE$.simpleOgcHasRasterExtents($this.evidence$3));
            } else {
                throw new MatchError((Object)ogcLayer2);
            }
            Object evalHisto = object;
            Object histIO = package.flatMap$.MODULE$.toFlatMapOps(Sync$.MODULE$.apply($this.evidence$3).delay((Function0 & Serializable & scala.Serializable)() -> this.histoCache().getIfPresent(layer)), $this.evidence$3).flatMap((Function1 & Serializable & scala.Serializable)cached -> {
                Object object;
                Option option = cached;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Validated h = (Validated)some.value();
                    object = ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)h), $this.evidence$3);
                } else if (None$.MODULE$.equals(option)) {
                    object = evalHisto;
                } else {
                    throw new MatchError((Object)option);
                }
                return package.flatMap$.MODULE$.toFlatMapOps(object, $this.evidence$3).flatMap((Function1 & Serializable & scala.Serializable)hist -> package.functor$.MODULE$.toFunctorOps(Sync$.MODULE$.apply($this.evidence$3).delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.histoCache().put(layer, hist)), $this.evidence$3).map((Function1 & Serializable & scala.Serializable)_ -> hist));
            });
            Object res = package.flatMap$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.applicativeError$.MODULE$.catsSyntaxApplicativeError(package.parallel$.MODULE$.catsSyntaxTuple2Parallel(new Tuple2(evalExtent.apply((Object)re.extent(), (Object)OptionIdOps$.MODULE$.some$extension(package.option$.MODULE$.catsSyntaxOptionId((Object)re.cellSize()))), histIO)).parMapN((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Validated validated;
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Validated validated2 = (Validated)tuple2._1();
                    Validated validated3 = (Validated)tuple2._2();
                    if (validated2 instanceof Validated.Valid) {
                        Validated.Valid valid = (Validated.Valid)validated2;
                        MultibandTile mbtile = (MultibandTile)valid.a();
                        if (validated3 instanceof Validated.Valid) {
                            Validated.Valid valid2 = (Validated.Valid)validated3;
                            List hists = (List)valid2.a();
                            return new Validated.Valid((Object)new Tuple2((Object)mbtile, (Object)hists));
                        }
                    }
                }
                if (tuple2 != null && (validated = (Validated)tuple2._1()) instanceof Validated.Invalid) {
                    Validated.Invalid invalid = (Validated.Invalid)validated;
                    NonEmptyList errs = (NonEmptyList)invalid.e();
                    return new Validated.Invalid((Object)errs);
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Validated validated4 = (Validated)tuple2._2();
                if (!(validated4 instanceof Validated.Invalid)) throw new MatchError((Object)tuple2);
                Validated.Invalid invalid = (Validated.Invalid)validated4;
                NonEmptyList errs = (NonEmptyList)invalid.e();
                return new Validated.Invalid((Object)errs);
            }, $this.evidence$2), $this.evidence$3), $this.evidence$3), $this.evidence$3).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Validated validated;
                boolean bl = false;
                Right right = null;
                Either either = x0$2;
                if (either instanceof Right) {
                    Validated.Valid valid;
                    Tuple2 tuple2;
                    bl = true;
                    right = (Right)either;
                    Validated validated2 = (Validated)right.value();
                    if (validated2 instanceof Validated.Valid && (tuple2 = (Tuple2)(valid = (Validated.Valid)validated2).a()) != null) {
                        MultibandTile mbtile = (MultibandTile)tuple2._1();
                        List hists = (List)tuple2._2();
                        byte[] rendered = package$RasterOps$.MODULE$.render$extension(package$.MODULE$.RasterOps((Raster<MultibandTile>)new Raster((CellGrid)mbtile, re.extent())), params.crs(), layer.style(), params.format(), (List<Histogram<Object>>)hists);
                        this.tileCache().put((Object)params, (Object)rendered);
                        return package.functor$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)scala.package$.MODULE$.Right().apply((Object)rendered)), $this.evidence$3), $this.evidence$3).widen();
                    }
                }
                if (bl && (validated = (Validated)right.value()) instanceof Validated.Invalid) {
                    Validated.Invalid invalid = (Validated.Invalid)validated;
                    NonEmptyList errs = (NonEmptyList)invalid.e();
                    return package.functor$.MODULE$.toFunctorOps(package.functor$.MODULE$.toFunctorOps(Logger$.MODULE$.apply($this.evidence$1).debug((Function0 & Serializable & scala.Serializable)() -> errs.toList().toString()), $this.evidence$3).as((Object)scala.package$.MODULE$.Left().apply((Object)new GetMapBadRequest(package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)errs), (Encoder)Encoder$.MODULE$.encodeNonEmptyList(MamlError$.MODULE$.encodeMamlError())).spaces2()))), $this.evidence$3).widen();
                }
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Left left = (Left)either;
                Throwable err = (Throwable)left.value();
                return package.functor$.MODULE$.toFunctorOps(package.functor$.MODULE$.toFunctorOps(Logger$.MODULE$.apply($this.evidence$1).error((Function0 & Serializable & scala.Serializable)() -> geotrellis.server.utils.package$.MODULE$.throwableExtensions(err).stackTraceString()), $this.evidence$3).as((Object)scala.package$.MODULE$.Left().apply((Object)new GetMapInternalServerError(geotrellis.server.utils.package$.MODULE$.throwableExtensions(err).stackTraceString()))), $this.evidence$3).widen();
            });
            return res;
        }, List$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Option option = params.layers().headOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                String layerName = (String)some.value();
                object = package.flatMap$.MODULE$.toFlatMapOps(this.model().sources().find(geotrellis.store.query.package$.MODULE$.withName(layerName)), $this.evidence$3).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
                    Object object;
                    Option option = x$1.headOption();
                    if (option instanceof Some) {
                        MutableArrayTile tile = ArrayTile$.MODULE$.empty((DataType)new IntUserDefinedNoDataCellType(0), 1, 1);
                        Raster raster = new Raster((CellGrid)MultibandTile$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tile[]{tile, tile, tile})), params.boundingBox());
                        object = package.functor$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)scala.package$.MODULE$.Right().apply((Object)package$RasterOps$.MODULE$.render$extension(package$.MODULE$.RasterOps((Raster<MultibandTile>)raster), params.crs(), (Option<OgcStyle>)None$.MODULE$, params.format(), (List<Histogram<Object>>)Nil$.MODULE$))), $this.evidence$3), $this.evidence$3).widen();
                    } else {
                        object = package.functor$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)scala.package$.MODULE$.Left().apply((Object)new GetMapBadRequest(new StringBuilder(42).append("Layer (").append(layerName).append(") not found or CRS (").append(params.crs()).append(") not supported").toString()))), $this.evidence$3), $this.evidence$3).widen();
                    }
                    return object;
                });
            } else if (None$.MODULE$.equals(option)) {
                object = package.functor$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)scala.package$.MODULE$.Left().apply((Object)new GetMapBadRequest("Layer not found (no layer name provided in request)"))), $this.evidence$3), $this.evidence$3).widen();
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        }));
        Option option = this.tileCache().getIfPresent((Object)params);
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] rendered = (byte[])some.value();
            object = package.functor$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension(package.applicative$.MODULE$.catsSyntaxApplicativeId((Object)scala.package$.MODULE$.Right().apply((Object)rendered)), this.evidence$3), this.evidence$3).widen();
        } else {
            object = res;
        }
        return (F)object;
    }

    public <F> GetMap<F> copy(WmsModel<F> model, Cache<WmsParams.GetMapParams, byte[]> tileCache, Cache<OgcLayer, Validated<NonEmptyList<MamlError>, List<Histogram<Object>>>> histoCache, Logger<F> evidence$1, Parallel<F> evidence$2, Concurrent<F> evidence$3, ApplicativeError<F, Throwable> evidence$4) {
        return new GetMap<F>(model, tileCache, histoCache, evidence$1, evidence$2, evidence$3, evidence$4);
    }

    public <F> WmsModel<F> copy$default$1() {
        return this.model();
    }

    public <F> Cache<WmsParams.GetMapParams, byte[]> copy$default$2() {
        return this.tileCache();
    }

    public <F> Cache<OgcLayer, Validated<NonEmptyList<MamlError>, List<Histogram<Object>>>> copy$default$3() {
        return this.histoCache();
    }

    public String productPrefix() {
        return "GetMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        WmsModel<F> wmsModel;
        int n = x$1;
        switch (n) {
            case 0: {
                wmsModel = this.model();
                break;
            }
            case 1: {
                wmsModel = this.tileCache();
                break;
            }
            case 2: {
                wmsModel = this.histoCache();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return wmsModel;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetMap;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetMap getMap = (GetMap)x$1;
        WmsModel<F> wmsModel = this.model();
        WmsModel<F> wmsModel2 = getMap.model();
        if (wmsModel == null) {
            if (wmsModel2 != null) {
                return false;
            }
        } else if (!((Object)wmsModel).equals(wmsModel2)) return false;
        Cache<WmsParams.GetMapParams, byte[]> cache = this.tileCache();
        Cache<WmsParams.GetMapParams, byte[]> cache2 = getMap.tileCache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        Cache<OgcLayer, Validated<NonEmptyList<MamlError>, List<Histogram<Object>>>> cache3 = this.histoCache();
        Cache<OgcLayer, Validated<NonEmptyList<MamlError>, List<Histogram<Object>>>> cache4 = getMap.histoCache();
        if (cache3 == null) {
            if (cache4 != null) {
                return false;
            }
        } else if (!cache3.equals(cache4)) return false;
        if (!getMap.canEqual(this)) return false;
        return true;
    }

    public GetMap(WmsModel<F> model, Cache<WmsParams.GetMapParams, byte[]> tileCache, Cache<OgcLayer, Validated<NonEmptyList<MamlError>, List<Histogram<Object>>>> histoCache, Logger<F> evidence$1, Parallel<F> evidence$2, Concurrent<F> evidence$3, ApplicativeError<F, Throwable> evidence$4) {
        this.model = model;
        this.tileCache = tileCache;
        this.histoCache = histoCache;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
        Product.$init$((Product)this);
    }
}

