/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture;

import android.content.Context;
import com.microsoft.dl.Platform;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.Failure;
import com.microsoft.dl.video.capture.CapturerConfiguration;
import com.microsoft.dl.video.capture.CapturerMode;
import com.microsoft.dl.video.capture.DeviceManager;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CameraParameters;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.FpsRange;
import com.microsoft.dl.video.capture.api.ImageFormat;
import com.microsoft.dl.video.capture.impl.CaptureWorker;
import com.microsoft.dl.video.capture.impl.FpsRangeComparator;
import com.microsoft.dl.video.capture.impl.ResolutionMatcher;
import com.microsoft.dl.video.graphics.GraphicsException;
import com.microsoft.dl.video.utils.Resolution;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

public class Capturer {
    private static final int PERCENT = 100;
    private static final int MILLIS = 1000;
    private static final int FULL_ANGLE = 360;
    private static final int ANGLE_LANDSCAPE_LEFT = 0;
    private static final int ANGLE_PORTRAIT = 90;
    private static final int ANGLE_LANDSCAPE_RIGHT = 180;
    private static final int ANGLE_PORTRAIT_UPSIDEDOWN = 270;
    private static Method sCheckSelfPermissionMethod;
    private static volatile boolean sCheckSelfPermissionMethodDetected;
    private final String debugName;
    private final CameraCapabilities capabilities;
    private final List<CapturerMode> modes;
    private final CaptureWorker worker;
    private final Thread workerThread;
    private State state = State.STOPPED;

    protected Capturer(int index, long nativeContext, CapturerConfiguration parameters, String debugName) throws CaptureException {
        this.debugName = debugName;
        this.capabilities = CameraManagerSingleton.getInstance().getCameraCapabilities(DeviceManager.getInstance().getCameraId(index));
        this.modes = Capturer.evaluateCapturingModes(this.capabilities, parameters, debugName);
        if (Log.isLoggable((String)"Video", (int)4)) {
            int i = 0;
            for (CapturerMode mode : this.modes) {
                Log.i((String)"Video", (String)("Capturing mode " + i++ + ": " + mode + " (" + debugName + ")"));
            }
        }
        this.worker = new CaptureWorker(this.capabilities.getCameraId(), nativeContext, parameters, debugName);
        this.workerThread = new Thread((Runnable)this.worker, "CaptureWorker");
    }

    protected final boolean initialize(long timeoutMs) throws InterruptedException, CaptureException {
        if (!Capturer.hasCameraPermission()) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Initialize failed, no camera permission");
            }
            throw new CaptureException("Could not open the camera by have no camera permission", ErrorCode.ANDROID_CAMERA_NO_PERMISSION);
        }
        this.workerThread.start();
        return this.worker.isOpen(timeoutMs);
    }

    public static Object create(int index, long nativeContext, CapturerConfiguration parameters, String debugName, long timeoutMs) {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Creating the capturer (" + debugName + ")"));
        }
        try {
            Capturer capturer = new Capturer(index, nativeContext, parameters, debugName);
            try {
                if (capturer.initialize(timeoutMs)) {
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)("Capturer created and initialized successfully (" + debugName + ")"));
                    }
                    return capturer;
                }
            }
            catch (InterruptedException e) {
                throw new CaptureException(e, ErrorCode.ANDROID_CAMERA_OPEN_INTERRUPTED);
            }
            throw new CaptureException("Could not open the camera in time", ErrorCode.ANDROID_CAMERA_OPEN_TIMEOUT);
        }
        catch (CaptureException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught ( (" + debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught ( (" + debugName + ")"), (Throwable)e);
            }
            return CaptureException.newRuntimeFailure("Capturer: create runtime error", e).getNativeContext();
        }
    }

    public final synchronized long shutdown(long timeoutMs) {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Shutting down the capturer (" + this.debugName + ")"));
        }
        try {
            if (this.worker != null) {
                this.worker.close();
                if (this.workerThread != null && this.workerThread.isAlive()) {
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)("Waiting until worker thread exit (" + this.debugName + ")"));
                    }
                    try {
                        this.workerThread.join(timeoutMs);
                    }
                    catch (InterruptedException e) {
                        throw new CaptureException(e, ErrorCode.ANDROID_CAMERA_CLOSE_INTERRUPTED);
                    }
                    if (this.workerThread.isAlive()) {
                        throw new CaptureException("Could not close the camera in time", ErrorCode.ANDROID_CAMERA_CLOSE_TIMEOUT);
                    }
                }
            }
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("The capturer shut down successfully (" + this.debugName + ")"));
            }
            return 0L;
        }
        catch (CaptureException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return CaptureException.newRuntimeFailure("Capture: shutdown runtime error", e).getNativeContext();
        }
    }

    public final synchronized int getNumModes() {
        return this.modes.size();
    }

    public final synchronized CapturerMode getMode(int i) {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Calling getMode(" + i + ") on camera (" + this.debugName + ")"));
        }
        if (i < 0 || i >= this.modes.size()) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Thre is no mode #" + i + " (" + this.debugName + ")"));
            }
            return null;
        }
        return this.modes.get(i);
    }

    public final synchronized boolean isRunning() {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Calling isRunning() on camera (" + this.debugName + ")"));
        }
        return this.workerThread.isAlive() && this.state == State.STARTED;
    }

    public final synchronized boolean isFlashUnitAvailable() {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Calling isFlashUnitAvailable() on camera (" + this.debugName + ")"));
        }
        if (this.capabilities.isFlashUnitAvailable()) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Flash Unit Available on camera (" + this.debugName + ")"));
            }
            return true;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Flash Unit Not Available on camera (" + this.debugName + ")"));
        }
        return false;
    }

    public final synchronized long setFlashTorchMode(boolean torchTurnOn) {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Calling setFlashTorchMode(" + torchTurnOn + ") on camera (" + this.debugName + ")"));
        }
        try {
            if (this.capabilities.isFlashUnitAvailable()) {
                this.worker.setFlashTorchMode(torchTurnOn);
                return 0L;
            }
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Camera (" + this.debugName + ") does not support flash."));
            }
            throw new CaptureException("Camera does not support Flash.", ErrorCode.ANDROID_CAPTURER_INVALID_MODE);
        }
        catch (CaptureException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
    }

    public final synchronized boolean isFaceDetectionAvailable() {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Calling isFaceDetectionAvailable() on camera (" + this.debugName + ")"));
        }
        if (this.capabilities.getMaxFaceCount() > 0) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Face detection Available on camera (" + this.debugName + ")"));
            }
            return true;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Face detection Not Available on camera (" + this.debugName + ")"));
        }
        return false;
    }

    public final synchronized long enableFaceDetection(boolean enable) {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Calling setFaceDetectionMode(" + enable + ") on camera (" + this.debugName + ")"));
        }
        try {
            this.worker.enableFaceDetection(enable);
            return 0L;
        }
        catch (CaptureException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
    }

    public final synchronized long startMode(int modeId, int fps, boolean enableFaceDetection) {
        CapturerMode modeResult;
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Calling startMode(modeId:" + modeId + ", fps: " + fps + ") on camera (" + this.debugName + ")"));
        }
        if ((modeResult = this.getMode(modeId)) instanceof Failure) {
            return ((Failure)((Object)modeResult)).getNativeContext();
        }
        CapturerMode mode = modeResult;
        CameraParameters cameraParameters = this.composeParameters(mode, fps);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Starting capturing mode " + modeId + " [" + mode + "], " + (float)fps / 1000.0f + " fps, CameraParameters: " + cameraParameters + " (" + this.debugName + ")"));
        }
        try {
            if (this.state == State.STARTED) {
                if (!this.worker.shouldUpdateParameters(cameraParameters, modeId)) {
                    return 0L;
                }
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Restarting the capturer in order to apply capturing mode change (" + this.debugName + ")"));
                }
                this.worker.stop();
            }
            this.worker.setParameters(cameraParameters, modeId);
            this.worker.setFramerate(fps);
            this.worker.enableFaceDetection(enableFaceDetection);
            this.state = this.worker.start() ? State.STARTED : State.START_REQUESTED_MISSING_PARAM;
            return 0L;
        }
        catch (CaptureException | GraphicsException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return CaptureException.newRuntimeFailure("Capturer: startMode runtime error", e).getNativeContext();
        }
    }

    public final synchronized long stop() {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Stopping capturing (" + this.debugName + ")"));
        }
        try {
            if (this.state != State.STARTED) {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Capturing is already stopped (" + this.debugName + ")"));
                }
            } else {
                this.worker.stop();
            }
            this.state = State.STOPPED;
            return 0L;
        }
        catch (CaptureException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return CaptureException.newRuntimeFailure("Capturer: stop runtime error", e).getNativeContext();
        }
    }

    public final synchronized long setPreview(Object previewDisplay) {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting preview display to " + previewDisplay));
        }
        try {
            if (this.state == State.STARTED) {
                if (!this.worker.shouldUpdatePreviewDisplay(previewDisplay)) {
                    return 0L;
                }
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Restarting the capturer in order to apply preview display change (" + this.debugName + ")"));
                }
                this.worker.stop();
            }
            this.worker.setPreviewDisplay(previewDisplay, false);
            if (this.state != State.STOPPED) {
                this.state = this.worker.start() ? State.STARTED : State.START_REQUESTED_MISSING_PARAM;
            }
            return 0L;
        }
        catch (CaptureException | GraphicsException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return CaptureException.newRuntimeFailure("Capturer: setPreview runtime error", e).getNativeContext();
        }
    }

    public final synchronized long setOffScreenPreview() throws GraphicsException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Calling setOffScreenPreview() on camera (" + this.debugName + ")"));
        }
        try {
            return this.setPreview(this.worker.getOffscreenPreviewSurface());
        }
        catch (GraphicsException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
    }

    public final synchronized long setPreviewOrientation(int angle) {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Calling setPreviewOrientation(angle:" + angle + ") on camera (" + this.debugName + ")"));
        }
        int orientationAngle = this.adjustPreviewOrientation(angle);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting preview display orientation to " + orientationAngle + "/" + angle + " degrees (" + this.debugName + ")"));
        }
        try {
            this.worker.setOrientationAngle(orientationAngle);
            if (this.state == State.START_REQUESTED_MISSING_PARAM) {
                this.state = this.worker.start() ? State.STARTED : State.START_REQUESTED_MISSING_PARAM;
            }
            return 0L;
        }
        catch (CaptureException | GraphicsException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return CaptureException.newRuntimeFailure("Capturer: setPreviewOrientation runtime error", e).getNativeContext();
        }
    }

    public final synchronized long setUseGpuCallback(boolean useGpuCallback) {
        CaptureWorker.CallbackType callbackType;
        CaptureWorker.CallbackType callbackType2 = callbackType = useGpuCallback ? CaptureWorker.CallbackType.GPU : CaptureWorker.CallbackType.CPU;
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting callback type to " + callbackType.name() + " (" + this.debugName + ")"));
        }
        try {
            if (this.state == State.STARTED) {
                if (!this.worker.shouldUpdateCallbackType(callbackType)) {
                    return 0L;
                }
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Restarting the capturer in order to apply callback type change (" + this.debugName + ")"));
                }
                this.worker.stop();
            }
            this.worker.setCallbackType(callbackType);
            if (this.state != State.STOPPED) {
                this.state = this.worker.start() ? State.STARTED : State.START_REQUESTED_MISSING_PARAM;
            }
            return 0L;
        }
        catch (CaptureException | GraphicsException e) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Restarting the capturer in order to apply callback type change (" + this.debugName + ")"), (Throwable)e);
            }
            return new Failure(e).getNativeContext();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            return CaptureException.newRuntimeFailure("Capturer: setUseGpuCallback runtime error", e).getNativeContext();
        }
    }

    private CameraParameters composeParameters(CapturerMode mode, int fps) {
        CameraParameters parameters = new CameraParameters();
        parameters.setImageFormat(mode.getFormat());
        parameters.setResolution(mode.getResolutionTransformation().getFrom());
        parameters.setFpsRange(this.findFpsRange(fps, mode.getFrameRateRanges()));
        if (this.capabilities.getSupportedFocusModes().contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        } else if (this.capabilities.getSupportedFocusModes().contains("continuous-picture")) {
            parameters.setFocusMode("continuous-picture");
        }
        return parameters;
    }

    public FpsRange findFpsRange(int fps, Collection<FpsRange> candidates) {
        FpsRange bestRange = Collections.min(candidates, new FpsRangeComparator(fps));
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Frame rate matching " + (float)fps / 1000.0f + " found: " + bestRange + " fps, candidates: " + candidates + " (" + this.debugName + ")"));
        }
        return bestRange;
    }

    private int adjustPreviewOrientation(int angle) {
        switch (this.capabilities.getFacing()) {
            case FRONT: {
                return angle % 360;
            }
        }
        return (360 - angle) % 360;
    }

    private static boolean hasCameraPermission() {
        boolean result;
        block13: {
            if (!sCheckSelfPermissionMethodDetected) {
                try {
                    Class<?> clazz = Class.forName("androidx.core.content.ContextCompat");
                    sCheckSelfPermissionMethod = clazz.getMethod("checkSelfPermission", Context.class, String.class);
                }
                catch (Exception e) {
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)"Have no android x package with ContextCompat class");
                    }
                    sCheckSelfPermissionMethod = null;
                }
                finally {
                    sCheckSelfPermissionMethodDetected = true;
                }
            }
            result = true;
            if (sCheckSelfPermissionMethod != null) {
                try {
                    Object r = sCheckSelfPermissionMethod.invoke(null, Platform.getInfo().getAppContext(), "android.permission.CAMERA");
                    if (r instanceof Integer) {
                        boolean bl = result = (Integer)r == 0;
                    }
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)("Check permission result=" + r));
                    }
                }
                catch (Exception e) {
                    if (!Log.isLoggable((String)"Video", (int)6)) break block13;
                    Log.e((String)"Video", (String)"Check permission method invoke failed");
                }
            }
        }
        return result;
    }

    private static EnumSet<ResolutionMatcher.TransformationAllowed> getAllowedTransformatios(Set<CapturerConfiguration.TransformationOptions> transformationOptions, boolean isMandatoryResolution) {
        ArrayList<ResolutionMatcher.TransformationAllowed> transformationsAllowed = new ArrayList<ResolutionMatcher.TransformationAllowed>(2);
        if (isMandatoryResolution && transformationOptions.contains((Object)CapturerConfiguration.TransformationOptions.AllowCroppingMandatoryResolutions) || transformationOptions.contains((Object)CapturerConfiguration.TransformationOptions.AllowCroppingAnyResolution)) {
            transformationsAllowed.add(ResolutionMatcher.TransformationAllowed.Cropping);
        }
        if (isMandatoryResolution && transformationOptions.contains((Object)CapturerConfiguration.TransformationOptions.AllowScalingMandatoryResolutions) || transformationOptions.contains((Object)CapturerConfiguration.TransformationOptions.AllowScalingAnyResolution)) {
            transformationsAllowed.add(ResolutionMatcher.TransformationAllowed.AllScaling);
        } else if (isMandatoryResolution && transformationOptions.contains((Object)CapturerConfiguration.TransformationOptions.AllowMultipleScalingMandatoryResolutions) || transformationOptions.contains((Object)CapturerConfiguration.TransformationOptions.AllowMultipleScalingAnyResolution)) {
            transformationsAllowed.add(ResolutionMatcher.TransformationAllowed.MultipleScaling);
        }
        return transformationsAllowed.isEmpty() ? EnumSet.noneOf(ResolutionMatcher.TransformationAllowed.class) : EnumSet.copyOf(transformationsAllowed);
    }

    private static List<CapturerMode> evaluateCapturingModes(CameraCapabilities capabilities, CapturerConfiguration parameters, String debugName) throws CaptureException {
        HashSet<Resolution> cameraResolutions = new HashSet<Resolution>(capabilities.getSupportedResolutions());
        cameraResolutions.removeAll(parameters.getBannedCameraResolution());
        ResolutionMatcher resolutionMatcher = new ResolutionMatcher(cameraResolutions, capabilities.getNativeAspectRatio());
        EnumSet<CapturerMode.Orientation> orientation = Capturer.evaluateOrientation(capabilities.getFacing(), capabilities.getOrientation());
        NavigableSet<FpsRange> fpsRanges = Capturer.filterFpsRanges(parameters.getAbsFpsRange(), capabilities.getSupportedFpsRanges());
        if (fpsRanges.isEmpty()) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("None of the camera fps ranges " + capabilities.getSupportedFpsRanges() + " meets requirements of " + parameters.getAbsFpsRange()));
            }
            return Collections.emptyList();
        }
        FpsRange absFpsRange = Capturer.getAbsRange(fpsRanges);
        ArrayList<CapturerMode> modes = new ArrayList<CapturerMode>();
        for (Map.Entry<Resolution, CapturerConfiguration.ResolutionParameters> outputResolution : parameters.getOutputResolutions()) {
            EnumSet<ResolutionMatcher.TransformationAllowed> allowedTransformations = Capturer.getAllowedTransformatios(parameters.getTransformationOptions(), outputResolution.getValue().isMandatory());
            ResolutionMatcher.ResolutionTransformation resolutionTransformation = resolutionMatcher.findBest(outputResolution.getKey(), outputResolution.getValue().isMandatory() ? Float.POSITIVE_INFINITY : (float)parameters.getMaxTransformationZoom() / 100.0f, outputResolution.getValue().isMandatory() ? Float.POSITIVE_INFINITY : (float)parameters.getMaxTransformationCrop() / 100.0f, allowedTransformations);
            if (resolutionTransformation != null) {
                Set<ImageFormat> imageFormats = Capturer.filterSupportedImageFormats(capabilities.getSupportedImageFormats(), parameters.getCpuImageFormats());
                for (ImageFormat imageFormat : imageFormats) {
                    modes.add(new CapturerMode(resolutionTransformation, imageFormat, orientation, fpsRanges, absFpsRange));
                }
                continue;
            }
            if (!outputResolution.getValue().isMandatory()) continue;
            throw new CaptureException("Coud not support mandaroty resolution " + outputResolution.getKey() + " (" + debugName + ")", ErrorCode.ANDROID_CAPTURER_MISSING_MANDATORY_RESOLUTION);
        }
        return modes;
    }

    private static EnumSet<CapturerMode.Orientation> evaluateOrientation(CameraCapabilities.Facing facing, int mountingAngle) throws CaptureException {
        mountingAngle %= 360;
        switch (facing) {
            case FRONT: {
                switch (mountingAngle) {
                    case 0: {
                        return EnumSet.of(CapturerMode.Orientation.FlippedHorizontally);
                    }
                    case 90: {
                        return EnumSet.of(CapturerMode.Orientation.FlippedVertically, CapturerMode.Orientation.FlippedHorizontally, CapturerMode.Orientation.Transposed);
                    }
                    case 180: {
                        return EnumSet.of(CapturerMode.Orientation.FlippedVertically);
                    }
                    case 270: {
                        return EnumSet.of(CapturerMode.Orientation.Transposed);
                    }
                }
                throw new CaptureException("unsupported mountingAngle=" + mountingAngle, ErrorCode.ANDROID_CAPTURER_INVALID_ORIENTATION);
            }
            case BACK: 
            case EXTERNAL: 
            case OTHER: {
                switch (mountingAngle) {
                    case 0: {
                        return EnumSet.noneOf(CapturerMode.Orientation.class);
                    }
                    case 90: {
                        return EnumSet.of(CapturerMode.Orientation.FlippedVertically, CapturerMode.Orientation.Transposed);
                    }
                    case 180: {
                        return EnumSet.of(CapturerMode.Orientation.FlippedVertically, CapturerMode.Orientation.FlippedHorizontally);
                    }
                    case 270: {
                        return EnumSet.of(CapturerMode.Orientation.FlippedVertically, CapturerMode.Orientation.Transposed);
                    }
                }
                throw new CaptureException("unsupported mountingAngle=" + mountingAngle, ErrorCode.ANDROID_CAPTURER_INVALID_ORIENTATION);
            }
        }
        throw new CaptureException("unsupported facing=" + (Object)((Object)facing), ErrorCode.ANDROID_CAPTURER_INVALID_FACING);
    }

    private static NavigableSet<FpsRange> filterFpsRanges(FpsRange absRange, Iterable<FpsRange> candidates) {
        TreeSet<FpsRange> result = new TreeSet<FpsRange>();
        for (FpsRange candidate : candidates) {
            if (candidate.getMin() < absRange.getMin() || candidate.getMax() > absRange.getMax()) continue;
            result.add(candidate);
        }
        return result;
    }

    private static FpsRange getAbsRange(Collection<FpsRange> ranges) throws CaptureException {
        return new FpsRange(Collections.min(ranges, new Comparator<FpsRange>(){

            @Override
            public int compare(FpsRange left, FpsRange right) {
                return left.getMin() < right.getMin() ? -1 : (left.getMin() > right.getMin() ? 1 : 0);
            }
        }).getMin(), Collections.max(ranges, new Comparator<FpsRange>(){

            @Override
            public int compare(FpsRange left, FpsRange right) {
                return left.getMax() < right.getMax() ? -1 : (left.getMax() > right.getMax() ? 1 : 0);
            }
        }).getMax());
    }

    private static Set<ImageFormat> filterSupportedImageFormats(Set<ImageFormat> capabilities, Set<ImageFormat> parameters) {
        HashSet<ImageFormat> result = new HashSet<ImageFormat>(capabilities);
        result.retainAll(parameters);
        return result;
    }

    static {
        sCheckSelfPermissionMethodDetected = false;
    }

    public static enum State {
        STOPPED,
        START_REQUESTED_MISSING_PARAM,
        STARTED;

    }
}

