/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.capture.api.FpsRange;
import com.microsoft.dl.video.capture.api.ImageFormat;
import com.microsoft.dl.video.utils.Resolution;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class CapturerConfiguration {
    private static final int CPU_IMAGE_FORMAT_MASK_NV12 = 1;
    private static final int CPU_IMAGE_FORMAT_MASK_NV21 = 2;
    private FpsRange absFpsRange;
    private int maxTransformationZoom;
    private int maxTransformationCrop;
    private int numBuffers;
    private boolean useDummyPreviewSurface;
    private boolean useWorkerThread;
    private CameraImplVer cameraImplVer;
    private int faceDataKeepThresholdInMs;
    private final Set<Resolution> bannedCameraResolution = new HashSet<Resolution>();
    private final NavigableMap<Resolution, ResolutionParameters> outputResolutions = new TreeMap<Resolution, ResolutionParameters>();
    private final Set<TransformationOptions> transformationOptions = new HashSet<TransformationOptions>();
    private final Set<ImageFormat> cpuImageFormats = new HashSet<ImageFormat>();
    private final String simpleClassName = this.getClass().getSimpleName();

    public final void setAbsFpsRange(int min, int max) {
        block2: {
            try {
                this.absFpsRange = new FpsRange(min, max);
            }
            catch (RuntimeException e) {
                if (!Log.isLoggable((String)"Video", (int)6)) break block2;
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
        }
    }

    public final void setMaxTransformationZoom(int maxTransformationZoom) {
        this.maxTransformationZoom = maxTransformationZoom;
    }

    public final void setMaxTransformationCrop(int maxTransformationCrop) {
        this.maxTransformationCrop = maxTransformationCrop;
    }

    public final void setNumBuffers(int numBuffers) {
        this.numBuffers = numBuffers;
    }

    public final void setUseDummyPreviewSurface(boolean useDummyPreviewSurface) {
        this.useDummyPreviewSurface = useDummyPreviewSurface;
    }

    public final void setUseWorkerThread(boolean useWorkerThread) {
        this.useWorkerThread = useWorkerThread;
    }

    public final void setCameraImplVer(int cameraVer) {
        switch (cameraVer) {
            case 2: {
                this.cameraImplVer = CameraImplVer.CAMERA_2;
                break;
            }
            case 3: {
                this.cameraImplVer = CameraImplVer.CAMERA_X;
                break;
            }
            default: {
                this.cameraImplVer = CameraImplVer.CAMERA_1;
            }
        }
    }

    public final void setFaceDataKeepThresholdInMs(int faceDataKeepThresholdInMs) {
        this.faceDataKeepThresholdInMs = faceDataKeepThresholdInMs;
    }

    public final boolean addOutputResolution(int width, int height, boolean isMandatory) {
        try {
            this.outputResolutions.put(new Resolution(width, height), new ResolutionParameters(isMandatory));
            return true;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return false;
        }
    }

    public final boolean banCameraResolution(int width, int height) {
        try {
            this.bannedCameraResolution.add(new Resolution(width, height));
            return true;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return false;
        }
    }

    public final boolean addTransformationOption(int option) {
        try {
            this.transformationOptions.add(TransformationOptions.values()[option]);
            return true;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return false;
        }
    }

    public final void setCpuImageFormats(int formats) {
        this.cpuImageFormats.clear();
        if ((formats & 1) != 0) {
            this.cpuImageFormats.add(ImageFormat.NV12);
        }
        if ((formats & 2) != 0) {
            this.cpuImageFormats.add(ImageFormat.NV21);
        }
    }

    public final FpsRange getAbsFpsRange() {
        return this.absFpsRange;
    }

    public final int getMaxTransformationZoom() {
        return this.maxTransformationZoom;
    }

    public final int getMaxTransformationCrop() {
        return this.maxTransformationCrop;
    }

    public final int getNumBuffers() {
        return this.numBuffers;
    }

    public final boolean isUseDummyPreviewSurface() {
        return this.useDummyPreviewSurface;
    }

    public final boolean isUsingWorkerThread() {
        return this.useWorkerThread;
    }

    public final CameraImplVer getCameraImplVer() {
        return this.cameraImplVer;
    }

    public final Iterable<Map.Entry<Resolution, ResolutionParameters>> getOutputResolutions() {
        return this.outputResolutions.entrySet();
    }

    public final Set<Resolution> getBannedCameraResolution() {
        return this.bannedCameraResolution;
    }

    public final Set<TransformationOptions> getTransformationOptions() {
        return this.transformationOptions;
    }

    public final int getFaceDataKeepThresholdInMs() {
        return this.faceDataKeepThresholdInMs;
    }

    public final Set<ImageFormat> getCpuImageFormats() {
        return this.cpuImageFormats;
    }

    public final String toString() {
        return this.simpleClassName + " [absFpsRange=" + this.absFpsRange + ", maxTransformationZoom=" + this.maxTransformationZoom + ", maxTransformationCrop=" + this.maxTransformationCrop + ", outputResolutions=" + this.outputResolutions + ", numBuffers=" + this.numBuffers + ", bannedCameraResolution=" + this.bannedCameraResolution + ", transformationOptions=" + this.transformationOptions + ", useDummyPreviewSurface=" + this.useDummyPreviewSurface + ", useWorkerThread=" + this.useWorkerThread + ", cameraImplVer=" + (Object)((Object)this.cameraImplVer) + ", faceDataKeepThresholdInMs=" + this.faceDataKeepThresholdInMs + ", cpuImageFormats=" + this.cpuImageFormats + "]";
    }

    public static class ResolutionParameters {
        private final boolean isMandatory;

        public ResolutionParameters(boolean isMandatory) {
            this.isMandatory = isMandatory;
        }

        public final boolean isMandatory() {
            return this.isMandatory;
        }

        public final String toString() {
            return this.isMandatory ? "mandatory" : "optional";
        }
    }

    public static enum CameraImplVer {
        CAMERA_1,
        CAMERA_2,
        CAMERA_X;

    }

    public static enum TransformationOptions {
        AllowCroppingMandatoryResolutions,
        AllowMultipleScalingMandatoryResolutions,
        AllowScalingMandatoryResolutions,
        AllowCroppingAnyResolution,
        AllowMultipleScalingAnyResolution,
        AllowScalingAnyResolution;

    }
}

