/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.api;

import com.microsoft.dl.video.capture.api.FpsRange;
import com.microsoft.dl.video.capture.api.ImageFormat;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import com.microsoft.dl.video.utils.Resolution;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;

public class CameraCapabilities
extends StaticCameraCapabilities {
    private NavigableSet<ImageFormat> supportedImageFormats;
    private NavigableSet<Resolution> supportedResolutions;
    private NavigableSet<FpsRange> supportedFpsRanges;
    private NavigableSet<String> supportedFocusModes;
    private NavigableSet<Integer> supportedFaceDetectModes;
    private int maxFaceCount;
    private boolean isFlashUnitAvailable;
    private float nativeAspectRatio;
    private final String simpleClassName = this.getClass().getSimpleName();

    public final NavigableSet<ImageFormat> getSupportedImageFormats() {
        return this.supportedImageFormats;
    }

    public final void setSupportedImageFormats(NavigableSet<ImageFormat> supportedImageFormats) {
        this.supportedImageFormats = supportedImageFormats;
    }

    public final NavigableSet<Resolution> getSupportedResolutions() {
        return this.supportedResolutions;
    }

    public final void setSupportedResolutions(NavigableSet<Resolution> supportedResolutions) {
        this.supportedResolutions = supportedResolutions;
    }

    public final NavigableSet<FpsRange> getSupportedFpsRanges() {
        return this.supportedFpsRanges;
    }

    public final void setSupportedFpsRanges(NavigableSet<FpsRange> supportedFpsRanges) {
        this.supportedFpsRanges = supportedFpsRanges;
    }

    public final NavigableSet<String> getSupportedFocusModes() {
        return this.supportedFocusModes;
    }

    public final void setSupportedFocusModes(NavigableSet<String> supportedFocusModes) {
        this.supportedFocusModes = supportedFocusModes;
    }

    public final boolean isFlashUnitAvailable() {
        return this.isFlashUnitAvailable;
    }

    public final void setFlashUnitAvailability(boolean isFlashUnitAvailable) {
        this.isFlashUnitAvailable = isFlashUnitAvailable;
    }

    public final float getNativeAspectRatio() {
        return this.nativeAspectRatio;
    }

    public final void setNativeAspectRatio(float nativeAspectRatio) {
        this.nativeAspectRatio = nativeAspectRatio;
    }

    public final NavigableSet<Integer> getSupportedFaceDetectModes() {
        return this.supportedFaceDetectModes;
    }

    public final void setSupportedFaceDetectModes(NavigableSet<Integer> supportedFaceDetectModes) {
        this.supportedFaceDetectModes = supportedFaceDetectModes;
    }

    public int getMaxFaceCount() {
        return this.maxFaceCount;
    }

    public void setMaxFaceCount(int maxFaceCount) {
        this.maxFaceCount = maxFaceCount;
    }

    @Override
    public final CameraCapabilities clone() {
        CameraCapabilities clone = (CameraCapabilities)super.clone();
        clone.supportedImageFormats = new TreeSet<ImageFormat>((SortedSet<ImageFormat>)this.supportedImageFormats);
        clone.supportedResolutions = new TreeSet<Resolution>((SortedSet<Resolution>)this.supportedResolutions);
        clone.supportedFpsRanges = new TreeSet<FpsRange>((SortedSet<FpsRange>)this.supportedFpsRanges);
        clone.supportedFocusModes = new TreeSet<String>((SortedSet<String>)this.supportedFocusModes);
        clone.supportedFaceDetectModes = new TreeSet<Integer>((SortedSet<Integer>)this.supportedFaceDetectModes);
        clone.maxFaceCount = this.maxFaceCount;
        clone.isFlashUnitAvailable = this.isFlashUnitAvailable;
        return clone;
    }

    @Override
    public final String toString() {
        String desc = this.simpleClassName + " [cameraId=" + this.cameraId + ", facing=" + (Object)((Object)this.facing) + ", orientation=" + this.orientation + ", supportedImageFormats=" + this.supportedImageFormats + ", supportedResolutions=" + this.supportedResolutions + ", supportedFpsRanges=" + this.supportedFpsRanges + ", supportedFocusModes=" + this.supportedFocusModes + ", isFlashUnitAvailable=" + this.isFlashUnitAvailable + ", nativeAspectRatio=" + this.nativeAspectRatio + ", supportedFaceDetectModes=" + this.supportedFaceDetectModes + ", maxFaceCount=" + this.maxFaceCount;
        desc = this.isHDMIIngestionCamera ? desc + ", HDMI Ingestion Camera" : (this.smartCameraType == SmartCameraType.INVALID ? desc + ", Normal Camera" : desc + ", Smart Camera [Type=" + (Object)((Object)this.smartCameraType) + ", IntelliFrameIndex=" + this.intelliFrameIndex + ", ExtensionVerion=" + this.extensionVersion + ", DriverVersion=" + this.driverVersion + "]");
        desc = desc + "]";
        return desc;
    }

    public static enum SmartCameraType {
        INVALID,
        ACTIVE_SPEAKER,
        INTELLI_FRAME,
        ROOM_VIEW;


        public static SmartCameraType fromInteger(int type) {
            switch (type) {
                case 1: {
                    return ACTIVE_SPEAKER;
                }
                case 2: {
                    return INTELLI_FRAME;
                }
                case 3: {
                    return ROOM_VIEW;
                }
            }
            return INVALID;
        }
    }

    public static enum Facing {
        BACK,
        FRONT,
        EXTERNAL,
        OTHER;

    }
}

