/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.api;

import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.ErrorCodeException;
import com.microsoft.dl.video.Failure;

public final class CaptureException
extends ErrorCodeException {
    private static final long serialVersionUID = 1L;
    private String generatedErrorInfo = null;

    public CaptureException(String detailMessage, ErrorCode errorCode) {
        super(detailMessage, errorCode, null);
    }

    public CaptureException(String detailMessage, Throwable throwable, ErrorCode errorCode) {
        super(detailMessage, throwable, errorCode, null);
    }

    public CaptureException(Throwable throwable, ErrorCode errorCode) {
        super(null, throwable, errorCode, null);
    }

    @Override
    public synchronized String getErrorInfo() {
        if (this.generatedErrorInfo == null) {
            String message = this.getMessage();
            if (message == null) {
                message = "ln" + Integer.toString(CaptureException.getLineNumber(this.getStackTrace(), 0));
            }
            String cause = this.getCause() == null ? null : this.getCause().toString();
            String tag = CaptureException.getClassNameAndMethod(this.getStackTrace(), 0);
            this.generatedErrorInfo = CaptureException.formatErrorInfo(message, cause, tag);
        }
        return this.generatedErrorInfo;
    }

    public static Failure newRuntimeFailure(String message, RuntimeException exception) {
        return new Failure(new CaptureException(message, exception, ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE));
    }

    private static String formatErrorInfo(String message, String cause, String tag) {
        StringBuilder sb = new StringBuilder();
        sb.append("Message: ").append(message != null ? message : "null");
        sb.append(", Location: ").append(tag != null ? tag : "null");
        sb.append(", Cause: ").append(cause != null ? cause : "null");
        return sb.toString();
    }

    private static int getLineNumber(StackTraceElement[] elems, int depth) {
        if (depth < 0 || elems.length <= depth) {
            return -1;
        }
        StackTraceElement elem = elems[depth];
        if (elem == null) {
            return -2;
        }
        return elem.getLineNumber();
    }

    private static String getClassNameAndMethod(StackTraceElement[] elems, int depth) {
        if (depth < 0 || elems.length <= depth) {
            return "stackTraceElement outOfRange: depth=" + depth + " total_depth=" + elems.length;
        }
        StackTraceElement elem = elems[depth];
        if (elem == null) {
            return "stackTraceElement == null";
        }
        String className = elem.getClassName();
        int lastIndex = className.lastIndexOf(46);
        return new StringBuilder(className.subSequence(lastIndex + 1, className.length())).append('.').append(elem.getMethodName()).toString();
    }
}

