/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.api;

import com.microsoft.dl.video.utils.Resolution;

public enum ImageFormat {
    YV12("YV12", 12),
    NV12("NV12", 12),
    NV21("NV21", 12),
    NV16("NV16", 16),
    YUY2("YUY2", 16);

    private static final int YV12_PADDING_BITS = 4;
    private final String name;
    private final int fourCC;
    private final int bitsPerPixel;

    private ImageFormat(String s, int bitsPerPixel) {
        this.name = s;
        this.fourCC = ImageFormat.strToFourCC(s);
        this.bitsPerPixel = bitsPerPixel;
    }

    private static int strToFourCC(String str) {
        int n = 0;
        for (int i = str.length() - 1; i >= 0; --i) {
            n <<= 8;
            n |= str.charAt(i);
        }
        return n;
    }

    public int getFourCC() {
        return this.fourCC;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getSampleSize(Resolution resolution) {
        switch (this) {
            case YV12: {
                int stride = resolution.getWidth() % 16 > 0 ? (resolution.getWidth() >> 4) + 1 << 4 : resolution.getWidth();
                return stride * resolution.getHeight() * this.bitsPerPixel / 8;
            }
        }
        return resolution.getNumPixels() * this.bitsPerPixel / 8;
    }

    public final String toString() {
        return this.name;
    }
}

