/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.api;

import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraRect;

public class StaticCameraCapabilities
implements Cloneable {
    private final String simpleClassName = this.getClass().getSimpleName();
    protected String cameraId;
    protected CameraCapabilities.Facing facing;
    protected int orientation;
    protected CameraRect cameraArraySize;
    protected String friendlyName;
    protected String manufacturer;
    protected String model;
    protected int pid;
    protected int vid;
    protected boolean isHDMIIngestionCamera = false;
    protected CameraCapabilities.SmartCameraType smartCameraType = CameraCapabilities.SmartCameraType.INVALID;
    protected int intelliFrameIndex = 0;
    protected int extensionVersion = 0;
    protected int driverVersion = 0;

    public final boolean getIsHDMIIngestionCamera() {
        return this.isHDMIIngestionCamera;
    }

    public final void setIsHDMIIngestionCamera(boolean isHDMIIngestionCamera) {
        this.isHDMIIngestionCamera = isHDMIIngestionCamera;
    }

    public final String getCameraId() {
        return this.cameraId;
    }

    public final void setCameraId(String cameraId) {
        this.cameraId = cameraId;
    }

    public final CameraCapabilities.Facing getFacing() {
        return this.facing;
    }

    public final void setFacing(CameraCapabilities.Facing facing) {
        this.facing = facing;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public final void setFriendlyName(String name) {
        this.friendlyName = name;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public final String getManufacturer() {
        return this.manufacturer;
    }

    public final void setModel(String model) {
        this.model = model;
    }

    public final String getModel() {
        return this.model;
    }

    public final void setPid(int pid) {
        this.pid = pid;
    }

    public final int getPid() {
        return this.pid;
    }

    public final void setVid(int vid) {
        this.vid = vid;
    }

    public final int getVid() {
        return this.vid;
    }

    public final CameraCapabilities.SmartCameraType getSmartCameraType() {
        return this.smartCameraType;
    }

    public final void setSmartCameraType(CameraCapabilities.SmartCameraType type) {
        this.smartCameraType = type;
    }

    public final int getSmartCameraExtensionVersion() {
        return this.extensionVersion;
    }

    public final void setSmartCameraExtensionVersion(int version) {
        this.extensionVersion = version;
    }

    public final int getSmartCameraDriverVersion() {
        return this.driverVersion;
    }

    public final void setSmartCameraDriverVersion(int version) {
        this.driverVersion = version;
    }

    public final int getSmartCameraIntelliFrameIndex() {
        return this.intelliFrameIndex;
    }

    public final void setSmartCameraIntelliFrameIndex(int index) {
        this.intelliFrameIndex = index;
    }

    public final CameraRect getCameraArraySize() {
        return this.cameraArraySize;
    }

    public final void setCameraArraySize(CameraRect cameraArraySize) {
        this.cameraArraySize = cameraArraySize;
    }

    public StaticCameraCapabilities clone() {
        try {
            StaticCameraCapabilities clone = (StaticCameraCapabilities)super.clone();
            clone.cameraArraySize = this.cameraArraySize == null ? null : (CameraRect)this.cameraArraySize.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        String desc = this.simpleClassName + " [cameraId=" + this.cameraId + ", facing=" + (Object)((Object)this.facing) + ", orientation=" + this.orientation + ", cameraArraySize=" + this.cameraArraySize;
        desc = this.isHDMIIngestionCamera ? desc + ", HDMI Ingestion Camera" : (this.smartCameraType == CameraCapabilities.SmartCameraType.INVALID ? desc + ", Normal Camera" : desc + ", Smart Camera [Type=" + (Object)((Object)this.smartCameraType) + ", IntelliFrameIndex=" + this.intelliFrameIndex + ", ExtensionVerion=" + this.extensionVersion + ", DriverVersion=" + this.driverVersion + "]");
        desc = desc + "]";
        return desc;
    }
}

