/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import com.microsoft.dl.utils.Clock;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.utils.Systrace;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.ErrorCodeException;
import com.microsoft.dl.video.Failure;
import com.microsoft.dl.video.capture.CapturerConfiguration;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCallback;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CameraParameters;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.impl.OffscreenPreviewSurface;
import com.microsoft.dl.video.capture.impl.PassthroughPreviewSurface;
import com.microsoft.dl.video.capture.impl.TextureRender;
import com.microsoft.dl.video.graphics.GraphicsException;
import com.microsoft.dl.video.utils.Resolution;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class CaptureWorker
implements Runnable,
CameraCallback,
Closeable {
    public static final int FULL_ANGLE = 360;
    public static final int RIGHT_ANGLE = 90;
    private static final int MILLIS = 1000;
    private static final int ANGLE_LANDSCAPE_LEFT = 0;
    private static final int ANGLE_PORTRAIT = 90;
    private static final int ANGLE_LANDSCAPE_RIGHT = 180;
    private static final int ANGLE_PORTRAIT_UPSIDEDOWN = 270;
    private static final long TIMEOUT_MILLIS = 500L;
    private final String debugName;
    private final String cameraId;
    private final int numBuffers;
    private final long nativeContext;
    private final boolean useAutoOffscreenPreviewSurface;
    private final CapturerConfiguration.CameraImplVer cameraImplVer;
    private final Object offscreenPreviewSurfaceLock = new Object();
    private OffscreenPreviewSurface offscreenPreviewSurface;
    private final Object passthroughPreviewSurfaceLock = new Object();
    private PassthroughPreviewSurface passthroughPreviewSurface;
    private final Object cameraStateMonitor = new Object();
    private Camera camera;
    private boolean cameraStarted;
    private Looper looper;
    private Handler handler = null;
    private boolean useWorkerThread = false;
    private volatile CaptureException exception;
    private CameraParameters parameters;
    private Object previewDisplay;
    private Object externalPreviewDisplay;
    private int orientationAngle = -1;
    private Orientation orientation;
    private CallbackType callbackType = CallbackType.CPU;
    private final Object callbackTypeMonitor = new Object();
    private int framerate = -1;
    private int modeId = -1;
    private TextureRender m_textureRender = null;
    private boolean isPreviewOffScreen = true;
    private final Object faceInfoLock = new Object();
    private final int faceDataKeepingThresholdInMs;
    private List<float[]> faceInfos = null;
    private boolean faceInfoConsumedOnce = false;
    private volatile long lastFaceDetectedTimestamp = 0L;
    private volatile boolean enableFaceDetection = false;

    private static native void onCpuFrameCaptured(byte[] var0, long var1, int var3, boolean var4, boolean var5, boolean var6, float[][] var7, long var8);

    private static native void onCpuFrameCaptured2(ByteBuffer var0, int var1, ByteBuffer var2, ByteBuffer var3, int var4, int var5, long var6, int var8, boolean var9, boolean var10, boolean var11, float[][] var12, long var13);

    private static native void onGpuFrameCaptured(int var0, int var1, long var2, int var4, boolean var5, boolean var6, boolean var7, float[][] var8, long var9);

    private static native void onGpuFrameDropped(long var0);

    private static native void onCapturingFailed(long var0, long var2);

    public CaptureWorker(String cameraId, long nativeContext, CapturerConfiguration parameters, String debugName) {
        this.debugName = debugName;
        this.cameraId = cameraId;
        this.numBuffers = parameters.getNumBuffers();
        this.nativeContext = nativeContext;
        this.useAutoOffscreenPreviewSurface = parameters.isUseDummyPreviewSurface();
        this.useWorkerThread = parameters.isUsingWorkerThread();
        this.cameraImplVer = parameters.getCameraImplVer();
        this.faceDataKeepingThresholdInMs = parameters.getFaceDataKeepThresholdInMs();
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Starting  CaptureWorker with debugName=[" + debugName + "], cameraId=[" + cameraId + "], numBuffers=[" + this.numBuffers + "], nativeContext=[" + nativeContext + "], useAutoOffscreenPreviewSurface=[" + this.useAutoOffscreenPreviewSurface + "], cameraImplVer=[" + (Object)((Object)this.cameraImplVer) + "], faceDataKeepingThresholdInMs=[" + this.faceDataKeepingThresholdInMs + "], useWorkerThread=[" + this.useWorkerThread + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpen(long timeoutMs) throws InterruptedException, CaptureException {
        Object object = this.cameraStateMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (this.camera == null) {
                if (this.exception != null) {
                    CaptureException exception = this.exception;
                    this.exception = null;
                    throw exception;
                }
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"camera open timed out.");
                    }
                    return false;
                }
                this.cameraStateMonitor.wait(waitMs);
            }
            return true;
        }
    }

    public boolean shouldUpdateParameters(CameraParameters parameters, int modeId) throws CaptureException {
        if (parameters == null || modeId < 0) {
            throw new CaptureException("parameters must not be null and modeId must be non-negative", ErrorCode.ANDROID_CAPTURER_INVALID_CAMERA_PARAMETERS);
        }
        if (!parameters.equals(this.parameters) || modeId != this.modeId) {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"shouldUpdateParameters: true");
            }
            return true;
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"shouldUpdateParameters: flase");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(CameraParameters parameters, int modeId) throws CaptureException {
        if (!this.shouldUpdateParameters(parameters, modeId)) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Skip Setting capture worker(" + this.debugName + "): parameters=[" + parameters + "], modeId=" + modeId));
            }
            return;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting capture worker(" + this.debugName + "): parameters=[" + parameters + "], modeId=" + modeId));
        }
        Object object = this.cameraStateMonitor;
        synchronized (object) {
            if (this.camera == null) {
                throw new CaptureException("camera is not open", ErrorCode.ANDROID_CAPTURER_CAMERA_NOT_OPEN);
            }
            this.camera.setParameters(parameters);
        }
        this.parameters = parameters;
        this.modeId = modeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlashTorchMode(boolean torchTurnOn) throws CaptureException {
        if (this.parameters.getFlashTorchMode() == torchTurnOn) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Skip Setting capture worker(" + this.debugName + "): torchTurnOn=[" + torchTurnOn + "]"));
            }
            return;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting capture worker(" + this.debugName + "): torchTurnOn=[" + torchTurnOn + "]"));
        }
        Object object = this.cameraStateMonitor;
        synchronized (object) {
            if (this.camera == null) {
                if (Log.isLoggable((String)"Video", (int)5)) {
                    Log.w((String)"Video", (String)"camera is not open.");
                }
                throw new CaptureException("can not set flash torch [" + torchTurnOn + "], on unopened camera.", ErrorCode.ANDROID_CAPTURER_CAMERA_NOT_OPEN);
            }
            this.camera.setFlashTorchMode(torchTurnOn);
            this.parameters.setFlashTorchMode(torchTurnOn);
        }
    }

    private boolean shouldUpdateFramerate(int framerate) throws CaptureException {
        if (framerate < 0) {
            throw new CaptureException("framerate must be non-negative", ErrorCode.ANDROID_CAPTURER_INVALID_FRAME_RATE);
        }
        return framerate != this.framerate;
    }

    public void setFramerate(int framerate) throws CaptureException {
        if (!this.shouldUpdateFramerate(framerate)) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Skip Setting capture worker(" + this.debugName + "): framerate=" + (float)framerate / 1000.0f));
            }
            return;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting capture worker(" + this.debugName + "): framerate=" + (float)framerate / 1000.0f));
        }
        this.framerate = framerate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableFaceDetection(boolean enableFaceDetection) throws CaptureException {
        if (this.camera != null) {
            this.camera.enableFaceDetection(enableFaceDetection);
            this.enableFaceDetection = enableFaceDetection;
            Object object = this.faceInfoLock;
            synchronized (object) {
                if (enableFaceDetection && this.faceInfos == null) {
                    this.faceInfos = new ArrayList<float[]>();
                } else if (!enableFaceDetection && this.faceInfos != null) {
                    this.faceInfos.clear();
                    this.faceInfos = null;
                }
            }
        } else if (Log.isLoggable((String)"Video", (int)6)) {
            Log.e((String)"Video", (String)("Setting capture worker(" + this.debugName + "): setFaceDetectionMode=" + enableFaceDetection + " failed, cause camera not initialized!"));
        }
    }

    public boolean shouldUpdatePreviewDisplay(Object previewDisplay) throws GraphicsException {
        Object currentPreviewDisplay;
        Object object = currentPreviewDisplay = this.callbackType == CallbackType.GPU ? this.getPassthroughPreviewSurface().getExternalPreviewDisplay() : this.previewDisplay;
        return previewDisplay != currentPreviewDisplay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviewDisplay(Object previewDisplay, boolean isPreviewOffScreen) throws CaptureException, GraphicsException {
        if (!this.shouldUpdatePreviewDisplay(previewDisplay)) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Skip Setting capture worker(" + this.debugName + "): previewDisplay=" + previewDisplay + "<-" + this.previewDisplay + ", isPreviewOffScreen=" + isPreviewOffScreen + "<-" + this.isPreviewOffScreen));
            }
            return;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting capture worker(" + this.debugName + "): previewDisplay=" + previewDisplay + "<-" + this.previewDisplay + ", isPreviewOffScreen=" + isPreviewOffScreen + "<-" + this.isPreviewOffScreen));
        }
        this.isPreviewOffScreen = isPreviewOffScreen;
        Object object = this.cameraStateMonitor;
        synchronized (object) {
            if (this.camera == null) {
                throw new CaptureException("camera is not open", ErrorCode.ANDROID_CAPTURER_CAMERA_NOT_OPEN);
            }
            if (this.callbackType == CallbackType.GPU && !isPreviewOffScreen) {
                this.camera.setPreviewDisplay(null);
                PassthroughPreviewSurface passthroughPreviewSurface = this.getPassthroughPreviewSurface();
                passthroughPreviewSurface.allocSurfaceTexture(previewDisplay);
                previewDisplay = passthroughPreviewSurface.getSurfaceTexture();
            }
            this.camera.setPreviewDisplay(previewDisplay);
        }
        this.previewDisplay = previewDisplay;
    }

    private boolean shouldUpdateOrientationAngle(int orientationAngle) throws CaptureException {
        if (orientationAngle < 0 || orientationAngle % 90 > 0) {
            throw new CaptureException("orientationAngle must be non-negative and divisible by 90", ErrorCode.ANDROID_CAPTURER_INVALID_ORIENTATION);
        }
        return orientationAngle != this.orientationAngle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrientationAngle(int orientationAngle) throws CaptureException {
        if (!this.shouldUpdateOrientationAngle(orientationAngle)) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Skip Setting capture worker(" + this.debugName + "): orientationAngle=" + orientationAngle + " <- " + this.orientationAngle));
            }
            return;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting capture worker(" + this.debugName + "): orientationAngle=" + orientationAngle + " <- " + this.orientationAngle));
        }
        Object object = this.cameraStateMonitor;
        synchronized (object) {
            if (this.camera == null) {
                throw new CaptureException("camera is not open", ErrorCode.ANDROID_CAPTURER_CAMERA_NOT_OPEN);
            }
            this.camera.setDisplayOrientation(orientationAngle);
        }
        this.orientationAngle = orientationAngle;
        this.orientation = Orientation.values()[orientationAngle % 360 / 90];
    }

    public boolean shouldUpdateCallbackType(CallbackType callbackType) {
        return callbackType != this.callbackType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallbackType(CallbackType callbackType) throws CaptureException, GraphicsException {
        if (!this.shouldUpdateCallbackType(callbackType)) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Skip Setting capture worker(" + this.debugName + "): callbackType=" + callbackType.name() + " <- " + this.callbackType.name()));
            }
            return;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting capture worker(" + this.debugName + "): callbackType=" + callbackType.name() + " <- " + this.callbackType.name()));
        }
        if (callbackType == CallbackType.GPU) {
            Object object = this.callbackTypeMonitor;
            synchronized (object) {
                this.callbackType = callbackType;
            }
            this.setPreviewDisplay(this.previewDisplay, this.isPreviewOffScreen);
        } else {
            Object object = this.callbackTypeMonitor;
            synchronized (object) {
                this.callbackType = callbackType;
            }
            PassthroughPreviewSurface passthroughPreviewSurface = this.getPassthroughPreviewSurface();
            Object externalPreviewDisplay = passthroughPreviewSurface.getExternalPreviewDisplay();
            passthroughPreviewSurface.releaseSurfaceTexture();
            this.setPreviewDisplay(externalPreviewDisplay, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() throws CaptureException, GraphicsException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Starting capture worker(" + this.debugName + "): parameters=[" + this.parameters + "], modeId=" + this.modeId + ", framerate=" + (float)this.framerate / 1000.0f + ", orientationAngle=" + this.orientationAngle + ", previewDisplay=" + this.previewDisplay));
        }
        if (this.parameters == null) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Capture worker was not started, parameters are not set (" + this.debugName + ")"));
            }
            return false;
        }
        if (this.modeId < 0) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Capture worker was not started, modeId is not set (" + this.debugName + ")"));
            }
            return false;
        }
        if (this.framerate < 0) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Capture worker was not started, framerate is not set (" + this.debugName + ")"));
            }
            return false;
        }
        if (this.orientationAngle < 0) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("OrientationAngle is not set, defaulting to 0 (" + this.debugName + ")"));
            }
            this.setOrientationAngle(0);
        }
        if (this.previewDisplay == null) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("previewDisplay is NULL (" + this.debugName + ")"));
            }
            if (this.useAutoOffscreenPreviewSurface) {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Using auto offscreen preview surface (" + this.debugName + ")"));
                }
                this.setPreviewDisplay(this.getOffscreenPreviewSurface(), true);
            } else if (this.cameraImplVer == CapturerConfiguration.CameraImplVer.CAMERA_1) {
                if (Log.isLoggable((String)"Video", (int)5)) {
                    Log.w((String)"Video", (String)("Capture worker was not started, camera 1 preview surface is not set (" + this.debugName + ")"));
                }
                return false;
            }
        }
        if (this.usingBufferMode()) {
            this.camera.prepareBuffers(this.numBuffers);
        }
        try {
            if (this.isOpen(500L)) {
                Object object = this.cameraStateMonitor;
                synchronized (object) {
                    if (this.camera == null) {
                        throw new CaptureException("camera is not open", ErrorCode.ANDROID_CAPTURER_CAMERA_NOT_OPEN);
                    }
                    this.camera.setCallback(this, this.usingBufferMode());
                    this.camera.startPreview();
                    this.cameraStarted = true;
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)("Capture worker started (" + this.debugName + ")"));
                    }
                    return true;
                }
            }
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Camera not open in given time (500)");
            }
        }
        catch (InterruptedException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"camera is not open, throwing  InterruptedException");
            }
            throw new CaptureException(e, ErrorCode.ANDROID_CAMERA_OPEN_INTERRUPTED);
        }
        if (Log.isLoggable((String)"Video", (int)6)) {
            Log.e((String)"Video", (String)("Capture worker start failed (" + this.debugName + ")"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Stopping capture worker (" + this.debugName + ")"));
        }
        Object object = this.cameraStateMonitor;
        synchronized (object) {
            if (this.camera == null) {
                if (Log.isLoggable((String)"Video", (int)5)) {
                    Log.w((String)"Video", (String)("Capture worker has no open camera (" + this.debugName + ")"));
                }
                return;
            }
            this.cameraStarted = false;
            this.camera.setCallback(null, this.usingBufferMode());
            this.camera.stopPreview();
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Capture worker stopped (" + this.debugName + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Closing capture worker (" + this.debugName + ")"));
        }
        Object object = this.cameraStateMonitor;
        synchronized (object) {
            if (this.looper != null) {
                this.looper.quit();
                this.looper = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Camera camera = null;
        CaptureException exception = null;
        try {
            try {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Entering thread proc (" + this.debugName + ")"));
                }
                Looper.prepare();
                camera = CameraManagerSingleton.getInstance().openCamera(this.cameraId);
            }
            catch (CaptureException e) {
                exception = e;
            }
            catch (RuntimeException e) {
                exception = new CaptureException(e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
            }
            Object e = this.cameraStateMonitor;
            synchronized (e) {
                this.camera = camera;
                this.exception = exception;
                this.looper = Looper.myLooper();
                if (this.useWorkerThread) {
                    this.handler = new Handler(this.looper);
                    Log.i((String)"Video", (String)("Handler prepared for worker thread. (" + this.debugName + ")"));
                }
                this.cameraStateMonitor.notifyAll();
            }
            Looper.loop();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            CaptureWorker.onCapturingFailed(new Failure(new CaptureException(e, ErrorCode.ANDROID_UNCHECKED_EXCEPTION)).getNativeContext(), this.nativeContext);
        }
        finally {
            try {
                Object e = this.cameraStateMonitor;
                synchronized (e) {
                    this.camera = null;
                    if (camera != null) {
                        camera.close();
                    }
                    this.cameraStateMonitor.notifyAll();
                }
            }
            catch (CaptureException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
                }
                CaptureWorker.onCapturingFailed(new Failure(e).getNativeContext(), this.nativeContext);
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
                }
                CaptureWorker.onCapturingFailed(new Failure(new CaptureException(e, ErrorCode.ANDROID_CAMERA_CLOSE_FAILED)).getNativeContext(), this.nativeContext);
            }
            if (this.m_textureRender != null) {
                this.m_textureRender.deInitGL();
                this.m_textureRender = null;
            }
            this.closeOffscreenPreviewSurface();
            this.closePassthroughPreviewSurface();
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Leaving thread proc (" + this.debugName + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onCpuFrameCaptured(byte[] data) {
        long ts = Clock.getPlatformTime();
        Systrace.begin((Systrace.Section)Systrace.Section.CaptureVideo);
        try {
            Object object = this.callbackTypeMonitor;
            synchronized (object) {
                if (this.usingBufferMode()) {
                    CaptureWorker.onCpuFrameCaptured(data, ts, this.modeId, this.orientation.isVertFlipped(), this.orientation.isHorizFlipped(), this.orientation.isTransposed(), this.enableFaceDetection ? this.attachFaceInfoToFrame(ts) : (float[][])null, this.nativeContext);
                }
            }
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            CaptureWorker.onCapturingFailed(new Failure(new CaptureException(e, ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE)).getNativeContext(), this.nativeContext);
        }
        finally {
            Systrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCpuFrameCaptured(ByteBuffer yBuffer, int yRowStride, ByteBuffer uBuffer, ByteBuffer vBuffer, int uvRowStride, int uvPixelStride) {
        long ts = Clock.getPlatformTime();
        Systrace.begin((Systrace.Section)Systrace.Section.CaptureVideo);
        try {
            Object object = this.callbackTypeMonitor;
            synchronized (object) {
                if (this.usingBufferMode()) {
                    CaptureWorker.onCpuFrameCaptured2(yBuffer, yRowStride, uBuffer, vBuffer, uvRowStride, uvPixelStride, ts, this.modeId, this.orientation.isVertFlipped(), this.orientation.isHorizFlipped(), this.orientation.isTransposed(), this.enableFaceDetection ? this.attachFaceInfoToFrame(ts) : (float[][])null, this.nativeContext);
                }
            }
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            CaptureWorker.onCapturingFailed(new Failure(new CaptureException(e, ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE)).getNativeContext(), this.nativeContext);
        }
        finally {
            Systrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGpuFrameCaptured(int textureTarget, int textureId) {
        long ts = Clock.getPlatformTime();
        Object object = this.callbackTypeMonitor;
        synchronized (object) {
            if (!this.usingBufferMode()) {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)("textureTarget[" + textureTarget + "], textureId[" + textureId + "], ts[" + ts + "], modeId[" + this.modeId + "], nativeContext[" + this.nativeContext + "]"));
                }
                CaptureWorker.onGpuFrameCaptured(textureTarget, textureId, ts, this.modeId, this.orientation.isVertFlipped(), this.orientation.isHorizFlipped(), this.orientation.isTransposed(), this.enableFaceDetection ? this.attachFaceInfoToFrame(ts) : (float[][])null, this.nativeContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGpuFrameDropped() {
        Object object = this.callbackTypeMonitor;
        synchronized (object) {
            if (this.callbackType == CallbackType.GPU) {
                CaptureWorker.onGpuFrameDropped(this.nativeContext);
            }
        }
    }

    @Override
    public final void onError(ErrorCodeException e) {
        if (Log.isLoggable((String)"Video", (int)6)) {
            Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
        }
        CaptureWorker.onCapturingFailed(new Failure(e).getNativeContext(), this.nativeContext);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFaceDetected(Rect[] faces) {
        Object object = this.faceInfoLock;
        synchronized (object) {
            if (!this.cameraStarted || this.camera == null || this.faceInfos == null) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"onFaceDetected called but evn not ready!");
                }
                return;
            }
            this.faceInfos.clear();
            this.lastFaceDetectedTimestamp = Clock.getPlatformTime();
            if (faces != null && faces.length > 0) {
                Matrix matrix = this.camera.getFaceTransferMatrix();
                if (matrix == null) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"Camera have not initialize face matrix!");
                    }
                    return;
                }
                RectF srcRect = new RectF();
                RectF dstRect = new RectF();
                for (int i = 0; i < faces.length; ++i) {
                    srcRect.set(faces[i]);
                    matrix.mapRect(dstRect, srcRect);
                    this.faceInfos.add(new float[]{dstRect.top, dstRect.bottom, dstRect.left, dstRect.right});
                }
                this.faceInfoConsumedOnce = false;
            }
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)("Detected " + this.faceInfos.size() + " faces!"));
            }
        }
    }

    private boolean usingBufferMode() {
        return this.callbackType == CallbackType.CPU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float[][] attachFaceInfoToFrame(long ts) {
        Object object = this.faceInfoLock;
        synchronized (object) {
            if (this.faceInfos == null || this.faceInfos.size() <= 0 || this.lastFaceDetectedTimestamp <= 0L) {
                return null;
            }
            long duration = (ts - this.lastFaceDetectedTimestamp) / 1000L;
            if (this.faceInfoConsumedOnce && duration > (long)this.faceDataKeepingThresholdInMs) {
                this.faceInfos.clear();
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)("Clean capture face info due to already keeping " + duration + " ms."));
                }
                return null;
            }
            int size = this.faceInfos.size();
            float[][] facesArray = new float[size][4];
            for (int i = 0; i < size; ++i) {
                facesArray[i] = this.faceInfos.get(i);
            }
            this.faceInfoConsumedOnce = true;
            return facesArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceTexture getOffscreenPreviewSurface() throws GraphicsException {
        Object object = this.offscreenPreviewSurfaceLock;
        synchronized (object) {
            if (this.offscreenPreviewSurface == null) {
                this.offscreenPreviewSurface = new OffscreenPreviewSurface(this, this.handler);
            }
            this.offscreenPreviewSurface.allocSurfaceTexture(new Resolution(1, 1));
            return this.offscreenPreviewSurface.getSurfaceTexture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOffscreenPreviewSurface() {
        try {
            OffscreenPreviewSurface surface = null;
            Object object = this.offscreenPreviewSurfaceLock;
            synchronized (object) {
                surface = this.offscreenPreviewSurface;
                this.offscreenPreviewSurface = null;
            }
            if (surface != null) {
                surface.close();
            }
        }
        catch (GraphicsException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            CaptureWorker.onCapturingFailed(new Failure(e).getNativeContext(), this.nativeContext);
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            CaptureWorker.onCapturingFailed(new Failure(new CaptureException(e, ErrorCode.ANDROID_CAPTURER_OFFSCREEN_SURFACE_CLOSE_FAILED)).getNativeContext(), this.nativeContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PassthroughPreviewSurface getPassthroughPreviewSurface() throws GraphicsException {
        Object object = this.passthroughPreviewSurfaceLock;
        synchronized (object) {
            if (this.passthroughPreviewSurface == null) {
                this.passthroughPreviewSurface = new PassthroughPreviewSurface(this, this.handler);
            }
            return this.passthroughPreviewSurface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePassthroughPreviewSurface() {
        try {
            PassthroughPreviewSurface surface = null;
            Object object = this.passthroughPreviewSurfaceLock;
            synchronized (object) {
                surface = this.passthroughPreviewSurface;
                this.passthroughPreviewSurface = null;
            }
            if (surface != null) {
                surface.close();
            }
        }
        catch (GraphicsException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            CaptureWorker.onCapturingFailed(new Failure(e).getNativeContext(), this.nativeContext);
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Exception caught (" + this.debugName + ")"), (Throwable)e);
            }
            CaptureWorker.onCapturingFailed(new Failure(new CaptureException(e, ErrorCode.ANDROID_CAPTURER_PASSTHROUGH_SURFACE_CLOSE_FAILED)).getNativeContext(), this.nativeContext);
        }
    }

    private static enum Orientation {
        LANDSCAPE_LEFT(false, false, false),
        PORTRAIT(false, true, true),
        LANDSCAPE_RIGHT(true, true, false),
        PORTRAIT_UPSIDEDOWN(true, false, true);

        private final boolean isVertFlipped;
        private final boolean isHorizFlipped;
        private final boolean isTransposed;

        private Orientation(boolean isVertFlipped, boolean isHorizFlipped, boolean isTransposed) {
            this.isVertFlipped = isVertFlipped;
            this.isHorizFlipped = isHorizFlipped;
            this.isTransposed = isTransposed;
        }

        public boolean isVertFlipped() {
            return this.isVertFlipped;
        }

        public boolean isHorizFlipped() {
            return this.isHorizFlipped;
        }

        public boolean isTransposed() {
            return this.isTransposed;
        }

        public String toString() {
            return this.name() + " (" + (this.isVertFlipped ? "V" : "-") + (this.isHorizFlipped ? "H" : "-") + (this.isTransposed ? "T" : "-") + ")";
        }
    }

    public static enum CallbackType {
        CPU,
        GPU;

    }
}

