/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl;

import android.os.Handler;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.capture.api.CameraCallback;
import com.microsoft.dl.video.capture.impl.AbstractPreviewSurface;
import com.microsoft.dl.video.graphics.GraphicsException;
import com.microsoft.dl.video.graphics.egl.EGLException;
import com.microsoft.dl.video.graphics.egl.WindowSurfaceContext;

public class PassthroughPreviewSurface
extends AbstractPreviewSurface {
    private Object externalPreviewDisplay;
    private final String simpleClassName = this.getClass().getSimpleName();

    private static WindowSurfaceContext createSurface() throws EGLException {
        WindowSurfaceContext surfaceContext = null;
        try {
            surfaceContext = new WindowSurfaceContext();
            return surfaceContext;
        }
        catch (EGLException e) {
            if (surfaceContext != null) {
                surfaceContext.close();
            }
            throw e;
        }
    }

    public PassthroughPreviewSurface(CameraCallback callback) throws EGLException {
        super(callback, null, PassthroughPreviewSurface.createSurface());
    }

    public PassthroughPreviewSurface(CameraCallback callback, Handler handler) throws EGLException {
        super(callback, handler, PassthroughPreviewSurface.createSurface());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocSurfaceTexture(Object externalPreviewDisplay) throws GraphicsException {
        WindowSurfaceContext windowSurfaceContext = this.getSurface();
        synchronized (windowSurfaceContext) {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)(this.simpleClassName + " requested for " + externalPreviewDisplay));
            }
            if (externalPreviewDisplay == this.externalPreviewDisplay) {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)(this.simpleClassName + " reusing existing " + this.getSurfaceTexture()));
                }
                return;
            }
            this.releaseSurfaceTexture();
            if (externalPreviewDisplay == null) {
                return;
            }
            try {
                this.getSurface().attachSurface(externalPreviewDisplay);
                super.alloc();
            }
            catch (GraphicsException e) {
                this.getSurface().detachSurface();
                throw e;
            }
            this.externalPreviewDisplay = externalPreviewDisplay;
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)(this.simpleClassName + " allocated " + this.getSurfaceTexture()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSurfaceTexture() throws GraphicsException {
        WindowSurfaceContext windowSurfaceContext = this.getSurface();
        synchronized (windowSurfaceContext) {
            if (this.getSurfaceTexture() == null) {
                return;
            }
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)(this.simpleClassName + " releasing " + this.getSurfaceTexture()));
            }
            super.release();
            this.getSurface().detachSurface();
            this.externalPreviewDisplay = null;
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)(this.simpleClassName + " surface texture released"));
            }
        }
    }

    public Object getExternalPreviewDisplay() {
        return this.externalPreviewDisplay;
    }

    @Override
    protected WindowSurfaceContext getSurface() {
        return (WindowSurfaceContext)super.getSurface();
    }
}

