/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.real.impl;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManager;
import com.microsoft.dl.video.capture.api.CameraManagerFactory;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import com.microsoft.dl.video.capture.impl.real.impl.CameraCapabilitiesUtils;
import com.microsoft.dl.video.capture.impl.real.impl.RealCameraImpl;
import java.util.Map;

public class RealCameraManagerImpl
implements CameraManager {
    private Map<String, CameraCapabilities> capabilities;
    private Map<String, StaticCameraCapabilities> staticCapabilities;

    @Override
    public final String[] getCameraIds() {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("CAMERA: Returning Total: " + android.hardware.Camera.getNumberOfCameras()));
        }
        int cameraNum = android.hardware.Camera.getNumberOfCameras();
        String[] cameraIds = new String[cameraNum];
        for (int i = 0; i < cameraNum; ++i) {
            cameraIds[i] = String.valueOf(i);
        }
        return cameraIds;
    }

    @Override
    public final Camera openCamera(String id) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("CAMERA:openCamera: " + id));
        }
        return new RealCameraImpl(id);
    }

    @Override
    public final StaticCameraCapabilities getStaticCameraCapabilities(String id) throws CaptureException {
        if (this.staticCapabilities == null) {
            this.staticCapabilities = CameraCapabilitiesUtils.obtainStatic();
        }
        if (!this.staticCapabilities.containsKey(id)) {
            throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_CAMERA_INVALID_ID);
        }
        return this.staticCapabilities.get(id).clone();
    }

    @Override
    public final CameraCapabilities getCameraCapabilities(String id) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)"CAMERA:getCameraCapabilities");
        }
        if (this.capabilities == null) {
            this.capabilities = CameraCapabilitiesUtils.obtain();
        }
        if (this.capabilities == null || !this.capabilities.containsKey(id)) {
            throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_CAMERA_INVALID_ID);
        }
        return this.capabilities.get(id).clone();
    }

    @Override
    public void close() {
    }

    public static class Factory
    implements CameraManagerFactory {
        @Override
        public final CameraManager createCameraManager() {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"CAMERA:createCameraManager");
            }
            return new RealCameraManagerImpl();
        }
    }
}

