/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.real.impl2;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Range;
import android.util.Size;
import com.microsoft.dl.Platform;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CameraRect;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.FpsRange;
import com.microsoft.dl.video.capture.api.ImageFormat;
import com.microsoft.dl.video.capture.impl.CameraExtensions;
import com.microsoft.dl.video.capture.impl.real.impl.CameraCapabilitiesUtils;
import com.microsoft.dl.video.utils.Resolution;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class Camera2CapabilitiesUtils
extends CameraCapabilitiesUtils {
    private static final int FULL_ANGLE = 360;
    public static final int CAMERA_API_VERSION_2 = 2;

    private Camera2CapabilitiesUtils() {
    }

    private static void getCustomCameraCapabilities(String cameraId, CameraCharacteristics cameraInfo, CameraCapabilities caps) {
        if (Build.VERSION.SDK_INT < 29) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("getCustomCameraCapabilities is not supported on Android Q below. [SDK_INT:" + Build.VERSION.SDK_INT + "]"));
            }
            return;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("getCustomCameraCapabilities [" + cameraId + "]"));
        }
        caps.setFriendlyName(Camera2CapabilitiesUtils.getFriendlyName(cameraInfo));
        caps.setManufacturer(Camera2CapabilitiesUtils.getManufacturer(cameraInfo));
        caps.setModel(Camera2CapabilitiesUtils.getModel(cameraInfo));
        caps.setPid(Camera2CapabilitiesUtils.getPid(cameraInfo));
        caps.setVid(Camera2CapabilitiesUtils.getVid(cameraInfo));
        CameraCapabilities.SmartCameraType cameraType = Camera2CapabilitiesUtils.getSmartCameraType(cameraInfo);
        if (cameraType != CameraCapabilities.SmartCameraType.INVALID) {
            caps.setSmartCameraType(cameraType);
            caps.setSmartCameraExtensionVersion(Camera2CapabilitiesUtils.getSmartCameraExtensionVersion(cameraInfo));
            caps.setSmartCameraDriverVersion(Camera2CapabilitiesUtils.getSmartCameraDriverVersion(cameraInfo));
        }
    }

    public static CameraCapabilities getCameraCapabilities(String cameraId) throws CaptureException {
        CameraCharacteristics cameraInfo = Camera2CapabilitiesUtils.getCameraInfo(cameraId);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("getCameraCapabilities for cameraId: " + cameraId));
        }
        CameraCapabilities capabilities = new CameraCapabilities();
        capabilities.setCameraId(cameraId);
        capabilities.setFacing(Camera2CapabilitiesUtils.getCameraFacing(cameraInfo));
        capabilities.setOrientation(Camera2CapabilitiesUtils.getCameraOrientation(cameraInfo));
        capabilities.setCameraArraySize(Camera2CapabilitiesUtils.getCameraArraySize(cameraInfo));
        capabilities.setSupportedImageFormats(Camera2CapabilitiesUtils.getImageFormats());
        capabilities.setSupportedResolutions(Camera2CapabilitiesUtils.getResolutions(cameraInfo));
        capabilities.setSupportedFpsRanges(Camera2CapabilitiesUtils.getFpsRanges(cameraInfo));
        capabilities.setSupportedFocusModes(Camera2CapabilitiesUtils.getFocusModes(cameraInfo));
        capabilities.setFlashUnitAvailability(Camera2CapabilitiesUtils.isFlashUnitAvailable(cameraInfo));
        capabilities.setNativeAspectRatio(Camera2CapabilitiesUtils.getNativeAspectRatio(cameraInfo));
        NavigableSet<Integer> detectionModes = Camera2CapabilitiesUtils.getFaceDetectModes(cameraInfo);
        capabilities.setSupportedFaceDetectModes(detectionModes);
        capabilities.setMaxFaceCount(Camera2CapabilitiesUtils.getMaxFaceCount(cameraInfo, detectionModes));
        Camera2CapabilitiesUtils.getCustomCameraCapabilities(cameraId, cameraInfo, capabilities);
        Camera2CapabilitiesUtils.fillSharingCameraCapabilities(cameraId, cameraInfo, capabilities);
        return capabilities;
    }

    private static void fillSharingCameraCapabilities(String cameraId, CameraCharacteristics cameraCharacteristics, CameraCapabilities capabilities) {
        block5: {
            String SharingCameraKey1 = "cameraType";
            String SharingCameraKey2 = "camera2.type";
            String SharingCameraKey3 = "android.camera.type";
            String HDMIIngestionCameraValue = "screen_share_internal";
            if (cameraId != null && cameraId.startsWith("teams-content-share")) {
                capabilities.setIsHDMIIngestionCamera(true);
                return;
            }
            try {
                List keys = cameraCharacteristics.getKeys();
                if (keys == null) {
                    return;
                }
                for (CameraCharacteristics.Key key : keys) {
                    String cameraType;
                    Object value;
                    String keyName = key.getName();
                    if (keyName == null || !"android.camera.type".equalsIgnoreCase(keyName) && !"camera2.type".equalsIgnoreCase(keyName) && !"cameraType".equalsIgnoreCase(keyName) || !((value = cameraCharacteristics.get(key)) instanceof String) || !"screen_share_internal".equalsIgnoreCase(cameraType = (String)value)) continue;
                    capabilities.setIsHDMIIngestionCamera(true);
                    return;
                }
            }
            catch (Exception ex) {
                if (!Log.isLoggable((String)"Video", (int)5)) break block5;
                Log.w((String)"Video", (String)("getCustomCameraCapabilities, fillSharingCameraCapabilities failed: ex=" + ex.getMessage()));
            }
        }
    }

    public static FpsRange mapFpsRange(Range<Integer> range) throws CaptureException {
        int min = (Integer)range.getLower();
        int max = (Integer)range.getUpper();
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("FpsRange, min:" + min + "  max:" + max));
            Log.d((String)"Video", (String)("converting as per camera1 expectation , min:" + min * 1000 + "  max:" + max * 1000));
        }
        return new FpsRange(min * 1000, max * 1000);
    }

    public static Map<String, CameraCapabilities> obtain() throws CaptureException {
        Map<String, CameraCapabilities> capabilities = Camera2CapabilitiesUtils.collect();
        if (Log.isLoggable((String)"Video", (int)4)) {
            for (CameraCapabilities caps : capabilities.values()) {
                Log.i((String)"Video", (String)("obtain capabilities: " + caps.toString()));
            }
        }
        return capabilities;
    }

    private static Map<String, CameraCapabilities> collect() throws CaptureException {
        String[] idList;
        HashMap<String, CameraCapabilities> capabilities = new HashMap<String, CameraCapabilities>();
        for (String id : idList = CameraManagerSingleton.getInstance().getCameraIds()) {
            capabilities.put(id, Camera2CapabilitiesUtils.getCameraCapabilities(id));
        }
        return capabilities;
    }

    private static float getNativeAspectRatio(CameraCharacteristics cameraInfo) {
        Size[] sizes;
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraInfo.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (streamConfigurationMap != null && (sizes = streamConfigurationMap.getOutputSizes(SurfaceTexture.class)) != null) {
            return (float)sizes[0].getWidth() / (float)sizes[0].getHeight();
        }
        return 0.0f;
    }

    private static NavigableSet<ImageFormat> getImageFormats() {
        TreeSet<ImageFormat> imageFormats = new TreeSet<ImageFormat>();
        imageFormats.add(ImageFormat.NV12);
        imageFormats.add(ImageFormat.NV21);
        return imageFormats;
    }

    private static NavigableSet<Resolution> getResolutions(CameraCharacteristics cameraInfo) throws CaptureException {
        Size[] sizes;
        TreeSet<Resolution> resolutions = new TreeSet<Resolution>();
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraInfo.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (streamConfigurationMap != null && (sizes = streamConfigurationMap.getOutputSizes(SurfaceTexture.class)) != null) {
            for (int i = 0; i < sizes.length; ++i) {
                resolutions.add(new Resolution(sizes[i].getWidth(), sizes[i].getHeight()));
                if (!Log.isLoggable((String)"Video", (int)3)) continue;
                Log.d((String)"Video", (String)("Resolutions, width: " + sizes[i].getWidth() + "height: " + sizes[i].getHeight()));
            }
        }
        return resolutions;
    }

    private static NavigableSet<FpsRange> getFpsRanges(CameraCharacteristics cameraInfo) throws CaptureException {
        TreeSet<FpsRange> fpsRanges = new TreeSet<FpsRange>();
        Range[] ranges = (Range[])cameraInfo.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (ranges != null) {
            for (Range range : ranges) {
                fpsRanges.add(Camera2CapabilitiesUtils.mapFpsRange((Range<Integer>)range));
            }
        }
        return fpsRanges;
    }

    private static NavigableSet<String> getFocusModes(CameraCharacteristics cameraInfo) {
        TreeSet<String> focusModes = new TreeSet<String>();
        int[] modes = (int[])cameraInfo.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (modes != null) {
            for (int mode : modes) {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)("focusModes: " + String.valueOf(mode)));
                }
                focusModes.add(String.valueOf(mode));
            }
        }
        return focusModes;
    }

    private static boolean isFlashUnitAvailable(CameraCharacteristics cameraInfo) {
        Boolean flashAvailable = (Boolean)cameraInfo.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (flashAvailable != null && flashAvailable.booleanValue()) {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"Flash Unit Available");
            }
            return true;
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"Flash Unit Not Available");
        }
        return false;
    }

    private static CameraCapabilities.Facing getCameraFacing(CameraCharacteristics cameraInfo) {
        Integer facing = (Integer)cameraInfo.get(CameraCharacteristics.LENS_FACING);
        if (facing == null) {
            return CameraCapabilities.Facing.OTHER;
        }
        switch (facing) {
            case 1: {
                return CameraCapabilities.Facing.BACK;
            }
            case 0: {
                return CameraCapabilities.Facing.FRONT;
            }
            case 2: {
                return CameraCapabilities.Facing.EXTERNAL;
            }
        }
        return CameraCapabilities.Facing.OTHER;
    }

    private static int getCameraOrientation(CameraCharacteristics cameraInfo) {
        int orientationValue;
        Integer orientation = (Integer)cameraInfo.get(CameraCharacteristics.SENSOR_ORIENTATION);
        int n = orientationValue = orientation == null ? 0 : orientation;
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("orientation:" + (360 - orientationValue)));
        }
        return 360 - orientationValue;
    }

    private static CameraRect getCameraArraySize(CameraCharacteristics cameraInfo) {
        Rect arraySize = (Rect)cameraInfo.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        if (arraySize == null) {
            arraySize = new Rect();
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("array size: " + arraySize.toString()));
        }
        return new CameraRect(arraySize);
    }

    private static NavigableSet<Integer> getFaceDetectModes(CameraCharacteristics cameraInfo) {
        TreeSet<Integer> faceDetectModes = new TreeSet<Integer>();
        int[] faceDetectModeArray = (int[])cameraInfo.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        if (faceDetectModeArray != null) {
            for (int faceDetectMode : faceDetectModeArray) {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)("faceDetectModes:" + faceDetectMode));
                }
                if (faceDetectMode == 0) continue;
                faceDetectModes.add(faceDetectMode);
            }
        }
        return faceDetectModes;
    }

    private static <T> T getCustomKeyOrDefault(CameraCharacteristics cameraInfo, CameraCharacteristics.Key<?> key, T defaultResult, Class<T> clazz) {
        T result;
        block6: {
            Object value = null;
            result = defaultResult;
            try {
                value = cameraInfo.get(key);
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("The value of key [" + key.getName() + "] is [" + value + "]"));
                }
                if (clazz.isInstance(value)) {
                    result = clazz.cast(value);
                } else if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Failed to convert the value of the key [" + key.getName() + "] to its type: " + key.getClass() + " value: [" + value + "]"));
                }
            }
            catch (IllegalArgumentException e) {
                if (!Log.isLoggable((String)"Video", (int)4)) break block6;
                Log.i((String)"Video", (String)("The key [" + key.getName() + "] is not supported by the device"));
            }
        }
        return result;
    }

    private static String getFriendlyName(CameraCharacteristics cameraInfo) {
        String friendlyName = Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.CAMERA_FRIENDLY_NAME, null, String.class);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("friendlyName: " + friendlyName));
        }
        return friendlyName;
    }

    private static String getManufacturer(CameraCharacteristics cameraInfo) {
        String manufacturer = Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.CAMERA_MANUFACTURER, null, String.class);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("manufacturer: " + manufacturer));
        }
        return manufacturer;
    }

    private static String getModel(CameraCharacteristics cameraInfo) {
        String model = Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.CAMERA_MODEL, null, String.class);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("model: " + model));
        }
        return model;
    }

    private static int getPid(CameraCharacteristics cameraInfo) {
        int pid = Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.CAMERA_PID, 0, Integer.class);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("pid: " + pid));
        }
        return pid;
    }

    private static int getVid(CameraCharacteristics cameraInfo) {
        int vid = Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.CAMERA_VID, 0, Integer.class);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("vid: " + vid));
        }
        return vid;
    }

    private static CameraCapabilities.SmartCameraType getSmartCameraType(CameraCharacteristics cameraInfo) {
        CameraCapabilities.SmartCameraType cameraType = CameraCapabilities.SmartCameraType.fromInteger(Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.SMART_CAMERA_TYPE, 0, Integer.class));
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("smartCameraType: " + (Object)((Object)cameraType)));
        }
        return cameraType;
    }

    private static int getSmartCameraExtensionVersion(CameraCharacteristics cameraInfo) {
        int extensionVersion = Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.SMART_CAMERA_EXTENSION_VERSION, 0, Integer.class);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("extensionVersion: " + extensionVersion));
        }
        return extensionVersion;
    }

    private static int getSmartCameraDriverVersion(CameraCharacteristics cameraInfo) {
        int driverVersion = Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.SMART_CAMERA_DRIVER_VERSION, 0, Integer.class);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("driverVersion: " + driverVersion));
        }
        return driverVersion;
    }

    private static int getSmartCameraIntelliFrameIndex(CameraCharacteristics cameraInfo) {
        int intelliFrameIndex = Camera2CapabilitiesUtils.getCustomKeyOrDefault(cameraInfo, CameraExtensions.SMART_CAMERA_INTELLI_FRAME_INDEX, 0, Integer.class);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("intelliFrameIndex: " + intelliFrameIndex));
        }
        return intelliFrameIndex;
    }

    private static int getMaxFaceCount(CameraCharacteristics cameraInfo, NavigableSet<Integer> detectionModes) {
        int maxFaceCount = (Integer)cameraInfo.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("maxFaceCount:" + maxFaceCount));
        }
        if (detectionModes == null || detectionModes.size() == 0) {
            maxFaceCount = 0;
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Reset maxFaceCount to 0 cause not supported face detection mode enable.");
            }
        }
        return maxFaceCount;
    }

    private static CameraCharacteristics getCameraInfo(String cameraId) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"getCameraInfo starts");
        }
        Context ctx = Platform.getInfo().getAppContext();
        CameraManager cameraManager = (CameraManager)ctx.getSystemService("camera");
        CameraCharacteristics characteristics = null;
        try {
            characteristics = cameraManager.getCameraCharacteristics(cameraId);
        }
        catch (CameraAccessException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught ", (Throwable)e);
            }
            throw new CaptureException("Could not get CameraInfo for the camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_GET_INFO_FAILED);
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught ", (Throwable)e);
            }
            throw new CaptureException("Could not get CameraInfo for the camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_GET_INFO_FAILED);
        }
        return characteristics;
    }
}

