/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.real.impl2;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.Looper;
import android.util.Range;
import android.view.Surface;
import com.microsoft.dl.Platform;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCallback;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CameraParameters;
import com.microsoft.dl.video.capture.api.CaptureException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;

public class RealCamera2Impl
implements Camera {
    private static final long CAMERA_TIMEOUT_MILLIS = 5000L;
    private static final long PREVIEW_TIMEOUT_MILLIS = 15000L;
    private final String m_cameraId;
    private final StateListener m_stateListener;
    private CameraDevice m_cameraDevice = null;
    private boolean m_captureSessionOpening = false;
    private boolean m_captureSessionClosed = true;
    private SurfaceTexture m_display = null;
    private int m_displayOrientation;
    private CameraParameters m_cameraParameters = null;
    private CaptureRequest.Builder m_captureBuilder = null;
    private final Handler m_backgroundHandler;
    private CameraCaptureSession m_captureSession = null;
    private final Object m_cameraStateMonitor = new Object();
    private Looper m_looper = null;
    private CaptureException m_exception = null;
    private CameraCapabilities m_capabilities = null;
    private int m_numBuffers = 0;
    private ImageReader m_imageReader = null;
    private boolean m_imageReaderClosing = false;
    private CameraCallback m_cameraCallback = null;
    private volatile boolean m_isFaceDetectionEnabled = false;
    private volatile Matrix matrix = null;
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpened(CameraDevice cameraDevice) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Camera: " + RealCamera2Impl.this.m_cameraId + " onOpened enter [" + cameraDevice + "]"));
            }
            Object object = RealCamera2Impl.this.m_cameraStateMonitor;
            synchronized (object) {
                RealCamera2Impl.this.m_cameraDevice = cameraDevice;
                RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
            }
            if (RealCamera2Impl.this.m_stateListener != null) {
                RealCamera2Impl.this.m_stateListener.onOpened(RealCamera2Impl.this.m_cameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnected(CameraDevice cameraDevice) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Camera: " + RealCamera2Impl.this.m_cameraId + " onDisconnected enter [" + cameraDevice + "]"));
            }
            Object object = RealCamera2Impl.this.m_cameraStateMonitor;
            synchronized (object) {
                cameraDevice.close();
                RealCamera2Impl.this.m_cameraDevice = null;
                RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
            }
            if (RealCamera2Impl.this.m_stateListener != null) {
                RealCamera2Impl.this.m_stateListener.onDisconnected(RealCamera2Impl.this.m_cameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(CameraDevice cameraDevice, int error) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Camera: " + RealCamera2Impl.this.m_cameraId + " onError enter [" + cameraDevice + "] error:" + error + " error info:" + RealCamera2Impl.getOpenCameraOnErrorReason(error)));
            }
            Object object = RealCamera2Impl.this.m_cameraStateMonitor;
            synchronized (object) {
                RealCamera2Impl.this.m_exception = new CaptureException("Camera failed, onError[" + error + "]", ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
                cameraDevice.close();
                RealCamera2Impl.this.m_cameraDevice = null;
                RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
            }
            if (RealCamera2Impl.this.m_stateListener != null) {
                RealCamera2Impl.this.m_stateListener.onError(RealCamera2Impl.this.m_cameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClosed(CameraDevice cameraDevice) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Camera: " + RealCamera2Impl.this.m_cameraId + " onClosed enter [" + cameraDevice + "]"));
            }
            Object object = RealCamera2Impl.this.m_cameraStateMonitor;
            synchronized (object) {
                RealCamera2Impl.this.m_captureSessionClosed = true;
                RealCamera2Impl.this.m_captureSession = null;
                RealCamera2Impl.this.m_cameraDevice = null;
                RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
            }
            if (RealCamera2Impl.this.m_stateListener != null) {
                RealCamera2Impl.this.m_stateListener.onClosed(RealCamera2Impl.this.m_cameraId);
            }
        }
    };
    private final CameraCaptureSession.CaptureCallback m_captureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            super.onCaptureCompleted(session, request, result);
            if (RealCamera2Impl.this.m_cameraCallback == null) {
                return;
            }
            Face[] faces = (Face[])result.get(CaptureResult.STATISTICS_FACES);
            Rect[] faceRects = null;
            if (faces != null && faces.length > 0) {
                faceRects = new Rect[faces.length];
                for (int i = 0; i < faces.length; ++i) {
                    faceRects[i] = faces[i].getBounds();
                }
            }
            RealCamera2Impl.this.m_cameraCallback.onFaceDetected(faceRects);
        }
    };

    private static String getOpenCameraOnErrorReason(int error) {
        switch (error) {
            case 1: {
                return "Camera is in use already.";
            }
            case 2: {
                return "Camera device could not be opened because there are too many other open cameras.";
            }
            case 3: {
                return "Camera is disabled due to a device policy.";
            }
            case 4: {
                return "Camera device fatal error.";
            }
            case 5: {
                return "Camera service fatal error.";
            }
        }
        return "Unknown error.";
    }

    public RealCamera2Impl(String cameraId, StateListener stateListener) throws CaptureException {
        try {
            Context ctx;
            CameraManager cameraManager;
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Camera: " + cameraId + " RealCamera2Impl ctor."));
            }
            if ((cameraManager = (CameraManager)(ctx = Platform.getInfo().getAppContext()).getSystemService("camera")) == null) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"Failed to get CameraManager");
                }
                throw new CaptureException("android.hardware.camera2.CameraManager NULL", ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
            }
            this.m_cameraId = cameraId;
            this.m_stateListener = stateListener;
            Camera2Thread worker = new Camera2Thread(cameraManager, cameraId);
            worker.start();
            this.waitForCameraOpen(5000L);
            this.m_backgroundHandler = new Handler(Looper.myLooper());
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("RuntimeException: Could not open camera: " + cameraId));
            }
            throw new CaptureException("Could not open camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
        }
        catch (InterruptedException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("InterruptedException: Could not open camera: " + cameraId));
            }
            throw new CaptureException("Could not open camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCameraOpen(long timeoutMs) throws InterruptedException, CaptureException {
        Object object = this.m_cameraStateMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (this.m_cameraDevice == null) {
                if (this.m_exception != null) {
                    CaptureException m_exception = this.m_exception;
                    this.m_exception = null;
                    throw m_exception;
                }
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"camera open timed out.");
                    }
                    return false;
                }
                this.m_cameraStateMonitor.wait(waitMs);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCaptureSessionOpen(long timeoutMs) throws InterruptedException, CaptureException {
        Object object = this.m_cameraStateMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (this.m_captureSessionOpening) {
                if (this.m_exception != null) {
                    CaptureException m_exception = this.m_exception;
                    this.m_exception = null;
                    throw m_exception;
                }
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"CaptureSessionOpen timed out.");
                    }
                    return false;
                }
                this.m_cameraStateMonitor.wait(waitMs);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCaptureSessionClose(long timeoutMs) throws InterruptedException, CaptureException {
        Object object = this.m_cameraStateMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (!this.m_captureSessionClosed) {
                if (this.m_exception != null) {
                    CaptureException m_exception = this.m_exception;
                    this.m_exception = null;
                    throw m_exception;
                }
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"CaptureSessionClose timed out.");
                    }
                    return false;
                }
                this.m_cameraStateMonitor.wait(waitMs);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForImageReaderClose(long timeoutMs) throws InterruptedException, CaptureException {
        Object object = this.m_cameraStateMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (this.m_imageReaderClosing) {
                if (this.m_exception != null) {
                    CaptureException m_exception = this.m_exception;
                    this.m_exception = null;
                    throw m_exception;
                }
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"ImageReaderClose timed out.");
                    }
                    return false;
                }
                this.m_cameraStateMonitor.wait(waitMs);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCameraClose(long timeoutMs) throws InterruptedException, CaptureException {
        Object object = this.m_cameraStateMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (this.m_cameraDevice != null) {
                if (this.m_exception != null) {
                    CaptureException m_exception = this.m_exception;
                    this.m_exception = null;
                    throw m_exception;
                }
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"camera close timed out.");
                    }
                    return false;
                }
                this.m_cameraStateMonitor.wait(waitMs);
            }
            return true;
        }
    }

    @Override
    public final void close() throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Camera: " + this.m_cameraId + " [" + this.m_cameraDevice + "] closing"));
        }
        this.m_backgroundHandler.removeCallbacksAndMessages(null);
        if (this.m_cameraDevice != null) {
            try {
                this.m_cameraDevice.close();
                this.m_captureSessionClosed = true;
                this.m_captureSession = null;
                this.waitForCameraClose(5000L);
                this.m_cameraDevice = null;
                if (this.m_looper != null) {
                    this.m_looper.quit();
                }
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("RuntimeException: Could not close camera: " + this.m_cameraId));
                }
                throw new CaptureException("Could not close camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_CLOSE_FAILED);
            }
            catch (InterruptedException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("InterruptedException: Could not close camera: " + this.m_cameraId));
                }
                throw new CaptureException("Could not close camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_CLOSE_FAILED);
            }
        }
    }

    @Override
    public final CameraParameters getParameters() throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Camera: " + this.m_cameraId + " having parameters as [" + this.m_cameraParameters + "]"));
        }
        return this.m_cameraParameters;
    }

    @Override
    public final void setParameters(CameraParameters parameters) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting parameters [" + parameters + "] to the camera: " + this.m_cameraId));
        }
        this.m_cameraParameters = parameters;
    }

    @Override
    public final void setFlashTorchMode(boolean torchTurnOn) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting flash mode [" + torchTurnOn + "] to the camera: " + this.m_cameraId));
        }
        try {
            if (this.m_captureSession == null || this.m_captureBuilder == null) {
                throw new CaptureException("Could not set flash torch mode [" + torchTurnOn + "] on null capture", ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
            }
            this.m_captureBuilder.set(CaptureRequest.FLASH_MODE, (Object)(torchTurnOn ? 2 : 0));
            this.m_captureSession.setRepeatingRequest(this.m_captureBuilder.build(), null, null);
            this.m_cameraParameters.setFlashTorchMode(torchTurnOn);
        }
        catch (CameraAccessException e) {
            throw new CaptureException("Could not set flash torch mode [" + torchTurnOn + "] on the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
        }
    }

    @Override
    public final void setPreviewDisplay(Object display) throws CaptureException {
        block7: {
            try {
                if (display == null) {
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)("Setting NULL PreviewDisplay to the camera: " + this.m_cameraId));
                    }
                    this.m_display = null;
                    break block7;
                }
                if (display instanceof SurfaceTexture) {
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)("Setting SurfaceTexture [" + display + "] as PreviewDisplay to the camera: " + this.m_cameraId));
                    }
                    this.m_display = (SurfaceTexture)display;
                    break block7;
                }
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("Setting unsupported [" + display.getClass().getCanonicalName() + "] as PreviewDisplay to the camera: " + this.m_cameraId));
                }
                this.m_display = null;
                throw new CaptureException(display.getClass().getCanonicalName() + " is not supported", ErrorCode.ANDROID_CAMERA_UNSUPPORTED_PREVIEW_DISPLAY);
            }
            catch (RuntimeException e) {
                throw new CaptureException("Could not set preview display [" + display + "] for the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_SET_PREVIEW_DISPLAY_FAILED);
            }
        }
    }

    @Override
    public final void setDisplayOrientation(int degrees) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting Display Orientation [" + degrees + "] to the camera: " + this.m_cameraId));
        }
        this.m_displayOrientation = degrees;
        if (this.m_isFaceDetectionEnabled) {
            this.initFaceMatrix();
        }
    }

    @Override
    public final void prepareBuffers(int numBuffers) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)"Preparing buffers");
        }
        this.m_numBuffers = Math.max(numBuffers, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCallback(CameraCallback cb, boolean usingBufferMode) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)"Setting callback");
        }
        this.m_cameraCallback = cb;
        if (cb == null || !usingBufferMode || this.m_numBuffers == 0) {
            if (this.m_imageReader != null) {
                Object object = this.m_cameraStateMonitor;
                synchronized (object) {
                    this.m_imageReaderClosing = true;
                    this.m_backgroundHandler.postAtFrontOfQueue(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            RealCamera2Impl.this.m_imageReader.close();
                            Object object = RealCamera2Impl.this.m_cameraStateMonitor;
                            synchronized (object) {
                                RealCamera2Impl.this.m_imageReaderClosing = false;
                                RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
                            }
                        }
                    });
                    try {
                        this.waitForImageReaderClose(5000L);
                    }
                    catch (InterruptedException e) {
                        if (Log.isLoggable((String)"Video", (int)6)) {
                            Log.e((String)"Video", (String)("InterruptedException: Could not close image reader " + this.m_cameraId));
                        }
                        throw new CaptureException("Could not close image reader " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_SET_CALLBACK_FAILED);
                    }
                    finally {
                        this.m_imageReaderClosing = false;
                        this.m_imageReader = null;
                    }
                }
            }
            return;
        }
        int width = this.m_cameraParameters.getResolution().getWidth();
        int height = this.m_cameraParameters.getResolution().getHeight();
        if (this.m_imageReader != null && (this.m_imageReader.getWidth() != width || this.m_imageReader.getHeight() != height || this.m_imageReader.getMaxImages() != this.m_numBuffers)) {
            this.m_imageReader.close();
            this.m_imageReader = null;
        }
        if (this.m_imageReader == null) {
            this.m_imageReader = ImageReader.newInstance((int)width, (int)height, (int)35, (int)this.m_numBuffers);
            this.m_imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageReaderCallback(this.m_cameraCallback), this.m_backgroundHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startPreview() throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("starting preview to the camera: " + this.m_cameraId + " [" + this.m_cameraDevice + "]"));
        }
        if (this.m_cameraDevice != null) {
            try {
                int width = this.m_cameraParameters.getResolution().getWidth();
                int height = this.m_cameraParameters.getResolution().getHeight();
                String logMessage = "Surfaces: width[" + width + "], height[" + height + "]";
                Object object = this.m_cameraStateMonitor;
                synchronized (object) {
                    this.m_captureSessionOpening = true;
                }
                final ArrayList<Surface> surfaces = new ArrayList<Surface>(2);
                if (this.m_display != null) {
                    logMessage = logMessage + "; preview[" + this.m_display + "]";
                    this.m_display.setDefaultBufferSize(width, height);
                    Surface previewSurface = new Surface(this.m_display);
                    surfaces.add(previewSurface);
                }
                if (this.m_imageReader != null && this.m_imageReader.getSurface() != null) {
                    logMessage = logMessage + "; image reader[" + this.m_imageReader.getSurface() + "], max images[" + this.m_imageReader.getMaxImages() + "]";
                    surfaces.add(this.m_imageReader.getSurface());
                }
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)logMessage);
                }
                this.m_cameraDevice.createCaptureSession(surfaces, new CameraCaptureSession.StateCallback(){

                    public void onActive(CameraCaptureSession session) {
                        if (Log.isLoggable((String)"Video", (int)4)) {
                            Log.i((String)"Video", (String)("capture session[" + session + "] onActive enter"));
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onConfigured(CameraCaptureSession session) {
                        if (Log.isLoggable((String)"Video", (int)4)) {
                            Log.i((String)"Video", (String)("capture session[" + session + "] onConfigured enter"));
                        }
                        Object object = RealCamera2Impl.this.m_cameraStateMonitor;
                        synchronized (object) {
                            RealCamera2Impl.this.m_captureSessionOpening = false;
                            RealCamera2Impl.this.m_captureSessionClosed = false;
                            RealCamera2Impl.this.m_captureSession = session;
                            RealCamera2Impl.this.setupCaptureRequest(surfaces);
                            RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onConfigureFailed(CameraCaptureSession session) {
                        if (Log.isLoggable((String)"Video", (int)4)) {
                            Log.i((String)"Video", (String)("capture session[" + session + "] onConfigureFailed enter"));
                        }
                        Object object = RealCamera2Impl.this.m_cameraStateMonitor;
                        synchronized (object) {
                            RealCamera2Impl.this.m_captureSessionOpening = false;
                            session.close();
                            RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClosed(CameraCaptureSession session) {
                        if (Log.isLoggable((String)"Video", (int)4)) {
                            Log.i((String)"Video", (String)("capture session[" + session + "] onClosed enter"));
                        }
                        Object object = RealCamera2Impl.this.m_cameraStateMonitor;
                        synchronized (object) {
                            RealCamera2Impl.this.m_captureSessionOpening = false;
                            RealCamera2Impl.this.m_captureSessionClosed = true;
                            RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
                        }
                    }

                    public void onReady(CameraCaptureSession session) {
                        if (Log.isLoggable((String)"Video", (int)4)) {
                            Log.i((String)"Video", (String)("capture session[" + session + "] onReady enter"));
                        }
                    }
                }, this.m_backgroundHandler);
            }
            catch (CameraAccessException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"start preview failed with CameraAccessException");
                }
                throw new CaptureException("CameraAccessException, Could not start preview from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_START_PREVIEW_FAILED);
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"start preview failed with RuntimeException");
                }
                throw new CaptureException("Could not start preview from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_START_PREVIEW_FAILED);
            }
        }
        if (Log.isLoggable((String)"Video", (int)6)) {
            Log.e((String)"Video", (String)"Start preview without camera opened");
        }
        throw new CaptureException("Could not start preview without camera " + this.m_cameraId, ErrorCode.ANDROID_CAMERA_START_PREVIEW_FAILED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopPreview() throws CaptureException {
        Object object = this.m_cameraStateMonitor;
        synchronized (object) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("stopping preview session [" + this.m_captureSession + "]"));
            }
            try {
                this.waitForCaptureSessionOpen(15000L);
                this.m_captureSessionOpening = false;
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("stopping preview session really [" + this.m_captureSession + "]"));
                }
                if (this.m_captureSession != null) {
                    this.m_captureSession.stopRepeating();
                    this.m_captureSession.abortCaptures();
                    this.m_captureSession.close();
                    this.waitForCaptureSessionClose(15000L);
                    this.m_captureSessionClosed = true;
                    this.m_captureSession = null;
                }
            }
            catch (CameraAccessException e) {
                throw new CaptureException("CameraAccessException for stopRepeating or abortCaptures from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_STOP_PREVIEW_FAILED);
            }
            catch (IllegalStateException e) {
                throw new CaptureException("IllegalStateException for stopRepeating or abortCaptures from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_STOP_PREVIEW_FAILED);
            }
            catch (RuntimeException e) {
                throw new CaptureException("Could not stop preview from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_STOP_PREVIEW_FAILED);
            }
            catch (InterruptedException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("InterruptedException: Could not close capture session: " + this.m_captureSession));
                }
                throw new CaptureException("InterruptedException for capture session from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_STOP_PREVIEW_FAILED);
            }
            finally {
                this.m_cameraStateMonitor.notifyAll();
            }
        }
    }

    @Override
    public void enableFaceDetection(boolean enableFaceDetection) throws CaptureException {
        if (enableFaceDetection == this.m_isFaceDetectionEnabled) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Camera already under m_isFaceDetectionEnabled = " + enableFaceDetection + " status!"));
            }
            return;
        }
        if (enableFaceDetection) {
            this.initFaceMatrix();
        }
        if (this.m_captureSession != null && this.m_captureBuilder != null) {
            this.updateRepeatingRequest(enableFaceDetection);
        } else if (Log.isLoggable((String)"Video", (int)5)) {
            Log.w((String)"Video", (String)("EnableFaceDetection with status " + enableFaceDetection + " but camera not started preview!"));
        }
        this.m_isFaceDetectionEnabled = enableFaceDetection;
    }

    @Override
    public final Matrix getFaceTransferMatrix() {
        return this.matrix;
    }

    private void setupCaptureRequest(List<Surface> surfaces) {
        block10: {
            try {
                this.m_captureBuilder = this.m_cameraDevice.createCaptureRequest(1);
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("setting CONTROL_AE_TARGET_FPS_RANGE, min:" + this.m_cameraParameters.getFpsRange().getMin() / 1000 + " max:" + this.m_cameraParameters.getFpsRange().getMax() / 1000));
                }
                this.m_captureBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(this.m_cameraParameters.getFpsRange().getMin() / 1000), (Comparable)Integer.valueOf(this.m_cameraParameters.getFpsRange().getMax() / 1000)));
                for (Surface surface : surfaces) {
                    this.m_captureBuilder.addTarget(surface);
                }
                this.updateRepeatingRequest(this.m_isFaceDetectionEnabled);
            }
            catch (CameraAccessException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("CameraAccessException: for setRepeatingRequest [" + this.m_captureSession + "], reason[" + e.getReason() + "]"));
                }
            }
            catch (IllegalStateException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("IllegalStateException : for setRepeatingRequest [" + this.m_captureSession + "]"));
                }
            }
            catch (IllegalArgumentException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("IllegalArgumentException : for setRepeatingRequest [" + this.m_captureSession + "]"));
                }
            }
            catch (CaptureException e) {
                if (!Log.isLoggable((String)"Video", (int)6)) break block10;
                Log.e((String)"Video", (String)("CaptureException : for startFaceDetectionRepeatingRequest [" + this.m_captureSession + "]"));
            }
        }
    }

    private void updateRepeatingRequest(boolean enableFaceDetection) throws CaptureException {
        try {
            if (enableFaceDetection) {
                this.m_captureBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.getFaceDetectMode());
                this.m_captureSession.setRepeatingRequest(this.m_captureBuilder.build(), this.m_captureCallback, null);
            } else {
                this.m_captureBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                this.m_captureSession.setRepeatingRequest(this.m_captureBuilder.build(), null, null);
            }
        }
        catch (CameraAccessException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("CameraAccessException: for setRepeatingRequest [" + this.m_captureSession + "], reason[" + e.getReason() + "]"));
            }
            throw new CaptureException("StartFaceDetectionRepeatingRequest failed, CameraAccessException", ErrorCode.ANDROID_CAMERA_START_REPEAT_REQUEST_FAILED);
        }
        catch (IllegalStateException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("IllegalStateException : for setRepeatingRequest [" + this.m_captureSession + "]"));
            }
            throw new CaptureException("StartFaceDetectionRepeatingRequest failed, IllegalStateException", ErrorCode.ANDROID_CAMERA_START_REPEAT_REQUEST_FAILED);
        }
        catch (IllegalArgumentException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("IllegalArgumentException : for setRepeatingRequest [" + this.m_captureSession + "]"));
            }
            throw new CaptureException("StartFaceDetectionRepeatingRequest failed, IllegalArgumentException", ErrorCode.ANDROID_CAMERA_START_REPEAT_REQUEST_FAILED);
        }
    }

    private void initFaceMatrix() throws CaptureException {
        CameraCapabilities cameraCapabilities = CameraManagerSingleton.getInstance().getCameraCapabilities(this.m_cameraId);
        if (cameraCapabilities == null) {
            return;
        }
        Rect arraySize = cameraCapabilities.getCameraArraySize().toRect();
        if (arraySize == null) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Got empty camera2 array size");
            }
            return;
        }
        this.matrix = new Matrix();
        float arraySizeWidth = arraySize.width();
        float arraySizeHeight = arraySize.height();
        this.matrix.setScale(1.0f / arraySizeWidth, 1.0f / arraySizeHeight);
        boolean isFrontCamera = cameraCapabilities.getFacing().ordinal() == CameraCapabilities.Facing.FRONT.ordinal();
        int finalAngle = isFrontCamera ? 360 - this.m_displayOrientation : this.m_displayOrientation;
        this.matrix.postRotate((float)finalAngle, 0.5f, 0.5f);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Camera2 face matrix config { isFrontCamera: " + isFrontCamera + ", displayOrientation: " + this.m_displayOrientation + ", arraySizeWidth: " + arraySizeWidth + ", arraySizeHeight: " + arraySizeHeight + " }"));
        }
    }

    private int getFaceDetectMode() throws CaptureException {
        NavigableSet<Integer> faceDetectMode;
        if (this.m_capabilities == null) {
            this.m_capabilities = CameraManagerSingleton.getInstance().getCameraCapabilities(this.m_cameraId);
        }
        if (this.m_capabilities != null && (faceDetectMode = this.m_capabilities.getSupportedFaceDetectModes()) != null && faceDetectMode.size() > 0) {
            if (faceDetectMode.contains(1)) {
                return 1;
            }
            return (Integer)faceDetectMode.last();
        }
        if (Log.isLoggable((String)"Video", (int)6)) {
            Log.e((String)"Video", (String)"Face detection supported, but no visible detection mode.");
        }
        return 0;
    }

    private static class ImageReaderCallback
    implements ImageReader.OnImageAvailableListener {
        private final CameraCallback mCallback;

        private ImageReaderCallback(CameraCallback callback) {
            this.mCallback = callback;
        }

        public void onImageAvailable(ImageReader reader) {
            Image image = reader.acquireLatestImage();
            if (image == null) {
                return;
            }
            Image.Plane[] planes = image.getPlanes();
            Image.Plane yPlane = planes[0];
            Image.Plane uPlane = planes[1];
            Image.Plane vPlane = planes[2];
            this.mCallback.onCpuFrameCaptured(yPlane.getBuffer(), yPlane.getRowStride(), uPlane.getBuffer(), vPlane.getBuffer(), vPlane.getRowStride(), vPlane.getPixelStride());
            image.close();
        }
    }

    private class Camera2Thread
    extends Thread {
        String cameraIdStr;
        CameraManager cameraManager;

        public Camera2Thread(CameraManager cameraManager, String cameraIdStr) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Camera2Thread: cameraIdStr:" + cameraIdStr + " cameraManager:" + cameraManager));
            }
            this.cameraManager = cameraManager;
            this.cameraIdStr = cameraIdStr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)"Starting Camera2Thread instance");
                }
                Looper.prepare();
                this.cameraManager.openCamera(this.cameraIdStr, RealCamera2Impl.this.mStateCallback, null);
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Camera2Thread: open camera end:" + this.cameraIdStr + " cameraManager:" + this.cameraManager));
                }
                RealCamera2Impl.this.m_looper = Looper.myLooper();
                Looper.loop();
            }
            catch (CameraAccessException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("CameraAccessException[" + (Object)((Object)e) + "],  Could not open camera: " + this.cameraIdStr));
                }
                Object object = RealCamera2Impl.this.m_cameraStateMonitor;
                synchronized (object) {
                    RealCamera2Impl.this.m_exception = new CaptureException("Could not open camera " + this.cameraIdStr, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
                    RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
                }
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("Exception[" + e + "], caught (" + this.cameraIdStr + ")"));
                }
                Object object = RealCamera2Impl.this.m_cameraStateMonitor;
                synchronized (object) {
                    RealCamera2Impl.this.m_exception = new CaptureException("Could not open camera " + this.cameraIdStr, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
                    RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
                }
            }
        }
    }

    public static abstract class StateListener {
        public void onOpened(String cameraId) {
        }

        public void onDisconnected(String cameraId) {
        }

        public void onError(String cameraId) {
        }

        public void onClosed(String cameraId) {
        }
    }
}

