/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.real.impl2;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraManager;
import android.os.Handler;
import android.os.HandlerThread;
import com.microsoft.dl.Platform;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.DeviceManager;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerFactory;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import com.microsoft.dl.video.capture.impl.real.impl2.Camera2CapabilitiesUtils;
import com.microsoft.dl.video.capture.impl.real.impl2.RealCamera2Impl;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class RealCamera2ManagerImpl
implements com.microsoft.dl.video.capture.api.CameraManager {
    private static final int REFRESH_DEVICE_DELAY_TIME = 10;
    private final Object m_capabilitiesLock = new Object();
    private Map<String, CameraCapabilities> m_capabilities;
    private final HandlerThread m_backgroundThread;
    private Handler m_backgroundHandler;
    private final CameraManager.AvailabilityCallback m_availabilityCallback = new CameraManager.AvailabilityCallback(){

        public void onCameraAvailable(String cameraId) {
            super.onCameraAvailable(cameraId);
            Log.i((String)"Video", (String)("AvailabilityCallback:onCameraAvailable cameraId=" + cameraId));
            RealCamera2ManagerImpl.this.refreshCameraDevice(cameraId, true);
        }

        public void onCameraUnavailable(String cameraId) {
            super.onCameraUnavailable(cameraId);
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("AvailabilityCallback:onCameraUnavailable cameraId=" + cameraId));
            }
            RealCamera2ManagerImpl.this.refreshCameraDevice(cameraId, false);
        }
    };
    private final RealCamera2Impl.StateListener m_stateListener = new RealCamera2Impl.StateListener(){

        @Override
        public void onDisconnected(String cameraId) {
            RealCamera2ManagerImpl.this.refreshCameraDevice(cameraId, false);
        }

        @Override
        public void onError(String cameraId) {
            RealCamera2ManagerImpl.this.refreshCameraDevice(cameraId, false);
        }
    };

    private RealCamera2ManagerImpl() {
        this.m_backgroundThread = new BackgroundThread();
        this.m_backgroundThread.start();
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"CAMERA2:created");
        }
    }

    @Override
    public final String[] getCameraIds() throws CaptureException {
        Context ctx;
        CameraManager cameraManager;
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("CAMERA2:getCameraIds starts with instance=" + this));
        }
        if ((cameraManager = (CameraManager)(ctx = Platform.getInfo().getAppContext()).getSystemService("camera")) == null) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"ERROR:cameraManager is null");
            }
            throw new CaptureException("android.hardware.camera2.CameraManager null", ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
        }
        try {
            return cameraManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"ERROR:get cameras exception caught=", (Throwable)e);
            }
            throw new CaptureException(e, ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
        }
    }

    @Override
    public final Camera openCamera(String id) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("CAMERA2:openCamera=" + id));
        }
        return new RealCamera2Impl(id, this.m_stateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CameraCapabilities getCameraCapabilities(String id) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)"CAMERA2:getCameraCapabilities");
        }
        Object object = this.m_capabilitiesLock;
        synchronized (object) {
            if (this.m_capabilities == null) {
                this.m_capabilities = Camera2CapabilitiesUtils.obtain();
            }
            if (!this.m_capabilities.containsKey(id)) {
                this.collectCameraCapabilities(id);
            }
            if (this.m_capabilities == null || !this.m_capabilities.containsKey(id)) {
                throw new CaptureException("ERROR:no such camera id=" + id, ErrorCode.ANDROID_CAMERA_INVALID_ID);
            }
            return Objects.requireNonNull(this.m_capabilities.get(id)).clone();
        }
    }

    @Override
    public final StaticCameraCapabilities getStaticCameraCapabilities(String id) throws CaptureException {
        return this.getCameraCapabilities(id);
    }

    @Override
    public void close() {
        Context ctx = Platform.getInfo().getAppContext();
        CameraManager cameraManager = (CameraManager)ctx.getSystemService("camera");
        if (cameraManager != null) {
            cameraManager.unregisterAvailabilityCallback(this.m_availabilityCallback);
        }
        if (this.m_backgroundHandler != null) {
            this.m_backgroundHandler.removeCallbacksAndMessages(null);
        }
        this.m_backgroundThread.quitSafely();
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"CAMERA2:closed");
        }
    }

    private void refreshCameraDevice(String id, boolean available) {
        if (this.m_backgroundHandler != null) {
            this.m_backgroundHandler.postDelayed((Runnable)new RefreshDeviceRunnable(id, available), available ? 0L : 10L);
        } else if (Log.isLoggable((String)"Video", (int)6)) {
            Log.e((String)"Video", (String)"ERROR:refresh camera device without handler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectCameraCapabilities(String cameraId) throws CaptureException {
        CameraCapabilities availableCameraCap = Camera2CapabilitiesUtils.getCameraCapabilities(cameraId);
        Object object = this.m_capabilitiesLock;
        synchronized (object) {
            if (this.m_capabilities != null && !this.m_capabilities.containsKey(cameraId)) {
                this.m_capabilities.put(cameraId, availableCameraCap);
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("CAMERA2:collection camera capabilities=" + availableCameraCap));
                }
            }
        }
    }

    public static class Factory
    implements CameraManagerFactory {
        @Override
        public final com.microsoft.dl.video.capture.api.CameraManager createCameraManager() {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"CAMERA2:createCameraManager");
            }
            return new RealCamera2ManagerImpl();
        }
    }

    private class RefreshDeviceRunnable
    implements Runnable {
        private final String m_cameraId;
        private final boolean m_available;

        RefreshDeviceRunnable(String id, boolean available) {
            this.m_cameraId = id;
            this.m_available = available;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("RefreshDeviceRunnable:run camera=" + this.m_cameraId + " available=" + this.m_available));
                }
                try {
                    if (this.m_cameraId == null) {
                        return;
                    }
                    if (this.m_available) {
                        if (DeviceManager.getInstance().isDeviceListed(this.m_cameraId)) {
                            if (Log.isLoggable((String)"Video", (int)4)) {
                                Log.i((String)"Video", (String)("RefreshDeviceRunnable: camera=" + this.m_cameraId + " already added"));
                            }
                            return;
                        }
                        RealCamera2ManagerImpl.this.getCameraCapabilities(this.m_cameraId);
                        DeviceManager.getInstance().notifyDeviceChanged(this.m_cameraId, true);
                        break block15;
                    }
                    if (Arrays.asList(RealCamera2ManagerImpl.this.getCameraIds()).contains(this.m_cameraId)) {
                        if (Log.isLoggable((String)"Video", (int)4)) {
                            Log.i((String)"Video", (String)("RefreshDeviceRunnable: camera=" + this.m_cameraId + " not detached really"));
                        }
                        return;
                    }
                    Object object = RealCamera2ManagerImpl.this.m_capabilitiesLock;
                    synchronized (object) {
                        CameraCapabilities removedCapabilities = null;
                        if (RealCamera2ManagerImpl.this.m_capabilities != null) {
                            removedCapabilities = (CameraCapabilities)RealCamera2ManagerImpl.this.m_capabilities.remove(this.m_cameraId);
                        }
                        if (removedCapabilities == null) {
                            if (Log.isLoggable((String)"Video", (int)4)) {
                                Log.i((String)"Video", (String)("RefreshDeviceRunnable: camera=" + this.m_cameraId + " capabilities not found"));
                            }
                            return;
                        }
                    }
                    DeviceManager.getInstance().notifyDeviceChanged(this.m_cameraId, false);
                }
                catch (CaptureException e) {
                    if (!Log.isLoggable((String)"Video", (int)6)) break block15;
                    Log.e((String)"Video", (String)"RefreshDeviceRunnable:run refresh device exception caught=", (Throwable)e);
                }
            }
        }
    }

    private class BackgroundThread
    extends HandlerThread {
        public BackgroundThread() {
            super("RealCamera2ManagerImpl:BackgroundThread");
        }

        protected void onLooperPrepared() {
            super.onLooperPrepared();
            RealCamera2ManagerImpl.this.m_backgroundHandler = new Handler(this.getLooper());
            Context ctx = Platform.getInfo().getAppContext();
            CameraManager cameraManager = (CameraManager)ctx.getSystemService("camera");
            if (cameraManager == null) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"BackgroundThread:onLooperPrepared cameraManager is null");
                }
                return;
            }
            cameraManager.registerAvailabilityCallback(RealCamera2ManagerImpl.this.m_availabilityCallback, RealCamera2ManagerImpl.this.m_backgroundHandler);
        }
    }
}

