/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.CallOptions;
import com.azure.android.communication.calling.IncomingAudioOptions;
import com.azure.android.communication.calling.IncomingVideoOptions;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioOptions;
import com.azure.android.communication.calling.OutgoingVideoOptions;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class AcceptTeamsCallOptions
extends CallOptions {
    AcceptTeamsCallOptions(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_accept_teams_call_options_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public AcceptTeamsCallOptions() {
        super(AcceptTeamsCallOptions.Create(), true);
    }

    @Override
    public AcceptTeamsCallOptions setIncomingVideoOptions(IncomingVideoOptions value) {
        super.setIncomingVideoOptions(value);
        return this;
    }

    @Override
    public AcceptTeamsCallOptions setOutgoingVideoOptions(OutgoingVideoOptions value) {
        super.setOutgoingVideoOptions(value);
        return this;
    }

    @Override
    public AcceptTeamsCallOptions setIncomingAudioOptions(IncomingAudioOptions value) {
        super.setIncomingAudioOptions(value);
        return this;
    }

    @Override
    public AcceptTeamsCallOptions setOutgoingAudioOptions(OutgoingAudioOptions value) {
        super.setOutgoingAudioOptions(value);
        return this;
    }

    static AcceptTeamsCallOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.AcceptTeamsCallOptions, AcceptTeamsCallOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.AcceptTeamsCallOptions, AcceptTeamsCallOptions.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

