/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;

public final class AdmitAllParticipantsResult {
    long handle;

    AdmitAllParticipantsResult(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_admit_all_participants_result_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_admit_all_participants_result_release(this.handle));
        this.handle = 0L;
    }

    public int getSuccessCount() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_admit_all_participants_result_get_success_count(this.handle, result));
        return (Integer)result.value;
    }

    public int getFailureCount() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_admit_all_participants_result_get_failure_count(this.handle, result));
        return (Integer)result.value;
    }

    static AdmitAllParticipantsResult getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.AdmitAllParticipantsResult, AdmitAllParticipantsResult.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_admit_all_participants_result_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.AdmitAllParticipantsResult, AdmitAllParticipantsResult.class, false);
    }
}

