/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AddPhoneNumberOptions;
import com.azure.android.communication.calling.CommonCall;
import com.azure.android.communication.calling.ErrorInfo;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.LocalVideoStreamsUpdatedEvent;
import com.azure.android.communication.calling.LocalVideoStreamsUpdatedListener;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import com.azure.android.communication.calling.RemoteParticipant;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.communication.common.PhoneNumberIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Call
extends CommonCall {
    private List<LocalVideoStreamsUpdatedListener> OnLocalVideoStreamsUpdatedListeners = new CopyOnWriteArrayList<LocalVideoStreamsUpdatedListener>();
    private List<PropertyChangedListener> OnIsMutedChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();

    Call(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    Call(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    @Deprecated
    public boolean isMuted() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_is_muted(this.handle, result));
        return (Boolean)result.value;
    }

    @Deprecated
    public List<LocalVideoStream> getLocalVideoStreams() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_local_video_streams(this.handle, result, result_length));
        ArrayList<LocalVideoStream> resultList = new ArrayList<LocalVideoStream>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(LocalVideoStream.getInstance(resultArray[i], true));
        }
        List<LocalVideoStream> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private static void OnLocalVideoStreamsUpdatedStaticHandler(long cookie, long args) {
        Call instance = Call.getInstance(cookie);
        if (instance != null) {
            LocalVideoStreamsUpdatedEvent args_converted = args != 0L ? LocalVideoStreamsUpdatedEvent.getInstance(args, false) : null;
            for (LocalVideoStreamsUpdatedListener listener : instance.OnLocalVideoStreamsUpdatedListeners) {
                listener.onLocalVideoStreamsUpdated(args_converted);
            }
        }
    }

    @Deprecated
    public void addOnLocalVideoStreamsUpdatedListener(LocalVideoStreamsUpdatedListener listener) {
        this.OnLocalVideoStreamsUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnLocalVideoStreamsUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_local_video_streams_updated(this.handle, this.getHandle(), this));
    }

    @Deprecated
    public void removeOnLocalVideoStreamsUpdatedListener(LocalVideoStreamsUpdatedListener listener) {
        this.OnLocalVideoStreamsUpdatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnLocalVideoStreamsUpdated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_local_video_streams_updated(this.handle, 0L, null));
        }
    }

    private static void OnIsMutedChangedStaticHandler(long cookie, long args) {
        Call instance = Call.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnIsMutedChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    @Deprecated
    public void addOnIsMutedChangedListener(PropertyChangedListener listener) {
        this.OnIsMutedChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsMutedChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_is_muted_changed(this.handle, this.getHandle(), this));
    }

    @Deprecated
    public void removeOnIsMutedChangedListener(PropertyChangedListener listener) {
        this.OnIsMutedChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsMutedChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_is_muted_changed(this.handle, 0L, null));
        }
    }

    private RemoteParticipant addParticipant(String participant) {
        Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_add_participant_string_participant(this.handle, participant, result_handle, errorContext), (ErrorInfo)errorContext.value);
        RemoteParticipant result_object = (Long)result_handle.value != 0L ? RemoteParticipant.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private RemoteParticipant addParticipant(String participant, AddPhoneNumberOptions options) {
        Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
        long options_converted = options != null ? options.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_add_participant_string_participant_add_phone_number_options_options(this.handle, participant, options_converted, result_handle, errorContext), (ErrorInfo)errorContext.value);
        RemoteParticipant result_object = (Long)result_handle.value != 0L ? RemoteParticipant.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    static Call getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.Call, Call.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_common_call_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.Call, Call.class, false);
    }

    private static Call getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.Call, Call.class, false);
    }

    @Override
    void restoreEventHandlers() {
        super.restoreEventHandlers();
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnLocalVideoStreamsUpdated")) {
            this.addOnLocalVideoStreamsUpdatedListener((LocalVideoStreamsUpdatedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsMutedChanged")) {
            this.addOnIsMutedChangedListener((PropertyChangedListener)eventListener);
        }
    }

    public RemoteParticipant addParticipant(CommunicationIdentifier participant) {
        String participantString = IdentifierHelpers.toMRI(participant);
        return this.addParticipant(participantString);
    }

    public RemoteParticipant addParticipant(PhoneNumberIdentifier participant, AddPhoneNumberOptions addPhoneNumberOptions) {
        String participantString = IdentifierHelpers.toMRI((CommunicationIdentifier)participant);
        return this.addParticipant(participantString, addPhoneNumberOptions);
    }
}

