/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.AudioOptions;
import com.azure.android.communication.calling.Call;
import com.azure.android.communication.calling.CallsUpdatedEvent;
import com.azure.android.communication.calling.CallsUpdatedListener;
import com.azure.android.communication.calling.CommonCallAgent;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.IncomingCall;
import com.azure.android.communication.calling.IncomingCallListener;
import com.azure.android.communication.calling.JoinCallOptions;
import com.azure.android.communication.calling.JoinMeetingLocator;
import com.azure.android.communication.calling.ModeInCommunicationHelper;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.PermissionUtility;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.StartCallOptions;
import com.azure.android.communication.calling.TelecomConnectionManager;
import com.azure.android.communication.calling.TelecomManagerIncomingCallEvent;
import com.azure.android.communication.calling.TelecomManagerIncomingCallListener;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class CallAgent
extends CommonCallAgent {
    private List<CallsUpdatedListener> OnCallsUpdatedListeners = new CopyOnWriteArrayList<CallsUpdatedListener>();
    private List<IncomingCallListener> OnIncomingCallListeners = new CopyOnWriteArrayList<IncomingCallListener>();
    private List<TelecomManagerIncomingCallListener> TelecomManagerOnIncomingCallListeners = new CopyOnWriteArrayList<TelecomManagerIncomingCallListener>();

    CallAgent(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    CallAgent(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public List<Call> getCalls() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_get_calls(this.handle, result, result_length));
        ArrayList<Call> resultList = new ArrayList<Call>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(Call.getInstance(resultArray[i], true));
        }
        List<Call> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private boolean isTelecomManagerEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_get_is_telecom_manager_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    private String getTelecomManagerAccountId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_get_telecom_manager_account_id(this.handle, result));
        return (String)result.value;
    }

    private static void OnCallsUpdatedStaticHandler(long cookie, long args) {
        CallAgent instance = CallAgent.getInstance(cookie);
        if (instance != null) {
            CallsUpdatedEvent args_converted = args != 0L ? CallsUpdatedEvent.getInstance(args, false) : null;
            for (CallsUpdatedListener listener : instance.OnCallsUpdatedListeners) {
                listener.onCallsUpdated(args_converted);
            }
        }
    }

    public void addOnCallsUpdatedListener(CallsUpdatedListener listener) {
        this.OnCallsUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCallsUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_set_on_calls_updated(this.handle, this.getHandle(), this));
    }

    public void removeOnCallsUpdatedListener(CallsUpdatedListener listener) {
        this.OnCallsUpdatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCallsUpdated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_set_on_calls_updated(this.handle, 0L, null));
        }
    }

    private static void OnIncomingCallStaticHandler(long cookie, long incomingCall) {
        CallAgent instance = CallAgent.getInstance(cookie);
        if (instance != null) {
            IncomingCall incomingCall_converted = incomingCall != 0L ? IncomingCall.getInstance(incomingCall, false) : null;
            for (IncomingCallListener listener : instance.OnIncomingCallListeners) {
                listener.onIncomingCall(incomingCall_converted);
            }
        }
    }

    public void addOnIncomingCallListener(IncomingCallListener listener) {
        this.OnIncomingCallListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIncomingCall", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_set_on_incoming_call(this.handle, this.getHandle(), this));
    }

    public void removeOnIncomingCallListener(IncomingCallListener listener) {
        this.OnIncomingCallListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIncomingCall", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_set_on_incoming_call(this.handle, 0L, null));
        }
    }

    private static void TelecomManagerOnIncomingCallStaticHandler(long cookie, long args) {
        CallAgent instance = CallAgent.getInstance(cookie);
        if (instance != null) {
            TelecomManagerIncomingCallEvent args_converted = args != 0L ? TelecomManagerIncomingCallEvent.getInstance(args, false) : null;
            for (TelecomManagerIncomingCallListener listener : instance.TelecomManagerOnIncomingCallListeners) {
                listener.onTelecomManagerIncomingCall(args_converted);
            }
        }
    }

    private void addTelecomManagerOnIncomingCallListener(TelecomManagerIncomingCallListener listener) {
        this.TelecomManagerOnIncomingCallListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "TelecomManagerOnIncomingCall", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_set_telecom_manager_on_incoming_call(this.handle, this.getHandle(), this));
    }

    private void removeTelecomManagerOnIncomingCallListener(TelecomManagerIncomingCallListener listener) {
        this.TelecomManagerOnIncomingCallListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "TelecomManagerOnIncomingCall", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_set_telecom_manager_on_incoming_call(this.handle, 0L, null));
        }
    }

    private Call startCallWithContext(Context context, String[] participants, StartCallOptions options) {
        long options_converted = options != null ? options.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_start_call_with_context(this.handle, context, participants, participants.length, options_converted, result_handle));
        Call result_object = (Long)result_handle.value != 0L ? Call.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private Call joinInternal(JoinMeetingLocator meetingLocator, JoinCallOptions joinCallOptions) {
        long meetingLocator_converted = meetingLocator != null ? meetingLocator.getHandle() : 0L;
        long joinCallOptions_converted = joinCallOptions != null ? joinCallOptions.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_join_internal(this.handle, meetingLocator_converted, joinCallOptions_converted, result_handle));
        Call result_object = (Long)result_handle.value != 0L ? Call.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    static CallAgent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallAgent, CallAgent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_common_call_agent_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallAgent, CallAgent.class, false);
    }

    private static CallAgent getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallAgent, CallAgent.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCallsUpdated")) {
            this.addOnCallsUpdatedListener((CallsUpdatedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIncomingCall")) {
            this.addOnIncomingCallListener((IncomingCallListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "TelecomManagerOnIncomingCall")) {
            this.addTelecomManagerOnIncomingCallListener((TelecomManagerIncomingCallListener)eventListener);
        }
    }

    public Call startCall(Context context, Iterable<CommunicationIdentifier> participants, StartCallOptions startCallOptions) {
        String[] participantsStrings = IdentifierHelpers.convertIdentifiersToMris(participants);
        PermissionUtility.throwIfNotAppropriatePermissions(context, startCallOptions != null ? startCallOptions.getOutgoingVideoOptions() : null, startCallOptions != null ? startCallOptions.getOutgoingAudioOptions() : null);
        Call call = this.startCallWithContext(context, participantsStrings, startCallOptions);
        if (startCallOptions != null && startCallOptions.getOutgoingAudioOptions() != null && startCallOptions.getOutgoingAudioOptions().isCommunicationAudioModeEnabled()) {
            ModeInCommunicationHelper.setModeInCommunication(context, call);
        }
        if (this.isTelecomManagerEnabled()) {
            TelecomConnectionManager.startOutgoingConnection(context, call.getHandle(), this.getTelecomManagerAccountId());
        }
        return call;
    }

    public Call startCall(Context context, Iterable<CommunicationIdentifier> participants) {
        String[] participantsStrings = IdentifierHelpers.convertIdentifiersToMris(participants);
        StartCallOptions callWithAudioOnly = new StartCallOptions();
        AudioOptions audioOptions = new AudioOptions();
        audioOptions.setMuted(false);
        callWithAudioOnly.setAudioOptions(audioOptions);
        PermissionUtility.throwIfNotAppropriatePermissions(context, null, audioOptions);
        Call call = this.startCallWithContext(context, participantsStrings, callWithAudioOnly);
        if (callWithAudioOnly != null && callWithAudioOnly.getOutgoingAudioOptions() != null && callWithAudioOnly.getOutgoingAudioOptions().isCommunicationAudioModeEnabled()) {
            ModeInCommunicationHelper.setModeInCommunication(context, call);
        }
        if (this.isTelecomManagerEnabled()) {
            TelecomConnectionManager.startOutgoingConnection(context, call.getHandle(), this.getTelecomManagerAccountId());
        }
        return call;
    }

    public Call join(Context context, JoinMeetingLocator meetingLocator, JoinCallOptions joinCallOptions) {
        PermissionUtility.throwIfNotAppropriatePermissions(context, joinCallOptions != null ? joinCallOptions.getOutgoingVideoOptions() : null, joinCallOptions != null ? joinCallOptions.getOutgoingAudioOptions() : null);
        Call call = this.joinInternal(meetingLocator, joinCallOptions);
        if (joinCallOptions != null && joinCallOptions.getOutgoingAudioOptions() != null && joinCallOptions.getOutgoingAudioOptions().isCommunicationAudioModeEnabled()) {
            ModeInCommunicationHelper.setModeInCommunication(context, call);
        }
        if (this.isTelecomManagerEnabled()) {
            TelecomConnectionManager.startOutgoingConnection(context, call.getHandle(), this.getTelecomManagerAccountId());
        }
        return call;
    }

    void addTelecomManagerOnIncomingCallListenerInternal(TelecomManagerIncomingCallListener listener) {
        this.addTelecomManagerOnIncomingCallListener(listener);
    }

    static void TriggerOnIncomingCallStaticHandler(long cookie, long incomingCall) {
        CallAgent.OnIncomingCallStaticHandler(cookie, incomingCall);
    }
}

