/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import androidx.annotation.RequiresApi;
import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.CommonCallAgentOptions;
import com.azure.android.communication.calling.EmergencyCallOptions;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.TelecomManagerOptions;

public final class CallAgentOptions
extends CommonCallAgentOptions {
    CallAgentOptions(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_call_agent_options_create(result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public CallAgentOptions() {
        super(CallAgentOptions.Create(), true);
    }

    public String getDisplayName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_get_display_name(this.handle, result));
        return (String)result.value;
    }

    public CallAgentOptions setDisplayName(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_set_display_name(this.handle, value));
        return this;
    }

    public EmergencyCallOptions getEmergencyCallOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_get_emergency_call_options(this.handle, result_handle));
        EmergencyCallOptions result_object = (Long)result_handle.value != 0L ? EmergencyCallOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallAgentOptions setEmergencyCallOptions(EmergencyCallOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_set_emergency_call_options(this.handle, value_converted));
        return this;
    }

    private int getPushNotificationTtl() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_get_push_notification_ttl(this.handle, result));
        return (Integer)result.value;
    }

    private CallAgentOptions setPushNotificationTtl(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_options_set_push_notification_ttl(this.handle, value));
        return this;
    }

    @Override
    public CallAgentOptions setDisableInternalPushForIncomingCall(boolean value) {
        super.setDisableInternalPushForIncomingCall(value);
        return this;
    }

    @Override
    @RequiresApi(value=25)
    public CallAgentOptions setTelecomManagerOptions(TelecomManagerOptions value) {
        super.setTelecomManagerOptions(value);
        return this;
    }

    static CallAgentOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallAgentOptions, CallAgentOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_common_call_agent_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallAgentOptions, CallAgentOptions.class, false);
    }

    public Integer getPushNotificationTtlInSeconds() {
        return this.getPushNotificationTtl();
    }

    public CallAgentOptions setPushNotificationTtlInSeconds(Integer value) {
        this.setPushNotificationTtl(value);
        return this;
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

