/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CallDebugInfo {
    long handle;

    CallDebugInfo(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_debug_info_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_debug_info_release(this.handle));
        this.handle = 0L;
    }

    private List<String> getSupportFilesInternal() {
        Out<String[]> result = new Out<String[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_debug_info_get_support_files_internal(this.handle, result, result_length));
        return Arrays.asList((String[])result.value);
    }

    static CallDebugInfo getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallDebugInfo, CallDebugInfo.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_debug_info_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallDebugInfo, CallDebugInfo.class, false);
    }

    public List<File> getSupportFiles() {
        List<String> filePaths = this.getSupportFilesInternal();
        ArrayList<File> files = new ArrayList<File>();
        for (String path : filePaths) {
            files.add(new File(path));
        }
        return files;
    }
}

