/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import java.util.Arrays;
import java.util.List;

public final class CallDiagnosticsOptions {
    long handle;

    CallDiagnosticsOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_diagnostics_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public CallDiagnosticsOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_call_diagnostics_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_diagnostics_options_release(this.handle));
        this.handle = 0L;
    }

    public String getAppName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_diagnostics_options_get_app_name(this.handle, result));
        return (String)result.value;
    }

    public CallDiagnosticsOptions setAppName(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_diagnostics_options_set_app_name(this.handle, value));
        return this;
    }

    public String getAppVersion() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_diagnostics_options_get_app_version(this.handle, result));
        return (String)result.value;
    }

    public CallDiagnosticsOptions setAppVersion(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_diagnostics_options_set_app_version(this.handle, value));
        return this;
    }

    private String[] getTagsInternal() {
        Out<String[]> result = new Out<String[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_diagnostics_options_get_tags_internal(this.handle, result, result_length));
        return (String[])result.value;
    }

    private CallDiagnosticsOptions setTagsInternal(String[] value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_diagnostics_options_set_tags_internal(this.handle, value, value.length));
        return this;
    }

    static CallDiagnosticsOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallDiagnosticsOptions, CallDiagnosticsOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_diagnostics_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallDiagnosticsOptions, CallDiagnosticsOptions.class, false);
    }

    public List<String> getTags() {
        return Arrays.asList(this.getTagsInternal());
    }

    public void setTags(List<String> value) {
        this.setTagsInternal(value.toArray(new String[0]));
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

