/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.IceServer;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CallNetworkOptions {
    long handle;

    CallNetworkOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_network_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public CallNetworkOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_call_network_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_network_options_release(this.handle));
        this.handle = 0L;
    }

    public String getProxyUrl() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_network_options_get_proxy_url(this.handle, result));
        return (String)result.value;
    }

    public CallNetworkOptions setProxyUrl(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_network_options_set_proxy_url(this.handle, value));
        return this;
    }

    public List<IceServer> getIceServers() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_network_options_get_ice_servers(this.handle, result, result_length));
        ArrayList<IceServer> resultList = new ArrayList<IceServer>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(IceServer.getInstance(resultArray[i], true));
        }
        List<IceServer> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private void setIceServersInternal(IceServer[] iceServers) {
        long[] iceServers_converted = new long[iceServers.length];
        for (int i = 0; i < iceServers.length; ++i) {
            iceServers_converted[i] = iceServers[i].handle;
        }
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_network_options_set_ice_servers_internal(this.handle, iceServers_converted, iceServers.length));
    }

    static CallNetworkOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallNetworkOptions, CallNetworkOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_network_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallNetworkOptions, CallNetworkOptions.class, false);
    }

    public CallNetworkOptions setIceServers(List<IceServer> iceServers) {
        IceServer[] iceServerList = new IceServer[iceServers.size()];
        for (int i = 0; i < iceServers.size(); ++i) {
            iceServerList[i] = iceServers.get(i);
        }
        this.setIceServersInternal(iceServerList);
        return this;
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

