/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioIssue;
import com.azure.android.communication.calling.CallIssue;
import com.azure.android.communication.calling.CallSurveyScore;
import com.azure.android.communication.calling.InternalObjectHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ScreenShareIssue;
import com.azure.android.communication.calling.VideoIssue;
import java.util.Arrays;
import java.util.EnumSet;

public final class CallSurvey {
    long handle;
    private EnumSet<CallIssue> callIssues;
    private EnumSet<AudioIssue> audioIssues;
    private EnumSet<VideoIssue> videoIssues;
    private EnumSet<ScreenShareIssue> screenShareIssues;

    CallSurvey(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_survey_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_release(this.handle));
        this.handle = 0L;
    }

    public CallSurveyScore getOverallScore() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_get_overall_score(this.handle, result_handle));
        CallSurveyScore result_object = (Long)result_handle.value != 0L ? CallSurveyScore.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallSurvey setOverallScore(CallSurveyScore value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_set_overall_score(this.handle, value_converted));
        return this;
    }

    public CallSurveyScore getAudioScore() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_get_audio_score(this.handle, result_handle));
        CallSurveyScore result_object = (Long)result_handle.value != 0L ? CallSurveyScore.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallSurvey setAudioScore(CallSurveyScore value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_set_audio_score(this.handle, value_converted));
        return this;
    }

    public CallSurveyScore getVideoScore() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_get_video_score(this.handle, result_handle));
        CallSurveyScore result_object = (Long)result_handle.value != 0L ? CallSurveyScore.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallSurvey setVideoScore(CallSurveyScore value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_set_video_score(this.handle, value_converted));
        return this;
    }

    public CallSurveyScore getScreenShareScore() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_get_screen_share_score(this.handle, result_handle));
        CallSurveyScore result_object = (Long)result_handle.value != 0L ? CallSurveyScore.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallSurvey setScreenShareScore(CallSurveyScore value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_set_screen_share_score(this.handle, value_converted));
        return this;
    }

    private void applyOverallIssues(long overallIssues) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_apply_overall_issues(this.handle, overallIssues));
    }

    private void applyAudioIssues(long audioIssues) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_apply_audio_issues(this.handle, audioIssues));
    }

    private void applyVideoIssues(long videoIssues) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_apply_video_issues(this.handle, videoIssues));
    }

    private void applyScreenShareIssues(long screenShareIssues) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_apply_screen_share_issues(this.handle, screenShareIssues));
    }

    static CallSurvey getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallSurvey, CallSurvey.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_survey_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallSurvey, CallSurvey.class, false);
    }

    public EnumSet<CallIssue> getOverallIssues() {
        return this.callIssues;
    }

    public EnumSet<AudioIssue> getAudioIssues() {
        return this.audioIssues;
    }

    public EnumSet<VideoIssue> getVideoIssues() {
        return this.videoIssues;
    }

    public EnumSet<ScreenShareIssue> getScreenShareIssues() {
        return this.screenShareIssues;
    }

    public CallSurvey setOverallIssues(EnumSet<CallIssue> overallIssues) {
        this.callIssues = this.callIssues;
        this.applyOverallIssues(InternalObjectHelpers.enumSetToLong(this.getOverallIssues()));
        return this;
    }

    public CallSurvey setOverallIssues(CallIssue ... overallIssues) {
        return this.setOverallIssues(EnumSet.copyOf(Arrays.asList(overallIssues)));
    }

    public CallSurvey setAudioIssues(EnumSet<AudioIssue> audioIssues) {
        this.audioIssues = audioIssues;
        this.applyAudioIssues(InternalObjectHelpers.enumSetToLong(this.getAudioIssues()));
        return this;
    }

    public CallSurvey setAudioIssues(AudioIssue ... audioIssues) {
        return this.setAudioIssues(EnumSet.copyOf(Arrays.asList(audioIssues)));
    }

    public CallSurvey setVideoIssues(EnumSet<VideoIssue> videoIssues) {
        this.videoIssues = videoIssues;
        this.applyVideoIssues(InternalObjectHelpers.enumSetToLong(this.getVideoIssues()));
        return this;
    }

    public CallSurvey setVideoIssues(VideoIssue ... videoIssues) {
        return this.setVideoIssues(EnumSet.copyOf(Arrays.asList(videoIssues)));
    }

    public CallSurvey setScreenShareIssues(EnumSet<ScreenShareIssue> screenShareIssues) {
        this.screenShareIssues = screenShareIssues;
        this.applyScreenShareIssues(InternalObjectHelpers.enumSetToLong(this.getScreenShareIssues()));
        return this;
    }

    public CallSurvey setScreenShareIssues(ScreenShareIssue ... screenShareIssues) {
        return this.setScreenShareIssues(EnumSet.copyOf(Arrays.asList(screenShareIssues)));
    }
}

