/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class CallSurveyRatingScale {
    long handle;

    CallSurveyRatingScale(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_survey_rating_scale_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public CallSurveyRatingScale() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_call_survey_rating_scale_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_rating_scale_release(this.handle));
        this.handle = 0L;
    }

    public int getLowerBound() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_rating_scale_get_lower_bound(this.handle, result));
        return (Integer)result.value;
    }

    public CallSurveyRatingScale setLowerBound(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_rating_scale_set_lower_bound(this.handle, value));
        return this;
    }

    public int getUpperBound() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_rating_scale_get_upper_bound(this.handle, result));
        return (Integer)result.value;
    }

    public CallSurveyRatingScale setUpperBound(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_rating_scale_set_upper_bound(this.handle, value));
        return this;
    }

    public int getLowScoreThreshold() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_rating_scale_get_low_score_threshold(this.handle, result));
        return (Integer)result.value;
    }

    public CallSurveyRatingScale setLowScoreThreshold(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_rating_scale_set_low_score_threshold(this.handle, value));
        return this;
    }

    static CallSurveyRatingScale getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallSurveyRatingScale, CallSurveyRatingScale.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_survey_rating_scale_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallSurveyRatingScale, CallSurveyRatingScale.class, false);
    }
}

