/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallSurveyRatingScale;
import com.azure.android.communication.calling.ErrorInfo;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class CallSurveyScore {
    long handle;

    CallSurveyScore(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_survey_score_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public CallSurveyScore() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_call_survey_score_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_score_release(this.handle));
        this.handle = 0L;
    }

    public int getScore() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_score_get_score(this.handle, result));
        return (Integer)result.value;
    }

    public CallSurveyScore setScore(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_score_set_score(this.handle, value));
        return this;
    }

    public CallSurveyRatingScale getScale() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_score_get_scale(this.handle, result_handle));
        CallSurveyRatingScale result_object = (Long)result_handle.value != 0L ? CallSurveyRatingScale.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallSurveyScore setScale(CallSurveyRatingScale value) {
        Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_survey_score_set_scale(this.handle, value_converted, errorContext), (ErrorInfo)errorContext.value);
        return this;
    }

    static CallSurveyScore getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallSurveyScore, CallSurveyScore.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_survey_score_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallSurveyScore, CallSurveyScore.class, false);
    }
}

