/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.CapabilitiesChangedEvent;
import com.azure.android.communication.calling.CapabilitiesChangedListener;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ParticipantCapability;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class CapabilitiesCallFeature
extends CallFeature {
    private List<CapabilitiesChangedListener> OnCapabilitiesChangedListeners = new CopyOnWriteArrayList<CapabilitiesChangedListener>();

    CapabilitiesCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    CapabilitiesCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public List<ParticipantCapability> getCapabilities() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_capabilities_call_feature_get_capabilities(this.handle, result, result_length));
        ArrayList<ParticipantCapability> resultList = new ArrayList<ParticipantCapability>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(ParticipantCapability.getInstance(resultArray[i], true));
        }
        List<ParticipantCapability> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private static void OnCapabilitiesChangedStaticHandler(long cookie, long args) {
        CapabilitiesCallFeature instance = CapabilitiesCallFeature.getInstance(cookie);
        if (instance != null) {
            CapabilitiesChangedEvent args_converted = args != 0L ? CapabilitiesChangedEvent.getInstance(args, false) : null;
            for (CapabilitiesChangedListener listener : instance.OnCapabilitiesChangedListeners) {
                listener.onCapabilitiesChanged(args_converted);
            }
        }
    }

    public void addOnCapabilitiesChangedListener(CapabilitiesChangedListener listener) {
        this.OnCapabilitiesChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCapabilitiesChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_capabilities_call_feature_set_on_capabilities_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnCapabilitiesChangedListener(CapabilitiesChangedListener listener) {
        this.OnCapabilitiesChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCapabilitiesChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_capabilities_call_feature_set_on_capabilities_changed(this.handle, 0L, null));
        }
    }

    static CapabilitiesCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CapabilitiesCallFeature, CapabilitiesCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CapabilitiesCallFeature, CapabilitiesCallFeature.class, false);
    }

    private static CapabilitiesCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CapabilitiesCallFeature, CapabilitiesCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCapabilitiesChanged")) {
            this.addOnCapabilitiesChangedListener((CapabilitiesChangedListener)eventListener);
        }
    }
}

