/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CapabilitiesChangedReason;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ParticipantCapability;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CapabilitiesChangedEvent {
    long handle;

    CapabilitiesChangedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_capabilities_changed_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_capabilities_changed_event_args_release(this.handle));
        this.handle = 0L;
    }

    public List<ParticipantCapability> getChangedCapabilities() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_capabilities_changed_event_args_get_changed_capabilities(this.handle, result, result_length));
        ArrayList<ParticipantCapability> resultList = new ArrayList<ParticipantCapability>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(ParticipantCapability.getInstance(resultArray[i], true));
        }
        List<ParticipantCapability> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public CapabilitiesChangedReason getReason() {
        Out<CapabilitiesChangedReason> result = new Out<CapabilitiesChangedReason>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_capabilities_changed_event_args_get_reason(this.handle, result));
        return (CapabilitiesChangedReason)((Object)result.value);
    }

    static CapabilitiesChangedEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CapabilitiesChangedEvent, CapabilitiesChangedEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_capabilities_changed_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CapabilitiesChangedEvent, CapabilitiesChangedEvent.class, false);
    }
}

