/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallCaptions;
import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Supplier;

public final class CaptionsCallFeature
extends CallFeature {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private List<PropertyChangedListener> OnActiveCaptionsTypeChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();

    CaptionsCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    CaptionsCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    private static void OnActiveCaptionsTypeChangedStaticHandler(long cookie, long args) {
        CaptionsCallFeature instance = CaptionsCallFeature.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnActiveCaptionsTypeChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnActiveCaptionsTypeChangedListener(PropertyChangedListener listener) {
        this.OnActiveCaptionsTypeChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnActiveCaptionsTypeChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_captions_call_feature_set_on_active_captions_type_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnActiveCaptionsTypeChangedListener(PropertyChangedListener listener) {
        this.OnActiveCaptionsTypeChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnActiveCaptionsTypeChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_captions_call_feature_set_on_active_captions_type_changed(this.handle, 0L, null));
        }
    }

    public CompletableFuture<CallCaptions> getCaptions() {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<CallCaptions>(){

            public CallCaptions get() {
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_captions_call_feature_get_captions(handle, result_handle));
                CallCaptions result_object = Factories.CallCaptionsFactory((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    static CaptionsCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CaptionsCallFeature, CaptionsCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CaptionsCallFeature, CaptionsCallFeature.class, false);
    }

    private static CaptionsCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CaptionsCallFeature, CaptionsCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnActiveCaptionsTypeChanged")) {
            this.addOnActiveCaptionsTypeChangedListener((PropertyChangedListener)eventListener);
        }
    }
}

