/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CommunicationCallType;
import com.azure.android.communication.calling.ErrorReporting;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.PushNotificationInfo;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public abstract class CommonCallAgent {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;

    CommonCallAgent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_common_call_agent_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_call_agent_release(this.handle));
        this.handle = 0L;
    }

    public CommunicationCallType getType() {
        Out<CommunicationCallType> result = new Out<CommunicationCallType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_call_agent_get_type(this.handle, result));
        return (CommunicationCallType)((Object)result.value);
    }

    private void disposeInternal() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_call_agent_dispose_internal(this.handle));
    }

    private CompletableFuture<Void> registerPushNotificationInternal(final String deviceToken) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_common_call_agent_register_push_notification_internal(handle, deviceToken));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> handlePushNotification(final PushNotificationInfo notification) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long notification_converted = notification != null ? notification.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_common_call_agent_handle_push_notification(handle, notification_converted));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> unregisterPushNotification() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_common_call_agent_unregister_push_notification(handle));
            }
        }, (Executor)executor);
    }

    public void dispose() {
        this.disposeInternal();
    }

    public CompletableFuture<Void> registerPushNotification(String deviceRegistrationToken) {
        if (deviceRegistrationToken == null || deviceRegistrationToken.trim().length() == 0) {
            throw ErrorReporting.getExceptionBySubCode(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN, 41099);
        }
        return this.registerPushNotificationInternal(deviceRegistrationToken);
    }
}

