/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import androidx.annotation.RequiresApi;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.TelecomManagerOptions;

public abstract class CommonCallAgentOptions {
    long handle;

    CommonCallAgentOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_common_call_agent_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_call_agent_options_release(this.handle));
        this.handle = 0L;
    }

    public boolean isDisableInternalPushForIncomingCall() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_call_agent_options_get_disable_internal_push_for_incoming_call(this.handle, result));
        return (Boolean)result.value;
    }

    public CommonCallAgentOptions setDisableInternalPushForIncomingCall(boolean value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_call_agent_options_set_disable_internal_push_for_incoming_call(this.handle, value));
        return this;
    }

    @RequiresApi(value=25)
    public TelecomManagerOptions getTelecomManagerOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_call_agent_options_get_telecom_manager_options(this.handle, result_handle));
        TelecomManagerOptions result_object = (Long)result_handle.value != 0L ? TelecomManagerOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    @RequiresApi(value=25)
    public CommonCallAgentOptions setTelecomManagerOptions(TelecomManagerOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_common_call_agent_options_set_telecom_manager_options(this.handle, value_converted));
        return this;
    }
}

