/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallCaptions;
import com.azure.android.communication.calling.CommunicationCaptionsListener;
import com.azure.android.communication.calling.CommunicationCaptionsReceivedEvent;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class CommunicationCaptions
extends CallCaptions {
    private List<PropertyChangedListener> OnActiveSpokenLanguageChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<PropertyChangedListener> OnCaptionsEnabledChangedListeners = new CopyOnWriteArrayList<PropertyChangedListener>();
    private List<CommunicationCaptionsListener> OnCaptionsReceivedListeners = new CopyOnWriteArrayList<CommunicationCaptionsListener>();

    CommunicationCaptions(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    CommunicationCaptions(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    private static void OnActiveSpokenLanguageChangedStaticHandler(long cookie, long args) {
        CommunicationCaptions instance = CommunicationCaptions.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnActiveSpokenLanguageChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnActiveSpokenLanguageChangedListener(PropertyChangedListener listener) {
        this.OnActiveSpokenLanguageChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnActiveSpokenLanguageChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_set_on_active_spoken_language_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnActiveSpokenLanguageChangedListener(PropertyChangedListener listener) {
        this.OnActiveSpokenLanguageChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnActiveSpokenLanguageChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_set_on_active_spoken_language_changed(this.handle, 0L, null));
        }
    }

    private static void OnCaptionsEnabledChangedStaticHandler(long cookie, long args) {
        CommunicationCaptions instance = CommunicationCaptions.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnCaptionsEnabledChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnCaptionsEnabledChangedListener(PropertyChangedListener listener) {
        this.OnCaptionsEnabledChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCaptionsEnabledChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_set_on_captions_enabled_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnCaptionsEnabledChangedListener(PropertyChangedListener listener) {
        this.OnCaptionsEnabledChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCaptionsEnabledChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_set_on_captions_enabled_changed(this.handle, 0L, null));
        }
    }

    private static void OnCaptionsReceivedStaticHandler(long cookie, long args) {
        CommunicationCaptions instance = CommunicationCaptions.getInstance(cookie);
        if (instance != null) {
            CommunicationCaptionsReceivedEvent args_converted = args != 0L ? CommunicationCaptionsReceivedEvent.getInstance(args, false) : null;
            for (CommunicationCaptionsListener listener : instance.OnCaptionsReceivedListeners) {
                listener.onCommunicationCaptions(args_converted);
            }
        }
    }

    public void addOnCaptionsReceivedListener(CommunicationCaptionsListener listener) {
        this.OnCaptionsReceivedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCaptionsReceived", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_set_on_captions_received(this.handle, this.getHandle(), this));
    }

    public void removeOnCaptionsReceivedListener(CommunicationCaptionsListener listener) {
        this.OnCaptionsReceivedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCaptionsReceived", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_set_on_captions_received(this.handle, 0L, null));
        }
    }

    static CommunicationCaptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CommunicationCaptions, CommunicationCaptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_captions_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CommunicationCaptions, CommunicationCaptions.class, false);
    }

    private static CommunicationCaptions getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CommunicationCaptions, CommunicationCaptions.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnActiveSpokenLanguageChanged")) {
            this.addOnActiveSpokenLanguageChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCaptionsEnabledChanged")) {
            this.addOnCaptionsEnabledChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCaptionsReceived")) {
            this.addOnCaptionsReceivedListener((CommunicationCaptionsListener)eventListener);
        }
    }
}

