/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallerInfo;
import com.azure.android.communication.calling.CaptionsResultType;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.Date;

public final class CommunicationCaptionsReceivedEvent {
    long handle;

    CommunicationCaptionsReceivedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_communication_captions_received_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_received_event_args_release(this.handle));
        this.handle = 0L;
    }

    public CallerInfo getSpeaker() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_received_event_args_get_speaker(this.handle, result_handle));
        CallerInfo result_object = (Long)result_handle.value != 0L ? CallerInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CaptionsResultType getResultType() {
        Out<CaptionsResultType> result = new Out<CaptionsResultType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_received_event_args_get_result_type(this.handle, result));
        return (CaptionsResultType)((Object)result.value);
    }

    public Date getTimestamp() {
        Out<Long> result = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_received_event_args_get_timestamp(this.handle, result));
        return (Long)result.value == 0L ? new Date(Long.MAX_VALUE) : new Date((Long)result.value);
    }

    public String getSpokenText() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_received_event_args_get_spoken_text(this.handle, result));
        return (String)result.value;
    }

    public String getSpokenLanguage() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_communication_captions_received_event_args_get_spoken_language(this.handle, result));
        return (String)result.value;
    }

    static CommunicationCaptionsReceivedEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CommunicationCaptionsReceivedEvent, CommunicationCaptionsReceivedEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_communication_captions_received_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CommunicationCaptionsReceivedEvent, CommunicationCaptionsReceivedEvent.class, false);
    }
}

