/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.InternalObjectHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.List;

public final class DataChannelSender {
    long handle;

    DataChannelSender(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_data_channel_sender_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_release(this.handle));
        this.handle = 0L;
    }

    private int getChannelIdInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_get_channel_id_internal(this.handle, result));
        return (Integer)result.value;
    }

    private int getMaxMessageSizeInBytesInternal() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_get_max_message_size_in_bytes_internal(this.handle, result));
        return (Integer)result.value;
    }

    private void setParticipantsInternal(String[] participants) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_set_participants_internal(this.handle, participants, participants.length));
    }

    public void sendMessage(byte[] data) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_send_message(this.handle, data, data.length));
    }

    public void closeSender() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_data_channel_sender_close_sender(this.handle));
    }

    static DataChannelSender getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelSender, DataChannelSender.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_data_channel_sender_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DataChannelSender, DataChannelSender.class, false);
    }

    public Integer getChannelId() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getChannelIdInternal());
    }

    public Integer getMaxMessageSizeInBytes() {
        return InternalObjectHelpers.extractIntegerObject(() -> this.getMaxMessageSizeInBytesInternal());
    }

    public void setParticipants(List<CommunicationIdentifier> participants) {
        ArrayList<String> mris = new ArrayList<String>();
        for (CommunicationIdentifier identifier : participants) {
            mris.add(IdentifierHelpers.toMRI(identifier));
        }
        String[] mriArray = new String[mris.size()];
        this.setParticipantsInternal(mris.toArray(mriArray));
    }
}

