/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.VideoDeviceInfo;
import com.azure.android.communication.calling.VideoDevicesUpdatedEvent;
import com.azure.android.communication.calling.VideoDevicesUpdatedListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DeviceManager {
    long handle;
    private List<VideoDevicesUpdatedListener> OnCamerasUpdatedListeners = new CopyOnWriteArrayList<VideoDevicesUpdatedListener>();

    DeviceManager(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_device_manager_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    DeviceManager(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_device_manager_release(this.handle));
        this.handle = 0L;
    }

    public List<VideoDeviceInfo> getCameras() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_device_manager_get_cameras(this.handle, result, result_length));
        ArrayList<VideoDeviceInfo> resultList = new ArrayList<VideoDeviceInfo>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(VideoDeviceInfo.getInstance(resultArray[i], true));
        }
        List<VideoDeviceInfo> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private static void OnCamerasUpdatedStaticHandler(long cookie, long args) {
        DeviceManager instance = DeviceManager.getInstance(cookie);
        if (instance != null) {
            VideoDevicesUpdatedEvent args_converted = args != 0L ? VideoDevicesUpdatedEvent.getInstance(args, false) : null;
            for (VideoDevicesUpdatedListener listener : instance.OnCamerasUpdatedListeners) {
                listener.onVideoDevicesUpdated(args_converted);
            }
        }
    }

    public void addOnCamerasUpdatedListener(VideoDevicesUpdatedListener listener) {
        this.OnCamerasUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCamerasUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_device_manager_set_on_cameras_updated(this.handle, this.getHandle(), this));
    }

    public void removeOnCamerasUpdatedListener(VideoDevicesUpdatedListener listener) {
        this.OnCamerasUpdatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCamerasUpdated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_device_manager_set_on_cameras_updated(this.handle, 0L, null));
        }
    }

    private void setDeviceOrientationInternal(int angle) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_device_manager_set_device_orientation_internal(this.handle, angle));
    }

    static DeviceManager getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DeviceManager, DeviceManager.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_device_manager_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DeviceManager, DeviceManager.class, false);
    }

    private static DeviceManager getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.DeviceManager, DeviceManager.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCamerasUpdated")) {
            this.addOnCamerasUpdatedListener((VideoDevicesUpdatedListener)eventListener);
        }
    }

    void setDeviceOrientation(int angle) {
        this.setDeviceOrientationInternal(angle);
    }
}

