/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.ErrorInfo;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import java.lang.reflect.InvocationTargetException;

final class ErrorReporting {
    long handle;

    ErrorReporting(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_error_reporting_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public ErrorReporting() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_error_reporting_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_error_reporting_release(this.handle));
        this.handle = 0L;
    }

    public static void throwError(int subcode) {
        Out<ErrorInfo> errorContext = new Out<ErrorInfo>();
        NativeLibraryHelpers.checkStatus(NativeLibrary.sam_error_reporting_throw_error(subcode, errorContext), (ErrorInfo)errorContext.value);
    }

    static ErrorReporting getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.ErrorReporting, ErrorReporting.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_error_reporting_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.ErrorReporting, ErrorReporting.class, false);
    }

    static CallingCommunicationException getExceptionBySubCode(int subCode) {
        try {
            ErrorReporting.throwError(subCode);
        }
        catch (CallingCommunicationException e) {
            return e;
        }
        return null;
    }

    static CallingCommunicationException getExceptionBySubCode(CallingCommunicationErrors legacyCode, int subCode) {
        try {
            ErrorReporting.throwError(subCode);
        }
        catch (CallingCommunicationException e) {
            CallingCommunicationException result = new CallingCommunicationException(legacyCode, e.getMessage());
            result.setCode(e.getCode());
            result.setSubCode(e.getSubCode());
            result.setMessage(e.getMessage());
            return result;
        }
        return null;
    }

    static <T extends Throwable> T getCauseBySubCode(Class<T> exceptionClass, int subCode, String legacyMessage) {
        try {
            ErrorReporting.throwError(subCode);
        }
        catch (CallingCommunicationException e) {
            try {
                return (T)((Throwable)exceptionClass.getDeclaredConstructor(String.class, Throwable.class).newInstance(legacyMessage, e));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }
}

