/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import java.util.Arrays;
import java.util.List;

public final class IceServer {
    long handle;

    IceServer(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_ice_server_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public IceServer() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_ice_server_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_release(this.handle));
        this.handle = 0L;
    }

    private String[] getUrlsInternal() {
        Out<String[]> result = new Out<String[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_get_urls_internal(this.handle, result, result_length));
        return (String[])result.value;
    }

    private IceServer setUrlsInternal(String[] value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_set_urls_internal(this.handle, value, value.length));
        return this;
    }

    public String getRealm() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_get_realm(this.handle, result));
        return (String)result.value;
    }

    public IceServer setRealm(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_set_realm(this.handle, value));
        return this;
    }

    public int getTcpPort() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_get_tcp_port(this.handle, result));
        return (Integer)result.value;
    }

    public IceServer setTcpPort(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_set_tcp_port(this.handle, value));
        return this;
    }

    public int getUdpPort() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_get_udp_port(this.handle, result));
        return (Integer)result.value;
    }

    public IceServer setUdpPort(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_set_udp_port(this.handle, value));
        return this;
    }

    public String getUsername() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_get_username(this.handle, result));
        return (String)result.value;
    }

    public IceServer setUsername(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_set_username(this.handle, value));
        return this;
    }

    public String getPassword() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_get_password(this.handle, result));
        return (String)result.value;
    }

    public IceServer setPassword(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_ice_server_set_password(this.handle, value));
        return this;
    }

    static IceServer getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IceServer, IceServer.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_ice_server_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IceServer, IceServer.class, false);
    }

    public List<String> getUrls() {
        return Arrays.asList(this.getUrlsInternal());
    }

    public IceServer setUrls(List<String> value) {
        this.setUrlsInternal(value.toArray(new String[0]));
        return this;
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

