/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.Constants;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.communication.common.CommunicationUserIdentifier;
import com.azure.android.communication.common.UnknownIdentifier;
import java.util.ArrayList;
import java.util.List;

class IdentifierHelpers {
    IdentifierHelpers() {
    }

    static String[] convertIdentifiersToMris(Iterable<CommunicationIdentifier> iterableIdentifiers) {
        ArrayList<String> identifiersList = new ArrayList<String>();
        for (CommunicationIdentifier communicationIdentifier : iterableIdentifiers) {
            identifiersList.add(IdentifierHelpers.toMRI(communicationIdentifier));
        }
        String[] identifiers = new String[identifiersList.size()];
        return identifiersList.toArray(identifiers);
    }

    static List<CommunicationIdentifier> convertMrisToIdentifiers(String[] mris) {
        ArrayList<CommunicationIdentifier> identifiersList = new ArrayList<CommunicationIdentifier>();
        for (String mri : mris) {
            identifiersList.add(IdentifierHelpers.from(mri));
        }
        return identifiersList;
    }

    static CommunicationIdentifier from(String mri) {
        if (mri.startsWith(Constants.ACS_AG08_MRI_PREFIX) || mri.startsWith(Constants.ACS_AG09_MRI_PREFIX)) {
            return new CommunicationUserIdentifier(mri);
        }
        if (mri == null) {
            return new UnknownIdentifier("null");
        }
        if (mri.isEmpty()) {
            return new UnknownIdentifier("empty");
        }
        return CommunicationIdentifier.fromRawId((String)mri);
    }

    static String toMRI(CommunicationIdentifier identifier) {
        return identifier.getRawId();
    }
}

